/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;

public class UserFunctionEditor
extends FunctionEditor {
    private UserFunction[] mainFunctions = new UserFunction[0];
    private String[] defaultVariableNames = new String[]{"x"};
    protected boolean parametersValid = true;

    public UserFunction[] getMainFunctions() {
        return this.mainFunctions;
    }

    public void setMainFunctions(UserFunction[] functions) {
        UserFunction u;
        UserFunction[] f;
        UserFunction[] userFunctionArray = f = this.getMainFunctions();
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            u = userFunctionArray[n2];
            this.objects.remove(u);
            ++n2;
        }
        userFunctionArray = functions;
        n = functions.length;
        n2 = 0;
        while (n2 < n) {
            u = userFunctionArray[n2];
            this.addObject(u, false);
            ++n2;
        }
        this.mainFunctions = functions;
        this.setDefaultVariables(functions[0].getIndependentVariables());
    }

    public UserFunction[] getSupportFunctions() {
        ArrayList temp = new ArrayList();
        for (Object next : this.objects) {
            if (this.isMainFunction(next)) continue;
            temp.add(next);
        }
        return temp.toArray(new UserFunction[0]);
    }

    @Override
    public String getName(Object obj) {
        return obj == null ? null : ((UserFunction)obj).getName();
    }

    @Override
    public String getExpression(Object obj) {
        return obj == null ? null : ((UserFunction)obj).getInputString();
    }

    @Override
    public String getDescription(Object obj) {
        return obj == null ? null : ((UserFunction)obj).getDescription();
    }

    @Override
    public void setDescription(Object obj, String desc) {
        if (obj != null) {
            if (desc != null && desc.trim().equals("")) {
                desc = null;
            }
            ((UserFunction)obj).setDescription(desc);
            super.setDescription(obj, desc);
        }
    }

    @Override
    public boolean isNameEditable(Object obj) {
        return ((UserFunction)obj).isNameEditable();
    }

    @Override
    public boolean isExpressionEditable(Object obj) {
        UserFunction f = (UserFunction)obj;
        return f.polynomial == null;
    }

    @Override
    public void evaluateAll() {
        super.evaluateAll();
        ParamEditor paramEditor = this.getParamEditor();
        if (!this.parametersValid && paramEditor != null) {
            paramEditor.evaluateAll();
        }
        int i = 0;
        while (i < this.evaluate.size()) {
            UserFunction f = (UserFunction)this.evaluate.get(i);
            if (!this.parametersValid && paramEditor != null) {
                f.setParameters(paramEditor.getNames(), paramEditor.getValues(), paramEditor.getDescriptions());
            }
            f.setExpression(f.getInputString(), f.getIndependentVariables());
            ++i;
        }
        this.parametersValid = true;
    }

    @Override
    public Object addObject(Object obj, int row, boolean postEdit, boolean firePropertyChange) {
        if ((obj = super.addObject(obj, row, postEdit, firePropertyChange)) != null) {
            this.firePropertyChange("function", null, obj);
        }
        return obj;
    }

    @Override
    public Object removeObject(Object obj, boolean postEdit) {
        if ((obj = super.removeObject(obj, postEdit)) != null) {
            this.firePropertyChange("function", obj, null);
        }
        return obj;
    }

    @Override
    public String getTooltip(Object obj) {
        return obj == null ? null : ((UserFunction)obj).getDescription();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        UserFunction[] mainFunctions;
        String propName = e.getPropertyName();
        if (propName.equals("param_description")) {
            UserFunction f;
            UserFunction[] userFunctionArray = this.getMainFunctions();
            int n = userFunctionArray.length;
            int n2 = 0;
            while (n2 < n) {
                f = userFunctionArray[n2];
                f.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
                ++n2;
            }
            userFunctionArray = this.getSupportFunctions();
            n = userFunctionArray.length;
            n2 = 0;
            while (n2 < n) {
                f = userFunctionArray[n2];
                f.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
                ++n2;
            }
        } else if (propName.equals("edit") && (mainFunctions = this.getMainFunctions()).length > 0) {
            String newName = (String)e.getOldValue();
            String oldName = null;
            Object obj = e.getNewValue();
            UserFunction func = this.getMainFunctions()[0];
            if (func.polynomial != null && obj != null) {
                if (obj instanceof FunctionEditor.DefaultEdit) {
                    FunctionEditor.DefaultEdit edit = (FunctionEditor.DefaultEdit)obj;
                    if (edit.editType != 2) {
                        super.propertyChange(e);
                        return;
                    }
                    oldName = (String)edit.undoObj;
                } else if (obj instanceof String) {
                    oldName = (String)obj;
                }
                if (oldName != null) {
                    UserFunction f;
                    UserFunction[] userFunctionArray = this.getMainFunctions();
                    int n = userFunctionArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        f = userFunctionArray[n3];
                        f.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
                        f.replaceParameterNameInExpression(oldName, newName);
                        ++n3;
                    }
                    userFunctionArray = this.getSupportFunctions();
                    n = userFunctionArray.length;
                    n3 = 0;
                    while (n3 < n) {
                        f = userFunctionArray[n3];
                        f.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
                        f.replaceParameterNameInExpression(oldName, newName);
                        ++n3;
                    }
                }
            }
        }
        super.propertyChange(e);
    }

    @Override
    protected boolean isImportant(Object obj) {
        int i = 0;
        while (i < this.mainFunctions.length) {
            if (this.mainFunctions[i] == obj) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void setReferences(Object obj, List<Object> ref) {
        UserFunction f = (UserFunction)obj;
        UserFunction[] references = ref.toArray(new UserFunction[0]);
        f.setReferences(references);
    }

    protected void setDefaultVariables(String[] varNames) {
        this.defaultVariableNames = varNames;
    }

    @Override
    protected boolean isDisallowedName(Object obj, String name) {
        boolean disallowed = super.isDisallowedName(obj, name);
        if (obj != null) {
            String var = ((UserFunction)obj).getIndependentVariable();
            boolean bl = disallowed = disallowed || var.equals(name);
        }
        if (disallowed) {
            return true;
        }
        if (obj != null && this.getName(obj).equals(name)) {
            return false;
        }
        if (this.functionPanel instanceof FitFunctionPanel) {
            FitFunctionPanel fitPanel = (FitFunctionPanel)this.functionPanel;
            if (fitPanel.functionTool != null) {
                String s = fitPanel.functionTool.getUniqueName(name);
                disallowed = !name.equals(s);
                for (DatasetCurveFitter next : fitPanel.functionTool.curveFitters) {
                    if (disallowed) {
                        return true;
                    }
                    disallowed = next.fitMap.keySet().contains(name);
                }
            }
        }
        return disallowed;
    }

    @Override
    protected String getVariablesString(String separator) {
        int i;
        StringBuffer vars = new StringBuffer("");
        int init = vars.length();
        boolean firstItem = true;
        UserFunction f = (UserFunction)this.getSelectedObject();
        if (f != null) {
            String[] s = f.getIndependentVariables();
            i = 0;
            while (i < s.length) {
                if (!firstItem) {
                    vars.append(" ");
                }
                vars.append(s[i]);
                firstItem = false;
                ++i;
            }
        }
        ArrayList<String> namesToSkip = new ArrayList<String>();
        namesToSkip.add(this.getName(this.getSelectedObject()));
        i = 0;
        while (i < this.mainFunctions.length) {
            namesToSkip.add(this.getName(this.mainFunctions[i]));
            ++i;
        }
        i = 0;
        while (i < this.names.length) {
            if (!namesToSkip.contains(this.names[i])) {
                if (!firstItem) {
                    vars.append(" ");
                }
                vars.append(this.names[i]);
                firstItem = false;
            }
            ++i;
        }
        String[] paramNames = this.paramEditor.getNames();
        int i2 = 0;
        while (i2 < paramNames.length) {
            if (!firstItem) {
                vars.append(" ");
            }
            vars.append(paramNames[i2]);
            firstItem = false;
            ++i2;
        }
        if (vars.length() == init) {
            return ToolsRes.getString("FunctionPanel.Instructions.Help");
        }
        return String.valueOf(ToolsRes.getString("FunctionPanel.Instructions.ValueCell")) + separator + vars.toString();
    }

    @Override
    protected boolean isInvalidExpression(Object obj) {
        UserFunction f = (UserFunction)obj;
        return !f.getExpression().equals(f.getInputString());
    }

    @Override
    protected Object createObject(String name, String expression, Object obj) {
        UserFunction f = (UserFunction)obj;
        if (f != null && f.getName().equals(name) && f.getInputString().equals(expression)) {
            return f;
        }
        if (f == null) {
            f = new UserFunction(name);
            f.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
            f.setExpression(expression, this.defaultVariableNames);
        } else if (!f.getName().equals(name)) {
            f.setNameEditable(true);
            f.setName(name);
        } else {
            f.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
            f.setExpression(expression, f.getIndependentVariables());
        }
        return f;
    }

    private boolean isMainFunction(Object obj) {
        int i = 0;
        while (i < this.mainFunctions.length) {
            if (obj == this.mainFunctions[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            UserFunctionEditor editor = (UserFunctionEditor)obj;
            UserFunction[] functions = editor.getMainFunctions();
            control.setValue("main_functions", functions);
            functions = editor.getSupportFunctions();
            if (functions.length > 0) {
                control.setValue("support_functions", functions);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new UserFunctionEditor();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            UserFunctionEditor editor = (UserFunctionEditor)obj;
            UserFunction[] functions = (UserFunction[])control.getObject("main_functions");
            editor.setMainFunctions(functions);
            int row = functions.length;
            functions = (UserFunction[])control.getObject("support_functions");
            if (functions != null) {
                int i = 0;
                while (i < functions.length) {
                    editor.addObject(functions[i], row + i, false, false);
                    ++i;
                }
            }
            return obj;
        }
    }
}

