/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class TristateCheckBox
extends JCheckBox {
    public static final State NOT_SELECTED = new State();
    public static final State SELECTED = new State();
    public static final State PART_SELECTED = new State();
    private final TristateDecorator model;

    public TristateCheckBox(String text, Icon icon, State initial) {
        super(text, icon);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState();
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(initial);
    }

    public TristateCheckBox(String text, State initial) {
        this(text, null, initial);
    }

    public TristateCheckBox(String text) {
        this(text, PART_SELECTED);
    }

    public TristateCheckBox() {
        this((String)null);
    }

    @Override
    public void addMouseListener(MouseListener l) {
    }

    public void setState(State state) {
        this.model.setState(state);
    }

    public State getState() {
        return this.model.getState();
    }

    @Override
    public void setSelected(boolean b) {
        if (b) {
            this.setState(SELECTED);
        } else {
            this.setState(NOT_SELECTED);
        }
    }

    public static class State {
        private State() {
        }
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;

        private TristateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setState(State state) {
            if (state == NOT_SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (state == SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            }
        }

        private State getState() {
            if (this.isSelected() && !this.isArmed()) {
                return SELECTED;
            }
            if (this.isSelected() && this.isArmed()) {
                return PART_SELECTED;
            }
            return NOT_SELECTED;
        }

        private void nextState() {
            State current = this.getState();
            if (current == NOT_SELECTED) {
                this.setState(SELECTED);
            } else if (current == SELECTED) {
                this.setState(PART_SELECTED);
            } else if (current == PART_SELECTED) {
                this.setState(NOT_SELECTED);
            }
        }

        @Override
        public void setArmed(boolean b) {
        }

        @Override
        public void setEnabled(boolean b) {
            TristateCheckBox.this.setFocusable(b);
            this.other.setEnabled(b);
        }

        @Override
        public boolean isArmed() {
            return this.other.isArmed();
        }

        @Override
        public boolean isSelected() {
            return this.other.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.other.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.other.isRollover();
        }

        @Override
        public void setSelected(boolean b) {
            this.other.setSelected(b);
        }

        @Override
        public void setPressed(boolean b) {
            this.other.setPressed(b);
        }

        @Override
        public void setRollover(boolean b) {
            this.other.setRollover(b);
        }

        @Override
        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        @Override
        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        @Override
        public void setActionCommand(String s) {
            this.other.setActionCommand(s);
        }

        @Override
        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        @Override
        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        @Override
        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }
}

