/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.dialogs.DialogsRes;

public class ToolsRes {
    static final String BUNDLE_NAME = "org.opensourcephysics.resources.tools.tools";
    static Locale resourceLocale = Locale.ENGLISH;
    static ResourceBundle res = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.tools", resourceLocale);
    static Object resObj = new ToolsRes();
    static PropertyChangeSupport support = new SwingPropertyChangeSupport(resObj);

    static {
        String language = Locale.getDefault().getLanguage();
        resourceLocale = Locale.ENGLISH;
        Locale[] localeArray = OSPRuntime.getInstalledLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            if (locale.getLanguage().equals(language)) {
                resourceLocale = locale;
                break;
            }
            ++n2;
        }
        res = ResourceBundle.getBundle(BUNDLE_NAME, resourceLocale);
    }

    private ToolsRes() {
    }

    public static String getString(String key) {
        try {
            return res.getString(key);
        }
        catch (MissingResourceException ex) {
            return "!" + key + "!";
        }
    }

    public static String getLanguage() {
        return resourceLocale.getLanguage();
    }

    public static void setLocale(Locale loc) {
        if (resourceLocale == loc) {
            return;
        }
        Locale prev = resourceLocale;
        resourceLocale = loc;
        res = ResourceBundle.getBundle(BUNDLE_NAME, resourceLocale);
        ControlsRes.setLocale(resourceLocale);
        DisplayRes.setLocale(resourceLocale);
        DialogsRes.setLocale(resourceLocale);
        String className = "org.opensourcephysics.ejs.EjsRes";
        try {
            Class<?> resClass = Class.forName(className);
            Method method = resClass.getMethod("setLocale", Locale.class);
            method.invoke(null, resourceLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        support.firePropertyChange("locale", prev, resourceLocale);
    }

    public static void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (property.equals("locale")) {
            support.addPropertyChangeListener(property, listener);
        }
    }

    public static void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        support.removePropertyChangeListener(property, listener);
    }
}

