/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

class ThreadViewerTableModel
extends AbstractTableModel {
    private Object dataLock;
    private int rowCount = 0;
    private Object[][] cellData = new Object[0][0];
    private Object[][] pendingCellData;
    private final int columnCount;
    private final String[] columnName;
    private final Class[] columnClass;
    private Thread internalThread;
    private volatile boolean noStopRequested;

    public ThreadViewerTableModel() {
        String[] names = new String[]{"Priority", "Alive", "Daemon", "Interrupted", "ThreadGroup", "Thread Name"};
        this.columnName = names;
        Class[] classes = new Class[]{Integer.class, Boolean.class, Boolean.class, Boolean.class, String.class, String.class};
        this.columnClass = classes;
        this.columnCount = this.columnName.length;
        this.dataLock = new Object();
        this.noStopRequested = true;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadViewerTableModel.this.runWork();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        };
        this.internalThread = new Thread(r, "ThreadViewer");
        this.internalThread.setPriority(8);
        this.internalThread.setDaemon(true);
        this.internalThread.start();
    }

    private void runWork() {
        Runnable transferPending = new Runnable(){

            @Override
            public void run() {
                ThreadViewerTableModel.this.transferPendingCellData();
                ThreadViewerTableModel.this.fireTableDataChanged();
            }
        };
        while (this.noStopRequested) {
            try {
                this.createPendingCellData();
                SwingUtilities.invokeAndWait(transferPending);
                Thread.sleep(5000L);
            }
            catch (InvocationTargetException tx) {
                tx.printStackTrace();
                this.stopRequest();
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void stopRequest() {
        this.noStopRequested = false;
        this.internalThread.interrupt();
    }

    public boolean isAlive() {
        return this.internalThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPendingCellData() {
        Thread[] thread = ThreadViewerTableModel.findAllThreads();
        Object[][] cell = new Object[thread.length][this.columnCount];
        int i = 0;
        while (i < thread.length) {
            Thread t = thread[i];
            Object[] rowCell = cell[i];
            rowCell[0] = new Integer(t.getPriority());
            rowCell[1] = new Boolean(t.isAlive());
            rowCell[2] = new Boolean(t.isDaemon());
            rowCell[3] = new Boolean(t.isInterrupted());
            rowCell[4] = t.getThreadGroup().getName();
            rowCell[5] = t.getName();
            ++i;
        }
        Object object = this.dataLock;
        synchronized (object) {
            this.pendingCellData = cell;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferPendingCellData() {
        Object object = this.dataLock;
        synchronized (object) {
            this.cellData = this.pendingCellData;
            this.rowCount = this.cellData.length;
        }
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.cellData[row][col];
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public Class<?> getColumnClass(int columnIdx) {
        return this.columnClass[columnIdx];
    }

    @Override
    public String getColumnName(int columnIdx) {
        return this.columnName[columnIdx];
    }

    public static Thread[] findAllThreads() {
        ThreadGroup group;
        ThreadGroup topGroup = group = Thread.currentThread().getThreadGroup();
        while (group != null) {
            topGroup = group;
            group = group.getParent();
        }
        int estimatedSize = topGroup.activeCount() * 2;
        Thread[] slackList = new Thread[estimatedSize];
        int actualSize = topGroup.enumerate(slackList);
        Thread[] list = new Thread[actualSize];
        System.arraycopy(slackList, 0, list, 0, actualSize);
        return list;
    }
}

