/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.JarTool;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ToolsRes;

public class ResourceLoader {
    public static final FileFilter OSP_CACHE_FILTER;
    protected static final String WIN_XP_DEFAULT_CACHE = "/Local Settings/Application Data/OSP/Cache";
    protected static final String WINDOWS_DEFAULT_CACHE = "/AppData/Local/OSP/Cache";
    protected static final String OSX_DEFAULT_CACHE = "/Library/Caches/OSP";
    protected static final String LINUX_DEFAULT_CACHE = "/Downloads/OSP/Cache";
    protected static final String SEARCH_CACHE_SUBDIRECTORY = "Search";
    protected static ArrayList<String> searchPaths;
    protected static ArrayList<String> appletSearchPaths;
    protected static int maxPaths;
    protected static Hashtable<String, Resource> resources;
    protected static boolean cacheEnabled;
    protected static boolean canceled;
    protected static Map<String, URLClassLoader> zipLoaders;
    protected static URLClassLoader xsetZipLoader;
    protected static Set<String> extractExtensions;
    protected static ArrayList<String> pathsNotFound;
    protected static File ospCache;
    protected static boolean zipURLsOK;

    static {
        searchPaths = new ArrayList();
        appletSearchPaths = new ArrayList();
        maxPaths = 20;
        resources = new Hashtable();
        cacheEnabled = false;
        canceled = false;
        zipLoaders = new TreeMap<String, URLClassLoader>();
        extractExtensions = new TreeSet<String>();
        pathsNotFound = new ArrayList();
        OSP_CACHE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith("osp-");
            }
        };
    }

    private ResourceLoader() {
    }

    public static Resource getResource(String name) {
        return ResourceLoader.getResource(name, true);
    }

    public static Resource getResourceZipURLsOK(String name) {
        zipURLsOK = true;
        Resource res = ResourceLoader.getResource(name, true);
        zipURLsOK = false;
        return res;
    }

    public static Resource getResource(String name, boolean searchFiles) {
        try {
            URL url = ResourceLoader.getAppletResourceURL(name);
            if (url != null) {
                return new Resource(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ResourceLoader.getResource(name, Resource.class, searchFiles);
    }

    public static Resource getResource(String name, Class<?> type) {
        return ResourceLoader.getResource(name, type, true);
    }

    public static Resource getResource(String name, Class<?> type, boolean searchFiles) {
        Resource res;
        if (name == null || name.equals("")) {
            return null;
        }
        pathsNotFound.clear();
        if (name.startsWith("\"")) {
            name = name.substring(1);
        }
        if (name.endsWith("\"")) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.startsWith("./")) {
            name = name.substring(2);
        }
        if (OSPRuntime.isAppletMode() || OSPRuntime.applet != null) {
            Resource appletRes = null;
            if (type == OSPRuntime.applet.getClass()) {
                try {
                    URL url = type.getResource(name);
                    appletRes = ResourceLoader.createResource(url);
                    if (appletRes != null) {
                        return appletRes;
                    }
                }
                catch (Exception url) {
                    // empty catch block
                }
            }
            Iterator<String> it = searchPaths.iterator();
            while (it.hasNext()) {
                String path = ResourceLoader.getPath(it.next(), name);
                appletRes = ResourceLoader.findResourceInClass(path, type, searchFiles);
                if (appletRes == null) continue;
                return appletRes;
            }
            appletRes = ResourceLoader.findResourceInClass(name, type, searchFiles);
            if (appletRes != null) {
                return appletRes;
            }
        }
        if ((res = ResourceLoader.findResource(name, type, searchFiles)) != null) {
            return res;
        }
        pathsNotFound.add(name);
        StringBuffer err = new StringBuffer("Not found: " + name);
        err.append(" [searched " + name);
        for (String next : searchPaths) {
            String path = ResourceLoader.getPath(next, name);
            if (pathsNotFound.contains(path)) continue;
            res = ResourceLoader.findResource(path, type, searchFiles);
            if (res != null) {
                return res;
            }
            pathsNotFound.add(path);
            err.append(";" + path);
        }
        err.append("]");
        OSPLog.fine(err.toString());
        return null;
    }

    public static Resource getResource(String basePath, String name) {
        return ResourceLoader.getResource(basePath, name, Resource.class);
    }

    public static Resource getResource(String basePath, String name, boolean searchFiles) {
        return ResourceLoader.getResource(basePath, name, Resource.class, searchFiles);
    }

    public static Resource getResource(String basePath, String name, Class<Resource> type) {
        return ResourceLoader.getResource(basePath, name, type, true);
    }

    public static Resource getResource(String basePath, String name, Class<Resource> type, boolean searchFiles) {
        if (basePath == null) {
            return ResourceLoader.getResource(name, type);
        }
        if (name.startsWith("./")) {
            name = name.substring(2);
        }
        pathsNotFound.clear();
        String path = ResourceLoader.getPath(basePath, name);
        Resource res = ResourceLoader.findResource(path, type, searchFiles);
        if (res != null) {
            return res;
        }
        if (basePath.startsWith("/") || basePath.indexOf(":/") > -1) {
            return null;
        }
        pathsNotFound.add(path);
        StringBuffer err = new StringBuffer("Not found: " + path);
        err.append(" [searched " + path);
        if (OSPRuntime.applet != null) {
            String codeBase;
            String docBase = OSPRuntime.applet.getDocumentBase().toExternalForm();
            path = ResourceLoader.getPath(ResourceLoader.getPath(docBase = String.valueOf(XML.getDirectoryPath(docBase)) + "/", basePath), name);
            if (!pathsNotFound.contains(path)) {
                res = ResourceLoader.findResource(path, type, searchFiles);
                if (res != null) {
                    return res;
                }
                pathsNotFound.add(path);
                err.append(";" + path);
            }
            if (!(codeBase = OSPRuntime.applet.getCodeBase().toExternalForm()).equals(docBase) && !pathsNotFound.contains(path = ResourceLoader.getPath(ResourceLoader.getPath(codeBase, basePath), name))) {
                res = ResourceLoader.findResource(path, type, searchFiles);
                if (res != null) {
                    return res;
                }
                pathsNotFound.add(path);
                err.append(";" + path);
            }
        }
        Iterator<String> it = searchPaths.iterator();
        while (it.hasNext()) {
            path = ResourceLoader.getPath(ResourceLoader.getPath(it.next(), basePath), name);
            if (pathsNotFound.contains(path)) continue;
            res = ResourceLoader.findResource(path, type, searchFiles);
            if (res != null) {
                return res;
            }
            pathsNotFound.add(path);
            err.append(";" + path);
        }
        err.append("]");
        OSPLog.fine(err.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchPath(String base) {
        if (base == null || base.equals("") || maxPaths < 1) {
            return;
        }
        ArrayList<String> arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(base)) {
                searchPaths.remove(base);
            } else {
                OSPLog.fine("Added path: " + base);
            }
            searchPaths.add(0, base);
            while (searchPaths.size() > Math.max(maxPaths, 0)) {
                base = searchPaths.get(searchPaths.size() - 1);
                OSPLog.fine("Removed path: " + base);
                searchPaths.remove(base);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSearchPath(String base) {
        if (base == null || base.equals("")) {
            return;
        }
        ArrayList<String> arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(base)) {
                OSPLog.fine("Removed path: " + base);
                searchPaths.remove(base);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAppletSearchPath(String base) {
        if (base == null || maxPaths < 1) {
            return;
        }
        if (!(base = base.trim()).endsWith("/")) {
            base = String.valueOf(base) + "/";
        }
        ArrayList<String> arrayList = appletSearchPaths;
        synchronized (arrayList) {
            if (appletSearchPaths.contains(base)) {
                appletSearchPaths.remove(base);
            } else {
                OSPLog.fine("Applet search path added: " + base);
            }
            appletSearchPaths.add(0, base);
            while (appletSearchPaths.size() > Math.max(maxPaths, 0)) {
                base = appletSearchPaths.get(appletSearchPaths.size() - 1);
                OSPLog.fine("Removed path: " + base);
                appletSearchPaths.remove(base);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAppletSearchPath(String base) {
        if (base == null || base.equals("")) {
            return;
        }
        ArrayList<String> arrayList = appletSearchPaths;
        synchronized (arrayList) {
            if (appletSearchPaths.contains(base)) {
                OSPLog.fine("Applet search path removed: " + base);
                appletSearchPaths.remove(base);
            }
        }
    }

    public static void setCacheEnabled(boolean enabled) {
        cacheEnabled = enabled;
    }

    public static boolean isCacheEnabled() {
        return cacheEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtractExtension(String extension) {
        if (extension == null || extension.equals("")) {
            return;
        }
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        OSPLog.finest("Added extension: " + extension);
        Set<String> set = extractExtensions;
        synchronized (set) {
            extractExtensions.add(extension);
        }
    }

    public static void setCanceled(boolean cancel) {
        canceled = cancel;
    }

    public static boolean isCanceled() {
        return canceled;
    }

    public static InputStream openInputStream(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.openInputStream();
    }

    public static Reader openReader(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.openReader();
    }

    public static String getString(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getString();
    }

    public static Icon getIcon(String path) {
        URL url = ResourceLoader.getAppletResourceURL(path);
        if (url != null) {
            return new ImageIcon(url);
        }
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getIcon();
    }

    public static Image getImage(String path) {
        URL url = ResourceLoader.getAppletResourceURL(path);
        if (url != null) {
            return new ImageIcon(url).getImage();
        }
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getImage();
    }

    public static BufferedImage getBufferedImage(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getBufferedImage();
    }

    public static BufferedImage getBufferedImage(String path, int bufferedImageType) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getBufferedImage(bufferedImageType);
    }

    public static AudioClip getAudioClip(String path) {
        Resource res = ResourceLoader.getResource(path);
        return res == null ? null : res.getAudioClip();
    }

    public static void setOSPCache(File newCache) {
        if (newCache != null && !newCache.equals(ospCache)) {
            if (ospCache != null && newCache.getAbsolutePath().contains(ospCache.getAbsolutePath())) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (!(newCache.exists() && newCache.isDirectory() || newCache.mkdirs())) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (!newCache.canWrite()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (ospCache != null) {
                File[] hostDirectories;
                File[] fileArray = hostDirectories = ospCache.listFiles(OSP_CACHE_FILTER);
                int n = hostDirectories.length;
                int n2 = 0;
                while (n2 < n) {
                    File host = fileArray[n2];
                    String hostname = host.getName();
                    File newHost = new File(newCache, hostname);
                    ResourceLoader.copyAllFiles(host, newHost);
                    ++n2;
                }
                File searchCache = new File(ospCache, SEARCH_CACHE_SUBDIRECTORY);
                File newSearchCache = new File(newCache, SEARCH_CACHE_SUBDIRECTORY);
                ResourceLoader.copyAllFiles(searchCache, newSearchCache);
                ResourceLoader.clearOSPCache(ospCache, true);
                File[] files = ospCache.listFiles();
                if (files != null && files.length == 0) {
                    ospCache.delete();
                }
            }
            ospCache = newCache;
        }
    }

    public static File getOSPCache() {
        return ospCache;
    }

    public static File getDefaultOSPCache() {
        String cachePath = System.getProperty("java.io.tmpdir");
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            userHome = String.valueOf(userHome) + "/";
            if (OSPRuntime.isMac()) {
                cachePath = String.valueOf(userHome) + OSX_DEFAULT_CACHE;
            } else if (OSPRuntime.isLinux()) {
                cachePath = String.valueOf(userHome) + LINUX_DEFAULT_CACHE;
            } else if (OSPRuntime.isWindows()) {
                String os = System.getProperty("os.name", "").toLowerCase();
                cachePath = os.indexOf("xp") > -1 ? String.valueOf(userHome) + WIN_XP_DEFAULT_CACHE : String.valueOf(userHome) + WINDOWS_DEFAULT_CACHE;
            }
        }
        if (cachePath == null) {
            return null;
        }
        return new File(cachePath);
    }

    public static File chooseOSPCache(Component parent) {
        JFileChooser chooser = new JFileChooser(ResourceLoader.getOSPCache());
        if (OSPRuntime.isMac()) {
            chooser.setFileSelectionMode(2);
        } else {
            chooser.setFileSelectionMode(1);
        }
        javax.swing.filechooser.FileFilter folderFilter = new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return ToolsRes.getString("LibraryTreePanel.FolderFileFilter.Description");
            }
        };
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(folderFilter);
        String text = ToolsRes.getString("ResourceLoader.FileChooser.Cache");
        chooser.setDialogTitle(text);
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        int result = chooser.showDialog(parent, text);
        if (result == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static boolean isOSPCachePath(String path) {
        File cacheFile = ResourceLoader.getOSPCache();
        if (cacheFile == null) {
            cacheFile = new File(System.getProperty("java.io.tmpdir"));
        }
        String cachePath = String.valueOf(XML.forwardSlash(cacheFile.getAbsolutePath())) + "/osp-";
        return XML.forwardSlash(path).contains(cachePath);
    }

    public static File getOSPCacheFile(String urlPath) {
        return ResourceLoader.getOSPCacheFile(urlPath, null);
    }

    public static File getOSPCacheFile(String urlPath, String name) {
        File cacheFile = ResourceLoader.getOSPCache();
        if (cacheFile == null) {
            cacheFile = new File(System.getProperty("java.io.tmpdir"));
        }
        return ResourceLoader.getCacheFile(cacheFile, urlPath, name);
    }

    public static File getSearchCache() {
        File ospCache = ResourceLoader.getOSPCache();
        if (ospCache == null) {
            ospCache = ResourceLoader.getDefaultOSPCache();
        }
        if (ospCache == null) {
            return null;
        }
        File searchCache = new File(ospCache, SEARCH_CACHE_SUBDIRECTORY);
        searchCache.mkdirs();
        return searchCache;
    }

    public static File getSearchCacheFile(String urlPath) {
        String filename = XML.getName(urlPath);
        String basename = XML.stripExtension(filename);
        String ext = XML.getExtension(filename);
        if (ext != null) {
            basename = String.valueOf(basename) + "_" + ext;
        }
        basename = basename.replace('&', '_').replace('?', '_').replace('=', '_');
        filename = String.valueOf(basename) + ".xml";
        return ResourceLoader.getCacheFile(ResourceLoader.getSearchCache(), urlPath, filename);
    }

    private static File getCacheFile(File cacheFile, String urlPath, String name) {
        String cachePath = XML.forwardSlash(cacheFile.getAbsolutePath());
        urlPath = ResourceLoader.getURIPath(urlPath);
        String host = "";
        String path = "";
        String filename = "";
        try {
            URL url = new URL(urlPath);
            host = url.getHost().replace('.', '_');
            path = ResourceLoader.getNonURIPath(url.getPath());
            int n = path.indexOf(cachePath);
            if (n > -1) {
                path = path.substring(n + cachePath.length());
            }
            if ((n = path.lastIndexOf(":")) > -1) {
                path = path.substring(n + 1);
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            String pathname = XML.getName(path);
            if (!"".equals(pathname)) {
                path = XML.getDirectoryPath(path);
            }
            path = path.replace('.', '_').replace("!", "");
            filename = name == null ? pathname : name;
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if ("".equals(host)) {
            host = "local_machine";
        }
        if (!path.startsWith("osp-")) {
            cacheFile = new File(cacheFile, "osp-" + host);
        }
        if (!"".equals(path)) {
            cacheFile = new File(cacheFile, path);
        }
        if (!"".equals(filename)) {
            cacheFile = new File(cacheFile, filename);
        }
        return cacheFile;
    }

    public static File downloadToOSPCache(String urlPath, String fileName, boolean alwaysOverwrite) {
        if (fileName == null) {
            return null;
        }
        File target = ResourceLoader.getOSPCacheFile(urlPath, fileName);
        File file = ResourceLoader.download(urlPath, target, alwaysOverwrite);
        if (file == null) {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Message1")) + "\n" + ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Message2") + "\n" + ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Message3"), ToolsRes.getString("ResourceLoader.Dialog.FailedToDownload.Title"), 0);
        }
        return file;
    }

    public static String getHTMLCode(String path) {
        Resource res = ResourceLoader.getResourceZipURLsOK(path);
        if (res == null) {
            return null;
        }
        String html = res.getString();
        if (html != null && html.trim().startsWith("<!DOCTYPE html")) {
            return html;
        }
        return null;
    }

    public static String getTitleFromHTMLCode(String code) {
        if (code == null) {
            return null;
        }
        String[] parts = code.split("<title>");
        if (parts.length > 1 && (parts = parts[1].split("</title>")).length > 1) {
            return parts[0].trim();
        }
        return null;
    }

    public static String getStyleSheetFromHTMLCode(String code) {
        if (code == null) {
            return null;
        }
        String[] parts = code.split("<head>");
        if (parts.length > 1 && (parts = parts[1].split("</head>")).length > 1 && (parts = parts[0].split("<link")).length > 1) {
            int i = 1;
            while (i < parts.length) {
                if (parts[i].contains("\"stylesheet\"") && (parts = parts[i].split("href")).length > 1 && (parts = parts[1].split("\"")).length > 1) {
                    return parts[1];
                }
                ++i;
            }
        }
        return null;
    }

    public static File copyHTMLToOSPCache(String htmlPath) {
        if (htmlPath == null) {
            return null;
        }
        String htmlCode = null;
        Resource res = ResourceLoader.getResourceZipURLsOK(htmlPath);
        if (res != null) {
            if (res.getFile() != null && ResourceLoader.isOSPCachePath(htmlPath)) {
                return res.getFile();
            }
            htmlCode = res.getString();
        }
        if (htmlCode != null) {
            String htmlBasePath = XML.getDirectoryPath(htmlPath);
            File htmlTarget = ResourceLoader.getOSPCacheFile(htmlPath);
            File targetDirectory = htmlTarget.getParentFile();
            targetDirectory.mkdirs();
            File imageDir = new File(targetDirectory, "images");
            String img = "<img ";
            String pre = "src=\"";
            String post = "\"";
            String temp = htmlCode;
            int j = temp.indexOf(img);
            if (j > -1) {
                imageDir.mkdirs();
            }
            while (j > -1) {
                String filename;
                File imageTarget;
                String next;
                String path;
                temp = temp.substring(j + img.length());
                j = temp.indexOf(pre);
                if ((j = (temp = temp.substring(j + pre.length())).indexOf(post)) > -1 && (res = ResourceLoader.getResourceZipURLsOK(path = XML.getResolvedPath(next = temp.substring(0, j), htmlBasePath))) != null && (imageTarget = ResourceLoader.download(path, new File(imageDir, filename = XML.getName(next)), false)) != null && !next.equals(path = XML.getPathRelativeTo(imageTarget.getAbsolutePath(), targetDirectory.getAbsolutePath()))) {
                    htmlCode = htmlCode.replace(String.valueOf(pre) + next + post, String.valueOf(pre) + path + post);
                }
                j = temp.indexOf(img);
            }
            String css = ResourceLoader.getStyleSheetFromHTMLCode(htmlCode);
            if (css != null && !css.startsWith("http:") && (res = ResourceLoader.getResourceZipURLsOK(XML.getResolvedPath(css, htmlBasePath))) != null) {
                String cssName = XML.getName(css);
                File cssTarget = new File(targetDirectory, cssName);
                cssTarget = ResourceLoader.download(res.getAbsolutePath(), cssTarget, false);
                if (cssTarget != null && !cssName.equals(css)) {
                    htmlCode = htmlCode.replace(css, cssName);
                }
            }
            try {
                FileWriter fout = new FileWriter(htmlTarget);
                fout.write(htmlCode);
                fout.close();
                return htmlTarget;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean copyAllFiles(File inFile, File outFile) {
        block8: {
            if (!inFile.isDirectory()) break block8;
            outFile.mkdir();
            success = true;
            var6_4 = inFile.listFiles();
            var5_6 = var6_4.length;
            var4_8 = 0;
            if (true) ** GOTO lbl40
        }
        buffer = new byte[16384];
        try {
            in = new FileInputStream(inFile);
            out = new FileOutputStream(outFile);
            while (true) {
                var5_7 = buffer;
                // MONITORENTER : buffer
                amountRead = in.read(buffer);
                if (amountRead == -1) {
                    // MONITOREXIT : var5_7
                    break;
                }
                out.write(buffer, 0, amountRead);
                // MONITOREXIT : var5_7
            }
            in.close();
            out.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
        do {
            in = var6_4[var4_8];
            filename = in.getName();
            out = new File(outFile, filename);
            success = success != false && ResourceLoader.copyAllFiles(in, out) != false;
            ++var4_8;
lbl40:
            // 2 sources

        } while (var4_8 < var5_6);
        return success;
    }

    public static boolean clearOSPCache(File cache, boolean clearSearchCache) {
        if (cache == null || !cache.canWrite()) {
            return false;
        }
        boolean success = true;
        File[] files = cache.listFiles(OSP_CACHE_FILTER);
        if (files == null) {
            return true;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File next = fileArray[n2];
            success = success && ResourceLoader.deleteFile(next);
            ++n2;
        }
        if (clearSearchCache) {
            File searchCache = new File(cache, SEARCH_CACHE_SUBDIRECTORY);
            boolean bl = success = success && ResourceLoader.deleteFile(searchCache);
        }
        if (!success) {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message1")) + "\n" + ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message2"), ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Title"), 2);
        }
        return success;
    }

    public static boolean clearOSPCacheHost(File hostDir) {
        if (hostDir == null || !hostDir.canWrite()) {
            return true;
        }
        if (!OSP_CACHE_FILTER.accept(hostDir)) {
            return false;
        }
        boolean success = ResourceLoader.deleteFile(hostDir);
        if (!success) {
            JOptionPane.showMessageDialog(null, String.valueOf(ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message1")) + "\n" + ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Message2"), ToolsRes.getString("ResourceLoader.Dialog.UnableToClearCache.Title"), 2);
        }
        return success;
    }

    public static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File next = fileArray[n2];
                ResourceLoader.deleteFile(next);
                ++n2;
            }
        }
        return file.delete();
    }

    public static List<File> getFiles(File directory, FileFilter filter) {
        File[] contents;
        ArrayList<File> results = new ArrayList<File>();
        if (directory.isFile()) {
            results.add(directory);
            return results;
        }
        File[] fileArray = contents = directory.listFiles(filter);
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                List<File> deeperList = ResourceLoader.getFiles(file, filter);
                results.addAll(deeperList);
            } else {
                results.add(file);
            }
            ++n2;
        }
        return results;
    }

    public static Set<String> getZipContents(String zipPath) {
        TreeSet<String> fileNames = new TreeSet<String>();
        try {
            URL url = new URL(ResourceLoader.getURIPath(zipPath));
            OSPLog.finest("zip url: " + url.toExternalForm());
            BufferedInputStream bufIn = new BufferedInputStream(url.openStream());
            ZipInputStream input = new ZipInputStream(bufIn);
            ZipEntry zipEntry = null;
            while ((zipEntry = input.getNextEntry()) != null) {
                OSPLog.finest("zip entry: " + zipEntry);
                if (zipEntry.isDirectory()) continue;
                String fileName = zipEntry.getName();
                fileNames.add(fileName);
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<File> unzip(String zipPath, File targetDir, boolean alwaysOverwrite) {
        if (targetDir == null) {
            targetDir = new File(System.getProperty("java.io.tmpdir"));
        }
        OSPLog.finer("unzipping " + zipPath + " to " + targetDir);
        try {
            URL url = new URL(ResourceLoader.getURIPath(zipPath));
            BufferedInputStream bufIn = new BufferedInputStream(url.openStream());
            ZipInputStream input = new ZipInputStream(bufIn);
            ZipEntry zipEntry = null;
            HashSet<File> fileSet = new HashSet<File>();
            byte[] buffer = new byte[1024];
            ResourceLoader.setCanceled(false);
            block2: while (true) {
                if ((zipEntry = input.getNextEntry()) == null) {
                    input.close();
                    return fileSet;
                }
                if (zipEntry.isDirectory()) continue;
                if (ResourceLoader.isCanceled()) {
                    input.close();
                    return null;
                }
                String filename = zipEntry.getName();
                File file = new File(targetDir, filename);
                if (!alwaysOverwrite && file.exists()) {
                    fileSet.add(file);
                    continue;
                }
                file.getParentFile().mkdirs();
                FileOutputStream output = new FileOutputStream(file);
                while (true) {
                    int bytesRead;
                    if ((bytesRead = input.read(buffer)) == -1) {
                        output.close();
                        input.closeEntry();
                        fileSet.add(file);
                        continue block2;
                    }
                    output.write(buffer, 0, bytesRead);
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static File download(String urlPath, File target, boolean alwaysOverwrite) {
        urlPath = ResourceLoader.getURIPath(urlPath);
        target.getParentFile().mkdirs();
        if (alwaysOverwrite || !target.exists()) {
            OSPLog.finer("downloading " + urlPath + " to " + target);
            try {
                Resource res = ResourceLoader.getResourceZipURLsOK(urlPath);
                InputStream reader = res.openInputStream();
                FileOutputStream writer = new FileOutputStream(target);
                byte[] buffer = new byte[65536];
                int bytesRead = 0;
                while ((bytesRead = reader.read(buffer)) > 0) {
                    writer.write(buffer, 0, bytesRead);
                }
                writer.close();
                reader.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (target.exists()) {
            return target;
        }
        return null;
    }

    public static File extractFileFromZIP(String source, File target, boolean alwaysOverwrite) {
        if (!alwaysOverwrite && target.exists()) {
            return target;
        }
        String lcSource = XML.forwardSlash(source).toLowerCase();
        int n = lcSource.indexOf(".zip!/");
        if (n == -1) {
            n = lcSource.indexOf(".jar!/");
        }
        if (n == -1) {
            n = lcSource.indexOf(".trz!/");
        }
        if (n == -1) {
            return null;
        }
        String sourceName = source.substring(n + 6);
        source = source.substring(0, n + 4);
        try {
            URL url = new URL(source);
            BufferedInputStream bufIn = new BufferedInputStream(url.openStream());
            ZipInputStream input = new ZipInputStream(bufIn);
            ZipEntry zipEntry = null;
            byte[] buffer = new byte[1024];
            while ((zipEntry = input.getNextEntry()) != null) {
                int bytesRead;
                String filename;
                if (zipEntry.isDirectory() || !sourceName.contains(filename = zipEntry.getName())) continue;
                target.getParentFile().mkdirs();
                FileOutputStream output = new FileOutputStream(target);
                while ((bytesRead = input.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                output.close();
                input.closeEntry();
            }
            input.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return target;
    }

    public static boolean isURLAvailable(String urlPath) {
        try {
            URL url = new URL(urlPath);
            HttpURLConnection urlConnect = (HttpURLConnection)url.openConnection();
            urlConnect.getContent();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static String getNonURIPath(String uriPath) {
        if (uriPath == null) {
            return null;
        }
        String path = uriPath;
        boolean isJarOrFile = false;
        if (path.startsWith("jar:")) {
            path = path.substring(4);
            isJarOrFile = true;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
            isJarOrFile = true;
        }
        if (isJarOrFile) {
            while (path.startsWith("//")) {
                path = path.substring(1);
            }
        }
        if (path.startsWith("/") && path.indexOf(":") > -1) {
            path = path.substring(1);
        }
        int j = path.indexOf("%20");
        while (j > -1) {
            String s = path.substring(0, j);
            path = String.valueOf(s) + " " + path.substring(j + 3);
            j = path.indexOf("%20");
        }
        return path;
    }

    public static String getURIPath(String path) {
        if (path == null) {
            return null;
        }
        if (!(path = XML.forwardSlash(path.trim())).equals("") && XML.getExtension(path) == null && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        int i = path.indexOf(" ");
        while (i > -1) {
            String s = path.substring(0, i);
            path = String.valueOf(s) + "%20" + path.substring(i + 1);
            i = path.indexOf(" ");
        }
        if (!(path.equals("") || path.startsWith("http:") || path.startsWith("jar:") || path.startsWith("file:/"))) {
            String protocol = OSPRuntime.isWindows() ? "file:/" : "file://";
            path = String.valueOf(protocol) + path;
        }
        return path;
    }

    private static URL getAppletResourceURL(String name) {
        if (OSPRuntime.applet == null || name == null || name.trim().equals("")) {
            return null;
        }
        if (name.startsWith("http:") || name.startsWith("https:")) {
            try {
                return new URL(name);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (!(name = name.trim()).startsWith("/")) {
            for (String path : appletSearchPaths) {
                String tempName = name;
                if (tempName.startsWith("../")) {
                    tempName = tempName.substring(3);
                    int last = (path = path.substring(0, path.length() - 1)).lastIndexOf("/");
                    path = last > 0 ? path.substring(0, last) : "/";
                } else if (tempName.startsWith("./")) {
                    tempName = tempName.substring(2);
                }
                URL url = OSPRuntime.applet.getClass().getResource(String.valueOf(path) + tempName);
                if (url == null) continue;
                return url;
            }
        }
        return OSPRuntime.applet.getClass().getResource(name);
    }

    private static Resource createFileResource(String path) {
        if (OSPRuntime.applet != null) {
            return null;
        }
        if (path.indexOf(".zip") > -1 || path.indexOf(".jar") > -1 || path.indexOf(".trz") > -1) {
            return null;
        }
        File file = new File(path);
        try {
            if (file.exists() && file.canRead()) {
                Resource res = new Resource(file);
                if (path.endsWith("xset")) {
                    xsetZipLoader = null;
                }
                OSPLog.finer("File: " + XML.forwardSlash(res.getAbsolutePath()));
                return res;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Resource createURLResource(String path) {
        URL url2;
        if (!(zipURLsOK || path.indexOf(".zip") <= -1 && path.indexOf(".jar") <= -1 && path.indexOf(".trz") <= -1)) {
            return null;
        }
        Resource res = null;
        if (OSPRuntime.applet != null) {
            try {
                url2 = ResourceLoader.getAppletResourceURL(path);
                res = ResourceLoader.createResource(url2);
            }
            catch (Exception url2) {
                // empty catch block
            }
        }
        if (res == null) {
            if (path.indexOf(":/") > -1) {
                try {
                    url2 = new URL(ResourceLoader.getURIPath(path));
                    res = ResourceLoader.createResource(url2);
                }
                catch (Exception url3) {}
            } else if (OSPRuntime.applet != null && !path.startsWith("/")) {
                URL url4;
                URL docBase = OSPRuntime.applet.getDocumentBase();
                try {
                    String basePath = docBase.toString();
                    int n = basePath.indexOf("?");
                    if (n > -1) {
                        docBase = new URL(basePath.substring(0, n));
                    }
                    url4 = new URL(docBase, path);
                    res = ResourceLoader.createResource(url4);
                }
                catch (Exception basePath) {
                    // empty catch block
                }
                if (res == null) {
                    URL codeBase = OSPRuntime.applet.getCodeBase();
                    String s = String.valueOf(XML.getDirectoryPath(docBase.toExternalForm())) + "/";
                    if (!codeBase.toExternalForm().equals(s)) {
                        try {
                            url4 = new URL(codeBase, path);
                            res = ResourceLoader.createResource(url4);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (res != null) {
            if (path.endsWith(".xset")) {
                xsetZipLoader = null;
            }
            OSPLog.finer("URL: " + XML.forwardSlash(res.getAbsolutePath()));
        }
        return res;
    }

    private static Resource createZipResource(String path) {
        String zipFileName;
        File zipFile;
        boolean deleteOnExit;
        path = ResourceLoader.getNonURIPath(path);
        String base = null;
        String fileName = path;
        int i = path.indexOf("zip!/");
        if (i == -1) {
            i = path.indexOf("jar!/");
        }
        if (i == -1) {
            i = path.indexOf("exe!/");
        }
        if (i == -1) {
            i = path.indexOf("trz!/");
        }
        if (i > -1) {
            base = path.substring(0, i + 3);
            fileName = path.substring(i + 5);
        }
        if (base == null) {
            if (path.endsWith(".zip") || path.endsWith(".trz") || path.endsWith(".jar") || path.endsWith(".exe")) {
                String name = XML.stripExtension(XML.getName(path));
                base = path;
                fileName = String.valueOf(name) + ".xset";
            } else if (path.endsWith(".xset")) {
                base = String.valueOf(path.substring(0, path.length() - 4)) + "zip";
            }
        }
        boolean isZip = base != null && (base.endsWith(".zip") || base.endsWith(".jar") || base.endsWith(".trz"));
        boolean bl = deleteOnExit = ospCache == null;
        if (isZip && path.startsWith("http:") && (zipFile = ResourceLoader.downloadToOSPCache(base, zipFileName = XML.getName(base), false)) != null) {
            if (deleteOnExit) {
                zipFile.deleteOnExit();
            }
            base = zipFile.getAbsolutePath();
            path = String.valueOf(base) + "!/" + fileName;
        }
        URLClassLoader zipLoader = null;
        URL url = null;
        if (base != null) {
            try {
                ZipFile zipFile2 = new ZipFile(base);
                Enumeration<? extends ZipEntry> entries = zipFile2.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equals(fileName) || entry.getSize() <= 0L) continue;
                    url = new URL("file", null, path);
                    url = new URL("jar", null, url.toExternalForm());
                }
                zipFile2.close();
            }
            catch (IOException zipFile2) {
                // empty catch block
            }
            if (url == null) {
                zipLoader = zipLoaders.get(base);
                if (zipLoader != null) {
                    url = zipLoader.findResource(fileName);
                } else {
                    try {
                        URL classURL;
                        URL[] urls = new URL[]{new URL("file", null, base)};
                        zipLoader = new URLClassLoader(urls);
                        url = zipLoader.findResource(fileName);
                        if (url == null && (classURL = Resource.class.getResource("/" + base)) != null) {
                            urls = new URL[]{classURL};
                            zipLoader = new URLClassLoader(urls);
                            url = zipLoader.findResource(fileName);
                            zipLoader.close();
                        }
                        if (url != null) {
                            zipLoaders.put(base, zipLoader);
                        }
                    }
                    catch (Exception urls) {
                        // empty catch block
                    }
                }
            }
        }
        if (url == null && xsetZipLoader != null && (url = xsetZipLoader.findResource(fileName)) != null) {
            for (String key : zipLoaders.keySet()) {
                if (zipLoaders.get(key) != xsetZipLoader) continue;
                base = key;
                break;
            }
        }
        String launchJarPath = OSPRuntime.getLaunchJarPath();
        if (url == null && launchJarPath != null) {
            zipLoader = zipLoaders.get(launchJarPath);
            if (zipLoader != null) {
                url = zipLoader.findResource(fileName);
            } else {
                try {
                    URL classURL;
                    URL[] urls = new URL[]{new URL("file", null, launchJarPath)};
                    zipLoader = new URLClassLoader(urls);
                    url = zipLoader.findResource(fileName);
                    if (url == null && (classURL = Resource.class.getResource("/" + launchJarPath)) != null) {
                        urls = new URL[]{classURL};
                        zipLoader = new URLClassLoader(urls);
                        url = zipLoader.findResource(fileName);
                    }
                    if (url != null) {
                        zipLoaders.put(launchJarPath, zipLoader);
                    }
                }
                catch (Exception urls) {
                    // empty catch block
                }
            }
            if (url != null) {
                base = launchJarPath;
            }
        }
        if (url != null) {
            Resource res;
            block40: {
                for (String ext : extractExtensions) {
                    File target;
                    if (!url.getFile().endsWith(ext)) continue;
                    File zip = new File(base);
                    String targetPath = fileName;
                    String parent = zip.getParent();
                    if (parent != null && !targetPath.startsWith("/") && fileName.indexOf(":/") == -1) {
                        targetPath = XML.getResolvedPath(fileName, parent);
                    }
                    if (!(target = new File(targetPath)).exists()) {
                        target = JarTool.extract(zip, fileName, targetPath);
                        if (deleteOnExit) {
                            target.deleteOnExit();
                        }
                    }
                    return ResourceLoader.createFileResource(target.getAbsolutePath());
                }
                res = ResourceLoader.createResource(url);
                if (res != null && res.getAbsolutePath().indexOf(path) != -1) break block40;
                return null;
            }
            try {
                if (fileName.endsWith("xset")) {
                    xsetZipLoader = zipLoader;
                }
                OSPLog.finer("Zip: " + XML.forwardSlash(res.getAbsolutePath()));
                return res;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Resource createClassResource(String name, Class<?> type) {
        URL url3;
        if (name.indexOf(":/") != -1) {
            return null;
        }
        String originalName = name;
        int i = name.indexOf("jar!/");
        if (i == -1) {
            i = name.indexOf("exe!/");
        }
        if (i != -1) {
            name = name.substring(i + 5);
        }
        Resource res = null;
        try {
            url3 = type.getResource("/" + name);
            res = ResourceLoader.createResource(url3);
        }
        catch (Exception url2) {
            // empty catch block
        }
        if (res == null) {
            try {
                url3 = type.getResource(name);
                res = ResourceLoader.createResource(url3);
            }
            catch (Exception url3) {
                // empty catch block
            }
        }
        if (res != null) {
            String path = XML.forwardSlash(res.getAbsolutePath());
            if (path.indexOf("/jre") > -1 && path.indexOf("/lib") > -1) {
                return null;
            }
            if (!ResourceLoader.getNonURIPath(path).contains(originalName) && !path.contains(originalName)) {
                return null;
            }
            if (name.endsWith("xset")) {
                xsetZipLoader = null;
            }
            OSPLog.finer("Class resource: " + path);
            OSPRuntime.setLaunchJarPath(path);
        }
        return res;
    }

    private static Resource createResource(URL url) throws IOException {
        InputStream stream;
        if (url == null) {
            return null;
        }
        String path = url.toExternalForm();
        URL working = url;
        String content = null;
        int n = path.toLowerCase().indexOf(".zip!/");
        if (n == -1) {
            n = path.toLowerCase().indexOf(".jar!/");
        }
        if (n == -1) {
            n = path.toLowerCase().indexOf(".trz!/");
        }
        if (n > -1 && path.startsWith("http")) {
            content = path.substring(n + 6);
            working = new URL(path.substring(0, n + 4));
        }
        if ((stream = working.openStream()).read() == -1) {
            stream.close();
            return null;
        }
        stream.close();
        Resource res = new Resource(working, content);
        return res;
    }

    private static Resource findResourceInClass(String path, Class<?> type, boolean searchFiles) {
        path = path.replaceAll("/\\./", "/");
        if (type == null) {
            type = Resource.class;
        }
        Resource res = null;
        if (cacheEnabled && (res = resources.get(path)) != null && (searchFiles || res.getFile() == null)) {
            OSPLog.finest("Found in cache: " + path);
            return res;
        }
        res = ResourceLoader.createClassResource(path, type);
        if (res != null) {
            if (cacheEnabled) {
                resources.put(path, res);
            }
            return res;
        }
        return null;
    }

    private static Resource findResource(String path, Class<?> type, boolean searchFiles) {
        path = path.replaceAll("/\\./", "/");
        if (type == null) {
            type = Resource.class;
        }
        Resource res = null;
        if (cacheEnabled && (res = resources.get(path)) != null && (searchFiles || res.getFile() == null)) {
            OSPLog.finest("Found in cache: " + path);
            return res;
        }
        if (searchFiles && (res = ResourceLoader.createFileResource(path)) != null || (res = ResourceLoader.createURLResource(path)) != null || (res = ResourceLoader.createZipResource(path)) != null || (res = ResourceLoader.createClassResource(path, type)) != null) {
            if (cacheEnabled) {
                resources.put(path, res);
            }
            return res;
        }
        return null;
    }

    private static String getPath(String base, String name) {
        if (base == null) {
            base = "";
        }
        if (base.endsWith(".jar") || base.endsWith(".zip") || base.endsWith(".trz")) {
            base = String.valueOf(base) + "!";
        }
        String path = XML.getResolvedPath(name, base);
        if (OSPRuntime.isMac() && path.startsWith("file:/") && !path.startsWith("file:///")) {
            path = path.substring(6);
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = "file:///" + path;
        }
        return path;
    }
}

