/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;

public class ParamEditor
extends FunctionEditor {
    protected double[] paramValues = new double[0];
    private DatasetManager data;
    private FunctionEditor[] functionEditors;
    protected String[] paramDescriptions = new String[0];

    public ParamEditor() {
        this.paramEditor = this;
    }

    public ParamEditor(DatasetManager input) {
        this();
        this.data = input;
        this.loadParametersFromData();
    }

    public Parameter[] getParameters() {
        Parameter[] params = new Parameter[this.objects.size()];
        int i = 0;
        while (i < this.objects.size()) {
            Parameter next = (Parameter)this.objects.get(i);
            params[i] = new Parameter(next.paramName, next.expression);
            params[i].setExpressionEditable(next.isExpressionEditable());
            params[i].setNameEditable(next.isNameEditable());
            params[i].setDescription(next.getDescription());
            params[i].value = next.value;
            ++i;
        }
        return params;
    }

    public void setParameters(Parameter[] params) {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < params.length) {
            list.add(params[i]);
            ++i;
        }
        this.setObjects(list);
    }

    public void setFunctionEditors(FunctionEditor[] editors) {
        this.functionEditors = editors;
    }

    public double[] getValues() {
        return this.paramValues;
    }

    public String[] getDescriptions() {
        return this.paramDescriptions;
    }

    @Override
    public String getName(Object obj) {
        return obj == null ? null : ((Parameter)obj).paramName;
    }

    @Override
    public String getExpression(Object obj) {
        return obj == null ? null : ((Parameter)obj).expression;
    }

    @Override
    public String getDescription(Object obj) {
        return obj == null ? null : ((Parameter)obj).getDescription();
    }

    @Override
    public void setDescription(Object obj, String desc) {
        if (obj != null) {
            Parameter p = (Parameter)obj;
            if (desc != null && desc.trim().equals("")) {
                desc = null;
            }
            p.setDescription(desc);
            super.setDescription(obj, desc);
        }
    }

    public void setDescription(String name, String description) {
        for (Object obj : this.objects) {
            Parameter param = (Parameter)obj;
            if (!param.getName().equals(name)) continue;
            this.setDescription(obj, description);
            break;
        }
    }

    @Override
    public String getTooltip(Object obj) {
        String s = ((Parameter)obj).getDescription();
        if (s == null) {
            s = ToolsRes.getString("ParamEditor.Table.Cell.Name.Tooltip");
            s = String.valueOf(s) + " (" + ToolsRes.getString("FunctionEditor.Tooltip.HowToEdit") + ")";
        }
        return s;
    }

    @Override
    public boolean isNameEditable(Object obj) {
        return ((Parameter)obj).isNameEditable();
    }

    @Override
    public boolean isExpressionEditable(Object obj) {
        return ((Parameter)obj).isExpressionEditable();
    }

    protected void evaluateObject(Object obj) {
        Parameter p = (Parameter)obj;
        p.evaluate(this.objects);
    }

    public ArrayList<Parameter> evaluateDependents(Parameter seed) {
        ArrayList<Parameter> temp = new ArrayList<Parameter>();
        ArrayList<Parameter> toRemove = new ArrayList<Parameter>();
        int i = 0;
        while (i < this.evaluate.size()) {
            Parameter param = (Parameter)this.evaluate.get(i);
            if (param.paramName.equals(seed.paramName)) {
                Parameter p;
                temp.add(seed);
                toRemove.add(seed);
                int j = i + 1;
                while (j < this.evaluate.size()) {
                    p = (Parameter)this.evaluate.get(j);
                    temp.add(new Parameter(p.paramName, p.expression));
                    ++j;
                }
                j = 0;
                while (j < temp.size()) {
                    p = temp.get(j);
                    p.evaluate(temp);
                    if (this.getReferences(p.getName(), null).isEmpty()) {
                        toRemove.add(p);
                    }
                    ++j;
                }
                temp.removeAll(toRemove);
                return temp;
            }
            ++i;
        }
        return temp;
    }

    @Override
    public void evaluateAll() {
        Parameter p;
        super.evaluateAll();
        if (this.getClass() != ParamEditor.class) {
            return;
        }
        if (this.paramValues.length != this.objects.size()) {
            this.paramValues = new double[this.objects.size()];
        }
        int i = 0;
        while (i < this.evaluate.size()) {
            p = (Parameter)this.evaluate.get(i);
            p.evaluate(this.objects);
            ++i;
        }
        if (this.paramDescriptions.length != this.objects.size()) {
            this.paramDescriptions = new String[this.objects.size()];
        }
        i = 0;
        while (i < this.objects.size()) {
            p = (Parameter)this.objects.get(i);
            this.paramValues[i] = p.getValue();
            this.paramDescriptions[i] = p.getDescription();
            ++i;
        }
    }

    @Override
    protected boolean isDisallowedName(Object obj, String name) {
        boolean disallowed = super.isDisallowedName(obj, name);
        if (!disallowed && obj != null && this.getName(obj).equals(name)) {
            return false;
        }
        if (this.functionEditors != null) {
            int i = 0;
            while (i < this.functionEditors.length) {
                disallowed = disallowed || this.functionEditors[i].isDisallowedName(null, name);
                ++i;
            }
        }
        return disallowed;
    }

    @Override
    protected void paste() {
        XMLControl[] controls = this.getClipboardContents();
        if (controls == null) {
            return;
        }
        int i = 0;
        while (i < controls.length) {
            Parameter param = (Parameter)controls[i].loadObject(null);
            param.setNameEditable(true);
            param.setExpressionEditable(true);
            this.addObject(param, true);
            ++i;
        }
        this.evaluateAll();
    }

    @Override
    protected boolean isInvalidExpression(Object obj) {
        return Double.isNaN(((Parameter)obj).getValue());
    }

    @Override
    protected Object createObject(String name, String expression, Object obj) {
        Parameter original = (Parameter)obj;
        if (original != null && original.paramName.equals(name) && original.expression.equals(expression)) {
            return original;
        }
        Parameter p = new Parameter(name, expression);
        if (original != null) {
            p.setExpressionEditable(original.isExpressionEditable());
            p.setNameEditable(original.isNameEditable());
            p.setDescription(original.getDescription());
        }
        return p;
    }

    @Override
    protected void refreshGUI() {
        super.refreshGUI();
        this.newButton.setToolTipText(ToolsRes.getString("ParamEditor.Button.New.Tooltip"));
        this.titledBorder.setTitle(ToolsRes.getString("ParamEditor.Border.Title"));
    }

    public void loadParametersFromData() {
        String[] names;
        if (this.data == null) {
            return;
        }
        String[] stringArray = names = this.data.getConstantNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String expression = this.data.getConstantExpression(name);
            Parameter p = (Parameter)this.getObject(name);
            if (p == null) {
                p = new Parameter(name, expression);
                p.setDescription(this.data.getConstantDescription(name));
                this.addObject(p, false);
            } else {
                this.setExpression(name, expression, false);
            }
            ++n2;
        }
    }

    protected void refreshParametersFromFunction(UserFunction f) {
        int i = 0;
        while (i < f.getParameterCount()) {
            String name = f.getParameterName(i);
            String val = String.valueOf(f.getParameterValue(i));
            Parameter p = (Parameter)this.getObject(name);
            if (p == null) {
                p = new Parameter(name, val);
                p.setNameEditable(false);
                p.setExpressionEditable(false);
                this.addObject(p, false);
            } else {
                this.setExpression(name, val, false);
            }
            ++i;
        }
    }

    @Override
    protected String getDefaultName() {
        return ToolsRes.getString("ParamEditor.New.Name.Default");
    }
}

