/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class FunctionTool
extends JDialog {
    protected static String[] parserNames = new String[]{"e", "pi", "min", "mod", "sin", "cos", "abs", "log", "acos", "acosh", "ceil", "cosh", "asin", "asinh", "atan", "atanh", "exp", "frac", "floor", "int", "random", "round", "sign", "sinh", "step", "tanh", "atan2", "max", "sqrt", "sqr", "if", "tan"};
    protected static String[] parserOperators = new String[]{"!", ",", ".", "+", "-", "*", "/", "^", "=", ">", "<", "&", "|", "(", ")"};
    protected Set<DatasetCurveFitter> curveFitters = new HashSet<DatasetCurveFitter>();
    protected Map<String, FunctionPanel> panels = new TreeMap<String, FunctionPanel>();
    protected HashSet<String> forbiddenNames = new HashSet();
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected JPanel noData;
    protected JToolBar toolbar;
    protected JToolBar dropdownbar;
    protected JLabel dropdownLabel;
    protected JComboBox dropdown;
    protected JPanel north = new JPanel(new BorderLayout());
    protected FunctionPanel selectedPanel;
    protected JScrollPane selectedPanelScroller;
    protected JButton helpButton;
    protected JButton closeButton;
    protected JButton fontButton;
    protected JButton undoButton;
    protected JButton redoButton;
    protected JPopupMenu popup;
    protected JMenuItem defaultFontSizeItem;
    protected JPanel buttonbar = new JPanel(new FlowLayout());
    protected Component[] toolbarComponents;
    protected String helpPath = "";
    protected String helpBase = "http://www.opensourcephysics.org/online_help/tools/";
    protected TextFrame helpFrame;
    protected JDialog helpDialog;
    protected ActionListener helpAction;
    protected int fontLevel = 0;
    protected boolean refreshing;

    public FunctionTool(Component comp) {
        this(comp, null);
    }

    public FunctionTool(Component comp, Component[] toolbarItems) {
        super(JOptionPane.getFrameForComponent(comp), comp == null);
        this.addForbiddenNames(parserNames);
        this.addForbiddenNames(UserFunction.dummyVars);
        this.setName("FunctionTool");
        this.createGUI();
        this.setToolbarComponents(toolbarItems);
    }

    public void setToolbarComponents(Component[] toolbarItems) {
        this.toolbarComponents = toolbarItems;
        this.refreshGUI();
    }

    public Component[] getToolbarComponents() {
        return this.toolbarComponents;
    }

    public FunctionPanel addPanel(String name, FunctionPanel panel) {
        OSPLog.finest("adding panel " + name);
        panel.setFontLevel(this.fontLevel);
        panel.setName(name);
        panel.setFunctionTool(this);
        this.panels.put(name, panel);
        panel.addForbiddenNames(this.forbiddenNames.toArray(new String[0]));
        this.refreshDropdown(name);
        panel.clearSelection();
        return panel;
    }

    public FunctionPanel removePanel(String name) {
        FunctionPanel panel = this.panels.get(name);
        if (panel != null) {
            OSPLog.finest("removing panel " + name);
            this.panels.remove(name);
            this.refreshDropdown(null);
            this.firePropertyChange("panel", panel, null);
        }
        return panel;
    }

    public FunctionPanel renamePanel(String prevName, String newName) {
        FunctionPanel panel = this.getPanel(prevName);
        if (panel == null || prevName.equals(newName)) {
            return panel;
        }
        OSPLog.finest("renaming panel " + prevName + " to " + newName);
        this.panels.remove(prevName);
        this.panels.put(newName, panel);
        panel.prevName = prevName;
        panel.setName(newName);
        this.refreshDropdown(newName);
        return panel;
    }

    public void setSelectedPanel(String name) {
        Object item = this.getDropdownItem(name);
        if (item != null) {
            this.dropdown.setSelectedItem(item);
        }
    }

    public String getSelectedName() {
        if (this.selectedPanel == null) {
            return null;
        }
        for (String name : this.panels.keySet()) {
            if (this.panels.get(name) != this.selectedPanel) continue;
            return name;
        }
        return null;
    }

    public FunctionPanel getSelectedPanel() {
        return this.getPanel(this.getSelectedName());
    }

    public FunctionPanel getPanel(String name) {
        return name == null ? null : this.panels.get(name);
    }

    public Set<String> getPanelNames() {
        return this.panels.keySet();
    }

    public void clearPanels() {
        OSPLog.finest("clearing panels");
        this.panels.clear();
        this.refreshDropdown(null);
    }

    public void addForbiddenNames(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.forbiddenNames.add(names[i]);
            ++i;
        }
    }

    @Override
    public void setVisible(boolean vis) {
        if (this.contentPane.getTopLevelAncestor() == this) {
            super.setVisible(vis);
        } else {
            this.contentPane.getTopLevelAncestor().setVisible(vis);
        }
        this.firePropertyChange("visible", null, new Boolean(vis));
    }

    @Override
    public boolean isVisible() {
        if (this.contentPane.getTopLevelAncestor() == this) {
            return super.isVisible();
        }
        return this.contentPane.getTopLevelAncestor().isVisible();
    }

    public void setHelpPath(String path) {
        this.helpPath = path;
    }

    public void setHelpAction(ActionListener action) {
        this.helpButton.removeActionListener(this.helpAction);
        this.helpAction = action;
        this.helpButton.addActionListener(this.helpAction);
    }

    public boolean isEmpty() {
        return this.panels.isEmpty();
    }

    public void setFontLevel(int level) {
        if ((level = Math.max(0, level)) == this.fontLevel) {
            return;
        }
        this.fontLevel = level;
        boolean vis = this.isVisible();
        this.setVisible(false);
        FontSizer.setFonts(this, level);
        FontSizer.setFonts(this.contentPane, level);
        FontSizer.setFonts(this.popup, level);
        FontSizer.setFonts(this.fontButton, level);
        for (FunctionPanel next : this.panels.values()) {
            if (next == this.getSelectedPanel()) continue;
            next.setFontLevel(level);
        }
        if (level < this.popup.getSubElements().length) {
            MenuElement[] e = this.popup.getSubElements();
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)e[level];
            item.setSelected(true);
        }
        int n = this.dropdown.getSelectedIndex();
        Object[] items = new Object[this.dropdown.getItemCount()];
        int i = 0;
        while (i < items.length) {
            items[i] = this.dropdown.getItemAt(i);
            ++i;
        }
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(items);
        this.dropdown.setModel(model);
        this.dropdown.setSelectedItem(n);
        Container c = this.contentPane.getTopLevelAncestor();
        Dimension dim = c.getSize();
        dim.width = c.getMinimumSize().width;
        int h = (int)(280.0 * FontSizer.getFactor(level));
        h = Math.max(h, dim.height);
        dim.height = h = Math.min(h, (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        this.setSize(dim);
        c.setSize(dim);
        this.setVisible(vis);
        this.refreshDropdown(null);
    }

    public int getFontLevel() {
        return this.fontLevel;
    }

    public void setDefaultVariables(String[] vars) {
        for (String name : this.getPanelNames()) {
            FunctionPanel panel = this.getPanel(name);
            UserFunctionEditor editor = (UserFunctionEditor)panel.getFunctionEditor();
            editor.setDefaultVariables(vars);
            editor.repaint();
        }
    }

    @Override
    protected void firePropertyChange(String name, Object oldObj, Object newObj) {
        super.firePropertyChange(name, oldObj, newObj);
    }

    private void createGUI() {
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                FunctionTool.this.refreshGUI();
                if (FunctionTool.this instanceof FitBuilder) {
                    FunctionTool.this.refreshDropdown(null);
                }
            }
        });
        this.setDefaultCloseOperation(1);
        this.noData = new JPanel(new BorderLayout());
        this.dropdownbar = new JToolBar();
        this.dropdownbar.setFloatable(false);
        this.dropdownLabel = new JLabel();
        this.dropdownLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
        this.dropdownLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                String name = FunctionTool.this.getSelectedName();
                if (name != null) {
                    FunctionPanel panel = FunctionTool.this.panels.get(name);
                    panel.clearSelection();
                }
            }
        });
        this.dropdownbar.add(this.dropdownLabel);
        this.dropdown = new JComboBox(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                if (FunctionTool.this.toolbarComponents != null && FunctionTool.this.toolbarComponents.length > 0 & FunctionTool.this.toolbarComponents[0] instanceof JButton) {
                    JButton button = (JButton)FunctionTool.this.toolbarComponents[0];
                    dim.height = button.getHeight();
                }
                return dim;
            }

            public void addItem(Object obj) {
                String name;
                if (obj == null) {
                    return;
                }
                int count = this.getItemCount();
                int i = 0;
                while (i < count) {
                    if (obj.equals(this.getItemAt(i))) {
                        return;
                    }
                    ++i;
                }
                Object[] array = (Object[])obj;
                String string = name = array.length > 2 ? (String)array[2] : (String)array[1];
                if (FunctionTool.this instanceof FitBuilder) {
                    name = FitBuilder.localize(name);
                }
                boolean added = false;
                int i2 = 0;
                while (i2 < count) {
                    String next;
                    Object[] nextArray = (Object[])this.getItemAt(i2);
                    String string2 = next = nextArray.length > 2 ? (String)nextArray[2] : (String)nextArray[1];
                    if (FunctionTool.this instanceof FitBuilder) {
                        next = FitBuilder.localize(next);
                    }
                    if (name.compareToIgnoreCase(next) < 0) {
                        this.insertItemAt(obj, i2);
                        added = true;
                        break;
                    }
                    ++i2;
                }
                if (!added) {
                    super.addItem(obj);
                }
            }
        };
        this.dropdown.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.dropdownbar.add(this.dropdown);
        DropdownRenderer renderer = new DropdownRenderer();
        this.dropdown.setRenderer(renderer);
        this.dropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = FunctionTool.this.dropdown.getSelectedItem();
                if (item != null) {
                    String name = ((Object[])item)[1].toString();
                    FunctionTool.this.select(name);
                    FunctionPanel panel = FunctionTool.this.panels.get(name);
                    if (panel != null) {
                        panel.getFunctionTable().clearSelection();
                        panel.getFunctionTable().selectOnFocus = false;
                        panel.getParamTable().clearSelection();
                        panel.getParamTable().selectOnFocus = false;
                        panel.refreshGUI();
                    }
                }
                FunctionTool.this.helpButton.requestFocusInWindow();
            }
        });
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.north.add((Component)this.dropdownbar, "South");
        this.north.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.closeButton = new JButton(ToolsRes.getString("Tool.Button.Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionTool.this.setVisible(false);
            }
        });
        this.helpAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FunctionTool.this.helpFrame == null) {
                    String help = XML.getResolvedPath(FunctionTool.this.helpPath, FunctionTool.this.helpBase);
                    if (ResourceLoader.getResource(help) != null) {
                        FunctionTool.this.helpFrame = new TextFrame(help);
                    } else {
                        String classBase = "/org/opensourcephysics/resources/tools/html/";
                        help = XML.getResolvedPath(FunctionTool.this.helpPath, classBase);
                        FunctionTool.this.helpFrame = new TextFrame(help);
                    }
                    FunctionTool.this.helpDialog = new JDialog((Dialog)FunctionTool.this, false);
                    FunctionTool.this.helpDialog.setContentPane(FunctionTool.this.helpFrame.getContentPane());
                    FunctionTool.this.helpDialog.setSize(700, 550);
                    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                    int x = (dim.width - FunctionTool.this.helpDialog.getBounds().width) / 2;
                    int y = (dim.height - FunctionTool.this.helpDialog.getBounds().height) / 2;
                    FunctionTool.this.helpDialog.setLocation(x, y);
                }
                FunctionTool.this.helpDialog.setVisible(true);
            }
        };
        this.helpButton = new JButton(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.addActionListener(this.helpAction);
        this.undoButton = new JButton(ToolsRes.getString("DataFunctionPanel.Button.Undo"));
        this.redoButton = new JButton(ToolsRes.getString("DataFunctionPanel.Button.Redo"));
        this.fontButton = new JButton(ToolsRes.getString("Tool.Menu.FontSize"));
        this.popup = new JPopupMenu();
        ButtonGroup group = new ButtonGroup();
        AbstractAction fontSizeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = Integer.parseInt(e.getActionCommand());
                FunctionTool.this.setFontLevel(i);
            }
        };
        int i = 0;
        while (i < 4) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem("+" + i);
            if (i == 0) {
                this.defaultFontSizeItem = item;
            }
            item.addActionListener(fontSizeAction);
            item.setActionCommand("" + i);
            this.popup.add(item);
            group.add(item);
            if (i == this.fontLevel) {
                item.setSelected(true);
            }
            ++i;
        }
        this.fontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionTool.this.popup.show(FunctionTool.this.fontButton, 0, FunctionTool.this.fontButton.getHeight());
            }
        });
        this.buttonbar.setBorder(BorderFactory.createEtchedBorder());
        this.buttonbar.add(this.helpButton);
        this.buttonbar.add(this.undoButton);
        this.buttonbar.add(this.redoButton);
        this.buttonbar.add(this.fontButton);
        this.buttonbar.add(this.closeButton);
        this.contentPane.add((Component)this.north, "North");
        this.contentPane.add((Component)this.noData, "Center");
        this.contentPane.add((Component)this.buttonbar, "South");
        this.setContentPane(this.contentPane);
        this.pack();
        Dimension dim = this.getSize();
        dim.height = Math.max(360, dim.height);
        this.setSize(dim);
        this.buttonbar.remove(this.undoButton);
        this.buttonbar.remove(this.redoButton);
        this.buttonbar.remove(this.fontButton);
        this.dropdown.setEnabled(false);
        this.dropdownLabel.setEnabled(false);
        dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    protected void refreshGUI() {
        if (this.toolbarComponents == null) {
            this.north.remove(this.toolbar);
        } else {
            this.north.add((Component)this.toolbar, "North");
            this.toolbar.removeAll();
            int i = 0;
            while (i < this.toolbarComponents.length) {
                this.toolbar.add(this.toolbarComponents[i]);
                ++i;
            }
        }
        if (this.selectedPanel != null) {
            String label = this.selectedPanel.getLabel();
            this.dropdownLabel.setText(String.valueOf(label) + ":");
        }
        this.closeButton.setText(ToolsRes.getString("Tool.Button.Close"));
        this.closeButton.setToolTipText(ToolsRes.getString("Tool.Button.Close.ToolTip"));
        this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.fontButton.setText(ToolsRes.getString("Tool.Menu.FontSize"));
        this.fontButton.setToolTipText(ToolsRes.getString("FunctionTool.Button.Display.Tooltip"));
        this.defaultFontSizeItem.setText(ToolsRes.getString("Tool.MenuItem.DefaultFontSize"));
        for (FunctionPanel panel : this.panels.values()) {
            panel.refreshGUI();
        }
        Dimension dim = this.getSize();
        dim.width = Math.max(dim.width, this.getMinimumSize().width);
        this.setSize(dim);
        this.helpButton.requestFocusInWindow();
    }

    private Object getDropdownItem(String name) {
        int i = 0;
        while (i < this.dropdown.getItemCount()) {
            Object item = this.dropdown.getItemAt(i);
            String itemName = ((Object[])item)[1].toString();
            if (itemName.equals(name)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public void refreshDropdown(String name) {
        Object item;
        this.refreshing = true;
        if (name == null && (item = this.dropdown.getSelectedItem()) != null) {
            name = ((Object[])item)[1].toString();
        }
        Object[] toSelect = null;
        this.dropdown.removeAllItems();
        for (String next : this.panels.keySet()) {
            FunctionPanel panel = this.panels.get(next);
            String displayName = panel.getDisplayName();
            Icon icon = panel.getIcon();
            if (icon != null && icon instanceof ResizableIcon) {
                int factor = FontSizer.getIntegerFactor(FontSizer.getLevel());
                ((ResizableIcon)icon).resize(factor);
            }
            Object[] item2 = new Object[]{icon, next, displayName};
            this.dropdown.addItem(item2);
            if (toSelect != null && !next.equals(name)) continue;
            toSelect = item2;
        }
        this.refreshing = false;
        if (toSelect != null) {
            this.dropdown.setSelectedItem(toSelect);
        } else {
            this.select(null);
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                FunctionTool.this.dropdown.revalidate();
                FunctionTool.this.helpButton.requestFocusInWindow();
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    private void select(String name) {
        if (this.refreshing) {
            return;
        }
        FunctionPanel panel = name == null ? null : this.panels.get(name);
        FunctionPanel prev = this.selectedPanel;
        if (this.selectedPanel != null) {
            this.contentPane.remove(this.selectedPanelScroller);
        } else {
            this.contentPane.remove(this.noData);
        }
        this.selectedPanel = panel;
        this.dropdown.setEnabled(panel != null);
        this.dropdownLabel.setEnabled(panel != null);
        if (panel != null) {
            this.selectedPanelScroller = new JScrollPane(panel);
            this.contentPane.add((Component)this.selectedPanelScroller, "Center");
            panel.refreshGUI();
        } else {
            this.contentPane.add((Component)this.noData, "Center");
            this.buttonbar.removeAll();
            this.buttonbar.add(this.helpButton);
            this.buttonbar.add(this.closeButton);
        }
        Container c = this.contentPane.getTopLevelAncestor();
        c.validate();
        this.refreshGUI();
        c.repaint();
        this.firePropertyChange("panel", prev, panel);
    }

    protected String getUniqueName(String proposedName) {
        int i = 0;
        String name = proposedName;
        if (ToolsRes.getString("DatasetCurveFitter.NewFit.Name").equals(proposedName)) {
            name = String.valueOf(name) + ++i;
        }
        while (this.panels.keySet().contains(name) || this.forbiddenNames.contains(name)) {
            name = String.valueOf(proposedName) + ++i;
        }
        return name;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public class DropdownRenderer
    extends JLabel
    implements ListCellRenderer {
        public DropdownRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null) {
                String val;
                Object[] array = (Object[])value;
                this.setIcon((Icon)array[0]);
                String string = val = array.length > 2 ? (String)array[2] : (String)array[1];
                if (FunctionTool.this instanceof FitBuilder) {
                    val = FitBuilder.localize(val);
                }
                this.setText(val);
            } else {
                this.setIcon(null);
                this.setText(null);
            }
            return this;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            FunctionTool tool = (FunctionTool)obj;
            ArrayList<FunctionPanel> functions = new ArrayList<FunctionPanel>(tool.panels.values());
            control.setValue("functions", functions);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            FunctionTool tool = (FunctionTool)obj;
            ArrayList functions = (ArrayList)control.getObject("functions");
            if (functions != null) {
                for (FunctionPanel panel : functions) {
                    tool.addPanel(panel.getName(), panel);
                }
            }
            return obj;
        }
    }
}

