/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.DataFunctionEditor;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.ToolsRes;

public class FunctionPanel
extends JPanel
implements PropertyChangeListener {
    protected FunctionTool functionTool;
    protected ParamEditor paramEditor;
    protected FunctionEditor functionEditor;
    protected Container box;
    protected JTextPane instructions;
    private JButton undoButton;
    private JButton redoButton;
    private UndoableEditSupport undoSupport;
    protected UndoManager undoManager;
    private int varBegin;
    private int varEnd;
    protected JTextField tableEditorField;
    protected String prevName;
    protected String description;
    private Icon icon;

    public FunctionPanel(FunctionEditor editor) {
        super(new BorderLayout());
        this.functionEditor = editor;
        editor.functionPanel = this;
        this.createGUI();
        this.refreshGUI();
    }

    public ParamEditor getParamEditor() {
        return this.paramEditor;
    }

    public FunctionEditor getFunctionEditor() {
        return this.functionEditor;
    }

    public FunctionEditor.Table getFunctionTable() {
        return this.functionEditor.getTable();
    }

    public FunctionEditor.Table getParamTable() {
        return this.paramEditor.getTable();
    }

    public String getLabel() {
        return ToolsRes.getString("FunctionPanel.Label");
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = this.paramEditor.buttonPanel.getPreferredSize().width;
        return dim;
    }

    protected void addForbiddenNames(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.functionEditor.forbiddenNames.add(names[i]);
            if (this.paramEditor != null) {
                this.paramEditor.forbiddenNames.add(names[i]);
            }
            ++i;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("edit")) {
            if (e.getNewValue() instanceof UndoableEdit) {
                this.undoSupport.postEdit((UndoableEdit)e.getNewValue());
            }
            this.refreshFunctions();
            this.refreshGUI();
            if (this.functionTool != null && this.functionEditor.getObjects().size() > 0) {
                String functionName = (String)e.getOldValue();
                String prevName = null;
                if (e.getNewValue() instanceof FunctionEditor.DefaultEdit) {
                    FunctionEditor.DefaultEdit edit = (FunctionEditor.DefaultEdit)e.getNewValue();
                    if (edit.editType == 2) {
                        prevName = edit.undoObj.toString();
                    }
                } else if (e.getNewValue() instanceof String) {
                    prevName = e.getNewValue().toString();
                }
                this.functionTool.firePropertyChange("function", prevName, functionName);
            }
        } else if (e.getPropertyName().equals("function")) {
            this.refreshFunctions();
            this.refreshGUI();
            if (this.functionTool != null) {
                this.functionTool.refreshGUI();
                this.functionTool.firePropertyChange("function", null, null);
            }
        } else if (e.getPropertyName().equals("description") && this.functionTool != null) {
            this.functionTool.firePropertyChange("description", null, null);
        }
    }

    protected void clearSelection() {
        this.getFunctionTable().clearSelection();
        this.getParamTable().clearSelection();
        this.refreshInstructions(null, false, -1);
    }

    protected void createGUI() {
        this.instructions = new JTextPane(){

            @Override
            public void paintComponent(Graphics g) {
                if (OSPRuntime.antiAliasText.booleanValue()) {
                    Graphics2D g2 = (Graphics2D)g;
                    RenderingHints rh = g2.getRenderingHints();
                    rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paintComponent(g);
            }
        };
        this.instructions.setEditable(false);
        this.instructions.setOpaque(false);
        this.instructions.setFocusable(false);
        this.instructions.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        StyledDocument doc = this.instructions.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(def, "SansSerif");
        Style blue = doc.addStyle("blue", def);
        StyleConstants.setBold(blue, false);
        StyleConstants.setForeground(blue, Color.blue);
        Style red = doc.addStyle("red", blue);
        StyleConstants.setBold(red, true);
        StyleConstants.setForeground(red, Color.red);
        this.instructions.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FunctionPanel.this.varEnd == 0) {
                    return;
                }
                FunctionPanel.this.instructions.setCaretPosition(FunctionPanel.this.varBegin);
                FunctionPanel.this.instructions.moveCaretPosition(FunctionPanel.this.varEnd);
                FunctionPanel.this.tableEditorField.replaceSelection(FunctionPanel.this.instructions.getSelectedText());
                FunctionPanel.this.tableEditorField.setBackground(Color.yellow);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!FunctionPanel.this.hasCircularErrors() && !FunctionPanel.this.hasInvalidExpressions()) {
                    StyledDocument doc = FunctionPanel.this.instructions.getStyledDocument();
                    Style blue = doc.getStyle("blue");
                    doc.setCharacterAttributes(0, FunctionPanel.this.instructions.getText().length(), blue, false);
                    FunctionPanel.this.varEnd = 0;
                    FunctionPanel.this.varBegin = 0;
                }
            }
        });
        this.instructions.addMouseMotionListener(new MouseMotionAdapter(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void mouseMoved(MouseEvent e) {
                FunctionPanel.access$2(FunctionPanel.this, 0);
                FunctionPanel.access$3(FunctionPanel.this, 0);
                text = FunctionPanel.this.instructions.getText();
                startVars = text.indexOf(": ");
                if (startVars == -1) {
                    return;
                }
                vars = text.substring(startVars += 2);
                doc = FunctionPanel.this.instructions.getStyledDocument();
                blue = doc.getStyle("blue");
                red = doc.getStyle("red");
                beginVar = FunctionPanel.this.instructions.viewToModel(e.getPoint()) - startVars;
                if (beginVar >= 0) ** GOTO lbl17
                doc.setCharacterAttributes(0, text.length(), blue, false);
                return;
                while (!(s = vars.substring(0, beginVar)).endsWith(" ")) {
                    --beginVar;
lbl17:
                    // 2 sources

                    if (beginVar > 0) continue;
                }
                FunctionPanel.access$3(FunctionPanel.this, beginVar + startVars);
                s = vars.substring(beginVar);
                len = s.indexOf(",");
                if (len == -1) {
                    len = s.indexOf(" ");
                }
                if (len == -1) {
                    len = s.length();
                }
                FunctionPanel.access$2(FunctionPanel.this, FunctionPanel.access$1(FunctionPanel.this) + len);
                doc.setCharacterAttributes(0, FunctionPanel.access$1(FunctionPanel.this), blue, false);
                doc.setCharacterAttributes(FunctionPanel.access$1(FunctionPanel.this), len, red, false);
                doc.setCharacterAttributes(FunctionPanel.access$0(FunctionPanel.this), text.length() - FunctionPanel.access$0(FunctionPanel.this), blue, false);
            }
        });
        this.box = Box.createVerticalBox();
        this.add((Component)this.box, "Center");
        if (this.functionEditor instanceof DataFunctionEditor) {
            DataFunctionEditor dfEditor = (DataFunctionEditor)this.functionEditor;
            this.paramEditor = new ParamEditor(dfEditor.getData());
        } else {
            this.paramEditor = new ParamEditor();
        }
        this.paramEditor.functionPanel = this;
        this.functionEditor.setParamEditor(this.paramEditor);
        this.paramEditor.setFunctionEditors(new FunctionEditor[]{this.functionEditor});
        this.box.add(this.paramEditor);
        this.box.add(this.functionEditor);
        this.paramEditor.addPropertyChangeListener(this);
        this.paramEditor.addPropertyChangeListener(this.functionEditor);
        this.functionEditor.addPropertyChangeListener(this);
        this.functionEditor.addPropertyChangeListener(this.paramEditor);
        JScrollPane scroller = new JScrollPane(this.instructions){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                Font font = FunctionPanel.this.instructions.getFont();
                dim.height = Math.max(dim.height, font.getSize() * 4);
                return dim;
            }
        };
        this.box.add(scroller);
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.undoButton = new JButton();
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionPanel.this.undoManager.undo();
            }
        });
        this.redoButton = new JButton();
        this.redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionPanel.this.undoManager.redo();
            }
        });
    }

    protected void refreshGUI() {
        this.undoButton.setText(ToolsRes.getString("DataFunctionPanel.Button.Undo"));
        this.undoButton.setToolTipText(ToolsRes.getString("DataFunctionPanel.Button.Undo.Tooltip"));
        this.redoButton.setText(ToolsRes.getString("DataFunctionPanel.Button.Redo"));
        this.redoButton.setToolTipText(ToolsRes.getString("DataFunctionPanel.Button.Redo.Tooltip"));
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
        if (this.functionTool != null && this.functionTool.getSelectedPanel() == this) {
            boolean needsButtons = true;
            Component[] componentArray = this.functionTool.buttonbar.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c == this.undoButton) {
                    needsButtons = false;
                }
                ++n2;
            }
            if (needsButtons) {
                this.functionTool.buttonbar.removeAll();
                this.functionTool.buttonbar.add(this.functionTool.helpButton);
                this.functionTool.buttonbar.add(this.undoButton);
                this.functionTool.buttonbar.add(this.redoButton);
                this.functionTool.buttonbar.add(this.functionTool.fontButton);
                this.functionTool.buttonbar.add(this.functionTool.closeButton);
            }
            this.paramEditor.refreshGUI();
            this.functionEditor.refreshGUI();
        }
    }

    protected void setFontLevel(int level) {
        FontSizer.setFonts(this, level);
        FontSizer.setFonts(this.undoButton, level);
        FontSizer.setFonts(this.redoButton, level);
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    protected void refreshFunctions() {
        this.functionEditor.evaluateAll();
    }

    protected void setFunctionTool(FunctionTool tool) {
        this.functionTool = tool;
    }

    protected void tabToNext(FunctionEditor editor) {
        if (editor == this.functionEditor) {
            this.functionTool.helpButton.requestFocusInWindow();
        } else {
            this.functionEditor.newButton.requestFocusInWindow();
        }
    }

    protected void refreshInstructions(FunctionEditor source, boolean editing, int selectedColumn) {
        String s;
        StyledDocument doc = this.instructions.getStyledDocument();
        Style style = doc.getStyle("blue");
        String string = s = this.isEmpty() ? ToolsRes.getString("FunctionPanel.Instructions.GetStarted") : String.valueOf(ToolsRes.getString("FunctionPanel.Instructions.General")) + "  " + ToolsRes.getString("FunctionPanel.Instructions.EditDescription");
        if (!editing && this.hasCircularErrors()) {
            s = ToolsRes.getString("FunctionPanel.Instructions.CircularErrors");
            style = doc.getStyle("red");
        } else if (!editing && this.hasInvalidExpressions()) {
            s = ToolsRes.getString("FunctionPanel.Instructions.BadCell");
            style = doc.getStyle("red");
        } else if (source != null) {
            if (selectedColumn == 0 && editing) {
                s = ToolsRes.getString("FunctionPanel.Instructions.NameCell");
            } else if (selectedColumn == 1 && editing) {
                s = source.getVariablesString(": ");
            } else if (selectedColumn > -1) {
                s = ToolsRes.getString("FunctionPanel.Instructions.EditCell");
                if (selectedColumn == 0) {
                    s = String.valueOf(s) + "  " + ToolsRes.getString("FunctionPanel.Instructions.NameCell");
                    s = String.valueOf(s) + "\n" + ToolsRes.getString("FunctionPanel.Instructions.EditDescription");
                } else {
                    s = String.valueOf(s) + " " + ToolsRes.getString("FunctionPanel.Instructions.Help");
                }
            }
        }
        this.instructions.setText(s);
        int len = this.instructions.getText().length();
        doc.setCharacterAttributes(0, len, style, false);
        this.revalidate();
    }

    protected boolean isEmpty() {
        return this.functionEditor.getObjects().size() == 0 && this.paramEditor.getObjects().size() == 0;
    }

    protected boolean hasInvalidExpressions() {
        return this.functionEditor.containsInvalidExpressions() || this.paramEditor.containsInvalidExpressions();
    }

    protected boolean hasCircularErrors() {
        return !this.functionEditor.circularErrors.isEmpty() || !this.paramEditor.circularErrors.isEmpty();
    }
}

