/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.AbstractAutoloadManager;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.KnownPolynomial;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.TristateCheckBox;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class FitBuilder
extends FunctionTool {
    static JFileChooser chooser;
    static FileFilter xmlFilter;
    static String[] preferredAutoloadSearchPaths;
    static Collection<String> initialAutoloadSearchPaths;
    static Map<String, String[]> autoloadMap;
    protected JButton newFitButton;
    protected JButton deleteFitButton;
    protected JButton cloneFitButton;
    protected JButton loadButton;
    protected JButton saveButton;
    protected JButton autoloadButton;
    protected Component parent;
    protected TreeSet<String> addedFits = new TreeSet();
    protected String defaultFitName;
    protected AutoloadManager autoloadManager;

    static {
        initialAutoloadSearchPaths = new TreeSet<String>();
        autoloadMap = new TreeMap<String, String[]>();
        xmlFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null || f.isDirectory()) {
                    return false;
                }
                String ext = XML.getExtension(f.getName());
                return ext != null && "xml".equals(ext.toLowerCase());
            }
        };
        preferredAutoloadSearchPaths = (String[])OSPRuntime.getPreference("autoload_search_paths");
        String[][] autoloadData = (String[][])OSPRuntime.getPreference("autoload_exclusions");
        if (autoloadData != null) {
            String[][] stringArray = autoloadData;
            int n = autoloadData.length;
            int n2 = 0;
            while (n2 < n) {
                String[] next = stringArray[n2];
                String filePath = XML.forwardSlash(next[0]);
                String[] functions = new String[next.length - 1];
                System.arraycopy(next, 1, functions, 0, functions.length);
                autoloadMap.put(filePath, functions);
                ++n2;
            }
        }
    }

    public FitBuilder(Component c) {
        super(c);
        this.parent = c;
        this.newFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Text"));
        this.newFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Tooltip"));
        this.newFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = FitBuilder.this.getUniqueName(ToolsRes.getString("DatasetCurveFitter.NewFit.Name"));
                UserFunction f = new UserFunction(name);
                Dataset dataset = null;
                DatasetCurveFitter fitter = FitBuilder.this.getSelectedCurveFitter();
                if (fitter != null) {
                    dataset = fitter.getData();
                }
                String var = dataset == null ? "x" : TeXParser.removeSubscripting(dataset.getColumnName(0));
                f.setExpression("0", new String[]{var});
                FitBuilder.this.addFitFunctionPanel(f);
            }
        });
        this.deleteFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Text"));
        this.deleteFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Tooltip"));
        this.deleteFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = FitBuilder.this.getSelectedName();
                FitBuilder.this.removePanel(name);
            }
        });
        this.cloneFitButton = new JButton(ToolsRes.getString("DatasetCurveFitter.Button.Clone.Text"));
        this.cloneFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Clone.Tooltip"));
        this.cloneFitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final HashMap<String, KnownFunction> fits = new HashMap<String, KnownFunction>();
                final ArrayList<String> fitnames = new ArrayList<String>();
                for (DatasetCurveFitter fitter : FitBuilder.this.curveFitters) {
                    int i = 0;
                    while (i < fitter.fitDropDown.getItemCount()) {
                        String name = fitter.fitDropDown.getItemAt(i).toString();
                        if (!fitnames.contains(name)) {
                            fitnames.add(name);
                            fits.put(name, fitter.fitMap.get(name));
                        }
                        ++i;
                    }
                }
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (String name : fitnames) {
                            DatasetCurveFitter fitter;
                            if (!name.equals(e.getActionCommand()) || (fitter = FitBuilder.this.getSelectedCurveFitter()) == null) continue;
                            KnownFunction f = (KnownFunction)fits.get(name);
                            UserFunction uf = fitter.createClone(f, name);
                            UserFunctionEditor editor = new UserFunctionEditor();
                            editor.setMainFunctions(new UserFunction[]{uf});
                            FitFunctionPanel panel = new FitFunctionPanel(editor);
                            FitBuilder.this.addPanel(uf.getName(), panel);
                        }
                    }
                };
                JPopupMenu popup = new JPopupMenu();
                for (String name : fitnames) {
                    JMenuItem item = new JMenuItem(name);
                    item.setActionCommand(name);
                    item.addActionListener(listener);
                    popup.add(item);
                }
                popup.show(FitBuilder.this.cloneFitButton, 0, FitBuilder.this.cloneFitButton.getHeight());
            }
        });
        String imageFile = "/org/opensourcephysics/resources/tools/images/open.gif";
        Icon openIcon = ResourceLoader.getIcon(imageFile);
        this.loadButton = new JButton(openIcon);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FitBuilder.this.loadFits();
            }
        });
        imageFile = "/org/opensourcephysics/resources/tools/images/save.gif";
        Icon saveIcon = ResourceLoader.getIcon(imageFile);
        this.saveButton = new JButton(saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FitBuilder.this.saveFits();
            }
        });
        this.autoloadButton = new JButton();
        this.autoloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoloadManager manager = FitBuilder.this.getAutoloadManager();
                manager.refreshAutoloadData();
                manager.setVisible(true);
            }
        });
        this.setToolbarComponents(new Component[]{this.loadButton, this.saveButton, new JToolBar.Separator(), this.newFitButton, this.cloneFitButton, this.deleteFitButton, Box.createHorizontalGlue(), this.autoloadButton});
        for (String dir : FitBuilder.getInitialSearchPaths()) {
            this.autoloadFits(dir);
        }
    }

    public DatasetCurveFitter getSelectedCurveFitter() {
        DataTool dataTool;
        DataToolTab tab;
        Window win = this.getOwner();
        if (win != null && win instanceof DataTool && (tab = (dataTool = (DataTool)win).getSelectedTab()) != null) {
            return tab.curveFitter;
        }
        return null;
    }

    @Override
    public void refreshDropdown(String name) {
        if (name == null) {
            name = this.defaultFitName;
        }
        this.deleteFitButton.setEnabled(!this.getPanelNames().isEmpty());
        if (this.getPanelNames().isEmpty()) {
            String label = ToolsRes.getString("FitFunctionPanel.Label");
            this.dropdownLabel.setText(String.valueOf(label) + ":");
        }
        super.refreshDropdown(name);
    }

    public boolean addFitFunction(KnownFunction f) {
        if (f instanceof UserFunction) {
            String name = f.getName();
            if (this.addedFits.contains(name)) {
                return true;
            }
            for (String next : this.getPanelNames()) {
                FitFunctionPanel panel = (FitFunctionPanel)this.getPanel(next);
                if (!name.equals(panel.originalName)) continue;
                return false;
            }
            FitFunctionPanel panel = this.addFitFunctionPanel((UserFunction)f);
            panel.originalName = name;
            this.addedFits.add(name);
        } else if (f instanceof KnownPolynomial) {
            UserFunction uf = new UserFunction((KnownPolynomial)f);
            return this.addFitFunction(uf);
        }
        return true;
    }

    private String loadFits() {
        int result;
        if (chooser == null) {
            chooser = OSPRuntime.getChooser();
            javax.swing.filechooser.FileFilter[] fileFilterArray = chooser.getChoosableFileFilters();
            int n = fileFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                javax.swing.filechooser.FileFilter filter = fileFilterArray[n2];
                if (filter.getDescription().toLowerCase().indexOf("xml") > -1) {
                    chooser.setFileFilter(filter);
                    break;
                }
                ++n2;
            }
        }
        if ((result = chooser.showOpenDialog(this)) == 0) {
            OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            return this.loadFits(fileName, false);
        }
        return null;
    }

    private String loadFits(String path, boolean loadAll) {
        if (path == null) {
            return this.loadFits();
        }
        XMLControlElement control = new XMLControlElement(path);
        if (control.failedToRead()) {
            JOptionPane.showMessageDialog(this, ToolsRes.getString("Dialog.Invalid.Message"), ToolsRes.getString("Dialog.Invalid.Title"), 0);
            return null;
        }
        Class<?> type = control.getObjectClass();
        if (FitBuilder.class.isAssignableFrom(type)) {
            if (loadAll || this.chooseFitFunctions(control, "Load")) {
                control.loadObject(this);
            }
        } else {
            JOptionPane.showMessageDialog(this, ToolsRes.getString("DatasetCurveFitter.FitBuilder.Dialog.WrongType.Message"), ToolsRes.getString("DatasetCurveFitter.FitBuilder.Dialog.WrongType.Title"), 0);
        }
        return path;
    }

    private String saveFits() {
        XMLControlElement control = new XMLControlElement(this);
        if (this.chooseFitFunctions(control, "Save")) {
            if (chooser == null) {
                chooser = OSPRuntime.getChooser();
                javax.swing.filechooser.FileFilter[] fileFilterArray = chooser.getChoosableFileFilters();
                int n = fileFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    javax.swing.filechooser.FileFilter filter = fileFilterArray[n2];
                    if (filter.getDescription().toLowerCase().indexOf("xml") > -1) {
                        chooser.setFileFilter(filter);
                        break;
                    }
                    ++n2;
                }
            }
            FontSizer.setFonts(chooser, FontSizer.getLevel());
            int result = chooser.showSaveDialog(this);
            if (result == 0) {
                int isSelected;
                OSPRuntime.chooserDir = chooser.getCurrentDirectory().toString();
                File file = chooser.getSelectedFile();
                if (file.exists() && (isSelected = JOptionPane.showConfirmDialog(this, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                    return null;
                }
                return this.saveFits(file.getAbsolutePath(), control);
            }
        }
        return null;
    }

    private String saveFits(String path, XMLControl control) {
        if (path == null) {
            return this.saveFits();
        }
        if (XML.getExtension(path) == null) {
            path = String.valueOf(path) + ".xml";
        }
        if (control == null || control.getObjectClass() != this.getClass()) {
            control = new XMLControlElement(this);
        }
        control.write(path);
        return path;
    }

    private void autoloadFits(String dirPath) {
        if (dirPath == null) {
            return;
        }
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles(xmlFilter);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type;
                File file = fileArray[n2];
                XMLControlElement control = new XMLControlElement(file.getPath());
                if (!control.failedToRead() && (type = control.getObjectClass()) != null && FitBuilder.class.isAssignableFrom(type)) {
                    XMLControlElement copyControl = new XMLControlElement(control);
                    String filePath = XML.forwardSlash(file.getAbsolutePath());
                    this.eliminateExcludedFunctions(copyControl, filePath);
                    copyControl.loadObject(this);
                }
                ++n2;
            }
        }
    }

    private Map<String, ArrayList<String[]>> findFitFunctions(String dirPath) {
        TreeMap<String, ArrayList<String[]>> results = new TreeMap<String, ArrayList<String[]>>();
        if (dirPath == null) {
            return results;
        }
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return results;
        }
        File[] files = dir.listFiles(xmlFilter);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type;
                File file = fileArray[n2];
                XMLControlElement control = new XMLControlElement(file.getPath());
                if (!control.failedToRead() && (type = control.getObjectClass()) != null && FitBuilder.class.isAssignableFrom(type)) {
                    ArrayList<String[]> functions = new ArrayList<String[]>();
                    for (Object next : control.getPropertyContent()) {
                        XMLControl[] panels;
                        if (!(next instanceof XMLProperty) || !((XMLProperty)next).getPropertyName().equals("functions")) continue;
                        XMLControl[] xMLControlArray = panels = ((XMLProperty)next).getChildControls();
                        int n3 = panels.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            XMLControl panelControl = xMLControlArray[n4];
                            String name = panelControl.getString("name");
                            String expression = panelControl.getString("description");
                            String[] data = new String[]{name, expression};
                            functions.add(data);
                            ++n4;
                        }
                        break block1;
                    }
                    results.put(file.getName(), functions);
                }
                ++n2;
            }
        }
        return results;
    }

    /*
     * Could not resolve type clashes
     */
    protected void eliminateExcludedFunctions(XMLControl fitBuilderControl, String filePath) {
        for (Object obj : fitBuilderControl.getPropertyContent()) {
            if (!(obj instanceof XMLProperty) || !((XMLProperty)obj).getPropertyName().equals("functions")) continue;
            XMLProperty prop = (XMLProperty)obj;
            List<Object> items = prop.getPropertyContent();
            ArrayList<Object> toRemove = new ArrayList<Object>();
            XMLControl[] panels = prop.getChildControls();
            int i = 0;
            while (i < panels.length) {
                XMLControl panelControl = panels[i];
                String name = panelControl.getString("name");
                if (this.isFunctionExcluded(filePath, name)) {
                    toRemove.add(items.get(i));
                }
                ++i;
            }
            for (Object next : toRemove) {
                items.remove(next);
            }
        }
    }

    private boolean isFunctionExcluded(String filePath, String functionName) {
        String[] functions = autoloadMap.get(filePath);
        if (functions == null) {
            return false;
        }
        String[] stringArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals("*")) {
                return true;
            }
            if (name.equals(functionName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void refreshGUI() {
        super.refreshGUI();
        this.setTitle(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Title"));
        if (this.getPanelNames().isEmpty()) {
            String label = ToolsRes.getString("FitFunctionPanel.Label");
            this.dropdownLabel.setText(String.valueOf(label) + ":");
        }
        if (this.saveButton != null) {
            this.saveButton.setEnabled(!this.getPanelNames().isEmpty());
            this.loadButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Button.Load.Tooltip"));
            this.saveButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.FitBuilder.Button.Save.Tooltip"));
            FitFunctionPanel panel = (FitFunctionPanel)this.getSelectedPanel();
            this.deleteFitButton.setEnabled(!this.getPanelNames().isEmpty() && panel.originalName == null);
            this.newFitButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Text"));
            this.newFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.NewFit.Tooltip"));
            this.deleteFitButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Text"));
            this.deleteFitButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.DeleteFit.Tooltip"));
            DatasetCurveFitter fitter = this.getSelectedCurveFitter();
            this.cloneFitButton.setEnabled(fitter != null);
            this.autoloadButton.setText(String.valueOf(ToolsRes.getString("FitBuilder.Button.Autoload")) + "...");
            this.autoloadButton.setToolTipText(ToolsRes.getString("FitBuilder.Button.Autoload.Tooltip"));
        }
    }

    protected boolean chooseFitFunctions(XMLControl control, String description) {
        ListChooser listChooser = new ListChooser(ToolsRes.getString("DatasetCurveFitter.FitBuilder." + description + ".Title"), ToolsRes.getString("DatasetCurveFitter.FitBuilder." + description + ".Message"), this);
        ArrayList<XMLControl> originals = new ArrayList<XMLControl>();
        ArrayList<XMLControl> choices = new ArrayList<XMLControl>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> expressions = new ArrayList<String>();
        for (Object next : control.getPropertyContent()) {
            if (!(next instanceof XMLProperty)) continue;
            XMLProperty prop = (XMLProperty)next;
            for (Object obj : prop.getPropertyContent()) {
                if (!(obj instanceof XMLProperty)) continue;
                XMLProperty f = (XMLProperty)obj;
                XMLControl function = f.getChildControls()[0];
                originals.add(function);
                choices.add(function);
                names.add(function.getString("name"));
                String desc = function.getString("description");
                expressions.add(desc);
            }
        }
        boolean[] selected = new boolean[choices.size()];
        int i = 0;
        while (i < selected.length) {
            selected[i] = true;
            ++i;
        }
        if (listChooser.choose(choices, names, expressions, selected)) {
            for (XMLControl next : originals) {
                if (choices.contains(next)) continue;
                XMLProperty prop = next.getParentProperty();
                XMLProperty parent = prop.getParentProperty();
                parent.getPropertyContent().remove(prop);
            }
            return true;
        }
        return false;
    }

    protected FitFunctionPanel addFitFunctionPanel(UserFunction f) {
        UserFunctionEditor editor = new UserFunctionEditor();
        editor.setMainFunctions(new UserFunction[]{f});
        FitFunctionPanel panel = new FitFunctionPanel(editor);
        return (FitFunctionPanel)this.addPanel(f.getName(), panel);
    }

    protected AutoloadManager getAutoloadManager() {
        if (this.autoloadManager == null) {
            this.autoloadManager = new AutoloadManager(this);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.autoloadManager.getBounds().width) / 2;
            int y = (dim.height - this.autoloadManager.getBounds().height) / 2;
            this.autoloadManager.setLocation(x, y);
        }
        this.autoloadManager.setFontLevel(FontSizer.getLevel());
        return this.autoloadManager;
    }

    public static String localize(String functionName) {
        String s = ToolsRes.getString("Function." + functionName + ".Name");
        if (!s.startsWith("!")) {
            return s;
        }
        return functionName;
    }

    protected static Collection<String> getInitialSearchPaths() {
        block4: {
            if (!initialAutoloadSearchPaths.isEmpty()) break block4;
            if (preferredAutoloadSearchPaths != null) {
                String[] stringArray = preferredAutoloadSearchPaths;
                int n = preferredAutoloadSearchPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String next = stringArray[n2];
                    initialAutoloadSearchPaths.add(next);
                    ++n2;
                }
            } else {
                for (String next : OSPRuntime.getDefaultSearchPaths()) {
                    initialAutoloadSearchPaths.add(next);
                }
            }
        }
        return initialAutoloadSearchPaths;
    }

    class AutoloadManager
    extends AbstractAutoloadManager {
        public AutoloadManager(JDialog dialog) {
            super(dialog);
        }

        @Override
        public void setVisible(boolean vis) {
            super.setVisible(vis);
            if (!vis) {
                Collection<String> searchPaths = this.getSearchPaths();
                ArrayList<String> defaultPaths = OSPRuntime.getDefaultSearchPaths();
                boolean isDefault = searchPaths.size() == defaultPaths.size();
                for (String next : searchPaths) {
                    boolean bl = isDefault = isDefault && defaultPaths.contains(next);
                }
                preferredAutoloadSearchPaths = isDefault ? null : searchPaths.toArray(new String[searchPaths.size()]);
                OSPRuntime.setPreference("autoload_search_paths", preferredAutoloadSearchPaths);
                Iterator<String> it = autoloadMap.keySet().iterator();
                while (it.hasNext()) {
                    String filePath = it.next();
                    String parentPath = XML.getDirectoryPath(filePath);
                    boolean keep = false;
                    for (String dir : searchPaths) {
                        boolean bl = keep = keep || parentPath.equals(dir);
                    }
                    if (keep && new File(filePath).exists()) continue;
                    it.remove();
                }
                if (autoloadMap.isEmpty()) {
                    OSPRuntime.setPreference("autoload_exclusions", null);
                } else {
                    String[][] autoloadData = new String[autoloadMap.size()][];
                    int i = 0;
                    for (String filePath : autoloadMap.keySet()) {
                        String[] functions = autoloadMap.get(filePath);
                        String[] fileAndFunctions = new String[functions.length + 1];
                        fileAndFunctions[0] = filePath;
                        System.arraycopy(functions, 0, fileAndFunctions, 1, functions.length);
                        autoloadData[i] = fileAndFunctions;
                        ++i;
                    }
                    OSPRuntime.setPreference("autoload_exclusions", autoloadData);
                }
                OSPRuntime.savePreferences();
            }
        }

        @Override
        protected void setFunctionSelected(String filePath, String[] function, boolean select) {
            int n;
            String[] oldExclusions = autoloadMap.get(filePath);
            String[] newExclusions = null;
            if (!select) {
                if (oldExclusions == null) {
                    newExclusions = new String[]{function[0]};
                } else {
                    n = oldExclusions.length;
                    newExclusions = new String[n + 1];
                    System.arraycopy(oldExclusions, 0, newExclusions, 0, n);
                    newExclusions[n] = function[0];
                }
            } else if (oldExclusions != null && (n = oldExclusions.length) > 1) {
                ArrayList<String> exclusions = new ArrayList<String>();
                String[] stringArray = oldExclusions;
                int n2 = oldExclusions.length;
                int n3 = 0;
                while (n3 < n2) {
                    String f = stringArray[n3];
                    if (!f.equals(function[0])) {
                        exclusions.add(f);
                    }
                    ++n3;
                }
                newExclusions = exclusions.toArray(new String[exclusions.size()]);
            }
            autoloadMap.remove(filePath);
            if (newExclusions != null) {
                autoloadMap.put(filePath, newExclusions);
            }
            this.refreshAutoloadData();
            for (String dir : this.getSearchPaths()) {
                FitBuilder.this.autoloadFits(dir);
            }
        }

        @Override
        protected boolean isFunctionSelected(String filePath, String[] function) {
            String[] functions = autoloadMap.get(filePath);
            if (functions == null) {
                return true;
            }
            String[] stringArray = functions;
            int n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals("*")) {
                    return false;
                }
                if (name.equals(function[0])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        protected void setFileSelected(String filePath, boolean select) {
            autoloadMap.remove(filePath);
            if (!select) {
                String[] function = new String[]{"*"};
                autoloadMap.put(filePath, function);
            }
            this.refreshAutoloadData();
            for (String dir : this.getSearchPaths()) {
                FitBuilder.this.autoloadFits(dir);
            }
        }

        @Override
        protected TristateCheckBox.State getFileSelectionState(String filePath) {
            String[] functions = autoloadMap.get(filePath);
            if (functions == null) {
                return TristateCheckBox.SELECTED;
            }
            if (functions[0].equals("*")) {
                return TristateCheckBox.NOT_SELECTED;
            }
            return TristateCheckBox.PART_SELECTED;
        }

        @Override
        public Collection<String> getSearchPaths() {
            Collection<String> paths = super.getSearchPaths();
            if (paths.isEmpty() && !this.initialized) {
                this.initialized = true;
                for (String next : FitBuilder.getInitialSearchPaths()) {
                    paths.add(next);
                    this.addSearchPath(next);
                }
            }
            return paths;
        }

        @Override
        protected void refreshAutoloadData() {
            TreeMap<String, Map<String, ArrayList<String[]>>> data = new TreeMap<String, Map<String, ArrayList<String[]>>>();
            for (String path : this.getSearchPaths()) {
                Map functionMap = FitBuilder.this.findFitFunctions(path);
                data.put(path, functionMap);
            }
            this.setAutoloadData(data);
        }

        @Override
        protected void refreshGUI() {
            this.refreshAutoloadData();
            super.refreshGUI();
            String title = String.valueOf(FitBuilder.this.getTitle()) + " " + this.getTitle();
            this.setTitle(title);
            this.setInstructions(String.valueOf(ToolsRes.getString("FitBuilder.Instructions.SelectToAutoload")) + "\n\n" + ToolsRes.getString("FitBuilder.Instructions.WhereDefined") + " " + ToolsRes.getString("FitBuilder.Instructions.HowToAddFunction") + " " + ToolsRes.getString("FitBuilder.Instructions.HowToAddDirectory"));
        }
    }
}

