/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.DiagnosticsForXuggle;
import org.opensourcephysics.tools.ToolsRes;

public class ExtensionsManager {
    private static final ExtensionsManager MANAGER = new ExtensionsManager();
    private static boolean isReady = false;
    private static boolean isSearching = false;
    private static Set<File> allJavaExtensionDirectories = new TreeSet<File>();
    private static int vmsFound = 0;
    private static Timer timer;
    String xuggleHome = System.getenv("XUGGLE_HOME");
    ExtensionsFilter extFilter = new ExtensionsFilter();

    public static void main(String[] args) {
        timer = new Timer(30000, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("ExtensionsManager.Dialog.SlowSearch.Message1")) + "\n" + ToolsRes.getString("ExtensionsManager.Dialog.SlowSearch.Message2") + " " + vmsFound + ".\n" + ToolsRes.getString("ExtensionsManager.Dialog.SlowSearch.Message3"), ToolsRes.getString("ExtensionsManager.Dialog.SlowSearch.Title"), 0);
                if (selected == 1) {
                    Set set = allJavaExtensionDirectories;
                    synchronized (set) {
                        ExtensionsManager.printExtensionDirectoriesForBitrock(allJavaExtensionDirectories);
                    }
                    System.exit(0);
                } else {
                    timer.restart();
                }
            }
        });
        timer.setRepeats(true);
        timer.start();
        System.exit(0);
    }

    public static ExtensionsManager getManager() {
        return MANAGER;
    }

    public static boolean isReady() {
        return isReady;
    }

    private ExtensionsManager() {
    }

    private static void printExtensionDirectoriesForBitrock(Set<File> extDirs) {
        String separator = " ";
        StringBuffer buf = new StringBuffer(2);
        for (File next : extDirs) {
            String fileName = XML.forwardSlash(next.getPath());
            buf.append("\"" + fileName + "\"" + separator);
        }
        String s = buf.toString();
        if (s.length() >= separator.length()) {
            s = s.substring(0, s.length() - separator.length());
        }
        System.out.print(s);
    }

    public boolean copyXuggleJarsTo(File dir) {
        if (this.xuggleHome == null || dir == null) {
            return false;
        }
        if (!new File(String.valueOf(this.xuggleHome) + "/share/java/jars/xuggle-xuggler.jar").exists()) {
            return false;
        }
        File xuggleJarDir = new File(String.valueOf(this.xuggleHome) + "/share/java/jars");
        String[] jarNames = DiagnosticsForXuggle.xuggleJarNames;
        File xuggleFile = new File(xuggleJarDir, jarNames[0]);
        long fileLength = xuggleFile.length();
        File extFile = new File(dir, jarNames[0]);
        if (!extFile.exists() || extFile.length() != fileLength) {
            String[] stringArray = jarNames;
            int n = jarNames.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                xuggleFile = new File(xuggleJarDir, next);
                extFile = new File(dir, next);
                if (!this.copyFile(xuggleFile, extFile)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public File getXuggleJar() {
        if (this.xuggleHome == null) {
            return null;
        }
        File xuggleJar = new File(String.valueOf(this.xuggleHome) + "/share/java/jars/xuggle-xuggler.jar");
        if (xuggleJar.exists()) {
            return xuggleJar;
        }
        return null;
    }

    public boolean copyQTJavaTo(File dir) {
        File qtSource = this.getQTJavaZip();
        if (qtSource == null) {
            return false;
        }
        File extFile = new File(dir, qtSource.getName());
        long modified = qtSource.lastModified();
        if (!extFile.exists() || extFile.lastModified() < modified) {
            return this.copyFile(qtSource, extFile);
        }
        return false;
    }

    public File getQTJavaZip() {
        String qtJarName = "QTJava.zip";
        String currentDir = OSPRuntime.getLaunchJarPath();
        currentDir = currentDir != null ? XML.getDirectoryPath(currentDir) : ".";
        String[] folderNames = new String[]{currentDir, "C:/Program Files/QuickTime/QTSystem", "C:/Program Files (x86)/QuickTime/QTSystem", "C:/windows/system32", "C:/windows/system", "C:/winNT/system32", "system/library/java/extensions"};
        long modified = 0L;
        File qtSource = null;
        String[] stringArray = folderNames;
        int n = folderNames.length;
        int n2 = 0;
        while (n2 < n) {
            long date;
            String next = stringArray[n2];
            File qtFile = new File(next, qtJarName);
            if (qtFile.exists() && (date = qtFile.lastModified()) > modified) {
                modified = date;
                qtSource = qtFile;
            }
            ++n2;
        }
        return qtSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> findAllJavaExtensionDirectories() {
        while (isSearching) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!isReady) {
            isSearching = true;
            vmsFound = 0;
            TreeSet<String> vmExtDirs = new TreeSet<String>();
            TreeSet<File> searchPaths = new TreeSet<File>();
            try {
                String paths = XML.forwardSlash(System.getProperty("java.ext.dirs"));
                String separator = System.getProperty("path.separator");
                int n = paths.indexOf(separator);
                while (n > -1) {
                    vmExtDirs.add(paths.substring(0, n));
                    paths = paths.substring(n + 1);
                    n = paths.indexOf(separator);
                }
                if (!"".equals(paths)) {
                    vmExtDirs.add(paths);
                }
                block9: for (String string : vmExtDirs) {
                    File dir = new File(string);
                    if (!dir.exists()) continue;
                    Set<File> set = allJavaExtensionDirectories;
                    synchronized (set) {
                        allJavaExtensionDirectories.add(dir);
                        ++vmsFound;
                    }
                    if (OSPRuntime.isMac()) {
                        while (dir != null && dir.getPath().indexOf("/JavaVirtualMachines") > -1) {
                            if (dir.getName().equals("JavaVirtualMachines")) {
                                searchPaths.add(dir);
                                continue block9;
                            }
                            dir = dir.getParentFile();
                        }
                        continue;
                    }
                    if (!OSPRuntime.isLinux()) continue;
                    while (dir != null && dir.getPath().indexOf("/jvm") > -1) {
                        if (dir.getName().equals("jvm")) {
                            searchPaths.add(dir);
                            continue block9;
                        }
                        dir = dir.getParentFile();
                    }
                }
                if (OSPRuntime.isWindows()) {
                    File file;
                    String string = System.getenv("ProgramFiles");
                    String w6432 = System.getenv("ProgramW6432");
                    String x86 = System.getenv("ProgramFiles(x86)");
                    if (string != null && (file = new File(string, "Java")).exists()) {
                        searchPaths.add(file);
                    }
                    if (w6432 != null && (file = new File(w6432, "Java")).exists()) {
                        searchPaths.add(file);
                    }
                    if (x86 != null && (file = new File(x86, "Java")).exists()) {
                        searchPaths.add(file);
                    }
                }
                for (File file : searchPaths) {
                    this.findJavaExtensionDirectories(file, allJavaExtensionDirectories);
                }
            }
            catch (Exception paths) {
                // empty catch block
            }
            isReady = true;
            isSearching = false;
            StringBuffer buf = new StringBuffer("Java extension directories: ");
            for (File next : allJavaExtensionDirectories) {
                buf.append(String.valueOf(next.getAbsolutePath()) + ", ");
            }
            OSPLog.fine(buf.toString());
        }
        return new TreeSet<File>(allJavaExtensionDirectories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> findJavaExtensionDirectories() {
        Set<File> extDirs = this.findAllJavaExtensionDirectories();
        TreeSet<File> toExclude = new TreeSet<File>();
        Set<File> set = extDirs;
        synchronized (set) {
            for (File next : extDirs) {
                if (next.getParentFile() == null || next.getParentFile().getParentFile() == null) continue;
                File javaFile = next.getParentFile().getParentFile();
                int n = javaFile.getPath().indexOf("jdk");
                n = Math.max(n, javaFile.getPath().indexOf("jre"));
                int oldVersion = javaFile.getPath().indexOf("1.5.");
                oldVersion = Math.max(oldVersion, javaFile.getPath().indexOf("-5-"));
                oldVersion = Math.max(oldVersion, javaFile.getPath().indexOf("1.4."));
                oldVersion = Math.max(oldVersion, javaFile.getPath().indexOf("1.3."));
                oldVersion = Math.max(oldVersion, javaFile.getPath().indexOf("1.2."));
                oldVersion = Math.max(oldVersion, javaFile.getPath().indexOf("1.3."));
                oldVersion = Math.max(oldVersion, javaFile.getPath().indexOf("1.2."));
                if (n <= -1 || oldVersion <= -1) continue;
                toExclude.add(next);
            }
            extDirs.removeAll(toExclude);
            vmsFound -= toExclude.size() + 1;
        }
        return extDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> findJavaExtensionDirectories(File dir, Set<File> extDirs) {
        if (dir == null) {
            return extDirs;
        }
        try {
            if (!dir.getCanonicalPath().equals(dir.getAbsolutePath())) {
                return extDirs;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] fileNames = dir.list();
        if (fileNames != null && fileNames.length > 0) {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                File subDir = new File(dir, next);
                if (this.extFilter.accept(subDir, subDir.getName())) {
                    Set<File> set = extDirs;
                    synchronized (set) {
                        extDirs.add(subDir);
                        ++vmsFound;
                    }
                } else {
                    this.findJavaExtensionDirectories(subDir, extDirs);
                }
                ++n2;
            }
        }
        return extDirs;
    }

    public boolean is32BitVM(String jrePath) {
        if (OSPRuntime.isWindows()) {
            String x86 = System.getenv("ProgramFiles(x86)");
            if (x86 != null) {
                return jrePath.contains(x86);
            }
            return true;
        }
        if (OSPRuntime.isMac()) {
            return true;
        }
        return OSPRuntime.getVMBitness() == 32;
    }

    public TreeSet<String> getPublicJREs(int vmBitness) {
        TreeSet<String> jreDirs = this.getAllJREs(vmBitness);
        if (OSPRuntime.isWindows()) {
            Iterator<String> it = jreDirs.iterator();
            while (it.hasNext()) {
                String next = it.next();
                if (next.indexOf("jdk") <= -1) continue;
                it.remove();
            }
        }
        StringBuffer buf = new StringBuffer(String.valueOf(vmBitness) + "-bit JREs: ");
        for (String next : jreDirs) {
            buf.append(String.valueOf(next) + ", ");
        }
        OSPLog.fine(buf.toString());
        return jreDirs;
    }

    public TreeSet<String> getAllJREs(int vmBitness) {
        Set<File> extDirs = this.findJavaExtensionDirectories();
        TreeSet<String> jreDirs = new TreeSet<String>();
        try {
            String x86 = System.getenv("ProgramFiles(x86)");
            for (File file : extDirs) {
                String jrePath;
                File javaFile = file.getParentFile().getParentFile();
                if (OSPRuntime.isWindows()) {
                    if (vmBitness == 32 && x86 != null && !file.getPath().contains(x86) || vmBitness == 64 && x86 != null && file.getPath().contains(x86) || !(javaFile = new File(javaFile, "bin/java.exe")).exists()) continue;
                    try {
                        if (!javaFile.getCanonicalPath().equals(javaFile.getAbsolutePath())) {
                            continue;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    jrePath = OSPRuntime.getJREPath(javaFile);
                    jreDirs.add(jrePath);
                    continue;
                }
                if (!(javaFile = new File(javaFile, "bin/java")).exists()) continue;
                jrePath = OSPRuntime.getJREPath(javaFile);
                if (OSPRuntime.isMac() && vmBitness == 32 && !jrePath.startsWith("/System/Library")) continue;
                jreDirs.add(jrePath);
            }
        }
        catch (Exception x86) {
            // empty catch block
        }
        if (OSPRuntime.isMac()) {
            TreeSet<File> homeDirs = new TreeSet<File>();
            String[] stringArray = new String[]{"/System/Library", "/Library"};
            int i = 0;
            while (i < stringArray.length) {
                String[] subDirs;
                File library = new File(stringArray[i]);
                if (library.exists() && (subDirs = library.list()) != null && subDirs.length > 0) {
                    String[] stringArray2 = subDirs;
                    int n = subDirs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] children;
                        String next = stringArray2[n2];
                        File nextFile = new File(library, next);
                        if (next.contains("Java")) {
                            this.findJREHomes(nextFile, homeDirs);
                        } else if (nextFile.getName().contains("Internet Plug-Ins") && (children = nextFile.list()) != null && children.length > 0) {
                            String[] stringArray3 = children;
                            int n3 = children.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String childName = stringArray3[n4];
                                if (childName.contains("Java")) {
                                    this.findJREHomes(new File(nextFile, childName), homeDirs);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                ++i;
            }
            for (File home : homeDirs) {
                if (vmBitness == 32 && !home.getAbsolutePath().startsWith("/System/Library")) continue;
                jreDirs.add(home.getAbsolutePath());
            }
        }
        StringBuffer buf = new StringBuffer(String.valueOf(vmBitness) + "-bit JREs: ");
        for (String string : jreDirs) {
            buf.append(String.valueOf(string) + ", ");
        }
        OSPLog.fine(buf.toString());
        return jreDirs;
    }

    private void findJREHomes(File parent, Set<File> jreHomes) {
        if (parent == null || !parent.exists() || !parent.isDirectory() || jreHomes == null) {
            return;
        }
        try {
            if (!parent.getCanonicalPath().equals(parent.getAbsolutePath())) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File javaFile = new File(parent, "bin/java");
        if (javaFile.exists()) {
            jreHomes.add(parent);
            return;
        }
        if (parent.getName().contains(".plugin")) {
            File child = new File(parent, "Contents");
            if (child.exists()) {
                this.findJREHomes(new File(child, "Home"), jreHomes);
            }
            return;
        }
        String[] children = parent.list();
        if (children != null) {
            String[] stringArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String childName = stringArray[n2];
                this.findJREHomes(new File(parent, childName), jreHomes);
                ++n2;
            }
        }
    }

    public String getDefaultJRE(int vmBitness) {
        String next;
        String JRE = null;
        TreeSet<String> jreDirs = this.getPublicJREs(vmBitness);
        Iterator iterator = jreDirs.iterator();
        while (iterator.hasNext()) {
            JRE = next = (String)iterator.next();
        }
        if (JRE == null) {
            jreDirs = this.getAllJREs(vmBitness);
            iterator = jreDirs.iterator();
            while (iterator.hasNext()) {
                JRE = next = (String)iterator.next();
            }
        }
        OSPLog.fine(String.valueOf(vmBitness) + "-bit default JRE: " + JRE);
        return JRE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean copyFile(File inFile, File outFile) {
        byte[] buffer = new byte[100000];
        try {
            FileInputStream in = new FileInputStream(inFile);
            FileOutputStream out = new FileOutputStream(outFile);
            while (true) {
                byte[] byArray = buffer;
                // MONITORENTER : buffer
                int amountRead = ((InputStream)in).read(buffer);
                if (amountRead == -1) {
                    // MONITOREXIT : byArray
                    break;
                }
                ((OutputStream)out).write(buffer, 0, amountRead);
                // MONITOREXIT : byArray
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            outFile.setLastModified(inFile.lastModified());
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    static class ExtensionsFilter
    implements FilenameFilter {
        ExtensionsFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (!dir.isDirectory()) {
                return false;
            }
            String path = XML.forwardSlash(dir.getPath());
            if (path.endsWith("/lib/ext")) {
                if (path.endsWith("/jre/lib/ext")) {
                    return true;
                }
                String jre = XML.getName(path.substring(0, path.length() - 8));
                if (jre.indexOf("jre") > -1) {
                    return true;
                }
                if (path.indexOf("jdk") > -1 && path.indexOf("/Java/") > -1) {
                    return true;
                }
                if (path.indexOf("jre") > -1 && path.indexOf("/Java/") > -1) {
                    return true;
                }
            }
            if (path.endsWith("java/packages/lib/ext")) {
                return true;
            }
            if (path.endsWith("Java/lib/ext")) {
                return true;
            }
            return path.endsWith("Java/Extensions");
        }
    }
}

