/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ThreadViewerTableModel;

public class DiagnosticsForThreads
extends JPanel {
    private ThreadViewerTableModel tableModel = new ThreadViewerTableModel();

    public DiagnosticsForThreads() {
        JTable table = new JTable(this.tableModel);
        table.setAutoResizeMode(3);
        FontSizer.setFonts(table, FontSizer.getLevel());
        Font font = table.getFont();
        table.setRowHeight(font.getSize() + 4);
        table.getTableHeader().setFont(font);
        TableColumnModel colModel = table.getColumnModel();
        int numColumns = colModel.getColumnCount();
        int i = 0;
        while (i < numColumns - 1) {
            TableColumn col = colModel.getColumn(i);
            col.sizeWidthToFit();
            col.setPreferredWidth(col.getWidth() + 5);
            col.setMaxWidth(col.getWidth() + 5);
            ++i;
        }
        JScrollPane sp = new JScrollPane(table);
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
    }

    public void dispose() {
        this.tableModel.stopRequest();
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public static void aboutThreads() {
        JDialog dialog = new JDialog();
        DiagnosticsForThreads viewer = new DiagnosticsForThreads();
        dialog.setContentPane(viewer);
        int level = FontSizer.getLevel();
        int w = (int)(600.0 * (1.0 + (double)level * 0.2));
        int h = (int)(300.0 * (1.0 + (double)level * 0.2));
        dialog.setSize(w, h);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - dialog.getBounds().width) / 2;
        int y = (dim.height - dialog.getBounds().height) / 2;
        dialog.setLocation(x, y);
        dialog.setTitle("Threads");
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Object lock;
        JFrame f = new JFrame();
        DiagnosticsForThreads viewer = new DiagnosticsForThreads();
        f.setContentPane(viewer);
        f.setSize(500, 300);
        f.setVisible(true);
        f.setDefaultCloseOperation(1);
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

