/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractSpinnerModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.display.ColorIcon;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.HessianMinimize;
import org.opensourcephysics.numerics.LevenbergMarquardt;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FitBuilder;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.KnownPolynomial;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DatasetCurveFitter
extends JPanel {
    static ArrayList<KnownFunction> defaultFits = new ArrayList();
    static JFileChooser chooser;
    static NumberFormat SEFormat;
    ArrayList<KnownFunction> localFits = new ArrayList();
    Map<String, KnownFunction> fitMap = new TreeMap<String, KnownFunction>();
    PropertyChangeListener fitListener;
    Dataset dataset;
    KnownFunction fit;
    HessianMinimize hessian = new HessianMinimize();
    LevenbergMarquardt levmar = new LevenbergMarquardt();
    FunctionDrawer drawer;
    Color color = Color.MAGENTA;
    JButton colorButton;
    JButton closeButton;
    JCheckBox autofitCheckBox;
    JLabel fitLabel;
    JLabel eqnLabel;
    JLabel rmsLabel;
    JToolBar fitBar;
    JToolBar eqnBar;
    JToolBar rmsBar;
    JComboBox fitDropDown;
    JTextField eqnField;
    NumberField rmsField;
    ParamTableModel paramModel;
    JTable paramTable;
    ParamCellRenderer cellRenderer;
    SpinCellEditor spinCellEditor;
    int fitNumber = 1;
    JButton fitBuilderButton;
    boolean refreshing = false;
    boolean isActive;
    boolean neverBeenActive = true;
    JSplitPane splitPane;
    JDialog colorDialog;
    int fontLevel;
    FitBuilder fitBuilder;
    double correlation = Double.NaN;
    double[] uncertainties = new double[2];
    DataToolTab tab;
    boolean fitEvaluatedToNaN = false;

    static {
        SEFormat = NumberFormat.getInstance();
        defaultFits.add(new KnownPolynomial(new double[]{0.0, 0.0}));
        defaultFits.add(new KnownPolynomial(new double[]{0.0, 0.0, 0.0}));
        defaultFits.add(new KnownPolynomial(new double[]{0.0, 0.0, 0.0, 0.0}));
        UserFunction f = new UserFunction("Gaussian");
        f.setParameters(new String[]{"A", "B", "C"}, new double[]{1.0, 0.0, 1.0}, new String[]{ToolsRes.getString("Function.Parameter.PeakHeight.Description"), ToolsRes.getString("Function.Parameter.PeakPosition.Description"), ToolsRes.getString("Function.Parameter.GaussianRMSWidth.Description")});
        f.setExpression("A*exp(-(x-B)^2/(2*C^2))", new String[]{"x"});
        f.setDescription(ToolsRes.getString("Function.Gaussian.Description"));
        defaultFits.add(f);
        f = new UserFunction("Exponential");
        f.setParameters(new String[]{"A", "B"}, new double[]{1.0, 1.0}, new String[]{ToolsRes.getString("Function.Parameter.Intercept.Description"), ToolsRes.getString("Function.Parameter.ExponentialMultiplier.Description")});
        f.setExpression("A*exp(-x*B)", new String[]{"x"});
        f.setDescription(ToolsRes.getString("Function.Exponential.Description"));
        defaultFits.add(f);
        f = new UserFunction("Sinusoid");
        f.setParameters(new String[]{"A", "B", "C"}, new double[]{1.0, 1.0, 0.0}, new String[]{ToolsRes.getString("Function.Parameter.Amplitude.Description"), ToolsRes.getString("Function.Parameter.Omega.Description"), ToolsRes.getString("Function.Parameter.Phase.Description")});
        f.setExpression("A*sin(B*x+C)", new String[]{"x"});
        f.setDescription(ToolsRes.getString("Function.Sinusoid.Description"));
        defaultFits.add(f);
    }

    public DatasetCurveFitter(Dataset data, FitBuilder builder) {
        this.dataset = data;
        this.fitBuilder = builder;
        this.createGUI();
    }

    public FunctionDrawer getDrawer() {
        return this.drawer;
    }

    public Dataset getData() {
        return this.dataset;
    }

    public void setData(Dataset data) {
        this.dataset = data;
        if (this.isActive) {
            this.fit(this.fit);
        }
        if (this.dataset != null) {
            String var = this.dataset.getXColumnName();
            var = TeXParser.removeSubscripting(var);
            this.fitBuilder.setDefaultVariables(new String[]{var});
            if (!this.isActive) {
                double[] x = this.dataset.getValidXPoints();
                double[] y = this.dataset.getValidYPoints();
                this.doLinearRegression(x, y, false);
                this.refreshStatusBar();
            }
        }
    }

    public void setColor(Color newColor) {
        this.color = newColor;
        if (this.drawer != null) {
            boolean nimbus;
            this.drawer.setColor(newColor);
            LookAndFeel currentLF = UIManager.getLookAndFeel();
            boolean bl = nimbus = currentLF.getClass().getName().indexOf("Nimbus") > -1;
            if (nimbus) {
                this.colorButton.setIcon(new ColorIcon(this.color, 12, DataTool.buttonHeight - 8));
            } else {
                this.colorButton.setBackground(this.color);
            }
            this.firePropertyChange("changed", null, null);
        }
    }

    public void setAutofit(boolean auto) {
        if (auto && !this.autofitCheckBox.isSelected()) {
            this.autofitCheckBox.doClick(0);
        } else if (!auto && this.autofitCheckBox.isSelected()) {
            this.autofitCheckBox.doClick(0);
        }
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (active) {
            if (this.neverBeenActive) {
                this.neverBeenActive = false;
                this.autofitCheckBox.setSelected(true);
            }
            this.fit(this.fit);
        }
    }

    public double fit(KnownFunction fit) {
        if (this.drawer == null) {
            this.selectFit((String)this.fitDropDown.getSelectedItem());
        }
        if (fit == null) {
            return Double.NaN;
        }
        if (this.dataset == null) {
            if (fit instanceof UserFunction) {
                this.eqnField.setText("y = " + ((UserFunction)fit).getFullExpression(new String[]{"x"}));
            } else {
                this.eqnField.setText("y = " + fit.getExpression("x"));
            }
            this.autofitCheckBox.setSelected(false);
            this.autofitCheckBox.setEnabled(false);
            this.spinCellEditor.stopCellEditing();
            this.paramTable.setEnabled(false);
            this.rmsField.setText(ToolsRes.getString("DatasetCurveFitter.RMSField.NoData"));
            this.rmsField.setForeground(Color.RED);
            return Double.NaN;
        }
        this.autofitCheckBox.setEnabled(true);
        this.paramTable.setEnabled(true);
        double[] x = this.dataset.getValidXPoints();
        double[] y = this.dataset.getValidYPoints();
        double devSq = 0.0;
        double[] prevParams = null;
        double prevDevSq = this.getDevSquared(fit, x, y);
        boolean isLinearFit = false;
        if (this.autofitCheckBox.isSelected() && !Double.isNaN(prevDevSq)) {
            UserFunction f;
            double[] params;
            if (fit instanceof KnownPolynomial) {
                KnownPolynomial poly = (KnownPolynomial)fit;
                poly.fitData(x, y);
                isLinearFit = poly.degree() == 1;
            } else if (fit instanceof UserFunction && (params = new double[(f = (UserFunction)fit).getParameterCount()]).length > 0 && params.length <= x.length && params.length <= y.length) {
                int i;
                MinimizeUserFunction minFunc = new MinimizeUserFunction(f, x, y);
                prevParams = new double[params.length];
                int i2 = 0;
                while (i2 < params.length) {
                    params[i2] = prevParams[i2] = f.getParameterValue(i2);
                    ++i2;
                }
                double tol = 1.0E-6;
                int iterations = 20;
                this.hessian.minimize(minFunc, params, iterations, tol);
                devSq = this.getDevSquared(fit, x, y);
                if (devSq > prevDevSq) {
                    i = 0;
                    while (i < prevParams.length) {
                        f.setParameterValue(i, prevParams[i]);
                        ++i;
                    }
                    this.levmar.minimize(minFunc, params, iterations, tol);
                    devSq = this.getDevSquared(fit, x, y);
                }
                if (devSq > prevDevSq) {
                    i = 0;
                    while (i < prevParams.length) {
                        f.setParameterValue(i, prevParams[i]);
                        ++i;
                    }
                    devSq = prevDevSq;
                    this.autofitCheckBox.setSelected(false);
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            this.drawer.functionChanged = true;
            this.paramTable.repaint();
        }
        this.doLinearRegression(x, y, isLinearFit);
        if (devSq == 0.0) {
            devSq = this.getDevSquared(fit, x, y);
        }
        double rmsDev = Math.sqrt(devSq / (double)x.length);
        this.rmsField.setForeground(this.eqnField.getForeground());
        if (x.length == 0 || y.length == 0) {
            this.rmsField.setText(ToolsRes.getString("DatasetCurveFitter.RMSField.NoData"));
            this.rmsField.setForeground(Color.RED);
        } else if (Double.isNaN(rmsDev)) {
            this.rmsField.setText(ToolsRes.getString("DatasetCurveFitter.RMSField.Undefined"));
            this.rmsField.setForeground(Color.RED);
        } else {
            this.rmsField.applyPattern("0.000E0");
            this.rmsField.setValue(rmsDev);
        }
        this.refreshStatusBar();
        this.firePropertyChange("fit", null, null);
        return rmsDev;
    }

    public void addFitFunction(KnownFunction f, boolean addToFitBuilder) {
        KnownFunction existing = this.fitMap.get(f.getName());
        if (existing != null) {
            if (existing.getExpression("x").equals(f.getExpression("x"))) {
                return;
            }
            f.setName(this.fitBuilder.getUniqueName(f.getName()));
        }
        String selectedFitName = this.fit == null ? this.getLineFitName() : this.fit.getName();
        this.fitBuilder.addFitFunction(f);
        this.fitDropDown.setSelectedItem(selectedFitName);
    }

    public void refreshStatusBar() {
        if (this.tab != null && this.tab.statsCheckbox.isSelected()) {
            this.tab.refreshStatusBar(this.tab.getCorrelationString());
        }
    }

    public double getUncertainty(int paramIndex) {
        if (paramIndex < this.uncertainties.length && this.autofitCheckBox.isSelected()) {
            return this.uncertainties[paramIndex];
        }
        return Double.NaN;
    }

    public String getUncertaintyString(int paramIndex) {
        double uncertainty = this.getUncertainty(paramIndex);
        if (Double.isNaN(uncertainty)) {
            return null;
        }
        if (SEFormat instanceof DecimalFormat) {
            DecimalFormat format = (DecimalFormat)SEFormat;
            if (uncertainty < 0.1) {
                format.applyPattern("0.0E0");
            } else if (uncertainty < 1.0) {
                format.applyPattern("0.00");
            } else if (uncertainty < 10.0) {
                format.applyPattern("0.0");
            } else if (uncertainty < 100.0) {
                format.applyPattern("0");
            } else {
                format.applyPattern("0.0E0");
            }
        }
        return "\ufffd " + SEFormat.format(uncertainty);
    }

    public KnownFunction getFitFunction(String name) {
        for (KnownFunction f : this.localFits) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public Map<String, Double> getSelectedFitParameters() {
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = this.fitBar.getPreferredSize();
        dim.height += this.eqnBar.getPreferredSize().height;
        dim.height += this.rmsBar.getPreferredSize().height + 1;
        return dim;
    }

    protected void createGUI() {
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(1);
        this.splitPane.setResizeWeight(0.8);
        this.splitPane.setDividerSize(6);
        this.autofitCheckBox = new JCheckBox("", true);
        this.autofitCheckBox.setOpaque(false);
        this.autofitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetCurveFitter.this.spinCellEditor.stopCellEditing();
                DatasetCurveFitter.this.paramTable.clearSelection();
                DatasetCurveFitter.this.fit(DatasetCurveFitter.this.fit);
                DatasetCurveFitter.this.firePropertyChange("changed", null, null);
            }
        });
        this.fitLabel = new JLabel(ToolsRes.getString("DatasetCurveFitter.Label.FitName"));
        this.fitLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.eqnLabel = new JLabel(ToolsRes.getString("DatasetCurveFitter.Label.Equation"));
        this.eqnLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.rmsLabel = new JLabel();
        this.rmsLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.fitDropDown = new JComboBox(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = DataTool.buttonHeight - 2;
                return dim;
            }

            public void addItem(Object obj) {
                if (obj == null) {
                    return;
                }
                String name = FitBuilder.localize((String)obj);
                int count = this.getItemCount();
                boolean added = false;
                int i = 0;
                while (i < count) {
                    String next = FitBuilder.localize((String)this.getItemAt(i));
                    if (next != null && name.compareToIgnoreCase(next) < 0) {
                        this.insertItemAt(obj, i);
                        added = true;
                        break;
                    }
                    ++i;
                }
                if (!added) {
                    super.addItem(obj);
                }
            }
        };
        for (KnownFunction f : defaultFits) {
            this.localFits.add(f.clone());
        }
        this.refreshFitMap();
        for (String next : this.fitMap.keySet()) {
            this.fitDropDown.addItem(next);
        }
        this.fitDropDown.setSelectedItem(this.getLineFitName());
        this.fitDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DatasetCurveFitter.this.refreshing || DatasetCurveFitter.this.fitBuilder.getSelectedCurveFitter() != DatasetCurveFitter.this) {
                    return;
                }
                String selection = (String)DatasetCurveFitter.this.fitDropDown.getSelectedItem();
                if (selection != null && DatasetCurveFitter.this.fit != null && !selection.equals(DatasetCurveFitter.this.fit.getName())) {
                    DatasetCurveFitter.this.firePropertyChange("changed", null, null);
                }
                DatasetCurveFitter.this.selectFit(selection);
                DatasetCurveFitter.this.fitDropDown.setToolTipText(DatasetCurveFitter.this.fit == null ? null : DatasetCurveFitter.this.fit.getDescription());
            }
        });
        class FitDropDownRenderer
        extends BasicComboBoxRenderer {
            FitDropDownRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                    int length = DatasetCurveFitter.this.fitDropDown.getItemCount();
                    if (-1 < index && index < length) {
                        String fitName = (String)DatasetCurveFitter.this.fitDropDown.getItemAt(index);
                        KnownFunction func = DatasetCurveFitter.this.getFitFunction(fitName);
                        list.setToolTipText(func == null ? null : func.getDescription());
                    }
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setFont(list.getFont());
                this.setText(value == null ? "" : FitBuilder.localize(value.toString()));
                return this;
            }
        }
        this.fitDropDown.setRenderer(new FitDropDownRenderer());
        this.eqnField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = DataTool.buttonHeight - 2;
                return dim;
            }
        };
        this.eqnField.setEditable(false);
        this.eqnField.setEnabled(true);
        this.eqnField.setBackground(Color.white);
        this.eqnField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String name = DatasetCurveFitter.this.fitDropDown.getSelectedItem().toString();
                    if (DatasetCurveFitter.this.fitBuilder.getPanelNames().contains(name)) {
                        DatasetCurveFitter.this.fitBuilder.setSelectedPanel(name);
                    } else {
                        UserFunction uf = DatasetCurveFitter.this.createClone(DatasetCurveFitter.this.fit, name);
                        UserFunctionEditor editor = new UserFunctionEditor();
                        editor.setMainFunctions(new UserFunction[]{uf});
                        FitFunctionPanel panel = new FitFunctionPanel(editor);
                        DatasetCurveFitter.this.fitBuilder.addPanel(uf.getName(), panel);
                        DatasetCurveFitter.this.fitDropDown.setSelectedItem(uf.getName());
                    }
                    DatasetCurveFitter.this.fitBuilder.setVisible(true);
                }
            }
        });
        this.colorButton = DataTool.createButton("");
        this.colorButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Color.Tooltip"));
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dialog = DatasetCurveFitter.this.getColorDialog();
                DatasetCurveFitter.this.closeButton.setText(ToolsRes.getString("Button.OK"));
                dialog.setTitle(ToolsRes.getString("DatasetCurveFitter.Dialog.Color.Title"));
                dialog.setVisible(true);
            }
        });
        this.rmsField = new NumberField(6){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = DataTool.buttonHeight - 2;
                return dim;
            }
        };
        this.rmsField.setEditable(false);
        this.rmsField.setEnabled(true);
        this.rmsField.setBackground(Color.white);
        this.cellRenderer = new ParamCellRenderer();
        this.spinCellEditor = new SpinCellEditor();
        this.paramModel = new ParamTableModel();
        this.paramTable = new ParamTable(this.paramModel);
        this.paramTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DatasetCurveFitter.this.paramTable.getSelectedColumn() == 0) {
                    DatasetCurveFitter.this.paramTable.clearSelection();
                }
            }
        });
        JScrollPane scroller = new JScrollPane(this.paramTable){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = DatasetCurveFitter.this.spinCellEditor.spinner.getPreferredSize();
                dim.width += DatasetCurveFitter.this.cellRenderer.fieldFont.getSize() * 7;
                return dim;
            }
        };
        this.splitPane.setRightComponent(scroller);
        this.add((Component)this.splitPane, "Center");
        this.fitBuilderButton = DataTool.createButton(ToolsRes.getString("DatasetCurveFitter.Button.Define.Text"));
        this.fitBuilderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetCurveFitter.this.autofitCheckBox.setSelected(false);
                String fitName = DatasetCurveFitter.this.fit.getName();
                if (fitName != null && DatasetCurveFitter.this.fitBuilder.getPanelNames().contains(fitName)) {
                    DatasetCurveFitter.this.fitBuilder.setSelectedPanel(fitName);
                } else if (DatasetCurveFitter.this.fitBuilder.getSelectedName() != null) {
                    DatasetCurveFitter.this.fitDropDown.setSelectedItem(DatasetCurveFitter.this.fitBuilder.getSelectedName());
                }
                DatasetCurveFitter.this.fitBuilder.refreshGUI();
                DatasetCurveFitter.this.fitBuilder.setVisible(true);
            }
        });
        this.fitListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                boolean isSelectedCurveFitter;
                if (DatasetCurveFitter.this.refreshing) {
                    return;
                }
                String prop = e.getPropertyName();
                if (!prop.equals("function") && !prop.equals("panel")) {
                    return;
                }
                boolean bl = isSelectedCurveFitter = DatasetCurveFitter.this.fitBuilder.getSelectedCurveFitter() == DatasetCurveFitter.this;
                if (prop.equals("panel")) {
                    String name;
                    KnownFunction f;
                    FitFunctionPanel panel;
                    if (e.getNewValue() != null) {
                        panel = (FitFunctionPanel)e.getNewValue();
                        f = DatasetCurveFitter.this.getFitFunction(panel);
                        name = f.getName();
                        if (!DatasetCurveFitter.this.fitMap.keySet().contains(name)) {
                            DatasetCurveFitter.this.localFits.add(f);
                            DatasetCurveFitter.this.fitMap.put(name, f);
                            DatasetCurveFitter.this.fitDropDown.addItem(name);
                        }
                        if (DatasetCurveFitter.this.fitBuilder.isVisible() && isSelectedCurveFitter && DatasetCurveFitter.this.tab != null && DatasetCurveFitter.this.tab.dataTool != null && !DatasetCurveFitter.this.tab.dataTool.isLoading) {
                            DatasetCurveFitter.this.fitDropDown.setSelectedItem(name);
                        }
                    }
                    if (e.getOldValue() != null) {
                        panel = (FitFunctionPanel)e.getOldValue();
                        f = DatasetCurveFitter.this.getFitFunction(panel);
                        name = f.getName();
                        if (!DatasetCurveFitter.this.fitBuilder.getPanelNames().contains(name)) {
                            DatasetCurveFitter.this.localFits.remove(f);
                        }
                    }
                } else if (prop.equals("function")) {
                    String fitName;
                    String name = (String)e.getNewValue();
                    FitFunctionPanel panel = (FitFunctionPanel)DatasetCurveFitter.this.fitBuilder.getSelectedPanel();
                    String oldFitName = fitName = panel.getName();
                    if (name.equals(fitName) && e.getOldValue() != null && e.getOldValue() instanceof String) {
                        oldFitName = (String)e.getOldValue();
                    }
                    KnownFunction f = DatasetCurveFitter.this.getFitFunction(panel);
                    DatasetCurveFitter.this.replaceFit(oldFitName, fitName, f);
                    if (!fitName.equals(oldFitName)) {
                        DatasetCurveFitter.this.fitDropDown.addItem(fitName);
                    }
                    if (isSelectedCurveFitter && DatasetCurveFitter.this.tab != null && DatasetCurveFitter.this.tab.dataTool != null && !DatasetCurveFitter.this.tab.dataTool.isLoading) {
                        DatasetCurveFitter.this.fitDropDown.setSelectedItem(fitName);
                    }
                }
                DatasetCurveFitter.this.firePropertyChange("changed", null, null);
                DatasetCurveFitter.this.refreshGUI();
            }
        };
        ArrayList<KnownFunction> fits = new ArrayList<KnownFunction>(this.localFits);
        for (KnownFunction f : fits) {
            if (this.fitBuilder.addFitFunction(f)) continue;
            this.localFits.remove(f);
        }
        for (String next : this.fitBuilder.getPanelNames()) {
            FitFunctionPanel panel = (FitFunctionPanel)this.fitBuilder.getPanel(next);
            KnownFunction f = this.getFitFunction(panel);
            if (this.localFits.contains(f)) continue;
            this.localFits.add(f);
        }
        JPanel fitPanel = new JPanel(new BorderLayout());
        this.splitPane.setLeftComponent(fitPanel);
        this.fitBar = new JToolBar();
        this.fitBar.setFloatable(false);
        this.fitBar.setBorder(BorderFactory.createEtchedBorder());
        this.fitBar.add(this.fitLabel);
        this.fitBar.add(this.fitDropDown);
        this.fitBar.addSeparator();
        this.fitBar.add(this.fitBuilderButton);
        fitPanel.add((Component)this.fitBar, "North");
        JPanel eqnPanel = new JPanel(new BorderLayout());
        fitPanel.add((Component)eqnPanel, "Center");
        this.eqnBar = new JToolBar();
        this.eqnBar.setFloatable(false);
        this.eqnBar.setBorder(BorderFactory.createEtchedBorder());
        this.eqnBar.add(this.eqnLabel);
        this.eqnBar.add(this.eqnField);
        this.eqnBar.add(this.colorButton);
        eqnPanel.add((Component)this.eqnBar, "North");
        JPanel rmsPanel = new JPanel(new BorderLayout());
        eqnPanel.add((Component)rmsPanel, "Center");
        this.rmsBar = new JToolBar();
        this.rmsBar.setFloatable(false);
        this.rmsBar.setBorder(BorderFactory.createEtchedBorder());
        this.rmsBar.add(this.autofitCheckBox);
        this.rmsBar.addSeparator();
        this.rmsBar.add(this.rmsLabel);
        this.rmsBar.add(this.rmsField);
        rmsPanel.add((Component)this.rmsBar, "North");
        this.refreshGUI();
    }

    protected void refreshGUI() {
        boolean nimbus;
        this.autofitCheckBox.setText(ToolsRes.getString("Checkbox.Autofit.Label"));
        this.rmsLabel.setText(ToolsRes.getString("DatasetCurveFitter.Label.RMSDeviation"));
        this.fitBuilderButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.Define.Text"));
        this.fitBuilderButton.setToolTipText(ToolsRes.getString("DatasetCurveFitter.Button.Define.Tooltip"));
        this.fitLabel.setText(ToolsRes.getString("DatasetCurveFitter.Label.FitName"));
        this.eqnLabel.setText(ToolsRes.getString("DatasetCurveFitter.Label.Equation"));
        LookAndFeel currentLF = UIManager.getLookAndFeel();
        boolean bl = nimbus = currentLF.getClass().getName().indexOf("Nimbus") > -1;
        if (nimbus) {
            this.colorButton.setIcon(new ColorIcon(this.color, 12, DataTool.buttonHeight - 8));
        } else {
            this.colorButton.setBackground(this.color);
        }
        this.refreshFitDropDown();
    }

    protected void refreshFitDropDown() {
        Runnable runner = new Runnable(){

            @Override
            public synchronized void run() {
                DatasetCurveFitter.this.refreshFitMap();
                String toSelect = DatasetCurveFitter.this.fitBuilder.defaultFitName = DatasetCurveFitter.this.getLineFitName();
                DatasetCurveFitter.this.refreshing = true;
                DatasetCurveFitter.this.fitDropDown.removeAllItems();
                for (String name : DatasetCurveFitter.this.fitMap.keySet()) {
                    if (DatasetCurveFitter.this.fit != null && name.equals(DatasetCurveFitter.this.fit.getName())) {
                        toSelect = name;
                    }
                    DatasetCurveFitter.this.fitDropDown.addItem(name);
                }
                DatasetCurveFitter.this.refreshing = false;
                DatasetCurveFitter.this.fitDropDown.setSelectedItem(toSelect);
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    protected void refreshFitMap() {
        this.fitMap.clear();
        for (KnownFunction f : this.localFits) {
            this.fitMap.put(f.getName(), f);
        }
    }

    protected String getLineFitName() {
        for (String key : this.fitMap.keySet()) {
            KnownPolynomial poly;
            KnownFunction f = this.fitMap.get(key);
            if (!(f instanceof KnownPolynomial) || (poly = (KnownPolynomial)f).getParameterCount() != 2) continue;
            return key;
        }
        return null;
    }

    protected void setDataToolTab(DataToolTab tab) {
        this.tab = tab;
    }

    protected void setFontLevel(int level) {
        this.fontLevel = level;
        FontSizer.setFonts(this, this.fontLevel);
        this.fitBuilder.setFontLevel(level);
        this.splitPane.setDividerLocation(this.splitPane.getMaximumDividerLocation());
    }

    protected void setParameterValue(int row, double value) {
        if (row < this.fit.getParameterCount()) {
            this.fit.setParameterValue(row, value);
        }
    }

    protected void selectFit(String name) {
        if (this.refreshing) {
            return;
        }
        if (name == null) {
            name = this.getLineFitName();
        }
        this.fit = this.fitMap.get(name);
        if (this.fit != null) {
            String indepVar;
            FunctionDrawer prev = this.drawer;
            this.drawer = new FunctionDrawer(this.fit);
            this.drawer.setColor(this.color);
            this.paramTable.tableChanged(null);
            String depVar = this.dataset == null ? "y" : TeXParser.removeSubscripting(this.dataset.getColumnName(1));
            String string = indepVar = this.dataset == null ? "x" : TeXParser.removeSubscripting(this.dataset.getColumnName(0));
            if (this.fit instanceof UserFunction) {
                this.eqnField.setText(String.valueOf(depVar) + " = " + ((UserFunction)this.fit).getFullExpression(new String[]{indepVar}));
            } else {
                this.eqnField.setText(String.valueOf(depVar) + " = " + this.fit.getExpression(indepVar));
            }
            this.firePropertyChange("drawer", prev, this.drawer);
            if (this.isActive) {
                this.fit(this.fit);
            }
            if (this.fitBuilder.isVisible()) {
                this.fitBuilder.setSelectedPanel(this.fit.getName());
            }
            this.revalidate();
        }
    }

    protected UserFunction createClone(KnownFunction f, String name) {
        String var = this.dataset == null ? "x" : TeXParser.removeSubscripting(this.dataset.getColumnName(0));
        f.getExpression(var);
        UserFunction uf = null;
        if (f instanceof UserFunction) {
            uf = ((UserFunction)f).clone();
        } else {
            uf = new UserFunction(f.getName());
            String[] params = new String[f.getParameterCount()];
            double[] values = new double[f.getParameterCount()];
            String[] desc = new String[f.getParameterCount()];
            int i = 0;
            while (i < params.length) {
                params[i] = f.getParameterName(i);
                values[i] = f.getParameterValue(i);
                desc[i] = f.getParameterDescription(i);
                ++i;
            }
            uf.setParameters(params, values, desc);
            uf.setExpression(f.getExpression(var), new String[]{var});
        }
        int n = 1;
        try {
            String number = name.substring(name.length() - 1);
            n = Integer.parseInt(number) + 1;
            name = name.substring(0, name.length() - 1);
        }
        catch (Exception number) {
            // empty catch block
        }
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < this.fitDropDown.getItemCount()) {
            names.add(this.fitDropDown.getItemAt(i).toString());
            ++i;
        }
        try {
            while (names.contains(String.valueOf(name) + n)) {
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        uf.setName(String.valueOf(name) + n);
        return uf;
    }

    private double getDevSquared(Function f, double[] x, double[] y) {
        this.fitEvaluatedToNaN = false;
        double total = 0.0;
        int i = 0;
        while (i < x.length) {
            double next = f.evaluate(x[i]);
            if (f instanceof UserFunction && this.tab != null) {
                this.fitEvaluatedToNaN = this.fitEvaluatedToNaN || ((UserFunction)f).evaluatedToNaN();
            }
            double dev = next - y[i];
            total += dev * dev;
            ++i;
        }
        if (this.tab != null) {
            if (this.fitEvaluatedToNaN) {
                String s = ToolsRes.getString("DatasetCurveFitter.Warning.FunctionError");
                this.tab.plot.setMessage(s, 2);
            } else {
                this.tab.plot.setMessage("", 2);
            }
        }
        return this.fitEvaluatedToNaN ? Double.NaN : total;
    }

    public void doLinearRegression(double[] xd, double[] yd, boolean isLinearFit) {
        int n = xd.length;
        this.correlation = Double.NaN;
        int i = 0;
        while (i < this.uncertainties.length) {
            this.uncertainties[i] = Double.NaN;
            ++i;
        }
        if (n < 3) {
            return;
        }
        double mean_x = xd[0];
        double mean_y = yd[0];
        int i2 = 1;
        while (i2 < n) {
            mean_x += xd[i2];
            mean_y += yd[i2];
            ++i2;
        }
        mean_x /= (double)n;
        mean_y /= (double)n;
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double sum_coproduct = 0.0;
        int i3 = 0;
        while (i3 < n) {
            double delta_x = xd[i3] - mean_x;
            double delta_y = yd[i3] - mean_y;
            sum_sq_x += delta_x * delta_x;
            sum_sq_y += delta_y * delta_y;
            sum_coproduct += delta_x * delta_y;
            ++i3;
        }
        if (sum_sq_x == 0.0 || sum_sq_y == 0.0) {
            this.correlation = Double.NaN;
            i3 = 0;
            while (i3 < this.uncertainties.length) {
                this.uncertainties[i3] = Double.NaN;
                ++i3;
            }
            return;
        }
        double pop_sd_x = sum_sq_x / (double)n;
        double pop_sd_y = sum_sq_y / (double)n;
        double cov_x_y = sum_coproduct / (double)n;
        this.correlation = cov_x_y * cov_x_y / (pop_sd_x * pop_sd_y);
        if (isLinearFit) {
            double sumSqErr = Math.max(0.0, sum_sq_y - sum_coproduct * sum_coproduct / sum_sq_x);
            double meanSqErr = sumSqErr / (double)(n - 2);
            this.uncertainties[0] = Math.sqrt(meanSqErr / sum_sq_x);
            this.uncertainties[1] = Math.sqrt(meanSqErr * (1.0 / (double)n + mean_x * mean_x / sum_sq_x));
        }
    }

    private KnownFunction getFitFunction(FitFunctionPanel panel) {
        UserFunction f = panel.getFitFunction();
        if (f.polynomial != null) {
            f.updatePolynomial();
            return f.polynomial.clone();
        }
        return f.clone();
    }

    protected void replaceFit(String oldName, String newName, KnownFunction newFit) {
        KnownFunction oldFit = this.fitMap.get(oldName);
        if (oldFit != null) {
            if (this.localFits.contains(oldFit)) {
                this.localFits.remove(oldFit);
                this.localFits.add(newFit);
            }
            this.refreshFitDropDown();
        }
        this.refreshFitMap();
    }

    protected JDialog getColorDialog() {
        if (this.colorDialog == null) {
            final Frame frame = JOptionPane.getFrameForComponent(this);
            final JColorChooser cc = new JColorChooser();
            cc.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DatasetCurveFitter.this.color = cc.getColor();
                    DatasetCurveFitter.this.setColor(DatasetCurveFitter.this.color);
                    frame.repaint();
                }
            });
            this.colorDialog = new JDialog(frame, false);
            this.closeButton = new JButton();
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetCurveFitter.this.colorDialog.setVisible(false);
                }
            });
            JPanel contentPane = new JPanel(new BorderLayout());
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.closeButton);
            AbstractColorChooserPanel chooser = cc.getChooserPanels()[0];
            chooser.setBorder(BorderFactory.createEmptyBorder(2, 2, 12, 2));
            contentPane.add((Component)chooser, "Center");
            contentPane.add((Component)buttonPanel, "South");
            this.colorDialog.setContentPane(contentPane);
            this.colorDialog.pack();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.colorDialog.getWidth()) / 2;
            Point p = this.getLocationOnScreen();
            int y = Math.max(0, p.y - this.colorDialog.getHeight());
            this.colorDialog.setLocation(x, y);
        }
        return this.colorDialog;
    }

    public static void setDefaultFitFunctions(ArrayList<KnownFunction> functions) {
        if (functions != null) {
            defaultFits = functions;
        }
    }

    public class MinimizeMultiVarFunction
    implements MultiVarFunction {
        MultiVarFunction f;
        double[] x;
        double[] y;
        double[] vars = new double[5];

        MinimizeMultiVarFunction(MultiVarFunction f, double[] x, double[] y) {
            this.f = f;
            this.x = x;
            this.y = y;
        }

        @Override
        public double evaluate(double[] params) {
            System.arraycopy(params, 0, this.vars, 1, 4);
            double sum = 0.0;
            int i = 0;
            int n = this.x.length;
            while (i < n) {
                this.vars[0] = this.x[i];
                double dev = this.y[i] - this.f.evaluate(this.vars);
                sum += dev * dev;
                ++i;
            }
            return sum;
        }
    }

    public class MinimizeUserFunction
    implements MultiVarFunction {
        UserFunction f;
        double[] x;
        double[] y;

        MinimizeUserFunction(UserFunction f, double[] x, double[] y) {
            this.f = f;
            this.x = x;
            this.y = y;
        }

        @Override
        public double evaluate(double[] params) {
            int i = 0;
            while (i < params.length) {
                this.f.setParameterValue(i, params[i]);
                ++i;
            }
            double sum = 0.0;
            int i2 = 0;
            while (i2 < this.x.length) {
                double dev = this.y[i2] - this.f.evaluate(this.x[i2]);
                sum += dev * dev;
                ++i2;
            }
            return sum;
        }
    }

    static class NumberField
    extends JTextField {
        protected NumberFormat format = NumberFormat.getInstance();
        protected double prevValue;
        protected String pattern = "0";
        protected int preferredWidth;

        public NumberField(int columns) {
            super(columns);
            this.setForeground(Color.black);
        }

        public double getValue() {
            double retValue;
            if (this.getText().equals(this.format.format(this.prevValue))) {
                return this.prevValue;
            }
            try {
                retValue = this.format.parse(this.getText()).doubleValue();
            }
            catch (ParseException e) {
                Toolkit.getDefaultToolkit().beep();
                this.setValue(this.prevValue);
                return this.prevValue;
            }
            return retValue;
        }

        public void setValue(double value) {
            if (!this.isVisible()) {
                return;
            }
            this.setText(this.format.format(value));
            this.prevValue = value;
        }

        public void applyPattern(String pattern) {
            if (this.format instanceof DecimalFormat) {
                try {
                    ((DecimalFormat)this.format).applyPattern(pattern);
                    this.pattern = pattern;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public String getPattern() {
            return this.pattern;
        }

        public NumberFormat getFormat() {
            return this.format;
        }

        protected void refreshPreferredWidth() {
            FontRenderContext frc = new FontRenderContext(null, false, false);
            Rectangle2D rect = this.getFont().getStringBounds(this.getText(), frc);
            this.preferredWidth = (int)rect.getWidth() + 8;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = Math.max(dim.width, this.preferredWidth);
            return dim;
        }
    }

    class ParamCellRenderer
    extends JLabel
    implements TableCellRenderer {
        Color lightBlue = new Color(204, 204, 255);
        Color lightGray = UIManager.getColor("Panel.background");
        Font fieldFont = new JTextField().getFont();
        Font labelFont = this.getFont();

        public ParamCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            String tooltip;
            this.setHorizontalAlignment(2);
            this.setBorder(new CellBorder(new Color(240, 240, 240)));
            String string = tooltip = col == 1 ? ToolsRes.getString("DatasetCurveFitter.SE.Description") : null;
            if (value instanceof String) {
                this.setFont(this.labelFont);
                this.setBackground(isSelected ? Color.LIGHT_GRAY : this.lightGray);
                this.setForeground(Color.black);
                this.setText(value.toString());
                if (col == 0) {
                    tooltip = DatasetCurveFitter.this.fit.getParameterDescription(row);
                }
            } else {
                this.setFont(this.fieldFont);
                this.setBackground(isSelected ? this.lightBlue : Color.white);
                this.setForeground(isSelected ? Color.red : (table.isEnabled() ? Color.black : Color.gray));
                NumberFormat format = DatasetCurveFitter.this.spinCellEditor.field.format;
                this.setText(format.format(value));
                if (!DatasetCurveFitter.this.autofitCheckBox.isSelected()) {
                    tooltip = String.valueOf(tooltip) + " " + ToolsRes.getString("DatasetCurveFitter.SE.Autofit");
                } else if (DatasetCurveFitter.this.fit instanceof KnownPolynomial) {
                    String uncert;
                    tooltip = String.valueOf(tooltip) + " " + ToolsRes.getString("DatasetCurveFitter.SE.Unknown");
                    KnownPolynomial poly = (KnownPolynomial)DatasetCurveFitter.this.fit;
                    if (poly.degree() == 1 && (uncert = DatasetCurveFitter.this.getUncertaintyString(row)) != null) {
                        tooltip = String.valueOf(uncert) + " (" + ToolsRes.getString("DatasetCurveFitter.SE.Name") + ")";
                    }
                } else {
                    tooltip = String.valueOf(tooltip) + " " + ToolsRes.getString("DatasetCurveFitter.SE.Unknown");
                }
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }

    class ParamTable
    extends JTable {
        public ParamTable(ParamTableModel model) {
            super(model);
            this.setGridColor(Color.blue);
            JTableHeader header = this.getTableHeader();
            header.setForeground(Color.blue);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return DatasetCurveFitter.this.cellRenderer;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            DatasetCurveFitter.this.spinCellEditor.rowNumber = row;
            return DatasetCurveFitter.this.spinCellEditor;
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (DatasetCurveFitter.this.cellRenderer != null) {
                Font aFont = DatasetCurveFitter.this.cellRenderer.labelFont;
                DatasetCurveFitter.this.cellRenderer.labelFont = aFont = aFont.deriveFont(font.getSize2D());
                DatasetCurveFitter.this.spinCellEditor.stepSizeLabel.setFont(aFont);
                aFont = DatasetCurveFitter.this.cellRenderer.fieldFont;
                DatasetCurveFitter.this.cellRenderer.fieldFont = aFont = aFont.deriveFont(font.getSize2D());
                DatasetCurveFitter.this.spinCellEditor.field.setFont(aFont);
            }
            this.getTableHeader().setFont(font);
            this.setRowHeight(font.getSize() + 4);
            TableModel model = this.getModel();
            if (model instanceof DefaultTableModel) {
                DefaultTableModel tm = (DefaultTableModel)model;
                tm.fireTableDataChanged();
            }
        }
    }

    class ParamTableModel
    extends AbstractTableModel {
        ParamTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? ToolsRes.getString("Table.Heading.Parameter") : ToolsRes.getString("Table.Heading.Value");
        }

        @Override
        public int getRowCount() {
            return DatasetCurveFitter.this.fit == null ? 0 : DatasetCurveFitter.this.fit.getParameterCount();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return DatasetCurveFitter.this.fit.getParameterName(row);
            }
            return new Double(DatasetCurveFitter.this.fit.getParameterValue(row));
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class SpinCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        SpinnerNumberCrawlerModel crawlerModel;
        JSpinner spinner;
        NumberField field;
        int rowNumber;
        JLabel stepSizeLabel;

        SpinCellEditor() {
            this.crawlerModel = new SpinnerNumberCrawlerModel(1.0);
            this.stepSizeLabel = new JLabel("10%");
            this.panel.setOpaque(false);
            this.spinner = new JSpinner(this.crawlerModel);
            this.spinner.setToolTipText(ToolsRes.getString("Table.Spinner.ToolTip"));
            this.spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    UserFunction f;
                    String name;
                    FitFunctionPanel panel;
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.autofitCheckBox.setSelected(false);
                    double val = (Double)SpinCellEditor.this.spinner.getValue();
                    SpinCellEditor.this.field.setValue(val);
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit.setParameterValue(SpinCellEditor.this.rowNumber, val);
                    if (((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit instanceof UserFunction && (panel = (FitFunctionPanel)((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fitBuilder.getPanel(name = (f = (UserFunction)((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit).getName())) != null) {
                        name = f.getParameterName(SpinCellEditor.this.rowNumber);
                        Parameter seed = new Parameter(name, SpinCellEditor.this.field.getText());
                        block0: for (Parameter p : panel.getParamEditor().evaluateDependents(seed)) {
                            int i = 0;
                            while (i < f.getParameterCount()) {
                                if (f.getParameterName(i).equals(p.getName())) {
                                    f.setParameterValue(i, p.getValue());
                                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.paramModel.fireTableCellUpdated(i, 1);
                                    continue block0;
                                }
                                ++i;
                            }
                        }
                        panel.getFitFunctionEditor().parametersValid = false;
                        f.updateReferenceParameters();
                    }
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.drawer.functionChanged = true;
                    DatasetCurveFitter.this.fit(((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit);
                    DatasetCurveFitter.this.firePropertyChange("changed", null, null);
                }
            });
            this.field = new NumberField(10);
            this.field.applyPattern("0.000E0");
            this.field.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
            this.spinner.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
            this.spinner.setEditor(this.field);
            this.stepSizeLabel.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JPopupMenu popup = new JPopupMenu();
                    ActionListener listener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            double percent = Double.parseDouble(e.getActionCommand());
                            (this).SpinCellEditor.this.crawlerModel.setPercentDelta(percent);
                            (this).SpinCellEditor.this.crawlerModel.refreshDelta();
                            (this).SpinCellEditor.this.stepSizeLabel.setText(String.valueOf(e.getActionCommand()) + "%");
                        }
                    };
                    int i = 0;
                    while (i < 3) {
                        String val = i == 0 ? "10" : (i == 1 ? "1.0" : "0.1");
                        JMenuItem item = new JMenuItem(String.valueOf(val) + "%");
                        item.setActionCommand(val);
                        item.addActionListener(listener);
                        popup.add(item);
                        ++i;
                    }
                    popup.show(SpinCellEditor.this.stepSizeLabel, 0, SpinCellEditor.this.stepSizeLabel.getHeight());
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    JComponent comp = (JComponent)e.getSource();
                    if (e.getKeyCode() == 10) {
                        SpinCellEditor.this.spinner.setValue(new Double(SpinCellEditor.this.field.getValue()));
                        comp.setBackground(Color.white);
                        SpinCellEditor.this.crawlerModel.refreshDelta();
                    } else {
                        comp.setBackground(Color.yellow);
                    }
                }
            });
            this.panel.add((Component)this.spinner, "Center");
            this.panel.add((Component)this.stepSizeLabel, "East");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.spinner.setValue(value);
            this.crawlerModel.refreshDelta();
            return this.panel;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                return true;
            }
            return e instanceof ActionEvent;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.field.getBackground() == Color.yellow) {
                DatasetCurveFitter.this.fit.setParameterValue(this.rowNumber, this.field.getValue());
                DatasetCurveFitter.this.drawer.functionChanged = true;
                DatasetCurveFitter.this.firePropertyChange("fit", null, null);
                this.field.setBackground(Color.white);
                DatasetCurveFitter.this.firePropertyChange("changed", null, null);
            }
            return null;
        }
    }

    class SpinnerNumberCrawlerModel
    extends AbstractSpinnerModel {
        double val = 0.0;
        double delta;
        double percentDelta = 10.0;

        public SpinnerNumberCrawlerModel(double initialDelta) {
            this.delta = initialDelta;
        }

        @Override
        public Object getValue() {
            return new Double(this.val);
        }

        @Override
        public Object getNextValue() {
            return new Double(this.val + this.delta);
        }

        @Override
        public Object getPreviousValue() {
            return new Double(this.val - this.delta);
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                this.val = (Double)value;
                this.fireStateChanged();
            }
        }

        public void setPercentDelta(double percent) {
            this.percentDelta = percent;
        }

        public double getPercentDelta() {
            return this.percentDelta;
        }

        public void refreshDelta() {
            if (this.val != 0.0) {
                this.delta = Math.abs(this.val * this.percentDelta / 100.0);
            }
        }
    }
}

