/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.DataColumn;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ToolsRes;

public class DataToolTable
extends DataTable {
    protected static final int RENAME_COLUMN_EDIT = 0;
    protected static final int INSERT_COLUMN_EDIT = 1;
    protected static final int DELETE_COLUMN_EDIT = 2;
    protected static final int INSERT_CELLS_EDIT = 3;
    protected static final int DELETE_CELLS_EDIT = 4;
    protected static final int REPLACE_CELLS_EDIT = 5;
    protected static final int INSERT_ROWS_EDIT = 6;
    protected static final int DELETE_ROWS_EDIT = 7;
    protected static String[] editTypes = new String[]{"rename column", "insert column", "delete column", "insert cells", "delete cells", "replace cells", "insert rows", "delete rows"};
    protected static Color xAxisColor = new Color(255, 255, 153);
    protected static Color yAxisColor = new Color(204, 255, 204);
    DataToolTab dataToolTab;
    DatasetManager dataManager;
    WorkingDataset workingData;
    HashMap<String, WorkingDataset> workingMap = new HashMap();
    HighlightableDataset selectedData = new HighlightableDataset();
    HeaderRenderer headerRenderer;
    LabelRenderer labelRenderer = new LabelRenderer();
    DataCellRenderer dataRenderer = new DataCellRenderer();
    DataEditor editor = new DataEditor();
    TreeSet<Integer> selectedRows = new TreeSet();
    TreeSet<Integer> selectedColumns = new TreeSet();
    JPopupMenu popup = new JPopupMenu();
    JMenuItem renameColumnItem;
    JMenuItem copyColumnsItem;
    JMenuItem cutColumnsItem;
    JMenuItem pasteColumnsItem;
    JMenuItem cloneColumnsItem;
    JMenuItem numberFormatItem;
    JMenuItem insertRowItem;
    JMenuItem pasteRowsItem;
    JMenuItem copyRowsItem;
    JMenuItem cutRowsItem;
    JMenuItem insertCellsItem;
    JMenuItem deleteCellsItem;
    JMenuItem copyCellsItem;
    JMenuItem cutCellsItem;
    JMenuItem pasteInsertCellsItem;
    JMenuItem pasteCellsItem;
    JMenuItem addEndRowItem;
    JMenuItem trimRowsItem;
    JMenuItem selectAllItem;
    JMenuItem selectNoneItem;
    JMenuItem clearContentsItem;
    Action clearCellsAction;
    Action pasteCellsAction;
    Action pasteInsertCellsAction;
    Action cantPasteCellsAction;
    Action cantPasteRowsAction;
    Action getPasteDataAction;
    MouseAdapter tableMouseListener;
    Color selectedBG;
    Color selectedFG;
    Color unselectedBG;
    Color selectedHeaderFG;
    Color selectedHeaderBG;
    Color rowBG;
    int focusRow;
    int focusCol;
    int mouseRow;
    int mouseCol;
    int leadCol = 0;
    int leadRow = 0;
    int prevSortedColumn;
    int pasteW;
    int pasteH;
    HashMap<String, double[]> pasteValues = new HashMap();
    DatasetManager pasteData = null;
    HashMap<Integer, Integer> workingRows = new HashMap();

    public DataToolTable(DataToolTab tab) {
        super(new DataToolTableModel(tab));
        this.dataToolTab = tab;
        this.dataManager = tab.dataManager;
        this.add(this.dataManager);
        this.setRowNumberVisible(true);
        this.setSelectionMode(2);
        this.headerRenderer = new HeaderRenderer(this.getTableHeader().getDefaultRenderer());
        this.getTableHeader().setDefaultRenderer(this.headerRenderer);
        ListSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() == -1) {
                    return;
                }
                DataToolTable.this.selectedRows.clear();
                int[] rows = DataToolTable.this.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    int modelRow = DataToolTable.this.getModelRow(rows[i]);
                    DataToolTable.this.selectedRows.add(modelRow);
                    ++i;
                }
                if (!e.getValueIsAdjusting()) {
                    int labelCol = DataToolTable.this.convertColumnIndexToView(0);
                    DataToolTable.this.addColumnSelectionInterval(labelCol, labelCol);
                    DataToolTable.this.dataToolTab.setSelectedData(DataToolTable.this.getSelectedData());
                }
            }
        });
        selectionModel = this.getColumnModel().getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DataToolTable.this.getTableHeader().repaint();
                DataToolTable.this.dataToolTab.refreshPlot();
            }
        });
        this.clearCellsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashMap<String, double[]> values = new HashMap<String, double[]>();
                int[] rows = DataToolTable.this.getSelectedModelRows();
                Iterator<String> it = DataToolTable.this.getSelectedColumnNames().iterator();
                while (it.hasNext()) {
                    values.put(it.next(), null);
                }
                HashMap<String, double[]> prev = DataToolTable.this.replaceCells(rows, values);
                TableEdit edit = new TableEdit(5, null, rows, new HashMap[]{prev, values});
                DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                DataToolTable.this.refreshUndoItems();
            }
        };
        this.pasteCellsAction = new AbstractAction(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block5: {
                    block2: {
                        block4: {
                            block3: {
                                rows = DataToolTable.this.getSelectedModelRows();
                                if (DataToolTable.this.pasteValues.isEmpty() || rows.length != 1 && DataToolTable.this.pasteH != rows.length) break block2;
                                pasteRows = new int[DataToolTable.this.pasteH];
                                if (DataToolTable.this.pasteH != rows.length) break block3;
                                pasteRows = rows;
                                break block4;
                            }
                            pasteRows[0] = rows[0];
                            vRow = DataToolTable.this.getViewRow(rows[0]);
                            i = 1;
                            ** GOTO lbl19
                            {
                                row = new int[]{DataToolTable.this.getRowCount()};
                                DataToolTable.this.insertRows(row, null);
                                do {
                                    if (vRow + i >= DataToolTable.this.getRowCount()) continue block0;
                                    pasteRows[i] = DataToolTable.this.getModelRow(vRow + i);
                                    ++i;
lbl19:
                                    // 2 sources

                                } while (i < DataToolTable.this.pasteH);
                            }
                        }
                        prev = DataToolTable.this.replaceCells(pasteRows, DataToolTable.this.pasteValues);
                        edit = new TableEdit(5, null, pasteRows, new HashMap[]{prev, DataToolTable.this.pasteValues});
                        DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                        DataToolTable.this.refreshUndoItems();
                        break block5;
                    }
                    DataToolTable.this.cantPasteCellsAction.actionPerformed(e);
                }
            }
        };
        this.pasteInsertCellsAction = new AbstractAction(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block5: {
                    block2: {
                        block4: {
                            block3: {
                                rows = DataToolTable.this.getSelectedModelRows();
                                if (DataToolTable.this.pasteValues.isEmpty() || rows.length != 1 && DataToolTable.this.pasteH != rows.length) break block2;
                                pasteRows = new int[DataToolTable.this.pasteH];
                                if (DataToolTable.this.pasteH != rows.length) break block3;
                                pasteRows = rows;
                                break block4;
                            }
                            pasteRows[0] = rows[0];
                            vRow = DataToolTable.this.getViewRow(rows[0]);
                            i = 1;
                            ** GOTO lbl19
                            {
                                row = new int[]{DataToolTable.this.getRowCount()};
                                DataToolTable.this.insertRows(row, null);
                                do {
                                    if (vRow + i >= DataToolTable.this.getRowCount()) continue block0;
                                    pasteRows[i] = DataToolTable.this.getModelRow(vRow + i);
                                    ++i;
lbl19:
                                    // 2 sources

                                } while (i < DataToolTable.this.pasteH);
                            }
                        }
                        DataToolTable.this.insertCells(pasteRows, DataToolTable.this.pasteValues);
                        edit = new TableEdit(3, null, pasteRows, DataToolTable.this.pasteValues);
                        DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                        DataToolTable.this.refreshUndoItems();
                        break block5;
                    }
                    DataToolTable.this.cantPasteCellsAction.actionPerformed(e);
                }
            }
        };
        this.cantPasteCellsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DataToolTable.this.dataToolTab, String.valueOf(ToolsRes.getString("DataToolTable.Dialog.CantPasteCells.Message1")) + " " + DataToolTable.this.pasteW + " x " + DataToolTable.this.pasteH + "\n" + ToolsRes.getString("DataToolTable.Dialog.CantPasteCells.Message2"), ToolsRes.getString("DataToolTable.Dialog.CantPaste.Title"), 2);
            }
        };
        this.cantPasteRowsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DataToolTable.this.dataToolTab, String.valueOf(ToolsRes.getString("DataToolTable.Dialog.CantPasteRows.Message1")) + " " + DataToolTable.this.pasteH + "\n" + ToolsRes.getString("DataToolTable.Dialog.CantPasteRows.Message2"), ToolsRes.getString("DataToolTable.Dialog.CantPaste.Title"), 2);
            }
        };
        this.getPasteDataAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.this.pasteValues.clear();
                DataToolTable.this.pasteData = null;
                String dataString = DataTool.paste();
                ArrayList<String> colNames = DataToolTable.this.getSelectedColumnNames();
                if (dataString != null) {
                    DataToolTable.this.pasteData = DataTool.parseData(dataString, null);
                    if (DataToolTable.this.pasteData != null) {
                        DataToolTable.this.pasteW = DataToolTable.this.pasteData.getDatasets().size();
                        if (DataToolTable.this.pasteW > 0 && DataToolTable.this.pasteW == colNames.size()) {
                            DataToolTable.this.pasteH = DataToolTable.this.pasteData.getDataset(0).getXPoints().length;
                            if (DataToolTable.this.pasteH > 0) {
                                int i = 0;
                                while (i < DataToolTable.this.pasteW) {
                                    double[] vals = DataToolTable.this.pasteData.getDataset(i).getYPoints();
                                    DataToolTable.this.pasteValues.put(colNames.get(i), vals);
                                    ++i;
                                }
                            }
                        }
                    }
                }
            }
        };
        this.getTableHeader().addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int n = DataToolTable.this.getTableHeader().columnAtPoint(e.getPoint());
                if ((n = DataToolTable.this.convertColumnIndexToModel(n)) == 0) {
                    DataToolTable.this.getTableHeader().setToolTipText(ToolsRes.getString("DataToolTable.Header.Deselect.Tooltip"));
                } else {
                    DataToolTable.this.getTableHeader().setToolTipText(ToolsRes.getString("DataToolTable.Header.Tooltip"));
                }
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int[] rows;
                if (DataToolTable.this.getRowCount() == 0) {
                    return;
                }
                Point mousePt = e.getPoint();
                int col = DataToolTable.this.columnAtPoint(mousePt);
                if (col == -1) {
                    return;
                }
                int labelCol = DataToolTable.this.convertColumnIndexToView(0);
                ArrayList<String> cols = DataToolTable.this.getSelectedColumnNames();
                if (OSPRuntime.isPopupTrigger(e)) {
                    String text;
                    if (col == labelCol) {
                        return;
                    }
                    String colName = DataToolTable.this.getColumnName(col);
                    if (!cols.contains(colName)) {
                        DataToolTable.this.setColumnSelectionInterval(col, col);
                        DataToolTable.this.leadCol = col;
                    }
                    DataToolTable.this.setRowSelectionInterval(0, DataToolTable.this.getRowCount() - 1);
                    DataToolTable.this.popup.removeAll();
                    cols = DataToolTable.this.getSelectedColumnNames();
                    if (cols.size() == 1 && DataToolTable.this.dataToolTab.isUserEditable()) {
                        int index = DataToolTable.this.convertColumnIndexToModel(col) - 1;
                        final Dataset data = DataToolTable.this.dataManager.getDataset(index);
                        text = ToolsRes.getString("DataToolTable.Popup.MenuItem.RenameColumn");
                        DataToolTable.this.renameColumnItem = new JMenuItem(text);
                        DataToolTable.this.renameColumnItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (data instanceof DataFunction) {
                                    DataToolTable.this.showDataBuilder();
                                    return;
                                }
                                String prevName = data.getYColumnName();
                                Object input = JOptionPane.showInputDialog((this).DataToolTable.this.dataToolTab, ToolsRes.getString("DataToolTable.Dialog.NameColumn.Message"), ToolsRes.getString("DataToolTable.Dialog.NameColumn.Title"), 3, null, null, prevName);
                                if (input == null || input.equals("")) {
                                    return;
                                }
                                String newName = (this).DataToolTable.this.dataToolTab.getUniqueYColumnName(data, input.toString(), true);
                                if (newName == null) {
                                    return;
                                }
                                int n = newName.indexOf("}");
                                if (n == 0) {
                                    return;
                                }
                                if (n > -1) {
                                    newName = newName.substring(0, n + 1);
                                }
                                DataToolTable.this.renameColumn(prevName, newName);
                                TableEdit edit = new TableEdit(0, newName, null, prevName);
                                (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                            }
                        });
                        DataToolTable.this.popup.add(DataToolTable.this.renameColumnItem);
                        DataToolTable.this.popup.addSeparator();
                    }
                    text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CopyColumns");
                    DataToolTable.this.copyColumnsItem = new JMenuItem(text);
                    DataToolTable.this.copyColumnsItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            (this).DataToolTable.this.dataToolTab.copyTableDataToClipboard();
                        }
                    });
                    DataToolTable.this.popup.add(DataToolTable.this.copyColumnsItem);
                    boolean addCutItem = true;
                    for (String name : cols) {
                        if (DataToolTable.this.dataToolTab.isDeletable(DataToolTable.this.getDataset(name))) continue;
                        addCutItem = false;
                    }
                    if (addCutItem) {
                        text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CutColumns");
                        DataToolTable.this.cutColumnsItem = new JMenuItem(text);
                        DataToolTable.this.cutColumnsItem.setActionCommand(String.valueOf(col));
                        DataToolTable.this.cutColumnsItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                (this).DataToolTable.this.copyColumnsItem.doClick();
                                DataToolTable.this.deleteSelectedColumns();
                            }
                        });
                        DataToolTable.this.popup.add(DataToolTable.this.cutColumnsItem);
                    }
                    if (DataToolTable.this.dataToolTab != null && DataToolTable.this.dataToolTab.dataTool != null && DataToolTable.this.dataToolTab.dataTool.hasPastableData() && DataToolTable.this.dataToolTab.dataTool.hasPastableColumns(DataToolTable.this.dataToolTab)) {
                        text = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteColumns");
                        DataToolTable.this.pasteColumnsItem = new JMenuItem(text);
                        DataToolTable.this.pasteColumnsItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                (this).DataToolTable.this.dataToolTab.dataTool.pasteColumnsItem.doClick(0);
                            }
                        });
                        DataToolTable.this.popup.add(DataToolTable.this.pasteColumnsItem);
                    }
                    DataToolTable.this.popup.addSeparator();
                    text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CloneColumns");
                    DataToolTable.this.cloneColumnsItem = new JMenuItem(text);
                    DataToolTable.this.cloneColumnsItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ArrayList<String> colNames = DataToolTable.this.getSelectedColumnNames();
                            int i = 0;
                            while (i < colNames.size()) {
                                Dataset data = DataToolTable.this.getDataset(colNames.get(i));
                                if (data != null) {
                                    Dataset clone = DataTool.copyDataset(data, null, false);
                                    double[] x = data.getXPoints();
                                    double[] y = data.getYPoints();
                                    clone.append(x, y);
                                    String name = data.getYColumnName();
                                    String postfix = "_" + ToolsRes.getString("DataTool.Clone.Subscript");
                                    int n = name.indexOf(postfix);
                                    if (n > -1) {
                                        name = name.substring(0, n);
                                    }
                                    name = String.valueOf(name) + postfix;
                                    name = (this).DataToolTable.this.dataToolTab.getUniqueYColumnName(clone, name, false);
                                    clone.setXYColumnNames(data.getXColumnName(), name);
                                    ArrayList<DataColumn> loadedColumns = (this).DataToolTable.this.dataToolTab.loadData(clone, false);
                                    if (!loadedColumns.isEmpty()) {
                                        for (DataColumn next : loadedColumns) {
                                            next.deletable = true;
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                    });
                    DataToolTable.this.popup.add(DataToolTable.this.cloneColumnsItem);
                    DataToolTable.this.popup.addSeparator();
                    text = ToolsRes.getString("DataToolTable.Popup.MenuItem.NumberFormat");
                    DataToolTable.this.numberFormatItem = new JMenuItem(text);
                    DataToolTable.this.numberFormatItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int colCount = DataToolTable.this.getColumnCount();
                            String[] names = new String[colCount - 1];
                            int labelCol = DataToolTable.this.convertColumnIndexToView(0);
                            int index = 0;
                            int i = 0;
                            while (i < colCount) {
                                if (i != labelCol) {
                                    String name;
                                    names[index] = name = DataToolTable.this.getColumnName(i);
                                    ++index;
                                }
                                ++i;
                            }
                            ArrayList<String> selected = DataToolTable.this.getSelectedColumnNames();
                            String[] selectedNames = new String[selected.size()];
                            int i2 = 0;
                            while (i2 < selectedNames.length) {
                                selectedNames[i2] = selected.get(i2);
                                ++i2;
                            }
                            DataTable.NumberFormatDialog dialog = DataToolTable.this.getFormatDialog(names, selectedNames);
                            dialog.setVisible(true);
                            (this).DataToolTable.this.dataToolTab.refreshPlot();
                        }
                    });
                    DataToolTable.this.popup.add(DataToolTable.this.numberFormatItem);
                    FontSizer.setFonts(DataToolTable.this.popup, FontSizer.getLevel());
                    DataToolTable.this.popup.show(DataToolTable.this.getTableHeader(), e.getX(), e.getY() + 8);
                } else if (e.getClickCount() == 2) {
                    if (col == labelCol) {
                        DataToolTable.this.selectAllCells();
                    } else {
                        DataToolTable.this.setRowSelectionInterval(0, DataToolTable.this.getRowCount() - 1);
                        DataToolTable.this.setColumnSelectionInterval(col, col);
                        DataToolTable.this.leadCol = col;
                    }
                    DataToolTable.this.sort(0);
                } else if (col == labelCol && DataToolTable.this.getSortedColumn() == col) {
                    if (col != DataToolTable.this.prevSortedColumn) {
                        rows = DataToolTable.this.getSelectedModelRows();
                        DataToolTable.this.setSelectedModelRows(rows);
                        DataToolTable.this.prevSortedColumn = col;
                    }
                } else if (e.isControlDown()) {
                    if (col != labelCol && DataToolTable.this.isColumnSelected(col)) {
                        DataToolTable.this.removeColumnSelectionInterval(col, col);
                    } else {
                        if (!DataToolTable.this.selectedRows.isEmpty()) {
                            DataToolTable.this.addColumnSelectionInterval(col, col);
                        }
                        if (DataToolTable.this.getSelectedColumns().length == 1) {
                            DataToolTable.this.leadCol = col;
                        }
                    }
                } else if (e.isShiftDown() && !DataToolTable.this.selectedRows.isEmpty()) {
                    if (DataToolTable.this.leadCol < DataToolTable.this.getColumnCount()) {
                        DataToolTable.this.setColumnSelectionInterval(col, DataToolTable.this.leadCol);
                    }
                } else if (col != DataToolTable.this.prevSortedColumn) {
                    rows = DataToolTable.this.getSelectedModelRows();
                    DataToolTable.this.setSelectedModelRows(rows);
                    DataToolTable.this.prevSortedColumn = col;
                }
                DataToolTable.this.getSelectedData();
                DataToolTable.this.addColumnSelectionInterval(labelCol, labelCol);
                DataToolTable.this.selectedColumns.clear();
                int[] selected = DataToolTable.this.getSelectedColumns();
                int i = 0;
                while (i < selected.length) {
                    if (selected[i] != labelCol) {
                        int modelCol = DataToolTable.this.convertColumnIndexToModel(selected[i]);
                        DataToolTable.this.selectedColumns.add(modelCol);
                    }
                    ++i;
                }
                if (DataToolTable.this.selectedColumns.isEmpty()) {
                    DataToolTable.this.clearSelection();
                }
            }
        });
        this.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!DataToolTable.this.popup.isVisible()) {
                    int row = DataToolTable.this.rowAtPoint(e.getPoint());
                    int col = DataToolTable.this.columnAtPoint(e.getPoint());
                    int labelCol = DataToolTable.this.convertColumnIndexToView(0);
                    DataToolTable.this.mouseRow = row;
                    DataToolTable.this.mouseCol = col;
                    DataToolTable.this.dataRenderer.showFocus = col == labelCol;
                    DataToolTable.this.repaint();
                    if (col == labelCol) {
                        DataToolTable.this.dataRenderer.showFocus = true;
                        DataToolTable.this.setToolTipText(ToolsRes.getString("DataToolTable.Deselect.Tooltip"));
                    } else {
                        Object obj = DataToolTable.this.getValueAt(row, col);
                        String name = DataToolTable.this.getColumnName(col);
                        DataToolTable.this.setToolTipText(String.valueOf(name) + " = " + obj);
                    }
                }
                DataToolTable.this.requestFocusInWindow();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int row;
                int col = DataToolTable.this.columnAtPoint(e.getPoint());
                DataToolTable.this.mouseRow = row = DataToolTable.this.rowAtPoint(e.getPoint());
                DataToolTable.this.mouseCol = col;
                int labelCol = DataToolTable.this.convertColumnIndexToView(0);
                if (col == labelCol) {
                    if (DataToolTable.this.leadRow < DataToolTable.this.getRowCount()) {
                        DataToolTable.this.setRowSelectionInterval(DataToolTable.this.leadRow, row);
                    }
                    DataToolTable.this.setColumnSelectionInterval(DataToolTable.this.getColumnCount() - 1, 0);
                }
                DataToolTable.this.dataRenderer.showFocus = false;
                DataToolTable.this.dataToolTab.setSelectedData(DataToolTable.this.getSelectedData());
                DataToolTable.this.dataToolTab.plot.repaint();
            }
        });
        this.tableMouseListener = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (!DataToolTable.this.popup.isVisible()) {
                    DataToolTable.this.mouseRow = -1;
                    DataToolTable.this.dataRenderer.showFocus = true;
                    DataToolTable.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int col = DataToolTable.this.columnAtPoint(e.getPoint());
                int row = DataToolTable.this.rowAtPoint(e.getPoint());
                int labelCol = DataToolTable.this.convertColumnIndexToView(0);
                if (OSPRuntime.isPopupTrigger(e)) {
                    DataToolTable.this.editor.stopCellEditing();
                    if (col == labelCol) {
                        if (!DataToolTable.this.isRowSelected(row)) {
                            DataToolTable.this.setRowSelectionInterval(row, row);
                        }
                        DataToolTable.this.setColumnSelectionInterval(0, DataToolTable.this.getColumnCount() - 1);
                    } else if (!DataToolTable.this.isCellSelected(row, col)) {
                        DataToolTable.this.setRowSelectionInterval(row, row);
                        DataToolTable.this.setColumnSelectionInterval(col, col);
                        DataToolTable.this.leadCol = col;
                        DataToolTable.this.leadRow = row;
                    }
                    DataToolTable.this.repaint();
                    DataToolTable.this.getPasteDataAction.actionPerformed(null);
                    final int[] rows = DataToolTable.this.getSelectedModelRows();
                    boolean isEmptyCells = true;
                    int[] selectedRows = DataToolTable.this.getSelectedRows();
                    ArrayList<String> selectedColumns = DataToolTable.this.getSelectedColumnNames();
                    int i = 0;
                    while (i < selectedRows.length) {
                        if (!DataToolTable.this.isEmptyCells(selectedRows[i], selectedColumns)) {
                            isEmptyCells = false;
                            break;
                        }
                        ++i;
                    }
                    DataToolTable.this.popup.removeAll();
                    if (col != labelCol) {
                        int index = DataToolTable.this.convertColumnIndexToModel(col) - 1;
                        Dataset data = DataToolTable.this.dataManager.getDataset(index);
                        DataToolTable.this.mouseRow = row;
                        DataToolTable.this.mouseCol = col;
                        DataToolTable.this.repaint();
                        String text = ToolsRes.getString("DataToolTable.Popup.MenuItem.SelectAll");
                        DataToolTable.this.selectAllItem = new JMenuItem(text);
                        DataToolTable.this.selectAllItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DataToolTable.this.selectAllCells();
                            }
                        });
                        DataToolTable.this.popup.add(DataToolTable.this.selectAllItem);
                        text = ToolsRes.getString("DataToolTable.Popup.MenuItem.SelectNone");
                        DataToolTable.this.selectNoneItem = new JMenuItem(text);
                        DataToolTable.this.selectNoneItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DataToolTable.this.clearSelection();
                            }
                        });
                        DataToolTable.this.popup.add(DataToolTable.this.selectNoneItem);
                        DataToolTable.this.popup.addSeparator();
                        if (DataToolTable.this.dataToolTab.isUserEditable() && !(data instanceof DataFunction)) {
                            text = ToolsRes.getString("DataToolTable.Popup.MenuItem.InsertCells");
                            DataToolTable.this.insertCellsItem = new JMenuItem(text);
                            DataToolTable.this.insertCellsItem.setActionCommand(String.valueOf(col));
                            DataToolTable.this.insertCellsItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    HashMap<String, double[]> emptyRow = new HashMap<String, double[]>();
                                    Iterator<String> it = DataToolTable.this.getSelectedColumnNames().iterator();
                                    while (it.hasNext()) {
                                        emptyRow.put(it.next(), null);
                                    }
                                    DataToolTable.this.insertCells(rows, emptyRow);
                                    TableEdit edit = new TableEdit(3, null, rows, emptyRow);
                                    (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                                    DataToolTable.this.refreshUndoItems();
                                }
                            });
                            DataToolTable.this.popup.add(DataToolTable.this.insertCellsItem);
                            if (DataToolTable.this.pasteData != null) {
                                text = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteInsertCells");
                                DataToolTable.this.pasteInsertCellsItem = new JMenuItem(text);
                                DataToolTable.this.pasteInsertCellsItem.setActionCommand(String.valueOf(col));
                                DataToolTable.this.pasteInsertCellsItem.addActionListener(DataToolTable.this.pasteInsertCellsAction);
                                DataToolTable.this.popup.add(DataToolTable.this.pasteInsertCellsItem);
                            }
                            text = ToolsRes.getString("DataToolTable.Popup.MenuItem.DeleteCells");
                            DataToolTable.this.deleteCellsItem = new JMenuItem(text);
                            DataToolTable.this.deleteCellsItem.setActionCommand(String.valueOf(col));
                            DataToolTable.this.deleteCellsItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Iterator<String> it = DataToolTable.this.getSelectedColumnNames().iterator();
                                    while (it.hasNext()) {
                                        (this).DataToolTable.this.pasteValues.put(it.next(), null);
                                    }
                                    HashMap<String, double[]> prev = DataToolTable.this.deleteCells(rows, (this).DataToolTable.this.pasteValues);
                                    TableEdit edit = new TableEdit(4, null, rows, prev);
                                    (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                                    DataToolTable.this.refreshUndoItems();
                                }
                            });
                            DataToolTable.this.popup.add(DataToolTable.this.deleteCellsItem);
                        }
                        if (!isEmptyCells || DataToolTable.this.pasteData != null) {
                            if (DataToolTable.this.popup.getComponentCount() > 0 && !DataToolTable.this.dataToolTab.originShiftEnabled) {
                                DataToolTable.this.popup.addSeparator();
                            }
                            if (!isEmptyCells) {
                                text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CopyCells");
                                DataToolTable.this.copyCellsItem = new JMenuItem(text);
                                DataToolTable.this.copyCellsItem.setActionCommand(String.valueOf(col));
                                DataToolTable.this.copyCellsItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        (this).DataToolTable.this.dataToolTab.copyTableDataToClipboard();
                                    }
                                });
                                DataToolTable.this.popup.add(DataToolTable.this.copyCellsItem);
                                if (DataToolTable.this.dataToolTab.isUserEditable() && !(data instanceof DataFunction)) {
                                    text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CutCells");
                                    DataToolTable.this.cutCellsItem = new JMenuItem(text);
                                    DataToolTable.this.cutCellsItem.setActionCommand(String.valueOf(col));
                                    DataToolTable.this.cutCellsItem.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            (this).DataToolTable.this.copyCellsItem.doClick();
                                            (this).DataToolTable.this.clearCellsAction.actionPerformed(e);
                                        }
                                    });
                                    DataToolTable.this.popup.add(DataToolTable.this.cutCellsItem);
                                    text = ToolsRes.getString("DataToolTable.Popup.MenuItem.DeleteContents");
                                    DataToolTable.this.clearContentsItem = new JMenuItem(text);
                                    DataToolTable.this.clearContentsItem.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            (this).DataToolTable.this.clearCellsAction.actionPerformed(null);
                                        }
                                    });
                                    DataToolTable.this.popup.add(DataToolTable.this.clearContentsItem);
                                }
                            }
                            if (DataToolTable.this.dataToolTab.isUserEditable() && DataToolTable.this.pasteData != null) {
                                text = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteCells");
                                DataToolTable.this.pasteCellsItem = new JMenuItem(text);
                                DataToolTable.this.pasteCellsItem.setActionCommand(String.valueOf(col));
                                DataToolTable.this.pasteCellsItem.addActionListener(DataToolTable.this.pasteCellsAction);
                                DataToolTable.this.popup.add(DataToolTable.this.pasteCellsItem);
                            }
                        }
                    } else {
                        DataToolTable.this.leadRow = row;
                        if (DataToolTable.this.dataToolTab.isUserEditable()) {
                            boolean hasRows;
                            String text = ToolsRes.getString("DataToolTable.Popup.MenuItem.InsertRows");
                            DataToolTable.this.insertRowItem = new JMenuItem(text);
                            DataToolTable.this.insertRowItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    HashMap<String, double[]> prev = DataToolTable.this.insertRows(rows, null);
                                    TableEdit edit = new TableEdit(6, null, rows, prev);
                                    (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                                    DataToolTable.this.refreshUndoItems();
                                }
                            });
                            DataToolTable.this.popup.add(DataToolTable.this.insertRowItem);
                            boolean bl = hasRows = !DataToolTable.this.pasteValues.isEmpty();
                            if (hasRows) {
                                for (String next : DataToolTable.this.pasteValues.keySet()) {
                                    boolean bl2 = hasRows = hasRows && DataToolTable.this.pasteData.getDatasetIndex(next) > -1;
                                }
                            }
                            if (hasRows) {
                                text = ToolsRes.getString("DataToolTable.Popup.MenuItem.PasteInsertRows");
                                DataToolTable.this.pasteRowsItem = new JMenuItem(text);
                                DataToolTable.this.pasteRowsItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        if (rows.length != 1 && (this).DataToolTable.this.pasteH != rows.length) {
                                            (this).DataToolTable.this.cantPasteRowsAction.actionPerformed(e);
                                            return;
                                        }
                                        int[] pasteRows = new int[(this).DataToolTable.this.pasteH];
                                        if ((this).DataToolTable.this.pasteH == rows.length) {
                                            pasteRows = rows;
                                        } else if (rows.length == 1) {
                                            pasteRows[0] = rows[0];
                                            int i = 1;
                                            while (i < (this).DataToolTable.this.pasteH) {
                                                pasteRows[i] = rows[0] + i;
                                                ++i;
                                            }
                                        }
                                        DataToolTable.this.insertRows(pasteRows, (this).DataToolTable.this.pasteValues);
                                        TableEdit edit = new TableEdit(6, null, pasteRows, (this).DataToolTable.this.pasteValues);
                                        (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                                        DataToolTable.this.refreshUndoItems();
                                    }
                                });
                                DataToolTable.this.popup.add(DataToolTable.this.pasteRowsItem);
                            }
                            DataToolTable.this.popup.addSeparator();
                        }
                        String text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CopyRows");
                        DataToolTable.this.copyRowsItem = new JMenuItem(text);
                        DataToolTable.this.copyRowsItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                OSPLog.finest("copying rows");
                                String data = (this).DataToolTable.this.dataToolTab.getSelectedTableData();
                                DataTool.copy(data);
                            }
                        });
                        DataToolTable.this.popup.add(DataToolTable.this.copyRowsItem);
                        if (DataToolTable.this.dataToolTab.isUserEditable()) {
                            text = ToolsRes.getString("DataToolTable.Popup.MenuItem.CutRows");
                            DataToolTable.this.cutRowsItem = new JMenuItem(text);
                            DataToolTable.this.cutRowsItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    (this).DataToolTable.this.copyRowsItem.doClick();
                                    int[] rows = DataToolTable.this.getSelectedModelRows();
                                    HashMap<String, double[]> removed = DataToolTable.this.deleteRows(rows);
                                    TableEdit edit = new TableEdit(7, null, rows, removed);
                                    (this).DataToolTable.this.dataToolTab.undoSupport.postEdit(edit);
                                    DataToolTable.this.refreshUndoItems();
                                }
                            });
                            DataToolTable.this.popup.add(DataToolTable.this.cutRowsItem);
                            DataToolTable.this.popup.addSeparator();
                            text = ToolsRes.getString("DataToolTable.Popup.MenuItem.AddEndRow");
                            DataToolTable.this.addEndRowItem = new JMenuItem(text);
                            DataToolTable.this.addEndRowItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    DataToolTable.this.insertRows(new int[]{DataToolTable.this.getRowCount()}, null);
                                }
                            });
                            DataToolTable.this.popup.add(DataToolTable.this.addEndRowItem);
                            if (DataToolTable.this.isEmptyRow(DataToolTable.this.getRowCount() - 1)) {
                                text = ToolsRes.getString("DataToolTable.Popup.MenuItem.TrimRows");
                                DataToolTable.this.trimRowsItem = new JMenuItem(text);
                                DataToolTable.this.trimRowsItem.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        DataToolTable.this.trimEmptyRows(0);
                                    }
                                });
                                DataToolTable.this.popup.add(DataToolTable.this.trimRowsItem);
                            }
                        }
                    }
                    FontSizer.setFonts(DataToolTable.this.popup, FontSizer.getLevel());
                    DataToolTable.this.popup.show(DataToolTable.this, e.getX(), e.getY() + 8);
                    return;
                }
                DataToolTable.this.dataRenderer.showFocus = true;
                if (col == labelCol) {
                    if (e.getClickCount() == 2) {
                        DataToolTable.this.leadRow = row;
                        DataToolTable.this.setRowSelectionInterval(row, row);
                        DataToolTable.this.setColumnSelectionInterval(0, DataToolTable.this.getColumnCount() - 1);
                    } else if (e.isShiftDown() && DataToolTable.this.leadRow < DataToolTable.this.getRowCount()) {
                        DataToolTable.this.setRowSelectionInterval(DataToolTable.this.leadRow, row);
                        for (int i : DataToolTable.this.selectedColumns) {
                            int n = DataToolTable.this.convertColumnIndexToView(i);
                            DataToolTable.this.addColumnSelectionInterval(n, n);
                        }
                    } else if (!e.isControlDown() && !e.isShiftDown()) {
                        DataToolTable.this.clearSelection();
                        DataToolTable.this.leadRow = 0;
                        DataToolTable.this.leadCol = 1;
                    }
                } else if (!e.isControlDown() && !e.isShiftDown()) {
                    DataToolTable.this.leadRow = row;
                    DataToolTable.this.leadCol = col;
                }
                DataToolTable.this.getSelectedData();
                DataToolTable.this.dataToolTab.plot.repaint();
                DataToolTable.this.addColumnSelectionInterval(labelCol, labelCol);
                DataToolTable.this.selectedColumns.clear();
                int[] selected = DataToolTable.this.getSelectedColumns();
                int i = 0;
                while (i < selected.length) {
                    if (selected[i] != labelCol) {
                        int modelCol = DataToolTable.this.convertColumnIndexToModel(selected[i]);
                        DataToolTable.this.selectedColumns.add(modelCol);
                    }
                    ++i;
                }
                if (DataToolTable.this.selectedColumns.isEmpty() || DataToolTable.this.selectedRows.isEmpty()) {
                    DataToolTable.this.clearSelection();
                }
            }
        };
        this.addMouseListener(this.tableMouseListener);
        InputMap im = this.getInputMap(1);
        AbstractAction enterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.this.editCellAt(DataToolTable.this.focusRow, DataToolTable.this.focusCol, e);
                DataToolTable.this.editor.field.requestFocus();
            }
        };
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.getActionMap().put(im.get(enter), enterAction);
        AbstractAction copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.this.dataToolTab.copyTableDataToClipboard();
            }
        };
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        KeyStroke copy = KeyStroke.getKeyStroke(67, mask);
        this.getActionMap().put(im.get(copy), copyAction);
        AbstractAction pasteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolTable.this.getPasteDataAction.actionPerformed(e);
                DataToolTable.this.pasteCellsAction.actionPerformed(e);
            }
        };
        KeyStroke paste = KeyStroke.getKeyStroke(86, mask);
        this.getActionMap().put(im.get(paste), pasteAction);
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
        im.put(delete, this.clearCellsAction);
        this.getActionMap().put(im.get(delete), this.clearCellsAction);
    }

    protected WorkingDataset getWorkingData(String colName) {
        int labelCol;
        String xName;
        Dataset xSource;
        if (colName == null) {
            return null;
        }
        WorkingDataset working = this.workingMap.get(colName);
        if (working == null && this.dataToolTab.originShiftEnabled) {
            working = this.workingMap.get(colName.substring(0, colName.length() - "'".length()));
        }
        if (working == null) {
            Dataset ySource = this.getDataset(colName);
            if (ySource == null) {
                return null;
            }
            working = new WorkingDataset(ySource);
            if (ySource.getMarkerShape() == 0) {
                ySource.setMarkerShape(2);
                working.setMarkersVisible(false);
            }
            this.workingMap.put(colName, working);
        }
        if ((xSource = this.getDataset(xName = this.getColumnName((labelCol = this.convertColumnIndexToView(0)) == 0 ? 1 : 0))) == null) {
            return null;
        }
        working.setXSource(xSource);
        Dataset ySource = working.getYSource();
        working.setMarkerColor(ySource.getFillColor(), ySource.getEdgeColor());
        working.setMarkerSize(ySource.getMarkerSize());
        working.markerType = ySource.getMarkerShape();
        working.setLineColor(ySource.getLineColor());
        working.setConnected(ySource.isConnected());
        return working;
    }

    protected WorkingDataset getWorkingData() {
        int n = this.dataManager.getDatasets().size();
        if (n < 2) {
            this.workingData = null;
        } else {
            int labelCol = this.convertColumnIndexToView(0);
            int yCol = labelCol < 2 ? 2 : 1;
            String yName = this.getColumnName(yCol);
            this.workingData = this.getWorkingData(yName);
        }
        return this.workingData;
    }

    protected void removeWorkingData(String colName) {
        if (colName == null) {
            return;
        }
        this.workingMap.remove(colName);
        this.setFormatPattern(colName, null);
        this.refreshTable();
    }

    protected void deleteSelectedColumns() {
        ArrayList<String> colNames = this.getSelectedColumnNames();
        int[] cols = this.getSelectedColumns();
        int i = colNames.size() - 1;
        while (i > -1) {
            Dataset deleted;
            String name = colNames.get(i);
            Dataset target = this.getDataset(name);
            if (this.dataToolTab.isDeletable(target) && (deleted = this.deleteColumn(name)) != null) {
                Integer colInt = new Integer(cols[i]);
                TableEdit edit = new TableEdit(2, name, colInt, deleted);
                this.dataToolTab.undoSupport.postEdit(edit);
            }
            --i;
        }
        this.refreshUndoItems();
    }

    protected void clearWorkingData() {
        Iterator<String> it = this.workingMap.keySet().iterator();
        while (it.hasNext()) {
            String colName = it.next().toString();
            this.setFormatPattern(colName, null);
        }
        this.workingMap.clear();
        this.refreshTable();
    }

    protected Dataset getDataset(String colName) {
        if (colName == null) {
            return null;
        }
        int i = this.dataManager.getDatasetIndex(colName);
        if (i == -1 && colName.endsWith("'")) {
            i = this.dataManager.getDatasetIndex(colName.substring(0, colName.length() - "'".length()));
        }
        if (i > -1) {
            return this.dataManager.getDataset(i);
        }
        for (Dataset next : this.dataManager.getDatasets()) {
            if (next.getYColumnName().equals(colName)) {
                return next;
            }
            if (!colName.endsWith("'") || !next.getYColumnName().equals(colName.substring(0, colName.length() - "'".length()))) continue;
            return next;
        }
        return null;
    }

    protected HighlightableDataset getSelectedData() {
        int i;
        double[] yValues;
        double[] xValues;
        if (this.getWorkingData() == null) {
            return null;
        }
        double[] x = this.workingData.getXSource().getYPoints();
        double[] y = this.workingData.getYSource().getYPoints();
        int workingIndex = 0;
        int i2 = 0;
        while (i2 < x.length) {
            if (!Double.isNaN(x[i2])) {
                this.workingRows.put(new Integer(workingIndex++), new Integer(i2));
            }
            ++i2;
        }
        this.workingData.clearHighlights();
        int labelCol = this.convertColumnIndexToView(0);
        int xCol = labelCol == 0 ? 1 : 0;
        int yCol = labelCol < 2 ? 2 : 1;
        int[] cols = this.getSelectedColumns();
        boolean colSelected = false;
        int k = 0;
        while (k < cols.length) {
            colSelected = colSelected || cols[k] == xCol || cols[k] == yCol;
            ++k;
        }
        if (!colSelected || this.getSelectedRowCount() == 0) {
            xValues = x;
            yValues = new double[x.length];
            i = 0;
            while (i < yValues.length) {
                yValues[i] = i < y.length ? y[i] : Double.NaN;
                ++i;
            }
        } else {
            xValues = new double[this.selectedRows.size()];
            yValues = new double[this.selectedRows.size()];
            i = 0;
            int index = 0;
            workingIndex = -1;
            for (int row : this.selectedRows) {
                xValues[i] = row >= x.length ? Double.NaN : x[row];
                yValues[i] = row >= y.length ? Double.NaN : y[row];
                ++i;
                while (index <= row) {
                    if (index < x.length && !Double.isNaN(x[index])) {
                        ++workingIndex;
                    }
                    ++index;
                }
                if (workingIndex <= -1 || index > x.length || Double.isNaN(x[index - 1])) continue;
                this.workingData.setHighlighted(workingIndex, true);
            }
        }
        DataTool.copyDataset(this.workingData, this.selectedData, false);
        this.selectedData.clear();
        this.selectedData.append(xValues, yValues);
        return this.selectedData;
    }

    protected int getModelRow(int row) {
        int labelCol = this.convertColumnIndexToView(0);
        return (Integer)this.getValueAt(row, labelCol);
    }

    protected int getViewRow(int row) {
        int col = this.convertColumnIndexToView(0);
        int i = 0;
        while (i < this.getRowCount()) {
            if (row == (Integer)this.getValueAt(i, col)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int[] getSelectedModelRows() {
        Integer[] a = this.selectedRows.toArray(new Integer[0]);
        int[] rows = new int[a.length];
        int i = 0;
        while (i < a.length) {
            rows[i] = a[i];
            ++i;
        }
        return rows;
    }

    protected void setSelectedModelRows(int[] rows) {
        if (this.getRowCount() < 1) {
            return;
        }
        this.removeRowSelectionInterval(0, this.getRowCount() - 1);
        TreeSet<Integer> viewRows = new TreeSet<Integer>();
        int i = 0;
        while (i < rows.length) {
            int row = this.getViewRow(rows[i]);
            if (row > -1) {
                viewRows.add(row);
            }
            ++i;
        }
        int start = -1;
        int end = -1;
        Iterator iterator = viewRows.iterator();
        while (iterator.hasNext()) {
            int next = (Integer)iterator.next();
            if (start == -1) {
                end = start = next;
                continue;
            }
            if (next == end + 1) {
                end = next;
                continue;
            }
            this.addRowSelectionInterval(start, end);
            start = next;
            end = next;
        }
        if (start > -1) {
            this.addRowSelectionInterval(start, end);
        }
    }

    protected ArrayList<String> getSelectedColumnNames() {
        int[] columns = this.getSelectedColumns();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < columns.length) {
            int index = this.convertColumnIndexToModel(columns[i]) - 1;
            if (index >= 0) {
                String name = this.dataManager.getDataset(index).getYColumnName();
                names.add(name);
            }
            ++i;
        }
        return names;
    }

    protected void setSelectedColumnNames(Collection<String> names) {
        if (this.getColumnCount() < 1) {
            return;
        }
        this.removeColumnSelectionInterval(0, this.getColumnCount() - 1);
        for (String colName : names) {
            int index = this.dataManager.getDatasetIndex(colName);
            if (index == -1) continue;
            int col = this.convertColumnIndexToView(index + 1);
            this.addColumnSelectionInterval(col, col);
        }
    }

    protected void insertColumn(Dataset data, int col) {
        data.setXColumnVisible(false);
        ArrayList<Dataset> datasets = this.dataManager.getDatasets();
        int index = datasets.size();
        if (index == 0) {
            this.dataToolTab.originatorID = data.getID();
        }
        int dataModelCol = index + 1;
        int dataViewCol = index + 1;
        int[] rows = this.getSelectedModelRows();
        ArrayList<String> cols = this.getSelectedColumnNames();
        this.clearSelection();
        TableModel model = this.getModel();
        int len = model.getColumnCount();
        int[] modelColumns = new int[len + 1];
        modelColumns[col] = dataModelCol;
        int j = 0;
        while (j < model.getColumnCount()) {
            int modelCol = this.convertColumnIndexToModel(j);
            if (modelCol != dataModelCol) {
                int viewCol = j;
                if (j < dataViewCol) {
                    if (j >= col) {
                        ++viewCol;
                    }
                } else if (j <= col) {
                    --viewCol;
                }
                modelColumns[viewCol] = modelCol;
            }
            ++j;
        }
        if (data instanceof DataFunction) {
            FunctionTool tool = this.dataToolTab.getDataBuilder();
            FunctionPanel panel = tool.getPanel(this.dataToolTab.getName());
            String presentation = panel.undoManager.getPresentationName();
            if (panel.undoManager.canUndo() && presentation.equals("Deletion")) {
                panel.undoManager.undo();
            }
        } else {
            this.dataManager.addDataset(data);
            this.getWorkingData(data.getYColumnName());
        }
        DataToolTable.super.refreshTable();
        int i = 0;
        while (i < modelColumns.length) {
            int j2 = i;
            while (j2 < modelColumns.length) {
                if (this.convertColumnIndexToModel(j2) == modelColumns[i]) {
                    if (j2 == i) break;
                    this.moveColumn(j2, i);
                    break;
                }
                ++j2;
            }
            ++i;
        }
        if (rows.length == 0) {
            this.setRowSelectionInterval(0, this.getRowCount() - 1);
        } else {
            this.setSelectedModelRows(rows);
        }
        cols.add(data.getYColumnName());
        this.setSelectedColumnNames(cols);
        this.refreshTable();
        this.refreshDataFunctions();
        this.dataToolTab.statsTable.refreshStatistics();
        this.dataToolTab.propsTable.refreshTable();
        this.dataToolTab.refreshGUI();
        this.dataToolTab.refreshPlot();
        this.dataToolTab.tabChanged(true);
        this.refreshUndoItems();
    }

    protected Dataset deleteColumn(String colName) {
        boolean sortColDeleted;
        int index = this.dataManager.getDatasetIndex(colName);
        int deletedCol = this.convertColumnIndexToView(index + 1);
        Dataset data = this.dataManager.getDataset(index);
        boolean bl = sortColDeleted = this.getSortedColumn() == index + 1;
        if (sortColDeleted) {
            this.sort(0);
        }
        int[] rows = this.getSelectedModelRows();
        ArrayList<String> cols = this.getSelectedColumnNames();
        this.clearSelection();
        TableModel model = this.getModel();
        int[] modelColumns = new int[model.getColumnCount() - 1];
        int viewCol = -1;
        int j = 0;
        while (j < model.getColumnCount()) {
            if (j != deletedCol) {
                ++viewCol;
                int modelCol = this.convertColumnIndexToModel(j);
                if (modelCol > index + 1) {
                    // empty if block
                }
                modelColumns[viewCol] = --modelCol;
            }
            ++j;
        }
        if (data instanceof DataFunction) {
            FunctionTool tool = this.dataToolTab.getDataBuilder();
            FunctionPanel panel = tool.getPanel(this.dataToolTab.getName());
            panel.functionEditor.removeObject(data, true);
        } else {
            this.dataManager.removeDataset(index);
            this.workingMap.remove(colName);
        }
        if (this.dataManager.getDatasets().isEmpty()) {
            this.dataToolTab.originatorID = 0;
            this.tableChanged(new TableModelEvent(this.getModel(), -1));
            this.dataToolTab.refreshGUI();
        } else {
            DataToolTable.super.refreshTable();
            int i = 0;
            while (i < modelColumns.length) {
                int j2 = i;
                while (j2 < modelColumns.length) {
                    if (this.convertColumnIndexToModel(j2) == modelColumns[i]) {
                        if (j2 == i) break;
                        this.moveColumn(j2, i);
                        break;
                    }
                    ++j2;
                }
                ++i;
            }
            if (cols.size() != 1 || !cols.contains(colName)) {
                this.setSelectedModelRows(rows);
                this.setSelectedColumnNames(cols);
            }
        }
        this.refreshTable();
        this.refreshDataFunctions();
        this.dataToolTab.refreshPlot();
        this.dataToolTab.propsTable.refreshTable();
        this.dataToolTab.refreshGUI();
        this.dataToolTab.tabChanged(true);
        this.refreshUndoItems();
        this.dataToolTab.varPopup = null;
        return data;
    }

    protected HashMap<String, double[]> insertCells(int[] rows, HashMap<String, double[]> values) {
        int count = this.getRowCount();
        int[] fillRows = new int[rows.length];
        int i = 0;
        while (i < rows.length) {
            fillRows[i] = count + i;
            ++i;
        }
        int[] cols = new int[values.keySet().size()];
        int k = 0;
        HashMap<String, double[]> inserted = new HashMap<String, double[]>();
        for (Dataset next : this.dataManager.getDatasets()) {
            String colName = next.getYColumnName();
            if (values.keySet().contains(colName)) {
                double[] vals = values.get(colName);
                vals = this.insertPoints(next, rows, vals);
                inserted.put(colName, vals);
                int index = this.dataManager.getDatasetIndex(colName);
                cols[k++] = this.convertColumnIndexToView(index + 1);
                continue;
            }
            this.insertPoints(next, fillRows, null);
        }
        this.refreshDataFunctions();
        this.refreshTable();
        this.setSelectedModelRows(rows);
        this.setSelectedColumnNames(values.keySet());
        this.dataToolTab.refreshPlot();
        this.refreshUndoItems();
        return inserted;
    }

    protected HashMap<String, double[]> deleteCells(int[] rows, HashMap<String, double[]> values) {
        int startFillRow = this.getRowCount() - rows.length;
        HashMap<String, double[]> deleted = new HashMap<String, double[]>();
        for (String colName : values.keySet()) {
            int index = this.dataManager.getDatasetIndex(colName);
            Dataset dataset = this.dataManager.getDataset(index);
            double[] removed = this.deletePoints(dataset, rows);
            deleted.put(colName, removed);
            int[] fillRows = new int[rows.length];
            int i = 0;
            while (i < rows.length) {
                fillRows[i] = startFillRow + i;
                ++i;
            }
            this.insertPoints(dataset, fillRows, null);
        }
        this.trimEmptyRows(startFillRow - 1);
        this.refreshDataFunctions();
        this.refreshTable();
        this.setSelectedColumnNames(values.keySet());
        this.setSelectedModelRows(rows);
        this.dataToolTab.refreshPlot();
        this.refreshUndoItems();
        return deleted;
    }

    protected HashMap<String, double[]> replaceCells(int[] rows, HashMap<String, double[]> values) {
        int[] cols = new int[values.keySet().size()];
        HashMap<String, double[]> replaced = new HashMap<String, double[]>();
        Iterator<String> it = values.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String colName = it.next();
            double[] vals = values.get(colName);
            int index = this.dataManager.getDatasetIndex(colName);
            Dataset data = this.dataManager.getDataset(index);
            double[] pts = this.replacePoints(data, rows, vals);
            replaced.put(colName, pts);
            cols[i++] = this.convertColumnIndexToView(index + 1);
        }
        this.refreshDataFunctions();
        this.refreshTable();
        this.setSelectedModelRows(rows);
        this.setSelectedColumnNames(values.keySet());
        this.refreshUndoItems();
        this.dataToolTab.refreshPlot();
        return replaced;
    }

    protected HashMap<String, double[]> insertRows(int[] rows, HashMap<String, double[]> values) {
        if (values == null) {
            values = new HashMap();
        }
        ArrayList<Dataset> datasets = this.dataManager.getDatasets();
        int i = 0;
        while (i < datasets.size()) {
            Dataset next = datasets.get(i);
            String name = next.getYColumnName();
            if (!values.keySet().contains(name)) {
                values.put(name, null);
            }
            ++i;
        }
        values = this.insertCells(rows, values);
        int endRow = this.getModelRow(this.getRowCount() - 1);
        int i2 = 0;
        while (i2 < rows.length) {
            if (endRow == rows[i2]) {
                Rectangle rect = this.getVisibleRect();
                rect.y = this.getSize().height - rect.height + this.getRowHeight();
                this.scrollRectToVisible(rect);
                break;
            }
            ++i2;
        }
        return values;
    }

    protected HashMap<String, double[]> deleteRows(int[] rows) {
        HashMap<String, double[]> removed = new HashMap<String, double[]>();
        for (Dataset next : this.dataManager.getDatasets()) {
            double[] cells = this.deletePoints(next, rows);
            removed.put(next.getYColumnName(), cells);
        }
        this.refreshTable();
        this.refreshDataFunctions();
        this.clearSelection();
        this.setSelectedColumnNames(removed.keySet());
        this.setSelectedModelRows(rows);
        this.refreshUndoItems();
        this.dataToolTab.refreshPlot();
        return removed;
    }

    protected boolean isEmptyRow(int row) {
        boolean empty = true;
        for (Dataset data : this.dataManager.getDatasets()) {
            if (data instanceof DataFunction) continue;
            double[] y = data.getYPoints();
            if (row >= y.length) {
                return false;
            }
            boolean bl = empty = empty && Double.isNaN(y[row]);
        }
        return empty;
    }

    protected boolean isEmptyCells(int row, ArrayList<String> columnNames) {
        boolean empty = true;
        for (Dataset data : this.dataManager.getDatasets()) {
            String name = data.getYColumnName();
            if (data instanceof DataFunction || !columnNames.contains(name)) continue;
            double[] y = data.getYPoints();
            if (row >= y.length) {
                return false;
            }
            boolean bl = empty = empty && Double.isNaN(y[row]);
        }
        return empty;
    }

    protected int getXColumn() {
        if (this.getColumnCount() < 2) {
            return -1;
        }
        int labelCol = this.convertColumnIndexToView(0);
        return labelCol == 0 ? 1 : 0;
    }

    protected int getYColumn() {
        if (this.getColumnCount() < 3) {
            return -1;
        }
        int labelCol = this.convertColumnIndexToView(0);
        return labelCol < 2 ? 2 : 1;
    }

    protected double[] replacePoints(Dataset dataset, int[] rows, double[] vals) {
        double[] replaced = new double[rows.length];
        DataColumn column = null;
        boolean shifted = false;
        if (dataset instanceof DataColumn) {
            column = (DataColumn)dataset;
            shifted = column.isShifted();
            column.setShifted(false);
        }
        double[] x = dataset.getXPoints();
        int count = x.length;
        int i = 0;
        while (i < rows.length) {
            count = Math.max(count, rows[i] + 1);
            ++i;
        }
        while (count > x.length) {
            int[] row = new int[]{x.length};
            this.insertRows(row, null);
            x = dataset.getXPoints();
        }
        double[] y = dataset.getYPoints();
        int i2 = 0;
        while (i2 < rows.length) {
            replaced[i2] = y[rows[i2]];
            y[rows[i2]] = vals == null ? Double.NaN : vals[i2];
            ++i2;
        }
        dataset.clear();
        dataset.append(x, y);
        if (column != null) {
            column.setShifted(shifted);
        }
        this.dataToolTab.tabChanged(true);
        return replaced;
    }

    protected double[] insertPoints(Dataset dataset, int[] rows, double[] vals) {
        if (vals == null) {
            vals = new double[rows.length];
            int i = 0;
            while (i < vals.length) {
                vals[i] = Double.NaN;
                ++i;
            }
        }
        if (dataset instanceof DataFunction) {
            return vals;
        }
        double[] y = dataset.getYPoints();
        int i = 0;
        while (i < rows.length) {
            int n = y.length;
            double[] newy = new double[n + 1];
            System.arraycopy(y, 0, newy, 0, rows[i]);
            System.arraycopy(y, rows[i], newy, rows[i] + 1, n - rows[i]);
            newy[rows[i]] = vals[i];
            y = newy;
            ++i;
        }
        double[] x = DataTool.getRowArray(y.length);
        dataset.clear();
        dataset.append(x, y);
        this.dataToolTab.tabChanged(true);
        return vals;
    }

    protected double[] deletePoints(Dataset dataset, int[] rows) {
        double[] removed = new double[rows.length];
        if (dataset instanceof DataFunction) {
            return removed;
        }
        double[] y = dataset.getYPoints();
        int i = rows.length - 1;
        while (i > -1) {
            int n = y.length;
            double[] newy = new double[n - 1];
            System.arraycopy(y, rows[i], removed, i, 1);
            if (rows[i] > 0) {
                System.arraycopy(y, 0, newy, 0, rows[i]);
            }
            if (rows[i] < n - 1) {
                System.arraycopy(y, rows[i] + 1, newy, rows[i], n - rows[i] - 1);
            }
            y = newy;
            --i;
        }
        double[] x = DataTool.getRowArray(y.length);
        dataset.clear();
        dataset.append(x, y);
        this.dataToolTab.tabChanged(true);
        return removed;
    }

    protected void trimEmptyRows(int minSize) {
        this.clearSelection();
        int endRow = this.getRowCount() - 1;
        boolean empty = true;
        int[] rows = new int[1];
        while (empty && endRow > minSize) {
            empty = this.isEmptyRow(endRow);
            if (!empty) continue;
            rows[0] = endRow--;
            this.deleteRows(rows);
        }
        if (this.getSelectedRows().length == 0) {
            this.removeColumnSelectionInterval(0, this.getColumnCount() - 1);
        }
    }

    protected void clearSelectionIfEmptyEndRow() {
        if (this.getRowCount() < 2) {
            return;
        }
        int[] selectedRows = this.getSelectedRows();
        int endRow = this.getRowCount() - 1;
        if (selectedRows.length == 1 && selectedRows[0] == endRow && this.isEmptyRow(endRow)) {
            this.clearSelection();
        }
    }

    protected void showDataBuilder() {
        FunctionTool tool = this.dataToolTab.getDataBuilder();
        tool.setSelectedPanel(this.dataToolTab.getName());
        tool.setVisible(true);
    }

    protected void renameColumn(String oldName, String newName) {
        int index = this.dataManager.getDatasetIndex(oldName);
        Dataset data = this.dataManager.getDataset(index);
        data.setXYColumnNames(data.getXColumnName(), newName);
        this.refreshDataFunctions();
        this.dataToolTab.columnNameChanged(oldName, newName);
        this.refreshTable();
        this.refreshUndoItems();
    }

    protected void refreshUndoItems() {
        if (this.dataToolTab != null) {
            this.dataToolTab.refreshUndoItems();
        }
    }

    public void refreshDataFunctions() {
        for (Dataset next : this.dataManager.getDatasets()) {
            if (!(next instanceof DataFunction)) continue;
            ((DataFunction)next).refreshFunctionData();
        }
    }

    public void selectAllCells() {
        this.selectAll();
        this.requestFocusInWindow();
    }

    @Override
    public void clearSelection() {
        if (this.workingData != null) {
            this.workingData.clearHighlights();
        }
        if (this.selectedData != null) {
            this.selectedData.clearHighlights();
        }
        if (this.focusRow > -1 && this.focusRow < this.getRowCount() && this.focusCol > 0 && this.focusCol < this.getColumnCount()) {
            this.setRowSelectionInterval(this.focusRow, this.focusRow);
            this.setColumnSelectionInterval(this.focusCol, this.focusCol);
        }
        this.leadCol = 0;
        this.leadRow = 0;
        super.clearSelection();
        this.repaint();
    }

    @Override
    public void refreshTable() {
        int[] modelColumns = this.getModelColumnOrder();
        int[] rows = this.getSelectedModelRows();
        ArrayList<String> cols = this.getSelectedColumnNames();
        boolean noView = this.convertColumnIndexToView(0) == -1;
        super.refreshTable();
        if (noView) {
            return;
        }
        boolean changed = this.dataToolTab.tabChanged;
        this.setModelColumnOrder(modelColumns);
        this.dataToolTab.tabChanged(changed);
        this.sort(this.getSortedColumn());
        if (!cols.isEmpty()) {
            this.setSelectedColumnNames(cols);
        }
        if (rows.length > 0) {
            this.setSelectedModelRows(rows);
        }
    }

    @Override
    public DataTable.NumberFormatDialog getFormatDialog(String[] names, String[] selected) {
        int i = 0;
        while (i < names.length) {
            if (names[i].endsWith("'")) {
                names[i] = names[i].substring(0, names[i].length() - "'".length());
            }
            ++i;
        }
        return super.getFormatDialog(names, selected);
    }

    public int[] getModelColumnOrder() {
        int[] modelColumns = new int[this.getModel().getColumnCount()];
        int i = 0;
        while (i < modelColumns.length) {
            modelColumns[i] = this.convertColumnIndexToModel(i);
            ++i;
        }
        return modelColumns;
    }

    public void setModelColumnOrder(int[] modelColumns) {
        if (modelColumns == null) {
            return;
        }
        int i = 0;
        while (i < modelColumns.length) {
            int j = i;
            while (j < modelColumns.length) {
                if (this.convertColumnIndexToModel(j) == modelColumns[i]) {
                    if (j == i) break;
                    this.moveColumn(j, i);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public String[] getHiddenMarkers() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.getColumnCount()) {
            String name = this.getColumnName(i);
            WorkingDataset next = this.getWorkingData(name);
            if (next != null && !next.isMarkersVisible()) {
                list.add(name);
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public void hideMarkers(String[] hiddenColumns) {
        if (hiddenColumns == null) {
            return;
        }
        int i = 0;
        while (i < hiddenColumns.length) {
            String name = hiddenColumns[i];
            WorkingDataset next = this.getWorkingData(name);
            if (next != null) {
                next.setMarkersVisible(false);
            }
            ++i;
        }
    }

    public void setWorkingColumns(String xColName, String yColName) {
        int labelCol = this.convertColumnIndexToView(0);
        this.getColumnModel().moveColumn(labelCol, 0);
        TableModel model = this.getModel();
        int i = 1;
        while (i < model.getColumnCount()) {
            if (xColName.equals(this.getColumnName(i))) {
                this.getColumnModel().moveColumn(i, 1);
                break;
            }
            ++i;
        }
        i = 2;
        while (i < model.getColumnCount()) {
            if (yColName.equals(this.getColumnName(i))) {
                this.getColumnModel().moveColumn(i, 2);
                break;
            }
            ++i;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.labelRenderer != null) {
            Font labelFont = this.labelRenderer.getFont();
            labelFont = labelFont.deriveFont(font.getSize2D());
            this.labelRenderer.setFont(labelFont);
            this.headerRenderer.headerFont = labelFont;
            this.rowNumberRenderer.setFont(labelFont);
        }
        this.setRowHeight(font.getSize() + 4);
    }

    protected void setLabelColumnWidth(int w) {
        this.labelColumnWidth = w;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        TableCellRenderer renderer = super.getCellRenderer(row, col);
        if (renderer == this.rowNumberRenderer) {
            return this.labelRenderer;
        }
        this.dataRenderer.renderer = renderer;
        return this.dataRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        this.editor.setColumn(col);
        return this.editor;
    }

    protected int getMinimumTableWidth() {
        int n = this.getColumnCount() - 1;
        return this.labelColumnWidth + n * this.minimumDataColumnWidth;
    }

    class DataCellRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;
        boolean showFocus = false;
        Color unlockedBG = Color.WHITE;
        Color lockedBG = new Color(255, 220, 0, 30);

        DataCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c;
            int modelCol = DataToolTable.this.convertColumnIndexToModel(col);
            if ((hasFocus || isSelected) && modelCol > 0) {
                DataToolTable.this.focusRow = row;
                DataToolTable.this.focusCol = col;
            }
            if (DataToolTable.this.selectedBG == null) {
                c = this.renderer.getTableCellRendererComponent(table, value, true, false, row, col);
                DataToolTable.this.selectedBG = c.getBackground();
                DataToolTable.this.selectedFG = c.getForeground();
                DataToolTable.this.selectedHeaderFG = DataToolTable.this.selectedFG.darker();
                float[] hsb = Color.RGBtoHSB(DataToolTable.this.selectedBG.getRed(), DataToolTable.this.selectedBG.getGreen(), DataToolTable.this.selectedBG.getBlue(), null);
                hsb[2] = hsb[2] * 0.85f;
                int darker = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
                DataToolTable.this.selectedHeaderBG = new Color(darker);
            }
            if (!this.showFocus) {
                hasFocus = col == DataToolTable.this.mouseCol && row == DataToolTable.this.mouseRow;
            }
            c = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            Dataset data = DataToolTable.this.dataManager.getDataset(modelCol - 1);
            if (!isSelected) {
                c.setBackground(DataToolTable.this.dataToolTab.isDeletable(data) ? this.unlockedBG : this.lockedBG);
            }
            return c;
        }
    }

    class DataEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JTextField field = new JTextField();
        int column;
        boolean isFunction;

        DataEditor() {
            this.field.setHorizontalAlignment(4);
            this.field.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
            this.field.setSelectionColor(new Color(204, 255, 255));
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(final KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        DataEditor.this.stopCellEditing();
                        Runnable runner = new Runnable(){

                            @Override
                            public synchronized void run() {
                                int row = DataToolTable.this.getModelRow(((DataEditor)(this).DataEditor.this).DataToolTable.this.focusRow) + 1;
                                if (row == DataToolTable.this.getRowCount()) {
                                    DataToolTable.this.insertRows(new int[]{row}, null);
                                }
                                row = DataToolTable.this.getViewRow(row);
                                DataToolTable.this.changeSelection(row, (this).DataEditor.this.column, false, false);
                                DataToolTable.this.editCellAt(row, (this).DataEditor.this.column, e);
                                (this).DataEditor.this.field.requestFocus();
                            }
                        };
                        SwingUtilities.invokeLater(runner);
                    } else if (DataEditor.this.field.isEnabled()) {
                        DataEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (DataEditor.this.field.getBackground() != Color.white) {
                        DataEditor.this.stopCellEditing();
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                    DataEditor.this.field.selectAll();
                }
            });
            this.field.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (OSPRuntime.isPopupTrigger(e)) {
                        DataEditor.this.stopCellEditing();
                        ((DataEditor)DataEditor.this).DataToolTable.this.tableMouseListener.mousePressed(e);
                    }
                }
            });
        }

        void setColumn(int col) {
            this.column = col;
            int modelCol = DataToolTable.this.convertColumnIndexToModel(col);
            Dataset data = DataToolTable.this.dataManager.getDataset(modelCol - 1);
            this.isFunction = data instanceof DataFunction;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            if (this.isFunction) {
                DataToolTable.this.showDataBuilder();
                return null;
            }
            this.field.setText(value == null ? "" : String.valueOf(value));
            this.field.setFont(DataToolTable.this.getFont());
            return this.field;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent && ((MouseEvent)e).getClickCount() == 2) {
                return true;
            }
            if (e instanceof ActionEvent) {
                return true;
            }
            return e instanceof KeyEvent;
        }

        @Override
        public Object getCellEditorValue() {
            DataToolTable.this.requestFocusInWindow();
            this.field.setBackground(Color.white);
            return this.field.getText();
        }
    }

    protected static class DataToolTableModel
    extends DataTable.DefaultDataTableModel {
        DataToolTab tab;

        DataToolTableModel(DataToolTab tab) {
            this.tab = tab;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return rowName;
            }
            String name = this.tab.dataManager.getColumnName(col - 1);
            if (this.tab.originShiftEnabled && this.tab.plot != null) {
                name = String.valueOf(name) + "'";
            }
            return name;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            double val;
            Dataset data;
            block4: {
                if (value == null) {
                    return;
                }
                data = this.tab.dataTable.dataManager.getDataset(col - 1);
                double[] y = data.getYPoints();
                val = Double.NaN;
                try {
                    val = Double.parseDouble(value.toString());
                    if (y[row] == val) {
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    if (!Double.isNaN(y[row])) break block4;
                    return;
                }
            }
            String name = data.getYColumnName();
            int[] rows = new int[]{row};
            HashMap<String, double[]> map = new HashMap<String, double[]>();
            map.put(name, new double[]{val});
            HashMap<String, double[]> old = this.tab.dataTable.replaceCells(rows, map);
            DataToolTable dataToolTable = this.tab.dataTable;
            dataToolTable.getClass();
            TableEdit edit = dataToolTable.new TableEdit(5, name, rows, new HashMap[]{old, map});
            this.tab.undoSupport.postEdit(edit);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0 && this.tab.isUserEditable();
        }
    }

    class HeaderRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;
        Font headerFont;
        DrawingPanel panel = new DrawingPanel();
        DrawableTextLine textLine = new DrawableTextLine("", 0.0, -6.0);

        public HeaderRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
            this.textLine.setJustification(0);
            this.panel.addDrawable(this.textLine);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Color bgColor;
            int yCol;
            int labelCol;
            String realname;
            String name = realname = value == null ? "" : value.toString();
            if (OSPRuntime.isMac()) {
                name = TeXParser.removeSubscripting(name);
            }
            Component c = this.renderer.getTableCellRendererComponent(table, name, isSelected, hasFocus, row, col);
            if (this.headerFont == null) {
                this.headerFont = c.getFont();
            }
            int xCol = (labelCol = DataToolTable.this.convertColumnIndexToView(0)) == 0 ? 1 : 0;
            int n = yCol = labelCol < 2 ? 2 : 1;
            if (DataToolTable.this.unselectedBG == null) {
                DataToolTable.this.unselectedBG = c.getBackground();
            }
            if (DataToolTable.this.unselectedBG == null) {
                DataToolTable.this.unselectedBG = UIManager.getColor("Panel.background");
            }
            DataToolTable.this.rowBG = DataToolTable.this.dataToolTab.plot.getBackground();
            Color color = col == xCol ? xAxisColor : (bgColor = col == yCol ? yAxisColor : DataToolTable.this.rowBG);
            if (!(c instanceof JComponent)) {
                return c;
            }
            JComponent comp = (JComponent)c;
            Dimension dim = comp.getPreferredSize();
            ++dim.height;
            dim.height = Math.max(DataToolTable.this.getRowHeight() + 2, dim.height);
            this.panel.setPreferredSize(dim);
            Border border = comp.getBorder();
            if (border instanceof EmptyBorder) {
                border = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
            }
            this.panel.setBorder(border);
            Dataset data = DataToolTable.this.getDataset(realname);
            Font font = !DataToolTable.this.dataToolTab.isDeletable(data) ? (DataToolTable.this.getSortedColumn() != DataToolTable.this.convertColumnIndexToModel(col) ? this.headerFont.deriveFont(2) : this.headerFont.deriveFont(3)) : (DataToolTable.this.getSortedColumn() != DataToolTable.this.convertColumnIndexToModel(col) ? this.headerFont.deriveFont(0) : this.headerFont.deriveFont(1));
            int[] cols = DataToolTable.this.getSelectedColumns();
            boolean selected = false;
            int i = 0;
            while (i < cols.length) {
                selected = selected || cols[i] == col;
                ++i;
            }
            selected = selected && DataToolTable.this.convertColumnIndexToModel(col) > 0;
            Color color2 = bgColor = selected ? DataToolTable.this.selectedHeaderBG : bgColor;
            if (OSPRuntime.isMac()) {
                comp.setFont(font);
                comp.setBackground(bgColor);
                comp.setForeground(selected ? DataToolTable.this.selectedHeaderFG : comp.getForeground());
                if (comp instanceof JLabel) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                }
                return comp;
            }
            this.textLine.setText(name);
            this.textLine.setFont(font);
            this.textLine.setColor(selected ? DataToolTable.this.selectedHeaderFG : comp.getForeground());
            this.textLine.setBackground(bgColor);
            this.panel.setBackground(bgColor);
            return this.panel;
        }
    }

    class LabelRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setText(value == null ? null : value.toString());
            this.setEnabled(true);
            boolean selected = false;
            if (table == DataToolTable.this) {
                this.setEnabled(row < DataToolTable.this.getRowCount() - 1 || !DataToolTable.this.isEmptyRow(row));
                int[] rows = DataToolTable.this.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    selected = selected || rows[i] == row;
                    ++i;
                }
            }
            this.setForeground(selected ? DataToolTable.this.selectedHeaderFG : Color.black);
            this.setBackground(selected ? DataToolTable.this.selectedHeaderBG : DataToolTable.this.unselectedBG);
            return this;
        }
    }

    protected class TableEdit
    extends AbstractUndoableEdit {
        Object target;
        Object value;
        int editType;
        String columnName;
        HashMap<String, double[]> map;

        public TableEdit(int type, String colName, Object target, Object value) {
            this.editType = type;
            this.columnName = colName;
            this.target = target;
            this.value = value;
            String name = colName == null ? null : ": column \"" + colName + "\"";
            OSPLog.finer(String.valueOf(editTypes[type]) + name);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            OSPLog.finer("undoing " + editTypes[this.editType]);
            switch (this.editType) {
                case 0: {
                    DataToolTable.this.renameColumn(this.columnName, this.value.toString());
                    break;
                }
                case 1: {
                    DataToolTable.this.deleteColumn(this.columnName);
                    break;
                }
                case 2: {
                    Dataset data = (Dataset)this.value;
                    int col = (Integer)this.target;
                    DataToolTable.this.insertColumn(data, col);
                    break;
                }
                case 3: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.deleteCells(rows, values);
                    break;
                }
                case 4: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.insertCells(rows, values);
                    break;
                }
                case 6: {
                    int[] rows = (int[])this.target;
                    DataToolTable.this.deleteRows(rows);
                    break;
                }
                case 7: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.insertRows(rows, values);
                    break;
                }
                case 5: {
                    int[] rows = (int[])this.target;
                    HashMap[] values = (HashMap[])this.value;
                    DataToolTable.this.replaceCells(rows, values[0]);
                }
            }
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            OSPLog.finer("redoing " + editTypes[this.editType]);
            switch (this.editType) {
                case 0: {
                    DataToolTable.this.renameColumn(this.value.toString(), this.columnName);
                    break;
                }
                case 1: {
                    Dataset data = (Dataset)this.value;
                    int col = (Integer)this.target;
                    DataToolTable.this.insertColumn(data, col);
                    break;
                }
                case 2: {
                    DataToolTable.this.deleteColumn(this.columnName);
                    break;
                }
                case 3: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.insertCells(rows, values);
                    break;
                }
                case 4: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.deleteCells(rows, values);
                    break;
                }
                case 6: {
                    int[] rows = (int[])this.target;
                    HashMap values = (HashMap)this.value;
                    DataToolTable.this.insertRows(rows, values);
                    break;
                }
                case 7: {
                    int[] rows = (int[])this.target;
                    DataToolTable.this.deleteRows(rows);
                    break;
                }
                case 5: {
                    int[] rows = (int[])this.target;
                    HashMap[] values = (HashMap[])this.value;
                    DataToolTable.this.replaceCells(rows, values[1]);
                }
            }
        }

        @Override
        public String getPresentationName() {
            return "Edit";
        }
    }

    class WorkingDataset
    extends HighlightableDataset {
        private final Dataset yData;
        private Dataset xData;
        boolean markersVisible;
        int markerType;
        boolean isWorkingYColumn;

        public WorkingDataset(Dataset yDataset) {
            this.yData = yDataset;
            this.setColor(this.yData.getFillColor(), this.yData.getLineColor());
            this.markerType = this.yData.getMarkerShape();
            this.setMarkerShape(this.markerType);
            boolean bl = this.markersVisible = this.markerType != 0;
            if (this.markerType == 0) {
                this.markerType = 1;
            }
            this.setMarkerSize(this.yData.getMarkerSize());
            this.setConnected(this.yData.isConnected());
        }

        @Override
        public void draw(DrawingPanel drawingPanel, Graphics g) {
            if (this.isWorkingYColumn) {
                this.drawSurrounds(drawingPanel, (Graphics2D)g);
            }
            boolean vis = this.markersVisible;
            if (this.isWorkingYColumn && !vis) {
                this.setMarkersVisible(true);
            }
            super.draw(drawingPanel, g);
            if (this.isWorkingYColumn && !vis) {
                this.setMarkersVisible(false);
            }
        }

        protected void drawSurrounds(DrawingPanel drawingPanel, Graphics2D g2) {
            Color c = g2.getColor();
            Stroke s = g2.getStroke();
            g2.setColor(new Color(51, 255, 51, 153));
            g2.setStroke(new BasicStroke(2.0f));
            RectangularShape shape = null;
            int radius = this.getMarkerSize() + 2;
            int marker = this.getMarkerShape();
            if (marker == 0 || marker == 6) {
                radius = 3;
            }
            int size = radius * 2 + 1;
            double[] tempX = this.getXPoints();
            double[] tempY = this.getYPoints();
            double xp = 0.0;
            double yp = 0.0;
            int i = 0;
            while (i < this.index) {
                if (!(Double.isNaN(tempY[i]) || drawingPanel.isLogScaleX() && tempX[i] <= 0.0 || drawingPanel.isLogScaleY() && tempY[i] <= 0.0)) {
                    xp = drawingPanel.xToPix(tempX[i]);
                    yp = drawingPanel.yToPix(tempY[i]);
                    shape = marker == 2 || marker == 8 || marker == 7 ? new Rectangle2D.Double(xp - (double)radius, yp - (double)radius, size, size) : new Ellipse2D.Double(xp - (double)radius, yp - (double)radius, size, size);
                    g2.draw(shape);
                }
                ++i;
            }
            g2.setColor(c);
            g2.setStroke(s);
        }

        public boolean isMarkersVisible() {
            return this.markersVisible || this.isWorkingYColumn;
        }

        public void setMarkersVisible(boolean visible) {
            if (!visible && this.markersVisible) {
                this.markerType = this.getMarkerShape();
                this.setMarkerShape(0);
            } else if (visible) {
                this.setMarkerShape(this.markerType);
            }
            this.markersVisible = visible;
        }

        public void setColor(Color edgeColor, Color lineColor) {
            Color fill = new Color(edgeColor.getRed(), edgeColor.getGreen(), edgeColor.getBlue(), 100);
            this.setMarkerColor(fill, edgeColor);
            this.setLineColor(lineColor);
            this.yData.setMarkerColor(fill, edgeColor);
            this.yData.setLineColor(lineColor);
        }

        @Override
        public void setConnected(boolean connected) {
            super.setConnected(connected);
            this.yData.setConnected(connected);
        }

        @Override
        public void setMarkerSize(int size) {
            super.setMarkerSize(size);
            this.yData.setMarkerSize(size);
        }

        @Override
        public void setMarkerShape(int shape) {
            super.setMarkerShape(shape);
            if (shape != 0) {
                this.yData.setMarkerShape(shape);
                this.markerType = shape;
            }
        }

        Dataset getYSource() {
            return this.yData;
        }

        Dataset getXSource() {
            return this.xData;
        }

        void setXSource(Dataset xDataset) {
            this.xData = xDataset;
            this.clear();
            double[] x = this.xData.getYPoints();
            double[] y = this.yData.getYPoints();
            if (x.length != y.length) {
                int n = Math.min(x.length, y.length);
                double[] nx = new double[n];
                System.arraycopy(x, 0, nx, 0, n);
                double[] ny = new double[n];
                System.arraycopy(y, 0, ny, 0, n);
                this.append(nx, ny);
            } else {
                this.append(x, y);
            }
            this.setXYColumnNames(this.xData.getYColumnName(), this.yData.getYColumnName());
        }
    }
}

