/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.ArrayTable;

public class ArrayInspector
extends JDialog
implements PropertyChangeListener {
    JTabbedPane tabbedPane = new JTabbedPane();
    ArrayTable[] tables;
    JSpinner spinner;
    JScrollPane scrollpane;
    Object array;
    boolean changed;

    public static ArrayInspector getInspector(XMLProperty arrayProp) {
        if (!arrayProp.getPropertyType().equals("array")) {
            return null;
        }
        Class<?> type = arrayProp.getPropertyClass();
        while (type.getComponentType() != null) {
            type = type.getComponentType();
        }
        if (type.getName().equals("double") || type.getName().equals("int") || type.getName().equals("boolean") || type.equals(String.class)) {
            String name = arrayProp.getPropertyName();
            XMLProperty parent = arrayProp.getParentProperty();
            while (!(parent instanceof XMLControl)) {
                name = parent.getPropertyName();
                arrayProp = parent;
                parent = parent.getParentProperty();
            }
            XMLControl arrayControl = (XMLControl)parent;
            Object arrayObj = arrayControl.getObject(name);
            if (arrayObj == null) {
                return null;
            }
            return ArrayInspector.getInspector(arrayObj, name);
        }
        return null;
    }

    public static ArrayInspector getInspector(Object arrayObj, String name) {
        ArrayInspector inspector = null;
        if (arrayObj instanceof double[]) {
            double[] array = (double[])arrayObj;
            inspector = new ArrayInspector(array, name);
        } else if (arrayObj instanceof double[][]) {
            double[][] array = (double[][])arrayObj;
            inspector = new ArrayInspector(array, name);
        } else if (arrayObj instanceof double[][][]) {
            double[][][] array = (double[][][])arrayObj;
            inspector = new ArrayInspector(array, name);
        } else if (arrayObj instanceof int[]) {
            int[] array = (int[])arrayObj;
            inspector = new ArrayInspector(array, name);
        } else if (arrayObj instanceof int[][]) {
            int[][] array = (int[][])arrayObj;
            inspector = new ArrayInspector(array, name);
        } else if (arrayObj instanceof int[][][]) {
            int[][][] array = (int[][][])arrayObj;
            inspector = new ArrayInspector(array, name);
        } else if (arrayObj instanceof String[]) {
            String[] array = (String[])arrayObj;
            inspector = new ArrayInspector(array, name);
        } else if (arrayObj instanceof String[][]) {
            String[][] array = (String[][])arrayObj;
            inspector = new ArrayInspector(array, name);
        } else if (arrayObj instanceof String[][][]) {
            String[][][] array = (String[][][])arrayObj;
            inspector = new ArrayInspector(array, name);
        } else if (arrayObj instanceof boolean[]) {
            boolean[] array = (boolean[])arrayObj;
            inspector = new ArrayInspector(array, name);
        } else if (arrayObj instanceof boolean[][]) {
            boolean[][] array = (boolean[][])arrayObj;
            inspector = new ArrayInspector(array, name);
        } else if (arrayObj instanceof boolean[][][]) {
            boolean[][][] array = (boolean[][][])arrayObj;
            inspector = new ArrayInspector(array, name);
        }
        if (inspector != null) {
            inspector.array = arrayObj;
        }
        return inspector;
    }

    public static boolean canInspect(XMLProperty arrayProp) {
        if (!arrayProp.getPropertyType().equals("array")) {
            return false;
        }
        String name = arrayProp.getPropertyName();
        XMLProperty parent = arrayProp.getParentProperty();
        while (!(parent instanceof XMLControl)) {
            name = parent.getPropertyName();
            arrayProp = parent;
            parent = parent.getParentProperty();
        }
        XMLControl arrayControl = (XMLControl)parent;
        Object arrayObj = arrayControl.getObject(name);
        return ArrayInspector.canInspect(arrayObj);
    }

    public static boolean canInspect(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof double[] || obj instanceof double[][] || obj instanceof double[][][] || obj instanceof int[] || obj instanceof int[][] || obj instanceof int[][][] || obj instanceof boolean[] || obj instanceof boolean[][] || obj instanceof boolean[][][] || obj instanceof String[] || obj instanceof String[][] || obj instanceof String[][][];
    }

    public Object getArray() {
        return this.array;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.changed = true;
        this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    public void setEditable(boolean editable) {
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].setEditable(editable);
            ++i;
        }
    }

    public void refreshTable() {
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i].refreshTable();
            ++i;
        }
    }

    protected void createGUI() {
        this.setSize(400, 300);
        this.setContentPane(new JPanel(new BorderLayout()));
        this.scrollpane = new JScrollPane(this.tables[0]);
        if (this.tables.length > 1) {
            SpinnerNumberModel model = new SpinnerNumberModel(0, 0, this.tables.length - 1, 1);
            this.spinner = new JSpinner(model);
            JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.spinner);
            editor.getTextField().setFont(this.tables[0].getFont());
            this.spinner.setEditor(editor);
            this.spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int i = (Integer)ArrayInspector.this.spinner.getValue();
                    ArrayInspector.this.scrollpane.setViewportView(ArrayInspector.this.tables[i]);
                }
            });
            Dimension dim = this.spinner.getMinimumSize();
            this.spinner.setMaximumSize(dim);
            this.getContentPane().add((Component)this.scrollpane, "Center");
            JToolBar toolbar = new JToolBar();
            toolbar.setFloatable(false);
            toolbar.add(new JLabel(" index "));
            toolbar.add(this.spinner);
            toolbar.add(Box.createHorizontalGlue());
            this.getContentPane().add((Component)toolbar, "North");
        } else {
            this.scrollpane.createHorizontalScrollBar();
            this.getContentPane().add((Component)this.scrollpane, "Center");
        }
    }

    private ArrayInspector() {
        super((Frame)null, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ArrayInspector.this.changed) {
                    ArrayInspector.this.firePropertyChange("arrayData", null, null);
                }
            }
        });
    }

    private ArrayInspector(int[] array) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: int[row]");
    }

    private ArrayInspector(int[] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": int[row]");
    }

    private ArrayInspector(int[][] array) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: int[row][column]");
    }

    private ArrayInspector(int[][] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": int[row][column]");
    }

    private ArrayInspector(int[][][] array) {
        this();
        this.tables = new ArrayTable[array.length];
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i] = new ArrayTable(array[i]);
            this.tables[i].addPropertyChangeListener("cell", this);
            ++i;
        }
        this.createGUI();
        this.setTitle("Array: int[index][row][column]");
    }

    private ArrayInspector(int[][][] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": int[index][row][column]");
    }

    private ArrayInspector(double[] array) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: double[row]");
    }

    private ArrayInspector(double[] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": double[row]");
    }

    private ArrayInspector(double[][] array) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: double[row][column]");
    }

    private ArrayInspector(double[][] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": double[row][column]");
    }

    private ArrayInspector(double[][][] array) {
        this();
        this.tables = new ArrayTable[array.length];
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i] = new ArrayTable(array[i]);
            this.tables[i].addPropertyChangeListener("cell", this);
            ++i;
        }
        this.createGUI();
        this.setTitle("Array: double[index][row][column]");
    }

    private ArrayInspector(double[][][] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": double[index][row][column]");
    }

    private ArrayInspector(String[] array) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: String[row]");
    }

    private ArrayInspector(String[] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": String[row]");
    }

    private ArrayInspector(String[][] array) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: String[row][column]");
    }

    private ArrayInspector(String[][] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": String[row][column]");
    }

    private ArrayInspector(String[][][] array) {
        this();
        this.tables = new ArrayTable[array.length];
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i] = new ArrayTable(array[i]);
            this.tables[i].addPropertyChangeListener("cell", this);
            ++i;
        }
        this.createGUI();
        this.setTitle("Array: String[index][row][column]");
    }

    private ArrayInspector(String[][][] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": String[index][row][column]");
    }

    private ArrayInspector(boolean[] array) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: boolean[row]");
    }

    private ArrayInspector(boolean[] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": boolean[row]");
    }

    private ArrayInspector(boolean[][] array) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(array);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: boolean[row][column]");
    }

    private ArrayInspector(boolean[][] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": boolean[row][column]");
    }

    private ArrayInspector(boolean[][][] array) {
        this();
        this.tables = new ArrayTable[array.length];
        int i = 0;
        while (i < this.tables.length) {
            this.tables[i] = new ArrayTable(array[i]);
            this.tables[i].addPropertyChangeListener("cell", this);
            ++i;
        }
        this.createGUI();
        this.setTitle("Array: boolean[index][row][column]");
    }

    private ArrayInspector(boolean[][][] array, String arrayName) {
        this(array);
        this.setTitle("Array \"" + arrayName + "\": boolean[index][row][column]");
    }
}

