/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.EigenvalueDecomposition;
import org.opensourcephysics.numerics.Function;

public class Polynomial
implements Function {
    protected double[] coefficients;

    public Polynomial(double[] coef) {
        this.coefficients = coef;
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    public Polynomial(String[] coef) {
        this.coefficients = new double[coef.length];
        int i = 0;
        int n = coef.length;
        while (i < n) {
            try {
                this.coefficients[i] = Double.parseDouble(coef[i]);
            }
            catch (NumberFormatException ex) {
                this.coefficients[i] = 0.0;
            }
            ++i;
        }
    }

    public static double evalPolynomial(double x, double[] coeff) {
        int n = coeff.length - 1;
        double y = coeff[n];
        int i = n - 1;
        while (i >= 0) {
            y = coeff[i] + y * x;
            --i;
        }
        return y;
    }

    public Polynomial add(double r) {
        int n = this.coefficients.length;
        double[] coef = new double[n];
        coef[0] = this.coefficients[0] + r;
        int i = 1;
        while (i < n) {
            coef[i] = this.coefficients[i];
            ++i;
        }
        return new Polynomial(coef);
    }

    public Polynomial add(Polynomial p) {
        int n = Math.max(p.degree(), this.degree()) + 1;
        double[] coef = new double[n];
        int i = 0;
        while (i < n) {
            coef[i] = this.coefficient(i) + p.coefficient(i);
            ++i;
        }
        return new Polynomial(coef);
    }

    public double coefficient(int n) {
        return n < this.coefficients.length ? this.coefficients[n] : 0.0;
    }

    public Polynomial deflate(double r) {
        int n = this.degree();
        double remainder = this.coefficients[n];
        double[] coef = new double[n];
        int k = n - 1;
        while (k >= 0) {
            coef[k] = remainder;
            remainder = remainder * r + this.coefficients[k];
            --k;
        }
        return new Polynomial(coef);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public Polynomial derivative() {
        int n = this.degree();
        if (n == 0) {
            double[] coef = new double[]{0.0};
            return new Polynomial(coef);
        }
        double[] coef = new double[n];
        int i = 1;
        while (i <= n) {
            coef[i - 1] = this.coefficients[i] * (double)i;
            ++i;
        }
        return new Polynomial(coef);
    }

    public Polynomial divide(double r) {
        return this.multiply(1.0 / r);
    }

    public Polynomial divide(Polynomial p) {
        return this.divideWithRemainder(p)[0];
    }

    public Polynomial[] divideWithRemainder(Polynomial p) {
        int n;
        Polynomial[] answer = new Polynomial[2];
        int m = this.degree();
        if (m < (n = p.degree())) {
            double[] q = new double[]{0.0};
            answer[0] = new Polynomial(q);
            answer[1] = p;
            return answer;
        }
        double[] quotient = new double[m - n + 1];
        double[] coef = new double[m + 1];
        int k = 0;
        while (k <= m) {
            coef[k] = this.coefficients[k];
            ++k;
        }
        double norm = 1.0 / p.coefficient(n);
        int k2 = m - n;
        while (k2 >= 0) {
            quotient[k2] = coef[n + k2] * norm;
            int j = n + k2 - 1;
            while (j >= k2) {
                int n2 = j;
                coef[n2] = coef[n2] - quotient[k2] * p.coefficient(j - k2);
                --j;
            }
            --k2;
        }
        double[] remainder = new double[n];
        int k3 = 0;
        while (k3 < n) {
            remainder[k3] = coef[k3];
            ++k3;
        }
        answer[0] = new Polynomial(quotient);
        answer[1] = new Polynomial(remainder);
        return answer;
    }

    public Polynomial integral() {
        return this.integral(0.0);
    }

    public Polynomial integral(double value) {
        int n = this.coefficients.length + 1;
        double[] coef = new double[n];
        coef[0] = value;
        int i = 1;
        while (i < n) {
            coef[i] = this.coefficients[i - 1] / (double)i;
            ++i;
        }
        return new Polynomial(coef);
    }

    public Polynomial multiply(double r) {
        int n = this.coefficients.length;
        double[] coef = new double[n];
        int i = 0;
        while (i < n) {
            coef[i] = this.coefficients[i] * r;
            ++i;
        }
        return new Polynomial(coef);
    }

    public Polynomial multiply(Polynomial p) {
        int n = p.degree() + this.degree();
        double[] coef = new double[n + 1];
        int i = 0;
        while (i <= n) {
            coef[i] = 0.0;
            int k = 0;
            while (k <= i) {
                int n2 = i;
                coef[n2] = coef[n2] + p.coefficient(k) * this.coefficient(i - k);
                ++k;
            }
            ++i;
        }
        return new Polynomial(coef);
    }

    public double[][] roots() {
        int highest;
        int i = highest = this.coefficients.length - 1;
        while (i > 0) {
            if (this.coefficients[highest] != 0.0) break;
            highest = i--;
        }
        if (highest == 0) {
            return new double[2][0];
        }
        double ch = this.coefficients[highest];
        double[][] companion = new double[highest][highest];
        companion[0][highest - 1] = -this.coefficients[0] / ch;
        int i2 = 0;
        while (i2 < highest - 1) {
            companion[0][i2] = -this.coefficients[highest - i2 - 1] / ch;
            companion[i2 + 1][i2] = 1.0;
            ++i2;
        }
        EigenvalueDecomposition eigen = new EigenvalueDecomposition(companion);
        double[][] roots = new double[][]{eigen.getRealEigenvalues(), eigen.getImagEigenvalues()};
        return roots;
    }

    public double[] rootsReal() {
        double[][] roots = this.roots();
        int n = roots[0].length;
        double[] temp = new double[n];
        int count = 0;
        int i = 0;
        while (i < n) {
            double magSquared = roots[0][i] * roots[0][i] + roots[1][i] * roots[1][i];
            if (roots[1][i] * roots[1][i] / magSquared < 1.0E-12) {
                temp[count] = roots[0][i];
                ++count;
            }
            ++i;
        }
        double[] re = new double[count];
        System.arraycopy(temp, 0, re, 0, count);
        return re;
    }

    public Polynomial subtract(double r) {
        return this.add(-r);
    }

    public Polynomial subtract(Polynomial p) {
        int n = Math.max(p.degree(), this.degree()) + 1;
        double[] coef = new double[n];
        int i = 0;
        while (i < n) {
            coef[i] = this.coefficient(i) - p.coefficient(i);
            ++i;
        }
        return new Polynomial(coef);
    }

    public String toString() {
        if (this.coefficients == null || this.coefficients.length < 1) {
            return "Polynomial coefficients are undefined.";
        }
        StringBuffer sb = new StringBuffer();
        boolean firstNonZeroCoefficientPrinted = false;
        int n = 0;
        int m = this.coefficients.length;
        while (n < m) {
            if (this.coefficients[n] != 0.0) {
                if (firstNonZeroCoefficientPrinted) {
                    sb.append(this.coefficients[n] > 0.0 ? " + " : " ");
                } else {
                    firstNonZeroCoefficientPrinted = true;
                }
                if (n == 0 || this.coefficients[n] != 1.0) {
                    sb.append(Double.toString(this.coefficients[n]));
                }
                if (n > 0) {
                    sb.append(" x^" + n);
                }
            }
            ++n;
        }
        String str = sb.toString();
        if (str.equals("")) {
            return "0";
        }
        return str;
    }

    @Override
    public double evaluate(double x) {
        int n = this.coefficients.length;
        double answer = this.coefficients[--n];
        while (n > 0) {
            answer = answer * x + this.coefficients[--n];
        }
        return answer;
    }

    public double[] valueAndDerivative(double x) {
        int n = this.coefficients.length;
        double[] answer = new double[]{this.coefficients[--n], 0.0};
        while (n > 0) {
            answer[1] = answer[1] * x + answer[0];
            answer[0] = answer[0] * x + this.coefficients[--n];
        }
        return answer;
    }
}

