/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.numerics.SuryonoParser;

public final class ParsedMultiVarFunction
implements MultiVarFunction {
    private final String fStr;
    private final MultiVarFunction function;
    private String[] functionNames;

    public ParsedMultiVarFunction(String _fStr, String[] var) throws ParserException {
        this.fStr = _fStr;
        SuryonoParser parser = null;
        parser = new SuryonoParser(this.fStr, var);
        this.function = parser;
        this.functionNames = parser.getFunctionNames();
    }

    @Override
    public double evaluate(double[] x) {
        return this.function.evaluate(x);
    }

    public String toString() {
        return "f(x) = " + this.fStr;
    }

    public String[] getFunctionNames() {
        return this.functionNames;
    }

    public boolean evaluatedToNaN() {
        if (this.function instanceof SuryonoParser) {
            return ((SuryonoParser)this.function).evaluatedToNaN();
        }
        return false;
    }
}

