/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ArrayLib;
import org.opensourcephysics.numerics.HessianMinimize;
import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.MultiVarFunction;

public class LevenbergMarquardt {
    int Iterations;
    double[][] H;
    private double rmsd_tmp;
    private double rmsd_tmp1;
    private double rmsd;
    private double[] xtmp;
    private double[] xtmp1;
    HessianMinimize hessianMinimize = new HessianMinimize();

    public double minimize(MultiVarFunction Veq, double[] x, int max, double tol) {
        int m = x.length;
        this.H = new double[m][m];
        double[] xxn = new double[m];
        double[] D = new double[m];
        double[] dx = new double[m];
        this.xtmp = new double[m];
        this.xtmp1 = new double[m];
        this.rmsd_tmp1 = this.rmsd_tmp = Veq.evaluate(x);
        System.arraycopy(x, 0, this.xtmp, 0, m);
        System.arraycopy(x, 0, this.xtmp1, 0, m);
        int i = 0;
        while (i < m) {
            dx[i] = (Math.abs(x[i]) + 1.0) / 100000.0;
            ++i;
        }
        double Lambda = 0.001;
        double err = 9999.0;
        double relerr = 9999.0;
        this.Iterations = 0;
        while (err > tol * 1.0E-6 && relerr > tol * 1.0E-6 && this.Iterations < max && Lambda > 1.0E-6) {
            ++this.Iterations;
            this.H = this.hessianMinimize.getHessian(Veq, x, D, dx);
            int i2 = 0;
            while (i2 < m) {
                this.H[i2][i2] = this.H[i2][i2] + Lambda;
                ++i2;
            }
            LUPDecomposition lu = new LUPDecomposition(this.H);
            xxn = lu.solve(D);
            int i3 = 0;
            while (i3 < m) {
                xxn[i3] = xxn[i3] + x[i3];
                ++i3;
            }
            err = (x[0] - xxn[0]) * (x[0] - xxn[0]);
            relerr = x[0] * x[0];
            x[0] = xxn[0];
            i3 = 1;
            while (i3 < m) {
                err += (x[i3] - xxn[i3]) * (x[i3] - xxn[i3]);
                relerr += x[i3] * x[i3];
                x[i3] = xxn[i3];
                ++i3;
            }
            this.rmsd = Veq.evaluate(x);
            if (this.rmsd < this.rmsd_tmp1) {
                Lambda /= 10.0;
                this.rmsd_tmp1 = this.rmsd;
                System.arraycopy(x, 0, this.xtmp1, 0, m);
            } else {
                System.arraycopy(this.xtmp1, 0, x, 0, m);
                Lambda *= 10.0;
            }
            err = Math.sqrt(err);
            relerr = err / (relerr + tol);
        }
        this.check_rmsd(Veq, this.xtmp, x, m);
        return err;
    }

    void check_rmsd(MultiVarFunction Veq, double[] xtmp, double[] xx, int mx) {
        if (Double.isNaN(ArrayLib.sum(xx))) {
            this.rmsd = this.rmsd_tmp;
            System.arraycopy(xtmp, 0, xx, 0, mx);
        } else {
            this.rmsd = Veq.evaluate(xx);
            if (this.rmsd <= this.rmsd_tmp) {
                this.rmsd_tmp = this.rmsd;
                System.arraycopy(xx, 0, xtmp, 0, mx);
            } else {
                this.rmsd = this.rmsd_tmp;
                System.arraycopy(xtmp, 0, xx, 0, mx);
            }
        }
    }

    public int getIterations() {
        return this.Iterations;
    }
}

