/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public class LUPDecomposition {
    private double[][] rows;
    private int[] permutation = null;
    private int parity = 1;

    public LUPDecomposition(double[][] components) throws IllegalArgumentException {
        int n = components.length;
        if (components[0].length != n) {
            throw new IllegalArgumentException("Illegal system: a" + n + " by " + components[0].length + " matrix is not a square matrix");
        }
        this.initialize(components);
    }

    private double[] backwardSubstitution(double[] xTilde) {
        int n = this.rows.length;
        double[] answer = new double[n];
        int i = n - 1;
        while (i >= 0) {
            answer[i] = xTilde[i];
            int j = i + 1;
            while (j < n) {
                int n2 = i;
                answer[n2] = answer[n2] - this.rows[i][j] * answer[j];
                ++j;
            }
            int n3 = i;
            answer[n3] = answer[n3] / this.rows[i][i];
            --i;
        }
        return answer;
    }

    private void decompose() {
        int n = this.rows.length;
        this.permutation = new int[n];
        int i = 0;
        while (i < n) {
            this.permutation[i] = i;
            ++i;
        }
        this.parity = 1;
        try {
            i = 0;
            while (i < n) {
                this.swapRows(i, this.largestPivot(i));
                this.pivot(i);
                ++i;
            }
        }
        catch (ArithmeticException e) {
            this.parity = 0;
        }
    }

    private boolean decomposed() {
        if (this.parity == 1 && this.permutation == null) {
            this.decompose();
        }
        return this.parity != 0;
    }

    public double determinant() {
        if (!this.decomposed()) {
            return Double.NaN;
        }
        double determinant = this.parity;
        int i = 0;
        while (i < this.rows.length) {
            determinant *= this.rows[i][i];
            ++i;
        }
        return determinant;
    }

    private double[] forwardSubstitution(double[] c) {
        int n = this.rows.length;
        double[] answer = new double[n];
        int i = 0;
        while (i < n) {
            answer[i] = c[this.permutation[i]];
            int j = 0;
            while (j <= i - 1) {
                int n2 = i;
                answer[n2] = answer[n2] - this.rows[i][j] * answer[j];
                ++j;
            }
            ++i;
        }
        return answer;
    }

    private void initialize(double[][] components) {
        int n = components.length;
        this.rows = new double[n][n];
        int i = 0;
        while (i < n) {
            System.arraycopy(components[i], 0, this.rows[i], 0, n);
            ++i;
        }
        this.permutation = null;
        this.parity = 1;
    }

    public double[][] inverseMatrixComponents() {
        if (!this.decomposed()) {
            return null;
        }
        int n = this.rows.length;
        double[][] inverseMatrix = new double[n][n];
        double[] column = new double[n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                column[j] = 0.0;
                ++j;
            }
            column[i] = 1.0;
            column = this.solve(column);
            j = 0;
            while (j < n) {
                if (Double.isNaN(column[j])) {
                    return null;
                }
                inverseMatrix[j][i] = column[j];
                ++j;
            }
            ++i;
        }
        return inverseMatrix;
    }

    public static void symmetrizeComponents(double[][] components) {
        int i = 0;
        while (i < components.length) {
            int j = i + 1;
            while (j < components.length) {
                double[] dArray = components[i];
                int n = j;
                dArray[n] = dArray[n] + components[j][i];
                double[] dArray2 = components[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] * 0.5;
                components[j][i] = components[i][j];
                ++j;
            }
            ++i;
        }
    }

    private int largestPivot(int k) {
        double maximum = Math.abs(this.rows[k][k]);
        int index = k;
        int i = k + 1;
        while (i < this.rows.length) {
            double abs = Math.abs(this.rows[i][k]);
            if (abs > maximum) {
                maximum = abs;
                index = i;
            }
            ++i;
        }
        return index;
    }

    private void pivot(int k) {
        double inversePivot = 1.0 / this.rows[k][k];
        int k1 = k + 1;
        int n = this.rows.length;
        int i = k1;
        while (i < n) {
            double[] dArray = this.rows[i];
            int n2 = k;
            dArray[n2] = dArray[n2] * inversePivot;
            int j = k1;
            while (j < n) {
                double[] dArray2 = this.rows[i];
                int n3 = j;
                dArray2[n3] = dArray2[n3] - this.rows[i][k] * this.rows[k][j];
                ++j;
            }
            ++i;
        }
    }

    public double[] solve(double[] c) {
        return this.decomposed() ? this.backwardSubstitution(this.forwardSubstitution(c)) : null;
    }

    private void swapRows(int i, int k) {
        if (i != k) {
            int j = 0;
            while (j < this.rows.length) {
                double temp = this.rows[i][j];
                this.rows[i][j] = this.rows[k][j];
                this.rows[k][j] = temp;
                ++j;
            }
            int nTemp = this.permutation[i];
            this.permutation[i] = this.permutation[k];
            this.permutation[k] = nTemp;
            this.parity = -this.parity;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        char[] separator = new char[]{'[', ' '};
        int n = this.rows.length;
        int i = 0;
        while (i < n) {
            separator[0] = 123;
            int j = 0;
            while (j < n) {
                sb.append(separator);
                sb.append(this.rows[i][j]);
                separator[0] = 32;
                ++j;
            }
            sb.append('}');
            sb.append('\n');
            ++i;
        }
        if (this.permutation != null) {
            sb.append(this.parity == 1 ? (char)'+' : '-');
            sb.append("( " + this.permutation[0]);
            i = 1;
            while (i < n) {
                sb.append(", " + this.permutation[i]);
                ++i;
            }
            sb.append(')');
            sb.append('\n');
        }
        return sb.toString();
    }
}

