/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ArrayLib;
import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.MultiVarFunction;

public class HessianMinimize {
    int Iterations;
    double[][] H;
    double[] xp;
    double[] xm;
    double[] xpp;
    double[] xpm;
    double[] xmp;
    double[] xmm;
    private double rmsd_tmp;
    private double rmsd;
    private double[] xtmp;

    public double minimize(MultiVarFunction Veq, double[] x, int max, double tol) {
        int m = x.length;
        double[] xxn = new double[m];
        double[] D = new double[m];
        double[] dx = new double[m];
        this.xtmp = new double[m];
        System.arraycopy(x, 0, this.xtmp, 0, m);
        this.rmsd_tmp = Veq.evaluate(x);
        this.rmsd = 0.0;
        this.crudeGuess(Veq, x);
        this.check_rmsd(Veq, this.xtmp, x, m);
        int i = 0;
        while (i < m) {
            dx[i] = (Math.abs(x[i]) + 1.0) / 100000.0;
            ++i;
        }
        double err = 9999.0;
        double relerr = 9999.0;
        this.Iterations = 0;
        while (err > tol * 1.0E-6 && relerr > tol * 1.0E-6 && this.Iterations < max) {
            ++this.Iterations;
            LUPDecomposition lu = new LUPDecomposition(this.getHessian(Veq, x, D, dx));
            xxn = lu.solve(D);
            int i2 = 0;
            while (i2 < m) {
                xxn[i2] = xxn[i2] + x[i2];
                ++i2;
            }
            err = (x[0] - xxn[0]) * (x[0] - xxn[0]);
            relerr = x[0] * x[0];
            x[0] = xxn[0];
            i2 = 1;
            while (i2 < m) {
                err += (x[i2] - xxn[i2]) * (x[i2] - xxn[i2]);
                relerr += x[i2] * x[i2];
                x[i2] = xxn[i2];
                ++i2;
            }
            err = Math.sqrt(err);
            relerr = err / (relerr + tol);
        }
        this.check_rmsd(Veq, this.xtmp, x, m);
        return err;
    }

    private void allocateArrays(int m) {
        this.H = new double[m][m];
        this.xp = new double[m];
        this.xm = new double[m];
        this.xpp = new double[m];
        this.xpm = new double[m];
        this.xmp = new double[m];
        this.xmm = new double[m];
    }

    void crudeGuess(MultiVarFunction Veq, double[] x) {
        int m = x.length;
        int Nc = 5;
        double f = 0.35;
        int n = 0;
        double[] xp = new double[m];
        double[] xm = new double[m];
        double[] dx = new double[m];
        int i = 0;
        while (i < m) {
            dx[i] = (Math.abs(x[i]) + 1.0) / 1000.0;
            ++i;
        }
        while (n < Nc) {
            ++n;
            i = 0;
            while (i < m) {
                int k = 0;
                while (k < m) {
                    if (k == i) {
                        xp[i] = x[i] + dx[i];
                        xm[i] = x[i] - dx[i];
                    } else {
                        xp[k] = x[k];
                        xm[k] = x[k];
                    }
                    ++k;
                }
                double sp = Veq.evaluate(xp);
                double s0 = Veq.evaluate(x);
                double sm = Veq.evaluate(xm);
                x[i] = x[i] - f * 0.5 * dx[i] * (sp - sm) / (sp - 2.0 * s0 + sm);
                dx[i] = 0.5 * dx[i];
                ++i;
            }
        }
    }

    void check_rmsd(MultiVarFunction Veq, double[] xtmp, double[] xx, int mx) {
        if (Double.isNaN(ArrayLib.sum(xx))) {
            this.rmsd = this.rmsd_tmp;
            System.arraycopy(xtmp, 0, xx, 0, mx);
        } else {
            this.rmsd = Veq.evaluate(xx);
            if (this.rmsd <= this.rmsd_tmp) {
                this.rmsd_tmp = this.rmsd;
                System.arraycopy(xx, 0, xtmp, 0, mx);
            } else {
                this.rmsd = this.rmsd_tmp;
                System.arraycopy(xtmp, 0, xx, 0, mx);
            }
        }
    }

    public int getIterations() {
        return this.Iterations;
    }

    public double[][] getHessian(MultiVarFunction Veq, double[] x, double[] D, double[] dx) {
        int m = x.length;
        if (this.xp == null || this.xp.length != m) {
            this.allocateArrays(m);
        }
        int i = 0;
        while (i < m) {
            int j = i;
            while (j < m) {
                int k;
                if (i == j) {
                    k = 0;
                    while (k < m) {
                        this.xp[k] = x[k];
                        this.xm[k] = x[k];
                        ++k;
                    }
                    this.xp[i] = x[i] + dx[i];
                    this.xm[i] = x[i] - dx[i];
                    this.H[i][i] = (Veq.evaluate(this.xp) - 2.0 * Veq.evaluate(x) + Veq.evaluate(this.xm)) / (dx[i] * dx[i]);
                } else {
                    k = 0;
                    while (k < m) {
                        this.xpp[k] = x[k];
                        this.xpm[k] = x[k];
                        this.xmp[k] = x[k];
                        this.xmm[k] = x[k];
                        ++k;
                    }
                    this.xpp[i] = x[i] + dx[i];
                    this.xpp[j] = x[j] + dx[j];
                    this.xpm[i] = x[i] + dx[i];
                    this.xpm[j] = x[j] - dx[j];
                    this.xmp[i] = x[i] - dx[i];
                    this.xmp[j] = x[j] + dx[j];
                    this.xmm[i] = x[i] - dx[i];
                    this.xmm[j] = x[j] - dx[j];
                    this.H[i][j] = ((Veq.evaluate(this.xpp) - Veq.evaluate(this.xpm)) / (2.0 * dx[j]) - (Veq.evaluate(this.xmp) - Veq.evaluate(this.xmm)) / (2.0 * dx[j])) / (2.0 * dx[i]);
                    this.H[j][i] = this.H[i][j];
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < m) {
            int k = 0;
            while (k < m) {
                this.xp[k] = x[k];
                this.xm[k] = x[k];
                ++k;
            }
            this.xp[i] = x[i] + dx[i];
            this.xm[i] = x[i] - dx[i];
            D[i] = -(Veq.evaluate(this.xp) - Veq.evaluate(this.xm)) / (2.0 * dx[i]);
            ++i;
        }
        return this.H;
    }
}

