/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.FFT;

public class FFTReal {
    static final double PI2 = Math.PI * 2;
    int n;
    FFT fft = new FFT();

    public FFTReal() {
        this.setN(2);
    }

    public FFTReal(int n) {
        this.setN(n);
    }

    public void setN(int n) {
        if (n % 2 != 0) {
            throw new IllegalArgumentException(String.valueOf(n) + " is not even");
        }
        this.n = n;
        this.fft.setN(n / 2);
    }

    public int getN() {
        return this.n;
    }

    public double[] transform(double[] data) {
        if (data.length != this.n) {
            this.setN(data.length);
        }
        this.fft.transform(data);
        this.shuffle(data, 1);
        return data;
    }

    public double[] backtransform(double[] data) {
        if (data.length != this.n) {
            this.setN(data.length);
        }
        this.shuffle(data, -1);
        this.fft.backtransform(data);
        return data;
    }

    public double[] inverse(double[] data) {
        this.backtransform(data);
        double norm = 2.0 / (double)this.n;
        int i = 0;
        while (i < this.n) {
            int n = i++;
            data[n] = data[n] * norm;
        }
        return data;
    }

    public double[] getNaturalFreq(double delta) {
        int n = this.n / 2;
        double[] freq = new double[n];
        double f = 0.0;
        double df = 0.5 / (double)n / delta;
        int i = 0;
        while (i < n) {
            freq[i] = f;
            f += df;
            ++i;
        }
        return freq;
    }

    public double[] getNaturalFreq(double xmin, double xmax) {
        return this.getNaturalFreq((xmax - xmin) / (double)(this.n - this.n % 2));
    }

    public double[] getNaturalOmega(double delta) {
        return this.getNaturalFreq(delta / (Math.PI * 2));
    }

    public double[] getNaturalOmega(double xmin, double xmax) {
        return this.getNaturalFreq((xmax - xmin) / (double)(this.n - this.n % 2) / (Math.PI * 2));
    }

    private void shuffle(double[] data, int sign) {
        int nh = this.n / 2;
        int nq = this.n / 4;
        if (this.n == 6) {
            nq = 2;
        }
        double c1 = 0.5;
        double c2 = -0.5 * (double)sign;
        double theta = (double)sign * Math.PI / (double)nh;
        double wtemp = Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = -Math.sin(theta);
        double wr = 1.0 + wpr;
        double wi = wpi;
        int i = 1;
        while (i < nq) {
            int i1 = 2 * i;
            int i3 = this.n - i1;
            double h1r = c1 * (data[i1] + data[i3]);
            double h1i = c1 * (data[i1 + 1] - data[i3 + 1]);
            double h2r = -c2 * (data[i1 + 1] + data[i3 + 1]);
            double h2i = c2 * (data[i1] - data[i3]);
            data[i1] = h1r + wr * h2r - wi * h2i;
            data[i1 + 1] = h1i + wr * h2i + wi * h2r;
            data[i3] = h1r - wr * h2r + wi * h2i;
            data[i3 + 1] = -h1i + wr * h2i + wi * h2r;
            wtemp = wr;
            wr += wtemp * wpr - wi * wpi;
            wi += wtemp * wpi + wi * wpr;
            ++i;
        }
        double d0 = data[0];
        if (sign == 1) {
            data[0] = d0 + data[1];
            data[1] = d0 - data[1];
        } else {
            data[0] = c1 * (d0 + data[1]);
            data[1] = c1 * (d0 - data[1]);
        }
        if (this.n % 4 == 0) {
            int n = nh + 1;
            data[n] = data[n] * -1.0;
        }
    }
}

