/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.ExtensionsManager;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class VideoIO {
    public static final String[] VIDEO_EXTENSIONS = new String[]{"mov", "avi", "mp4"};
    public static final String ENGINE_QUICKTIME = "QT";
    public static final String ENGINE_XUGGLE = "Xuggle";
    public static final String ENGINE_NONE = "none";
    public static final String DEFAULT_PREFERRED_EXPORT_EXTENSION = "mp4";
    public static final long XUGGLE_54_FILE_LENGTH = 1000000L;
    protected static JFileChooser chooser;
    protected static VideoFileFilter videoFileFilter;
    protected static Collection<VideoFileFilter> singleVideoTypeFilters;
    protected static FileFilter imageFileFilter;
    protected static ArrayList<VideoType> videoTypes;
    protected static ArrayList<VideoType> videoEngines;
    protected static String defaultXMLExt;
    protected static String videoEngine;
    protected static VideoEnginePanel videoEnginePanel;
    protected static boolean canceled;
    protected static String preferredExportExtension;

    static {
        videoFileFilter = new VideoFileFilter();
        singleVideoTypeFilters = new TreeSet<VideoFileFilter>();
        videoTypes = new ArrayList();
        videoEngines = new ArrayList();
        defaultXMLExt = "xml";
        preferredExportExtension = DEFAULT_PREFERRED_EXPORT_EXTENSION;
        try {
            String name = "org.opensourcephysics.media.gif.GifVideoType";
            Class<?> gifClass = Class.forName(name);
            VideoIO.addVideoType((VideoType)gifClass.newInstance());
        }
        catch (Exception name) {
        }
        catch (Error name) {
            // empty catch block
        }
        VideoFileFilter filter = new VideoFileFilter("jpg", new String[]{"jpg", "jpeg"});
        VideoIO.addVideoType(new ImageVideoType(filter));
        filter = new VideoFileFilter("png", new String[]{"png"});
        VideoIO.addVideoType(new ImageVideoType(filter));
        imageFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = VideoIO.getExtension(f);
                return extension != null && (extension.equals("gif") || extension.equals("jpg"));
            }

            @Override
            public String getDescription() {
                return MediaRes.getString("VideoIO.ImageFileFilter.Description");
            }
        };
        videoEnginePanel = new VideoEnginePanel();
    }

    protected VideoIO() {
    }

    public static String getExtension(File file) {
        return XML.getExtension(file.getName());
    }

    public static JFileChooser getChooser() {
        if (chooser == null) {
            File dir = OSPRuntime.chooserDir == null ? new File(System.getProperty("user.home")) : new File(OSPRuntime.chooserDir);
            chooser = new JFileChooser(dir);
            chooser.addPropertyChangeListener(videoEnginePanel);
        }
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    public static void setDefaultXMLExtension(String ext) {
        defaultXMLExt = ext;
    }

    public static String getRelativePath(String absolutePath) {
        if (absolutePath.indexOf("/") == -1 && absolutePath.indexOf("\\") == -1) {
            return absolutePath;
        }
        if (absolutePath.startsWith("http:")) {
            return absolutePath;
        }
        String path = absolutePath;
        String relativePath = "";
        boolean validPath = false;
        String base = System.getProperty("user.dir");
        if (base == null) {
            return path;
        }
        int j = 0;
        while (j < 3) {
            if (j > 0) {
                int k = base.lastIndexOf("\\");
                if (k == -1) {
                    k = base.lastIndexOf("/");
                }
                if (k == -1) break;
                base = base.substring(0, k);
                relativePath = String.valueOf(relativePath) + "../";
            }
            if (path.startsWith(base)) {
                path = path.substring(base.length() + 1);
                int i = path.indexOf("\\");
                while (i != -1) {
                    path = String.valueOf(path.substring(0, i)) + "/" + path.substring(i + 1);
                    i = path.indexOf("\\");
                }
                relativePath = String.valueOf(relativePath) + path;
                validPath = true;
                break;
            }
            ++j;
        }
        if (validPath) {
            return relativePath;
        }
        return path;
    }

    public static boolean isEngineInstalled(String engine) {
        if (engine.equals(ENGINE_XUGGLE)) {
            return ExtensionsManager.getManager().getXuggleJar() != null;
        }
        if (engine.equals(ENGINE_QUICKTIME)) {
            if (OSPRuntime.isMac()) {
                return true;
            }
            if (OSPRuntime.isLinux()) {
                return false;
            }
            return ExtensionsManager.getManager().getQTJavaZip() != null;
        }
        return false;
    }

    public static String getEngine() {
        if (videoEngine == null) {
            videoEngine = VideoIO.getDefaultEngine();
        }
        return videoEngine;
    }

    public static void setEngine(String engine) {
        if (engine == null || !engine.equals(ENGINE_QUICKTIME) && !engine.equals(ENGINE_XUGGLE) && !engine.equals(ENGINE_NONE)) {
            return;
        }
        videoEngine = engine;
    }

    public static String getDefaultEngine() {
        String engine = ENGINE_NONE;
        double xuggleVersion = 0.0;
        boolean hasQT = false;
        for (VideoType next : videoEngines) {
            if (next.getClass().getSimpleName().contains(ENGINE_XUGGLE)) {
                xuggleVersion = VideoIO.guessXuggleVersion();
                continue;
            }
            if (!next.getClass().getSimpleName().contains(ENGINE_QUICKTIME)) continue;
            hasQT = true;
        }
        if (xuggleVersion == 3.4) {
            engine = ENGINE_XUGGLE;
        } else if (hasQT) {
            engine = ENGINE_QUICKTIME;
        } else if (xuggleVersion == 5.4) {
            engine = ENGINE_XUGGLE;
        }
        return engine;
    }

    public static boolean updateEngine(String engine) {
        String extFolders = XML.forwardSlash(System.getProperty("java.ext.dirs"));
        ArrayList<File> extDirs = new ArrayList<File>();
        String separator = System.getProperty("path.separator");
        int n = extFolders.indexOf(separator);
        while (n > -1) {
            extDirs.add(new File(extFolders.substring(0, n)));
            extFolders = extFolders.substring(n + 1);
            n = extFolders.indexOf(separator);
        }
        if (!"".equals(extFolders)) {
            extDirs.add(new File(extFolders));
        }
        ExtensionsManager manager = ExtensionsManager.getManager();
        if (engine.equals(ENGINE_XUGGLE)) {
            boolean copied = false;
            for (File extDir : extDirs) {
                if (!extDir.exists()) continue;
                boolean bl = copied = manager.copyXuggleJarsTo(extDir) || copied;
            }
            return copied;
        }
        if (engine.equals(ENGINE_QUICKTIME)) {
            if (OSPRuntime.isLinux()) {
                return false;
            }
            boolean copied = false;
            for (File extDir : extDirs) {
                if (!extDir.exists()) continue;
                boolean bl = copied = manager.copyQTJavaTo(extDir) || copied;
            }
            return copied;
        }
        return false;
    }

    public static void testExec() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean copyFile(File inFile, File outFile) {
        byte[] buffer = new byte[100000];
        try {
            FileInputStream in = new FileInputStream(inFile);
            FileOutputStream out = new FileOutputStream(outFile);
            while (true) {
                byte[] byArray = buffer;
                // MONITORENTER : buffer
                int amountRead = ((InputStream)in).read(buffer);
                if (amountRead == -1) {
                    // MONITOREXIT : byArray
                    break;
                }
                ((OutputStream)out).write(buffer, 0, amountRead);
                // MONITOREXIT : byArray
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            outFile.setLastModified(inFile.lastModified());
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static String[] getVideoExtensions() {
        return videoFileFilter.getExtensions();
    }

    public static String getPreferredExportExtension() {
        return preferredExportExtension;
    }

    public static void setPreferredExportExtension(String extension) {
        if (extension != null && extension.length() > 1) {
            preferredExportExtension = extension;
        }
    }

    public static void addVideoType(VideoType type) {
        if (type != null) {
            boolean hasType = false;
            for (VideoType next : videoTypes) {
                if (!next.getDescription().equals(type.getDescription()) || next.getClass() != type.getClass()) continue;
                hasType = true;
            }
            if (!hasType) {
                videoTypes.add(type);
                VideoFileFilter filter = type.getDefaultFileFilter();
                if (filter != null && filter.extensions != null) {
                    singleVideoTypeFilters.add(filter);
                }
            }
        }
    }

    public static void addVideoEngine(VideoType engine) {
        if (engine != null) {
            OSPLog.finest(String.valueOf(engine.getClass().getSimpleName()) + " " + engine.getDefaultExtension());
            boolean hasType = false;
            for (VideoType next : videoEngines) {
                if (next.getClass() != engine.getClass()) continue;
                hasType = true;
            }
            if (!hasType) {
                videoEngines.add(engine);
                videoEnginePanel.addVideoEngine(engine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VideoType getVideoType(String className, String extension) {
        if (className == null && extension == null) {
            return null;
        }
        ArrayList<VideoType> candidates = new ArrayList<VideoType>();
        ArrayList<VideoType> arrayList = videoTypes;
        synchronized (arrayList) {
            if (className == null) {
                candidates.addAll(videoTypes);
            } else {
                className = className.toLowerCase();
                for (VideoType next : videoTypes) {
                    String name = next.getClass().getSimpleName().toLowerCase();
                    if (name.indexOf(className) <= -1) continue;
                    candidates.add(next);
                }
            }
            if (extension == null) {
                if (!candidates.isEmpty()) return (VideoType)candidates.get(0);
                return null;
            }
            extension = extension.toLowerCase();
            for (VideoType next : candidates) {
                String id = next.getDefaultExtension();
                if (id == null || id.indexOf(extension) <= -1) continue;
                return next;
            }
            for (VideoType next : candidates) {
                VideoFileFilter[] filters;
                VideoFileFilter[] videoFileFilterArray = filters = next.getFileFilters();
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    VideoFileFilter filter = videoFileFilterArray[n2];
                    if (filter.extensions != null) {
                        String[] stringArray = filter.extensions;
                        int n3 = filter.extensions.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String s = stringArray[n4];
                            if (s.indexOf(extension) > -1) {
                                return next;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    public static VideoType[] getVideoTypesForExtension(String ext) {
        VideoType next;
        VideoType[] vidTypes;
        ext = ext.toLowerCase();
        ArrayList<VideoType> found = new ArrayList<VideoType>();
        VideoType[] videoTypeArray = vidTypes = VideoIO.getVideoTypes();
        int n = vidTypes.length;
        int n2 = 0;
        while (n2 < n) {
            next = videoTypeArray[n2];
            String id = next.getDefaultExtension();
            if (id != null && id.indexOf(ext) > -1) {
                found.add(next);
            }
            ++n2;
        }
        videoTypeArray = vidTypes;
        n = vidTypes.length;
        n2 = 0;
        while (n2 < n) {
            VideoFileFilter[] filters;
            next = videoTypeArray[n2];
            VideoFileFilter[] videoFileFilterArray = filters = next.getFileFilters();
            int n3 = filters.length;
            int n4 = 0;
            while (n4 < n3) {
                VideoFileFilter filter = videoFileFilterArray[n4];
                if (filter.extensions != null) {
                    String[] stringArray = filter.extensions;
                    int n5 = filter.extensions.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String s = stringArray[n6];
                        if (s.indexOf(ext) > -1 && !found.contains(next)) {
                            found.add(next);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return found.toArray(new VideoType[0]);
    }

    public static VideoType[] getVideoTypes() {
        return VideoIO.getVideoTypesForEngine(VideoIO.getEngine());
    }

    public static VideoType[] getVideoTypesForEngine(String engine) {
        ArrayList<VideoType> available = new ArrayList<VideoType>();
        boolean skipQT = VideoIO.getEngine().equals(ENGINE_XUGGLE) || VideoIO.getEngine().equals(ENGINE_NONE);
        boolean skipXuggle = VideoIO.getEngine().equals(ENGINE_QUICKTIME) || VideoIO.getEngine().equals(ENGINE_NONE);
        for (VideoType next : videoTypes) {
            String typeName = next.getClass().getSimpleName();
            if (skipQT && typeName.contains(ENGINE_QUICKTIME) || skipXuggle && typeName.contains(ENGINE_XUGGLE)) continue;
            available.add(next);
        }
        return available.toArray(new VideoType[0]);
    }

    public static void setCanceled(boolean cancel) {
        canceled = cancel;
    }

    public static boolean isCanceled() {
        return canceled;
    }

    public static Video getVideo(String path, VideoType vidType) {
        OSPLog.fine("path: " + path + " type: " + vidType);
        Video video2 = null;
        VideoIO.setCanceled(false);
        if (vidType != null) {
            OSPLog.finest("requested type " + vidType.getClass().getSimpleName() + " " + vidType.getDescription());
            video2 = vidType.getVideo(path);
            if (video2 != null) {
                return video2;
            }
        }
        if (VideoIO.isCanceled()) {
            return null;
        }
        String extension = XML.getExtension(path);
        VideoType[] allTypes = VideoIO.getVideoTypesForExtension(extension);
        ArrayList<VideoType> allowedTypes = new ArrayList<VideoType>();
        boolean skipQT = VideoIO.getEngine().equals(ENGINE_XUGGLE) || VideoIO.getEngine().equals(ENGINE_NONE);
        boolean skipXuggle = VideoIO.getEngine().equals(ENGINE_QUICKTIME) || VideoIO.getEngine().equals(ENGINE_NONE);
        int i = 0;
        while (i < allTypes.length) {
            String typeName = allTypes[i].getClass().getSimpleName();
            if (!(skipQT && typeName.contains(ENGINE_QUICKTIME) || skipXuggle && typeName.contains(ENGINE_XUGGLE))) {
                allowedTypes.add(allTypes[i]);
            }
            ++i;
        }
        for (VideoType next : allowedTypes) {
            OSPLog.finest("preferred type " + next.getClass().getSimpleName() + " " + next.getDescription());
            video2 = next.getVideo(path);
            if (VideoIO.isCanceled()) {
                return null;
            }
            if (video2 == null) continue;
            return video2;
        }
        return null;
    }

    public static Video getVideo(String path, ArrayList<VideoType> engines, JComponent component, JFrame frame) {
        int response;
        String engine = VideoIO.getEngine();
        engine = ENGINE_NONE.equals(engine) ? MediaRes.getString("VideoIO.Engine.None") : (ENGINE_XUGGLE.equals(engine) ? MediaRes.getString("XuggleVideoType.Description") : MediaRes.getString("QTVideoType.Description"));
        String message = String.valueOf(MediaRes.getString("VideoIO.Dialog.TryDifferentEngine.Message1")) + " (" + engine + ").";
        message = String.valueOf(message) + "\n" + MediaRes.getString("VideoIO.Dialog.TryDifferentEngine.Message2");
        message = String.valueOf(message) + "\n\n" + MediaRes.getString("VideoIO.Dialog.Label.Path") + ": " + path;
        ArrayList<String> optionList = new ArrayList<String>();
        for (VideoType next : engines) {
            if (next.getClass().getSimpleName().equals("XuggleVideoType")) {
                optionList.add(MediaRes.getString("XuggleVideoType.Description"));
                continue;
            }
            if (!next.getClass().getSimpleName().equals("QTVideoType")) continue;
            optionList.add(MediaRes.getString("QTVideoType.Description"));
        }
        optionList.add(MediaRes.getString("Dialog.Button.Cancel"));
        Object[] options = optionList.toArray(new String[optionList.size()]);
        JPanel messagePanel = new JPanel(new BorderLayout());
        JTextArea textArea = new JTextArea();
        textArea.setText(message);
        textArea.setOpaque(false);
        textArea.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 4));
        messagePanel.add((Component)textArea, "North");
        if (component != null) {
            component.setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
            messagePanel.add((Component)component, "South");
        }
        if ((response = JOptionPane.showOptionDialog(frame, messagePanel, MediaRes.getString("VideoClip.Dialog.BadVideo.Title"), 1, 2, null, options, options[0])) >= 0 && response < options.length - 1) {
            VideoType desiredType = engines.get(response);
            Video video2 = VideoIO.getVideo(path, desiredType);
            if (video2 == null && !VideoIO.isCanceled()) {
                JOptionPane.showMessageDialog(frame, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadVideo.Message")) + "\n\n" + path, MediaRes.getString("VideoClip.Dialog.BadVideo.Title"), 2);
            }
            return video2;
        }
        return null;
    }

    public static Video clone(Video video2) {
        if (video2 == null) {
            return null;
        }
        if (video2 instanceof ImageVideo) {
            ImageVideo oldVid = (ImageVideo)video2;
            ImageVideo newVid = new ImageVideo(oldVid.getImages());
            newVid.rawImage = newVid.images[0];
            ArrayList<Filter> filters = video2.getFilterStack().getFilters();
            if (filters != null) {
                for (Filter filter : filters) {
                    newVid.getFilterStack().addFilter(filter);
                }
            }
            return newVid;
        }
        XMLControlElement control = new XMLControlElement(video2);
        return (Video)new XMLControlElement(control).loadObject(null);
    }

    public static File open(VideoPanel vidPanel) {
        return VideoIO.open(null, vidPanel);
    }

    public static File[] getChooserFiles(String type) {
        JFileChooser chooser = VideoIO.getChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(true);
        int result = 1;
        if (type.toLowerCase().equals("open")) {
            chooser.addChoosableFileFilter(videoFileFilter);
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
            result = chooser.showOpenDialog(null);
        } else if (type.toLowerCase().equals("open video")) {
            chooser.addChoosableFileFilter(videoFileFilter);
            result = chooser.showOpenDialog(null);
        } else if (type.toLowerCase().equals("save")) {
            String filename = MediaRes.getString("VideoIO.FileName.Untitled");
            chooser.setSelectedFile(new File(String.valueOf(filename) + "." + defaultXMLExt));
            result = chooser.showSaveDialog(null);
        } else if (type.toLowerCase().equals("insert image")) {
            chooser.setMultiSelectionEnabled(true);
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.addChoosableFileFilter(imageFileFilter);
            chooser.setSelectedFile(new File(""));
            result = chooser.showOpenDialog(null);
            File[] files = chooser.getSelectedFiles();
            chooser.removeChoosableFileFilter(imageFileFilter);
            chooser.setSelectedFile(new File(""));
            if (result == 0) {
                return files;
            }
        }
        if (result == 0) {
            File file = chooser.getSelectedFile();
            chooser.removeChoosableFileFilter(videoFileFilter);
            chooser.setSelectedFile(new File(""));
            return new File[]{file};
        }
        return null;
    }

    public static File open(File file, VideoPanel vidPanel) {
        File[] files;
        if (file == null && (files = VideoIO.getChooserFiles("open")) != null) {
            file = files[0];
        }
        if (file == null) {
            return null;
        }
        if (videoFileFilter.accept(file)) {
            VideoType[] types = VideoIO.getVideoTypes();
            Video video2 = null;
            int i = 0;
            while (i < types.length) {
                video2 = types[i].getVideo(file.getAbsolutePath());
                if (video2 != null) {
                    OSPLog.info(String.valueOf(file.getName()) + " opened as type " + types[i].getDescription());
                    break;
                }
                OSPLog.info(String.valueOf(file.getName()) + " failed as type " + types[i].getDescription());
                ++i;
            }
            if (video2 != null) {
                vidPanel.setVideo(video2);
                vidPanel.repaint();
            } else {
                JOptionPane.showMessageDialog(vidPanel, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadVideo.Message")) + ResourceLoader.getNonURIPath(XML.getAbsolutePath(file)));
            }
        } else {
            XMLControlElement control = new XMLControlElement();
            control.read(file.getAbsolutePath());
            Class<?> type = control.getObjectClass();
            if (VideoPanel.class.isAssignableFrom(type)) {
                vidPanel.setDataFile(file);
                control.loadObject(vidPanel);
            } else {
                if (!control.failedToRead()) {
                    JOptionPane.showMessageDialog(vidPanel, "\"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.XMLMismatch.Message"), MediaRes.getString("VideoIO.Dialog.XMLMismatch.Title"), 2);
                    return null;
                }
                JOptionPane.showMessageDialog(vidPanel, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadFile.Message")) + ResourceLoader.getNonURIPath(XML.getAbsolutePath(file)));
            }
            vidPanel.changed = false;
        }
        return file;
    }

    public static File save(File file, VideoPanel vidPanel) {
        return VideoIO.save(file, vidPanel, MediaRes.getString("VideoIO.Dialog.SaveAs.Title"));
    }

    public static File save(File file, VideoPanel vidPanel, String chooserTitle) {
        Video video2;
        if (file == null) {
            int i;
            video2 = vidPanel.getVideo();
            JFileChooser chooser = VideoIO.getChooser();
            chooser.removeChoosableFileFilter(videoFileFilter);
            chooser.removeChoosableFileFilter(imageFileFilter);
            chooser.setDialogTitle(chooserTitle);
            String filename = MediaRes.getString("VideoIO.FileName.Untitled");
            if (vidPanel.getFilePath() != null) {
                filename = XML.stripExtension(vidPanel.getFilePath());
            } else if (video2 != null && video2.getProperty("name") != null && (i = (filename = (String)video2.getProperty("name")).lastIndexOf(".")) > 0) {
                filename = filename.substring(0, i);
            }
            file = new File(String.valueOf(filename) + "." + defaultXMLExt);
            String parent = XML.getDirectoryPath(filename);
            if (!parent.equals("")) {
                XML.createFolders(parent);
                chooser.setCurrentDirectory(new File(parent));
            }
            chooser.setSelectedFile(file);
            int result = chooser.showSaveDialog(vidPanel);
            if (result == 0) {
                int selected;
                file = chooser.getSelectedFile();
                if (!defaultXMLExt.equals(VideoIO.getExtension(file))) {
                    filename = XML.stripExtension(file.getPath());
                    file = new File(String.valueOf(filename) + "." + defaultXMLExt);
                }
                if (file.exists() && (selected = JOptionPane.showConfirmDialog(vidPanel, " \"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.FileExists.Message"), MediaRes.getString("VideoIO.Dialog.FileExists.Title"), 2)) != 0) {
                    return null;
                }
                vidPanel.setDataFile(file);
            } else {
                return null;
            }
        }
        if ((video2 = vidPanel.getVideo()) != null) {
            video2.setProperty("base", XML.getDirectoryPath(XML.getAbsolutePath(file)));
            if (video2 instanceof ImageVideo) {
                ((ImageVideo)video2).saveInvalidImages();
            }
        }
        XMLControlElement xmlControl = new XMLControlElement(vidPanel);
        xmlControl.write(file.getAbsolutePath());
        vidPanel.changed = false;
        return file;
    }

    public static File writeImageFile(BufferedImage image, String filePath) {
        if (image == null) {
            return null;
        }
        File file = new File(filePath);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        String ext = XML.getExtension(filePath);
        try {
            if (ImageIO.write((RenderedImage)image, ext, file)) {
                return file;
            }
        }
        catch (IOException ex) {
            OSPLog.finer(ex.toString());
        }
        return null;
    }

    public static double guessXuggleVersion() {
        File xuggleJar = ExtensionsManager.getManager().getXuggleJar();
        if (xuggleJar != null) {
            return xuggleJar.length() < 1000000L ? 3.4 : 5.4;
        }
        return 0.0;
    }

    public static class StreamPiper
    implements Runnable {
        private final InputStream input;
        private final OutputStream output;

        public StreamPiper(InputStream in, OutputStream out) {
            this.input = in;
            this.output = out;
        }

        @Override
        public void run() {
            try {
                byte[] buffer = new byte[1024];
                int count = 0;
                while ((count = this.input.read(buffer)) >= 0) {
                    this.output.write(buffer, 0, count);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected static class VideoEnginePanel
    extends JPanel
    implements PropertyChangeListener {
        JPanel emptyPanel;
        File selectedFile;
        ButtonGroup videoEngineButtonGroup = new ButtonGroup();
        HashMap<JRadioButton, VideoType> buttonMap = new HashMap();
        TitledBorder title;
        boolean isClosing = false;

        VideoEnginePanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.title = BorderFactory.createTitledBorder(MediaRes.getString("VideoEnginePanel.TitledBorder.Title"));
            this.setBorder(this.title);
            this.emptyPanel = new JPanel(){

                @Override
                public Dimension getPreferredSize() {
                    return videoEnginePanel.getPreferredSize();
                }
            };
        }

        public void addVideoEngine(VideoType type) {
            JRadioButton button = new JRadioButton(type.getDescription());
            button.setActionCommand(type.getClass().getSimpleName());
            this.videoEngineButtonGroup.add(button);
            this.buttonMap.put(button, type);
            this.add(button);
        }

        public VideoType getSelectedVideoType() {
            if (chooser.getAccessory() == null || chooser.getAccessory() == this.emptyPanel) {
                return null;
            }
            for (JRadioButton button : this.buttonMap.keySet()) {
                if (!button.isSelected()) continue;
                VideoType engineType = this.buttonMap.get(button);
                OSPLog.finest("selected video type: " + engineType);
                String engineName = engineType.getClass().getSimpleName();
                String ext = XML.getExtension(this.selectedFile.getName());
                VideoType specificType = VideoIO.getVideoType(engineName, ext);
                return specificType == null ? engineType : specificType;
            }
            return null;
        }

        public void reset() {
            this.isClosing = false;
            this.refresh();
        }

        public void refresh() {
            if (this.isClosing) {
                return;
            }
            this.selectedFile = chooser.getSelectedFile();
            if (this.buttonMap.size() < 2) {
                chooser.setAccessory(null);
                chooser.validate();
                return;
            }
            int count = 0;
            boolean isButtonSelected = false;
            for (JRadioButton button : this.buttonMap.keySet()) {
                if (button.isSelected()) {
                    isButtonSelected = true;
                }
                VideoType type = this.buttonMap.get(button);
                VideoFileFilter[] videoFileFilterArray = type.getFileFilters();
                int n = videoFileFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VideoFileFilter filter = videoFileFilterArray[n2];
                    if (this.selectedFile != null && ((FileFilter)filter).accept(this.selectedFile)) {
                        ++count;
                    }
                    ++n2;
                }
            }
            if (count < 2) {
                chooser.setAccessory(this.emptyPanel);
            } else {
                chooser.setAccessory(videoEnginePanel);
                if (!isButtonSelected) {
                    for (JRadioButton button : this.buttonMap.keySet()) {
                        button.setSelected(button.getActionCommand().contains(VideoIO.getEngine()));
                    }
                }
            }
            chooser.validate();
            chooser.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.toLowerCase().indexOf("closing") > -1) {
                this.isClosing = true;
            } else {
                if (chooser.getAccessory() == null) {
                    return;
                }
                if (name.equals("SelectedFileChangedProperty")) {
                    this.refresh();
                }
            }
        }
    }
}

