/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.VideoClip;

public class VideoClipControl
extends ClipControl {
    protected VideoClipControl(VideoClip videoClip) {
        super(videoClip);
        this.video.addPropertyChangeListener(this);
    }

    @Override
    public void play() {
        this.video.play();
    }

    @Override
    public void stop() {
        this.video.stop();
    }

    @Override
    public void step() {
        this.video.stop();
        this.setStepNumber(this.stepNumber + 1);
    }

    @Override
    public void back() {
        this.video.stop();
        this.setStepNumber(this.stepNumber - 1);
    }

    @Override
    public void setStepNumber(int n) {
        if (n == this.stepNumber && this.clip.stepToFrame(n) == this.getFrameNumber()) {
            return;
        }
        n = Math.max(0, n);
        final int stepNum = Math.min(this.clip.getStepCount() - 1, n);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                int m = VideoClipControl.this.clip.stepToFrame(stepNum) + VideoClipControl.this.clip.getFrameShift();
                VideoClipControl.this.video.setFrameNumber(m);
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    @Override
    public int getStepNumber() {
        return this.clip.frameToStep(this.video.getFrameNumber());
    }

    @Override
    public void setRate(double newRate) {
        if (newRate == 0.0 || newRate == this.rate) {
            return;
        }
        this.rate = Math.abs(newRate);
        this.video.setRate(this.rate);
    }

    @Override
    public double getRate() {
        return this.video.getRate();
    }

    @Override
    public void setLooping(boolean loops) {
        if (loops == this.isLooping()) {
            return;
        }
        this.video.setLooping(loops);
    }

    @Override
    public boolean isLooping() {
        return this.video.isLooping();
    }

    @Override
    public int getFrameNumber() {
        int n = this.video.getFrameNumber() - this.clip.getFrameShift();
        n = Math.max(0, n);
        return n;
    }

    @Override
    public boolean isPlaying() {
        return this.video.isPlaying();
    }

    @Override
    public double getTime() {
        int n = this.video.getFrameNumber();
        return (this.video.getFrameTime(n) - this.video.getStartTime()) * this.timeStretch;
    }

    @Override
    public double getStepTime(int stepNumber) {
        int n = this.clip.stepToFrame(stepNumber);
        return (this.video.getFrameTime(n) - this.video.getStartTime()) * this.timeStretch;
    }

    @Override
    public void setFrameDuration(double duration) {
        if (duration == 0.0) {
            return;
        }
        duration = Math.abs(duration);
        double ti = this.video.getFrameTime(this.video.getStartFrameNumber());
        double tf = this.video.getFrameTime(this.video.getEndFrameNumber());
        int count = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
        if (count != 0) {
            this.timeStretch = duration * (double)count / (tf - ti);
        }
        this.support.firePropertyChange("frameduration", null, new Double(duration));
    }

    @Override
    public double getMeanFrameDuration() {
        int count = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
        if (count != 0) {
            double ti = this.video.getFrameTime(this.video.getStartFrameNumber());
            double tf = this.video.getFrameTime(this.video.getEndFrameNumber());
            return this.timeStretch * (tf - ti) / (double)count;
        }
        return this.timeStretch * this.video.getDuration() / (double)this.video.getFrameCount();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("framenumber")) {
            int n = (Integer)e.getNewValue();
            if (n == this.videoFrameNumber) {
                super.setFrameNumber(n - this.clip.getFrameShift());
                return;
            }
            super.setFrameNumber(n - this.clip.getFrameShift());
            Integer nInt = new Integer(this.stepNumber);
            this.support.firePropertyChange("stepnumber", null, nInt);
        } else if (name.equals("playing")) {
            this.support.firePropertyChange(e);
        } else if (name.equals("rate") || name.equals("looping")) {
            this.support.firePropertyChange(e);
        } else {
            super.propertyChange(e);
        }
    }

    @Override
    public void dispose() {
        this.video.removePropertyChangeListener(this);
    }

    public static XML.ObjectLoader getLoader() {
        return new ClipControl.Loader();
    }
}

