/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.geom.AffineTransform;

public class TransformArray {
    private AffineTransform[] array;
    private int length;

    public TransformArray(int initialLength) {
        this.length = initialLength;
        this.array = new AffineTransform[this.length];
        this.array[0] = new AffineTransform();
        this.fill(this.array[0]);
    }

    public AffineTransform get(int n) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        return this.array[n];
    }

    public void setLength(int newLength) {
        if (newLength == this.length || newLength < 1) {
            return;
        }
        AffineTransform[] newArray = new AffineTransform[newLength];
        System.arraycopy(this.array, 0, newArray, 0, Math.min(newLength, this.length));
        this.array = newArray;
        if (newLength > this.length) {
            AffineTransform at = this.array[this.length - 1];
            this.length = newLength;
            this.fill(at);
        } else {
            this.length = newLength;
        }
    }

    private void fill(AffineTransform at) {
        int n = 0;
        while (n < this.length) {
            if (this.array[n] == null) {
                this.array[n] = new AffineTransform(at);
            }
            ++n;
        }
    }
}

