/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VidCartesianCoordinateStringBuilder;
import org.opensourcephysics.media.core.VideoPanel;

public class TPoint
extends Point2D.Double
implements Interactive,
Trackable {
    protected static boolean coordsVisibleInMouseBox = true;
    protected static VidCartesianCoordinateStringBuilder coordinateStrBuilder = new VidCartesianCoordinateStringBuilder();
    protected boolean enabled = true;
    protected boolean trackEditTrigger = false;
    protected boolean coordsEditTrigger = false;
    protected boolean stepEditTrigger = false;
    protected boolean isAdjusting = false;
    protected Point screenPt;
    protected Point2D worldPt;
    protected PropertyChangeSupport support;
    protected TPoint attachedTo;

    public TPoint() {
        this(0.0, 0.0);
    }

    public TPoint(double x, double y) {
        super(x, y);
    }

    public TPoint(Point2D point) {
        this(point.getX(), point.getY());
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        return null;
    }

    @Override
    public void setX(double x) {
        this.setXY(x, this.getY());
    }

    @Override
    public void setY(double y) {
        this.setXY(this.getX(), y);
    }

    @Override
    public void setXY(double x, double y) {
        this.setLocation(x, y);
    }

    @Override
    public void setLocation(double x, double y) {
        if (this.getX() == x && this.getY() == y) {
            return;
        }
        super.setLocation(x, y);
        if (this.support != null) {
            this.support.firePropertyChange("location", null, this);
        }
    }

    public int getFrameNumber(VideoPanel vidPanel) {
        return vidPanel.getFrameNumber();
    }

    public Point getScreenPosition(VideoPanel vidPanel) {
        AffineTransform toScreen = vidPanel.getPixelTransform();
        if (!vidPanel.isDrawingInImageSpace()) {
            int n = this.getFrameNumber(vidPanel);
            toScreen.concatenate(vidPanel.getCoords().getToWorldTransform(n));
        }
        if (this.screenPt == null) {
            this.screenPt = new Point();
        }
        toScreen.transform(this, this.screenPt);
        return this.screenPt;
    }

    public void setScreenPosition(int x, int y, VideoPanel vidPanel) {
        if (this.screenPt == null) {
            this.screenPt = new Point();
        }
        if (this.worldPt == null) {
            this.worldPt = new Point2D.Double();
        }
        this.screenPt.setLocation(x, y);
        AffineTransform toScreen = vidPanel.getPixelTransform();
        if (!vidPanel.isDrawingInImageSpace()) {
            int n = this.getFrameNumber(vidPanel);
            toScreen.concatenate(vidPanel.getCoords().getToWorldTransform(n));
        }
        try {
            toScreen.inverseTransform(this.screenPt, this.worldPt);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        this.setXY(this.worldPt.getX(), this.worldPt.getY());
    }

    public void setScreenPosition(int x, int y, VideoPanel vidPanel, InputEvent e) {
        this.setScreenPosition(x, y, vidPanel);
    }

    public Point2D getWorldPosition(VideoPanel vidPanel) {
        int n = this.getFrameNumber(vidPanel);
        AffineTransform at = vidPanel.getCoords().getToWorldTransform(n);
        if (this.worldPt == null) {
            this.worldPt = new Point2D.Double();
        }
        return at.transform(this, this.worldPt);
    }

    public void setWorldPosition(double x, double y, VideoPanel vidPanel) {
        int n = this.getFrameNumber(vidPanel);
        AffineTransform at = vidPanel.getCoords().getToWorldTransform(n);
        if (this.worldPt == null) {
            this.worldPt = new Point2D.Double();
        }
        this.worldPt.setLocation(x, y);
        try {
            at.inverseTransform(this.worldPt, this.worldPt);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        this.setXY(this.worldPt.getX(), this.worldPt.getY());
    }

    public void showCoordinates(VideoPanel vidPanel) {
        if (coordsVisibleInMouseBox) {
            this.getWorldPosition(vidPanel);
            String s = coordinateStrBuilder.getCoordinateString(this.worldPt.getX(), this.worldPt.getY());
            vidPanel.setMessage(s, 0);
        }
    }

    public void attachTo(TPoint p) {
        if (p == null || p == this) {
            return;
        }
        this.detach();
        this.attachedTo = p;
        p.addPropertyChangeListener("location", new Follower());
        this.setXY(p.getX(), p.getY());
    }

    public void detach() {
        if (this.attachedTo != null) {
            PropertyChangeListener[] listeners;
            PropertyChangeListener[] propertyChangeListenerArray = listeners = this.attachedTo.support.getPropertyChangeListeners("location");
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Follower follower;
                PropertyChangeListener next = propertyChangeListenerArray[n2];
                if (next instanceof Follower && (follower = (Follower)next).getTarget() == this) {
                    this.attachedTo.removePropertyChangeListener("location", next);
                }
                ++n2;
            }
            this.attachedTo = null;
        }
    }

    public boolean isAttached() {
        return this.attachedTo != null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setTrackEditTrigger(boolean edit) {
        this.trackEditTrigger = edit;
    }

    public boolean isTrackEditTrigger() {
        return this.trackEditTrigger;
    }

    public void setCoordsEditTrigger(boolean edit) {
        this.coordsEditTrigger = edit;
    }

    public boolean isCoordsEditTrigger() {
        return this.coordsEditTrigger;
    }

    public void setStepEditTrigger(boolean stepEditTrigger) {
        this.stepEditTrigger = stepEditTrigger;
    }

    public boolean isStepEditTrigger() {
        return this.stepEditTrigger;
    }

    public Rectangle getBounds(VideoPanel vidPanel) {
        return null;
    }

    @Override
    public boolean isMeasured() {
        return false;
    }

    @Override
    public double getXMin() {
        return this.getX();
    }

    @Override
    public double getXMax() {
        return this.getX();
    }

    @Override
    public double getYMin() {
        return this.getY();
    }

    @Override
    public double getYMax() {
        return this.getY();
    }

    public double angle(double x, double y) {
        return Math.atan2(y - this.getY(), x - this.getX());
    }

    public double angle(Point2D pt) {
        return Math.atan2(pt.getY() - this.getY(), pt.getX() - this.getX());
    }

    public double sin(double x, double y) {
        return (this.getY() - y) / this.distance(x, y);
    }

    public double sin(Point2D pt) {
        return (this.getY() - pt.getY()) / this.distance(pt);
    }

    public double cos(double x, double y) {
        return (x - this.getX()) / this.distance(x, y);
    }

    public double cos(Point2D pt) {
        return (pt.getX() - this.getX()) / this.distance(pt);
    }

    public void center(Point2D pt1, Point2D pt2) {
        double x = (pt1.getX() + pt2.getX()) / 2.0;
        double y = (pt1.getY() + pt2.getY()) / 2.0;
        this.setLocation(x, y);
    }

    public void translate(double dx, double dy) {
        this.setXY(this.getX() + dx, this.getY() + dy);
    }

    public void setAdjusting(boolean adjusting) {
        this.isAdjusting = adjusting;
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.support == null) {
            this.support = new SwingPropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (this.support == null) {
            this.support = new SwingPropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.support != null) {
            this.support.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(property, listener);
    }

    @Override
    public String toString() {
        return "TPoint [" + this.x + ", " + this.y + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TPoint p = (TPoint)obj;
        return p.getX() == this.getX() && p.getY() == this.getY() && p.screenPt == this.screenPt && p.worldPt == this.worldPt;
    }

    public void setPositionOnLine(int xScreen, int yScreen, VideoPanel vidPanel, TPoint end1, TPoint end2) {
        if (this.screenPt == null) {
            this.screenPt = new Point();
        }
        if (this.worldPt == null) {
            this.worldPt = new Point2D.Double();
        }
        this.screenPt.setLocation(xScreen, yScreen);
        AffineTransform toScreen = vidPanel.getPixelTransform();
        if (!vidPanel.isDrawingInImageSpace()) {
            int n = this.getFrameNumber(vidPanel);
            toScreen.concatenate(vidPanel.getCoords().getToWorldTransform(n));
        }
        try {
            toScreen.inverseTransform(this.screenPt, this.worldPt);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        double dx = end2.getX() - end1.getX();
        double dy = end2.getY() - end1.getY();
        double u = ((this.worldPt.getX() - end1.getX()) * dx + (this.worldPt.getY() - end1.getY()) * dy) / end1.distanceSq(end2);
        if (Double.isNaN(u)) {
            u = 0.0;
        }
        double xLine = end1.getX() + u * dx;
        double yLine = end1.getY() + u * dy;
        this.setLocation(xLine, yLine);
    }

    private class Follower
    implements PropertyChangeListener {
        private Follower() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            TPoint p = (TPoint)e.getSource();
            TPoint.this.setXY(p.getX(), p.getY());
        }

        public TPoint getTarget() {
            return TPoint.this;
        }
    }
}

