/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.Drawable3D;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetTracePoint;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.displayejs.Style;

public class InteractiveTrace
extends AbstractInteractiveElement
implements Data,
LogMeasurable {
    public static final int SHOW_ALL = 0;
    public static final int ORDER_OF_APPEARANCE = 1;
    public static final int X_COORDINATE = 2;
    public static final int Y_COORDINATE = 3;
    public static final int Z_COORDINATE = 4;
    public static final int BAR = 14;
    public static final int POST = 15;
    public static final int AREA = 16;
    private static final int MAX_POINTS = 100000;
    protected boolean connected = true;
    protected boolean ignore = false;
    protected boolean active = true;
    protected boolean clearAtInput = false;
    protected int maxPoints = 100000;
    protected int skip = 0;
    protected int shapeSize;
    protected int drivenBy = 0;
    protected int memorySets = 1;
    private int shapeType = -1;
    protected Color memoryColor = null;
    protected String name = "trace";
    protected Dataset dataset = null;
    private int counter = 0;
    private int pointsAdded = 0;
    private int pointsNotProjected = 0;
    private double[] point = new double[3];
    private String xLabel = "x";
    private String yLabel = "y";
    private String zLabel = "z";
    protected ArrayList<OnePoint> list;
    protected ArrayList<OnePoint> displayList;
    private OnePoint nullPoint;
    private OnePoint lastPoint = this.nullPoint = new OnePoint(this, Double.NaN, Double.NaN, Double.NaN, false, 0, this.style);
    private OnePoint flushPoint = this.nullPoint;
    private Object3D[] minimalObjects = new Object3D[1];
    private AffineTransform transform = new AffineTransform();
    private ArrayList<ArrayList<OnePoint>> memoryLists = new ArrayList();
    protected double xmaxLogscale;
    protected double ymaxLogscale;
    protected double xminLogscale;
    protected double yminLogscale;
    private boolean showZ = false;
    private boolean allowTable = false;
    protected int datasetID = this.hashCode();

    public InteractiveTrace() {
        this.list = new ArrayList();
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void setName(String _name) {
        this.name = _name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void copyFrom(InteractiveElement _element) {
        super.copyFrom(_element);
        if (_element instanceof InteractiveTrace) {
            this.setMaximumPoints(((InteractiveTrace)_element).getMaximumPoints());
            this.setConnected(((InteractiveTrace)_element).isConnected());
            this.setIgnoreEqualPoints(((InteractiveTrace)_element).isIgnoreEqualPoints());
            this.setActive(((InteractiveTrace)_element).isActive());
            this.setSkip(((InteractiveTrace)_element).getSkip());
            this.setMemorySets(((InteractiveTrace)_element).getMemorySets());
            this.setMemoryColor(((InteractiveTrace)_element).getMemoryColor());
            this.setName(((InteractiveTrace)_element).getName());
            this.setAllowTable(((InteractiveTrace)_element).allowTable);
        }
    }

    @Override
    public void initializeMemberOfSet() {
        this.setAllowTable(true);
    }

    public void setMaximumPoints(int _n) {
        if (_n < 0 || _n == this.maxPoints) {
            return;
        }
        this.maxPoints = _n == 0 ? 100000 : _n;
        this.counter = 0;
        this.initialize();
    }

    public int getMaximumPoints() {
        return this.maxPoints;
    }

    public void setConnected(boolean connect) {
        this.connected = connect;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setIgnoreEqualPoints(boolean ignoreEqual) {
        this.ignore = ignoreEqual;
    }

    public boolean isIgnoreEqualPoints() {
        return this.ignore;
    }

    public void setActive(boolean acceptInput) {
        this.active = acceptInput;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setClearAtInput(boolean _clear) {
        this.clearAtInput = _clear;
    }

    public boolean isClearAtInput() {
        return this.clearAtInput;
    }

    public void setSkip(int howMany) {
        if (howMany == this.skip) {
            return;
        }
        this.skip = howMany;
        this.counter = 0;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setMemorySets(int howMany) {
        if (howMany == this.memorySets || howMany < 0) {
            return;
        }
        this.memoryLists.clear();
        this.memorySets = howMany;
    }

    public int getMemorySets() {
        return this.memorySets;
    }

    public void setMemoryDrivenBy(int driving) {
        this.drivenBy = driving;
    }

    public int getMemoryDrivenBy() {
        return this.drivenBy;
    }

    public void setMemoryColor(Color _color) {
        this.memoryColor = _color;
    }

    public Color getMemoryColor() {
        return this.memoryColor;
    }

    public void setAllowTable(boolean _allow) {
        this.allowTable = _allow;
    }

    public void setXLabel(String _label) {
        this.xLabel = _label;
    }

    public void setYLabel(String _label) {
        this.yLabel = _label;
    }

    public void setZLabel(String _label) {
        this.zLabel = _label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        ArrayList<Object> arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
        arrayList = this.memoryLists;
        synchronized (arrayList) {
            this.memoryLists.clear();
        }
        this.pointsNotProjected = 0;
        this.pointsAdded = 0;
        this.lastPoint = this.nullPoint;
        this.flushPoint = this.nullPoint;
        this.counter = 0;
        this.showZ = false;
    }

    public synchronized void initialize() {
        if (this.memorySets == 1) {
            return;
        }
        this.pointsNotProjected = 0;
        this.pointsAdded = 0;
        this.lastPoint = this.nullPoint;
        this.flushPoint = this.nullPoint;
        if (this.list.size() <= 0) {
            return;
        }
        switch (this.memorySets) {
            default: {
                if (this.memoryLists.size() < this.memorySets - 1) break;
                this.memoryLists.remove(0);
            }
            case 0: 
        }
        if (this.memoryColor != null) {
            for (OnePoint onePoint : this.list) {
                onePoint.pointStyle.setEdgeColor(this.memoryColor);
            }
        }
        this.memoryLists.add(this.list);
        this.list = new ArrayList();
    }

    public void addPoint(double xInput, double yInput) {
        if (this.clearAtInput) {
            this.clear();
        }
        this.addThePoint(xInput, yInput, 0.0);
    }

    public void addPoints(double[] xInput, double[] yInput) {
        if (this.clearAtInput) {
            this.clear();
        }
        int n = Math.min(xInput.length, yInput.length);
        int i = 0;
        while (i < n) {
            this.addThePoint(xInput[i], yInput[i], 0.0);
            ++i;
        }
    }

    public void addPoint(double xInput, double yInput, double zInput) {
        if (this.clearAtInput) {
            this.clear();
        }
        this.showZ = true;
        this.addThePoint(xInput, yInput, zInput);
    }

    public void addPoints(double[] xInput, double[] yInput, double[] zInput) {
        if (this.clearAtInput) {
            this.clear();
        }
        int n = Math.min(Math.min(xInput.length, yInput.length), zInput.length);
        int i = 0;
        while (i < n) {
            this.addThePoint(xInput[i], yInput[i], zInput[i]);
            ++i;
        }
    }

    public void moveToPoint(double xInput, double yInput) {
        if (this.clearAtInput) {
            this.clear();
        }
        boolean was_connected = this.connected;
        this.connected = false;
        this.addThePoint(xInput, yInput, 0.0);
        this.connected = was_connected;
    }

    public void moveToPoint(double xInput, double yInput, double zInput) {
        if (this.clearAtInput) {
            this.clear();
        }
        this.showZ = true;
        boolean was_connected = this.connected;
        this.connected = false;
        this.addThePoint(xInput, yInput, zInput);
        this.connected = was_connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThePoint(double xInput, double yInput, double zInput) {
        if (Double.isNaN(xInput) || Double.isNaN(yInput) || Double.isNaN(zInput)) {
            return;
        }
        if (this.ignore && xInput == this.lastPoint.coordinates[0] && yInput == this.lastPoint.coordinates[1] && zInput == this.lastPoint.coordinates[2]) {
            return;
        }
        if (this.skip > 0) {
            if (this.counter > 0) {
                ++this.counter;
                if (this.counter >= this.skip) {
                    this.counter = 0;
                }
                this.lastPoint = this.flushPoint = new OnePoint(this, xInput, yInput, zInput, this.connected && this.pointsAdded != 0, this.shapeType, this.style);
                return;
            }
            ++this.counter;
        }
        this.flushPoint = this.nullPoint;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            if (this.maxPoints > 0 && this.list.size() >= this.maxPoints) {
                this.list.remove(0);
                if (!this.list.isEmpty()) {
                    this.list.get((int)0).isConnected = false;
                }
            }
            this.lastPoint = new OnePoint(this, xInput, yInput, zInput, this.connected && this.pointsAdded != 0, this.shapeType, this.style);
            this.list.add(this.lastPoint);
        }
        ++this.pointsAdded;
        ++this.pointsNotProjected;
    }

    public void setShapeType(int _type) {
        if (this.shapeType == _type) {
            return;
        }
        this.shapeType = _type;
        switch (this.shapeType) {
            default: {
                this.style.displayObject = null;
                break;
            }
            case 1: {
                this.style.displayObject = new Ellipse2D.Float();
                break;
            }
            case 2: 
            case 14: 
            case 15: {
                this.style.displayObject = new Rectangle2D.Float();
                break;
            }
            case 3: {
                this.style.displayObject = new RoundRectangle2D.Float();
                break;
            }
            case 16: {
                this.style.displayObject = new Polygon();
            }
        }
        this.hasChanged = true;
    }

    public void setShapeSize(int _size) {
        if (this.shapeSize != _size) {
            this.shapeSize = _size;
            this.hasChanged = true;
        }
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getData2D() {
        double[][] data;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            int n = this.list.size();
            if (this.showZ) {
                data = this.flushPoint == this.nullPoint ? new double[3][n] : new double[3][n + 1];
                int i = 0;
                while (i < n) {
                    double[] coor = this.list.get((int)i).coordinates;
                    data[0][i] = coor[0];
                    data[1][i] = coor[1];
                    data[2][i] = coor[2];
                    ++i;
                }
                if (this.flushPoint != this.nullPoint) {
                    data[0][n] = this.flushPoint.coordinates[0];
                    data[1][n] = this.flushPoint.coordinates[1];
                    data[2][n] = this.flushPoint.coordinates[2];
                }
            } else {
                data = this.flushPoint == this.nullPoint ? new double[2][n] : new double[2][n + 1];
                int i = 0;
                while (i < n) {
                    double[] coor = this.list.get((int)i).coordinates;
                    data[0][i] = coor[0];
                    data[1][i] = coor[1];
                    ++i;
                }
                if (this.flushPoint != this.nullPoint) {
                    data[0][n] = this.flushPoint.coordinates[0];
                    data[1][n] = this.flushPoint.coordinates[1];
                }
            }
        }
        return data;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        String[] stringArray;
        if (this.showZ) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = this.xLabel;
            stringArray2[1] = this.yLabel;
            stringArray = stringArray2;
            stringArray2[2] = this.zLabel;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = this.xLabel;
            stringArray = stringArray3;
            stringArray3[1] = this.yLabel;
        }
        return stringArray;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, this.getStyle().getEdgeColor()};
    }

    @Override
    public Color[] getFillColors() {
        Color fillColor = this.getStyle().getFillPattern() instanceof Color ? (Color)this.getStyle().getFillPattern() : new Color(125, 125, 125);
        return new Color[]{Color.BLACK, fillColor};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        if (!this.visible) {
            return null;
        }
        if (_panel instanceof DrawingPanel3D) {
            if (this.hasChanged || _panel != this.panelWithValidProjection) {
                this.projectPoints(_panel, true);
            } else if (this.pointsNotProjected > 0) {
                this.projectPoints(_panel, false);
            }
        } else {
            this.projectPoints(_panel, true);
        }
        if (this.positionEnabled && Math.abs(this.lastPoint.pixel[0] - (double)_xpix) < (double)SENSIBILITY && Math.abs(this.lastPoint.pixel[1] - (double)_ypix) < (double)SENSIBILITY) {
            return new InteractionTargetTracePoint(this, new Point3D(this.lastPoint.coordinates[0], this.lastPoint.coordinates[1], this.lastPoint.coordinates[2]));
        }
        if (this.allowTable) {
            for (OnePoint onePoint : this.displayList) {
                if (!(Math.abs(onePoint.pixel[0] - (double)_xpix) < (double)SENSIBILITY) || !(Math.abs(onePoint.pixel[1] - (double)_ypix) < (double)SENSIBILITY)) continue;
                return this;
            }
        }
        return null;
    }

    @Override
    public Object3D[] getObjects3D(DrawingPanel3D _panel) {
        if (this.list.size() <= 0 || !this.visible) {
            return null;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel, true);
        } else if (this.pointsNotProjected > 0) {
            this.projectPoints(_panel, false);
        }
        return this.displayList.toArray(this.minimalObjects);
    }

    @Override
    public void draw(DrawingPanel3D _panel, Graphics2D _g, int _index) {
        try {
            OnePoint onePoint = this.displayList.get(_index);
            Color theColor = _panel.projectColor(onePoint.pointStyle.edgeColor, onePoint.distance);
            if (onePoint.isConnected) {
                OnePoint pointPrev = this.displayList.get(_index - 1);
                if (this.shapeType == 16) {
                    Paint theFillPattern = onePoint.pointStyle.fillPattern;
                    if (theFillPattern instanceof Color) {
                        theFillPattern = _panel.projectColor((Color)theFillPattern, onePoint.distance);
                    }
                    _g.setPaint(theFillPattern);
                    Polygon pol = (Polygon)onePoint.pointStyle.displayObject;
                    pol.reset();
                    pol.addPoint(pointPrev.zeroA, pointPrev.zeroB);
                    pol.addPoint((int)pointPrev.pixel[0], (int)pointPrev.pixel[1]);
                    pol.addPoint((int)onePoint.pixel[0], (int)onePoint.pixel[1]);
                    pol.addPoint(onePoint.zeroA, onePoint.zeroB);
                    pol.addPoint(pointPrev.zeroA, pointPrev.zeroB);
                    _g.fill(pol);
                }
                _g.setColor(theColor);
                _g.setStroke(onePoint.pointStyle.edgeStroke);
                _g.drawLine((int)onePoint.pixel[0], (int)onePoint.pixel[1], (int)pointPrev.pixel[0], (int)pointPrev.pixel[1]);
            }
            if (onePoint.pointStyle.displayObject != null) {
                Paint theFillPattern = onePoint.pointStyle.fillPattern;
                if (theFillPattern instanceof Color) {
                    theFillPattern = _panel.projectColor((Color)theFillPattern, onePoint.distance);
                }
                this.drawMarker(_g, onePoint, theColor, theFillPattern);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        if (this.list.size() <= 0 || !this.visible) {
            return;
        }
        this.projectPoints(_panel, true);
        Graphics2D g2 = (Graphics2D)_g;
        OnePoint pointPrev = null;
        for (OnePoint onePoint : this.displayList) {
            if (onePoint.isConnected) {
                if (this.shapeType == 16) {
                    g2.setPaint(onePoint.pointStyle.fillPattern);
                    Polygon pol = (Polygon)onePoint.pointStyle.displayObject;
                    pol.reset();
                    pol.addPoint(pointPrev.zeroA, pointPrev.zeroB);
                    pol.addPoint((int)pointPrev.pixel[0], (int)pointPrev.pixel[1]);
                    pol.addPoint((int)onePoint.pixel[0], (int)onePoint.pixel[1]);
                    pol.addPoint(onePoint.zeroA, onePoint.zeroB);
                    pol.addPoint(pointPrev.zeroA, pointPrev.zeroB);
                    g2.fill(pol);
                }
                if (onePoint.pointStyle.edgeColor != null) {
                    g2.setColor(onePoint.pointStyle.edgeColor);
                    g2.setStroke(onePoint.pointStyle.edgeStroke);
                    g2.drawLine((int)onePoint.pixel[0], (int)onePoint.pixel[1], (int)pointPrev.pixel[0], (int)pointPrev.pixel[1]);
                }
            }
            if (onePoint.pointStyle.displayObject != null) {
                this.drawMarker(g2, onePoint, onePoint.pointStyle.edgeColor, onePoint.pointStyle.fillPattern);
            }
            pointPrev = onePoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void projectPoints(DrawingPanel _panel, boolean forceProjection) {
        Iterator<ArrayList<OnePoint>> it;
        this.displayList = new ArrayList();
        if (this.memorySets != 1) {
            switch (this.drivenBy) {
                default: {
                    it = this.memoryLists.iterator();
                    while (it.hasNext()) {
                        this.displayList.addAll((Collection<OnePoint>)it.next());
                    }
                    break;
                }
                case 1: {
                    int n;
                    int i;
                    for (ArrayList<OnePoint> memory : this.memoryLists) {
                        i = 0;
                        n = Math.min(this.pointsAdded, memory.size());
                        while (i < n) {
                            this.displayList.add(memory.get(i));
                            ++i;
                        }
                    }
                    break;
                }
                case 2: {
                    OnePoint aPoint;
                    int n;
                    int i;
                    block12: for (ArrayList<OnePoint> memory : this.memoryLists) {
                        i = 0;
                        n = memory.size();
                        while (i < n) {
                            aPoint = memory.get(i);
                            if (!(aPoint.coordinates[0] <= this.lastPoint.coordinates[0])) continue block12;
                            this.displayList.add(aPoint);
                            ++i;
                        }
                    }
                    break;
                }
                case 3: {
                    OnePoint aPoint;
                    int n;
                    int i;
                    block14: for (ArrayList<OnePoint> memory : this.memoryLists) {
                        i = 0;
                        n = memory.size();
                        while (i < n) {
                            aPoint = memory.get(i);
                            if (!(aPoint.coordinates[1] <= this.lastPoint.coordinates[1])) continue block14;
                            this.displayList.add(aPoint);
                            ++i;
                        }
                    }
                    break;
                }
                case 4: {
                    OnePoint aPoint;
                    int n;
                    int i;
                    block16: for (ArrayList<OnePoint> memory : this.memoryLists) {
                        i = 0;
                        n = memory.size();
                        while (i < n) {
                            aPoint = memory.get(i);
                            if (!(aPoint.coordinates[2] <= this.lastPoint.coordinates[2])) continue block16;
                            this.displayList.add(aPoint);
                            ++i;
                        }
                    }
                }
            }
        }
        it = this.list;
        synchronized (it) {
            this.displayList.addAll((ArrayList)this.list.clone());
        }
        if (this.flushPoint != this.nullPoint) {
            this.displayList.add(this.flushPoint);
        }
        int i = 0;
        int n = this.displayList.size();
        while (i < n) {
            this.displayList.get(i).project(_panel, i, forceProjection);
            ++i;
        }
        this.hasChanged = false;
        this.panelWithValidProjection = _panel;
        this.pointsNotProjected = 0;
    }

    private void drawMarker(Graphics2D _g2, OnePoint _point, Color _color, Paint _fill) {
        if (this.shapeType == 16) {
            return;
        }
        if (!(_point.pointStyle.displayObject instanceof RectangularShape)) {
            _g2.setColor(_color);
            _g2.drawOval((int)_point.pixel[0], (int)_point.pixel[1], 1, 1);
            return;
        }
        RectangularShape shape = (RectangularShape)_point.pointStyle.displayObject;
        AffineTransform originalTransform = _g2.getTransform();
        this.transform.setTransform(originalTransform);
        this.transform.rotate(-_point.pointStyle.angle, _point.pixel[0], _point.pixel[1]);
        _g2.setTransform(this.transform);
        if (this.shapeType == 14) {
            if (_point.b1 < _point.zeroB) {
                shape.setFrame(_point.a1, _point.b1, this.shapeSize, _point.zeroB - _point.b1);
            } else {
                shape.setFrame(_point.a1, _point.zeroB, this.shapeSize, _point.b1 - _point.zeroB);
            }
        } else {
            shape.setFrame(_point.a1, _point.b1, this.shapeSize, this.shapeSize);
        }
        if (this.shapeType == 15) {
            _g2.setColor(_color);
            _g2.drawLine(_point.zeroA, _point.b1, _point.zeroA, _point.zeroB);
        }
        if (_fill != null) {
            _g2.setPaint(_fill);
            _g2.fill(shape);
        }
        _g2.setColor(_color);
        _g2.setStroke(_point.pointStyle.edgeStroke);
        _g2.draw(shape);
        _g2.setTransform(originalTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMinLogscale() {
        double xp;
        double min = Double.MAX_VALUE;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint onePoint : this.list) {
                double xp2 = onePoint.coordinates[0];
                if (!(xp2 > 0.0)) continue;
                min = Math.min(min, xp2);
            }
        }
        if (this.flushPoint != this.nullPoint && (xp = this.flushPoint.coordinates[0]) > 0.0) {
            min = Math.min(min, xp);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> memory : this.memoryLists) {
                for (OnePoint onePoint : memory) {
                    double xp3 = onePoint.coordinates[0];
                    if (!(xp3 > 0.0)) continue;
                    min = Math.min(min, xp3);
                }
            }
        }
        if (this.group == null) {
            return this.x + min * this.sizex;
        }
        return this.group.x + (this.x + min * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMaxLogscale() {
        double xp;
        double max = -1.7976931348623157E308;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint onePoint : this.list) {
                double xp2 = onePoint.coordinates[0];
                if (!(xp2 > 0.0)) continue;
                max = Math.max(max, xp2);
            }
        }
        if (this.flushPoint != this.nullPoint && (xp = this.flushPoint.coordinates[0]) > 0.0) {
            max = Math.max(max, xp);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> memory : this.memoryLists) {
                for (OnePoint onePoint : memory) {
                    double xp3 = onePoint.coordinates[0];
                    if (!(xp3 > 0.0)) continue;
                    max = Math.max(max, xp3);
                }
            }
        }
        if (this.group == null) {
            return this.x + max * this.sizex;
        }
        return this.group.x + (this.x + max * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMinLogscale() {
        double yp;
        double min = Double.MAX_VALUE;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint onePoint : this.list) {
                double yp2 = onePoint.coordinates[1];
                if (!(yp2 > 0.0)) continue;
                min = Math.min(min, yp2);
            }
        }
        if (this.flushPoint != this.nullPoint && (yp = this.flushPoint.coordinates[1]) > 0.0) {
            min = Math.min(min, yp);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> memory : this.memoryLists) {
                for (OnePoint onePoint : memory) {
                    double yp3 = onePoint.coordinates[1];
                    if (!(yp3 > 0.0)) continue;
                    min = Math.min(min, yp3);
                }
            }
        }
        if (this.group == null) {
            return this.y + min * this.sizey;
        }
        return this.group.y + (this.y + min * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMaxLogscale() {
        double yp;
        double max = -1.7976931348623157E308;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint onePoint : this.list) {
                double yp2 = onePoint.coordinates[1];
                if (!(yp2 > 0.0)) continue;
                max = Math.max(max, yp2);
            }
        }
        if (this.flushPoint != this.nullPoint && (yp = this.flushPoint.coordinates[1]) > 0.0) {
            max = Math.max(max, yp);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> memory : this.memoryLists) {
                for (OnePoint onePoint : memory) {
                    double yp3 = onePoint.coordinates[1];
                    if (!(yp3 > 0.0)) continue;
                    max = Math.max(max, yp3);
                }
            }
        }
        if (this.group == null) {
            return this.y + max * this.sizey;
        }
        return this.group.y + (this.y + max * this.sizey) * this.group.sizey;
    }

    @Override
    public boolean isMeasured() {
        return this.canBeMeasured && this.visible && !this.list.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMin() {
        double min = Double.MAX_VALUE;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint onePoint : this.list) {
                min = Math.min(min, onePoint.coordinates[0]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            min = Math.min(min, this.flushPoint.coordinates[0]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> memory : this.memoryLists) {
                for (OnePoint onePoint : memory) {
                    min = Math.min(min, onePoint.coordinates[0]);
                }
            }
        }
        if (this.group == null) {
            return this.x + min * this.sizex;
        }
        return this.group.x + (this.x + min * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getXMax() {
        double max = -1.7976931348623157E308;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint onePoint : this.list) {
                max = Math.max(max, onePoint.coordinates[0]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            max = Math.max(max, this.flushPoint.coordinates[0]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> memory : this.memoryLists) {
                for (OnePoint onePoint : memory) {
                    max = Math.max(max, onePoint.coordinates[0]);
                }
            }
        }
        if (this.group == null) {
            return this.x + max * this.sizex;
        }
        return this.group.x + (this.x + max * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMin() {
        double min = Double.MAX_VALUE;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint onePoint : this.list) {
                min = Math.min(min, onePoint.coordinates[1]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            min = Math.min(min, this.flushPoint.coordinates[1]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> memory : this.memoryLists) {
                for (OnePoint onePoint : memory) {
                    min = Math.min(min, onePoint.coordinates[1]);
                }
            }
        }
        if (this.group == null) {
            return this.y + min * this.sizey;
        }
        return this.group.y + (this.y + min * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getYMax() {
        double max = -1.7976931348623157E308;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint onePoint : this.list) {
                max = Math.max(max, onePoint.coordinates[1]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            max = Math.max(max, this.flushPoint.coordinates[1]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> memory : this.memoryLists) {
                for (OnePoint onePoint : memory) {
                    max = Math.max(max, onePoint.coordinates[1]);
                }
            }
        }
        if (this.group == null) {
            return this.y + max * this.sizey;
        }
        return this.group.y + (this.y + max * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getZMin() {
        double min = Double.MAX_VALUE;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint onePoint : this.list) {
                min = Math.min(min, onePoint.coordinates[2]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            min = Math.min(min, this.flushPoint.coordinates[2]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> memory : this.memoryLists) {
                for (OnePoint onePoint : memory) {
                    min = Math.min(min, onePoint.coordinates[2]);
                }
            }
        }
        if (this.group == null) {
            return this.z + min * this.sizez;
        }
        return this.group.z + (this.z + min * this.sizez) * this.group.sizez;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getZMax() {
        double max = -1.7976931348623157E308;
        ArrayList<OnePoint> arrayList = this.list;
        synchronized (arrayList) {
            for (OnePoint onePoint : this.list) {
                max = Math.max(max, onePoint.coordinates[2]);
            }
        }
        if (this.flushPoint != this.nullPoint) {
            max = Math.max(max, this.flushPoint.coordinates[2]);
        }
        if (this.memorySets != 1) {
            for (ArrayList<OnePoint> memory : this.memoryLists) {
                for (OnePoint onePoint : memory) {
                    max = Math.max(max, onePoint.coordinates[2]);
                }
            }
        }
        if (this.group == null) {
            return this.z + max * this.sizez;
        }
        return this.group.z + (this.z + max * this.sizez) * this.group.sizez;
    }

    private class OnePoint
    extends Object3D {
        boolean isConnected;
        boolean alreadyProjected;
        double[] coordinates;
        double[] pixel;
        int a1;
        int b1;
        int zeroA;
        int zeroB;
        int pointShapeType;
        Style pointStyle;

        OnePoint(Drawable3D _drawable, double _x, double _y, double _z, boolean _c, int _shapeType, Style _style) {
            super(_drawable, -1);
            this.coordinates = new double[3];
            this.pixel = new double[3];
            this.zeroA = 0;
            this.zeroB = 0;
            this.pointStyle = null;
            this.coordinates[0] = _x;
            this.coordinates[1] = _y;
            this.coordinates[2] = _z;
            this.isConnected = _c;
            this.pointShapeType = _shapeType;
            if (_style != null) {
                this.pointStyle = new Style(_style);
            }
            this.alreadyProjected = false;
        }

        protected void project(DrawingPanel _panel, int _index, boolean forceProjection) {
            this.index = _index;
            if (!forceProjection && this.alreadyProjected) {
                return;
            }
            if (this.pointShapeType == 14 || this.pointShapeType == 15 || this.pointShapeType == 16) {
                if (InteractiveTrace.this.group == null) {
                    ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex;
                    ((InteractiveTrace)InteractiveTrace.this).point[1] = 0.0;
                    ((InteractiveTrace)InteractiveTrace.this).point[2] = 0.0;
                } else {
                    ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.group.x + (InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex) * InteractiveTrace.this.group.sizex;
                    ((InteractiveTrace)InteractiveTrace.this).point[1] = 0.0;
                    ((InteractiveTrace)InteractiveTrace.this).point[2] = 0.0;
                }
                _panel.project(InteractiveTrace.this.point, this.pixel);
                this.zeroA = (int)this.pixel[0];
                this.zeroB = (int)this.pixel[1];
            }
            if (InteractiveTrace.this.group == null) {
                ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex;
                ((InteractiveTrace)InteractiveTrace.this).point[1] = InteractiveTrace.this.y + this.coordinates[1] * InteractiveTrace.this.sizey;
                ((InteractiveTrace)InteractiveTrace.this).point[2] = InteractiveTrace.this.z + this.coordinates[2] * InteractiveTrace.this.sizez;
            } else {
                ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.group.x + (InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex) * InteractiveTrace.this.group.sizex;
                ((InteractiveTrace)InteractiveTrace.this).point[1] = InteractiveTrace.this.group.y + (InteractiveTrace.this.y + this.coordinates[1] * InteractiveTrace.this.sizey) * InteractiveTrace.this.group.sizey;
                ((InteractiveTrace)InteractiveTrace.this).point[2] = InteractiveTrace.this.group.z + (InteractiveTrace.this.z + this.coordinates[2] * InteractiveTrace.this.sizez) * InteractiveTrace.this.group.sizez;
            }
            _panel.project(InteractiveTrace.this.point, this.pixel);
            this.alreadyProjected = true;
            this.distance = this.pixel[2];
            if (this.pointStyle.displayObject instanceof RectangularShape) {
                double dy;
                double dx;
                switch (this.pointStyle.position) {
                    default: {
                        dx = (double)InteractiveTrace.this.shapeSize / 2.0;
                        dy = (double)InteractiveTrace.this.shapeSize / 2.0;
                        break;
                    }
                    case 1: {
                        dx = (double)InteractiveTrace.this.shapeSize / 2.0;
                        dy = 0.0;
                        break;
                    }
                    case 2: {
                        dx = (double)InteractiveTrace.this.shapeSize / 2.0;
                        dy = InteractiveTrace.this.shapeSize;
                        break;
                    }
                    case 3: {
                        dx = InteractiveTrace.this.shapeSize;
                        dy = (double)InteractiveTrace.this.shapeSize / 2.0;
                        break;
                    }
                    case 7: {
                        dx = InteractiveTrace.this.shapeSize;
                        dy = InteractiveTrace.this.shapeSize;
                        break;
                    }
                    case 5: {
                        dx = InteractiveTrace.this.shapeSize;
                        dy = 0.0;
                        break;
                    }
                    case 4: {
                        dx = 0.0;
                        dy = (double)InteractiveTrace.this.shapeSize / 2.0;
                        break;
                    }
                    case 8: {
                        dx = 0.0;
                        dy = InteractiveTrace.this.shapeSize;
                        break;
                    }
                    case 6: {
                        dx = 0.0;
                        dy = 0.0;
                    }
                }
                if (this.pointShapeType == 14) {
                    this.a1 = (int)(this.pixel[0] - dx);
                    this.b1 = (int)this.pixel[1];
                } else {
                    this.a1 = (int)(this.pixel[0] - dx);
                    this.b1 = (int)(this.pixel[1] - dy);
                }
            }
        }
    }
}

