/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.PolarAxes;

public abstract class AbstractPolarAxis
extends AbstractAxes
implements PolarAxes {
    static final double LOG10 = Math.log(10.0);
    static int MAJOR_TIC = 5;
    protected double dr = 1.0;
    protected double dtheta = 0.39269908169872414;
    protected boolean autospaceRings = true;

    protected AbstractPolarAxis(DrawingPanel drawingPanel) {
        super(drawingPanel);
    }

    @Override
    public void autospaceRings(boolean autospace) {
        this.autospaceRings = autospace;
    }

    @Override
    public double getDeltaR() {
        return this.dr;
    }

    @Override
    public void setDeltaR(double dr) {
        this.dr = dr;
    }

    @Override
    public double getDeltaTheta() {
        return this.dtheta;
    }

    @Override
    public void setDeltaTheta(double dtheta) {
        this.dtheta = Math.abs(dtheta);
    }

    public void setLabelFormat(String formatString) {
        this.labelFormat = new DecimalFormat(formatString);
    }

    protected void drawRAxis(double dr, double rmax, DrawingPanel panel, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(this.gridcolor.darker());
        int x1 = panel.xToPix(0.0);
        int y1 = panel.yToPix(0.0);
        int x2 = panel.xToPix(rmax);
        g.drawLine(x1, y1, Math.min(x2, panel.getWidth() - panel.getRightGutter()), y1);
        FontMetrics fm = g2.getFontMetrics();
        int nLabels = (int)(panel.getXMax() / dr / (double)MAJOR_TIC);
        int stride = nLabels > 3 ? 2 : 1;
        double rm = Math.min(rmax, panel.getXMax());
        double r = nLabels > 3 ? (double)(stride * MAJOR_TIC) * dr : (double)MAJOR_TIC * dr;
        while (r <= rm) {
            String label = this.getLabel(r);
            int sW = fm.stringWidth(label) + 4;
            int sH = fm.getHeight();
            g2.setColor(new Color(247, 247, 247));
            int x0 = panel.xToPix(r);
            int y0 = panel.yToPix(0.0);
            g2.fill(new Rectangle2D.Double(x0 - sW / 2, y0 + 3, sW, sH));
            g2.setColor(Color.black);
            g2.draw(new Rectangle2D.Double(x0 - sW / 2, y0 + 3, sW, sH));
            g2.setColor(this.drawingPanel.getForeground());
            g2.drawString(label, x0 - sW / 2 + 2, y0 + 1 + sH);
            r += (double)(stride * MAJOR_TIC) * dr;
        }
    }

    String getLabel(double r) {
        if (r >= 10.0) {
            return Integer.toString((int)r);
        }
        return Double.toString(r);
    }

    @Override
    public double drawRings(double rmax, DrawingPanel panel, Graphics g) {
        double dr = Math.max(this.dr, 1.0E-9);
        if (this.autospaceRings) {
            double decade;
            int exponent = (int)(Math.log(rmax) / LOG10);
            dr = decade = Math.pow(10.0, exponent - 1);
            while (rmax / dr > (double)(5 * MAJOR_TIC)) {
                if (!((dr *= 2.0) / decade > 3.5) || !(dr / decade < 4.5)) continue;
                dr = 5.0 * decade;
                decade *= 10.0;
            }
        } else {
            int nrings = (int)(rmax / dr);
            while (nrings > 10 * MAJOR_TIC) {
                nrings = (int)(rmax / (dr *= 2.0));
            }
        }
        int xcenter = panel.xToPix(0.0);
        int ycenter = panel.yToPix(0.0);
        int xrad = (int)(panel.getXPixPerUnit() * rmax);
        int yrad = (int)(panel.getYPixPerUnit() * rmax);
        if (this.interiorColor != null) {
            g.setColor(this.interiorColor);
            g.fillOval(xcenter - xrad, ycenter - yrad, 2 * xrad, 2 * yrad);
        }
        int counter = 0;
        double r = 0.0;
        while (r <= rmax) {
            g.setColor(this.gridcolor);
            xrad = panel.xToPix(r) - xcenter;
            yrad = ycenter - panel.yToPix(r);
            if (counter % MAJOR_TIC == 0) {
                g.setColor(this.gridcolor.darker());
            }
            g.drawOval(xcenter - xrad, ycenter - yrad, 2 * xrad, 2 * yrad);
            ++counter;
            r += dr;
        }
        return dr;
    }

    @Override
    public void drawSpokes(double rmax, DrawingPanel panel, Graphics g) {
        g.setColor(this.gridcolor);
        double theta = 0.0;
        while (theta < Math.PI) {
            int x1 = panel.xToPix(rmax * Math.cos(theta));
            int y1 = panel.yToPix(rmax * Math.sin(theta));
            int x2 = panel.xToPix(-rmax * Math.cos(theta));
            int y2 = panel.yToPix(-rmax * Math.sin(theta));
            g.drawLine(x1, y1, x2, y2);
            theta += this.dtheta;
        }
    }
}

