/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Translator;

public class OSPRuntime {
    static String version = "2.3";
    static String releaseDate = "1 Jan 2015";
    public static volatile boolean disableAllDrawing = false;
    public static boolean loadVideoTool = true;
    public static boolean loadExportTool = true;
    public static boolean loadDataTool = true;
    public static boolean loadFourierTool = true;
    public static boolean loadTranslatorTool = true;
    public static boolean loadOSPLog = true;
    private static Translator translator;
    public static Locale[] defaultLocales;
    protected static boolean launcherMode;
    public static Boolean antiAliasText;
    public static boolean appletMode;
    public static JApplet applet;
    public static boolean webStart;
    protected static boolean authorMode;
    private static String launchJarPath;
    private static String launchJarName;
    private static JarFile launchJar;
    private static String buildDate;
    public static String chooserDir;
    public static String userhomeDir;
    public static final String OSP_ICON_FILE = "/org/opensourcephysics/resources/controls/images/osp_icon.gif";
    public static boolean launchingInSingleVM;
    public static final String CROSS_PLATFORM_LF = "CROSS_PLATFORM";
    public static final String NIMBUS_LF = "NIMBUS";
    public static final String SYSTEM_LF = "SYSTEM";
    public static final String METAL_LF = "METAL";
    public static final String GTK_LF = "GTK";
    public static final String MOTIF_LF = "MOTIF";
    public static final String WINDOWS_LF = "WINDOWS";
    public static final String DEFAULT_LF = "DEFAULT";
    public static final LookAndFeel DEFAULT_LOOK_AND_FEEL;
    public static final boolean DEFAULT_LOOK_AND_FEEL_DECORATIONS;
    public static final HashMap<String, String> LOOK_AND_FEEL_TYPES;
    private static XMLControl prefsControl;
    private static String prefsPath;
    private static String prefsFileName;
    private static JFileChooser chooser;

    static {
        defaultLocales = new Locale[]{Locale.ENGLISH, new Locale("es"), new Locale("de"), new Locale("da"), new Locale("sk"), Locale.TAIWAN};
        launcherMode = false;
        antiAliasText = false;
        authorMode = true;
        launchJar = null;
        DEFAULT_LOOK_AND_FEEL = UIManager.getLookAndFeel();
        DEFAULT_LOOK_AND_FEEL_DECORATIONS = JFrame.isDefaultLookAndFeelDecorated();
        LOOK_AND_FEEL_TYPES = new HashMap();
        prefsFileName = "osp.prefs";
        try {
            chooserDir = System.getProperty("user.dir", null);
            String userhome = System.getProperty("user.home");
            if (userhome != null) {
                userhomeDir = XML.forwardSlash(userhome);
            }
        }
        catch (Exception ex) {
            chooserDir = null;
        }
        LOOK_AND_FEEL_TYPES.put(METAL_LF, "javax.swing.plaf.metal.MetalLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(NIMBUS_LF, "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(GTK_LF, "com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(MOTIF_LF, "com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(WINDOWS_LF, "com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(CROSS_PLATFORM_LF, UIManager.getCrossPlatformLookAndFeelClassName());
        LOOK_AND_FEEL_TYPES.put(SYSTEM_LF, UIManager.getSystemLookAndFeelClassName());
        LOOK_AND_FEEL_TYPES.put(DEFAULT_LF, DEFAULT_LOOK_AND_FEEL.getClass().getName());
    }

    private OSPRuntime() {
    }

    public static void showAboutDialog(Component parent) {
        String date = OSPRuntime.getLaunchJarBuildDate();
        if (date == null) {
            date = releaseDate;
        }
        String aboutString = "OSP Library " + version + " released " + date + "\n" + "Open Source Physics Project \n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(parent, aboutString, "About Open Source Physics", 1);
    }

    public static boolean setLookAndFeel(boolean useDefaultLnFDecorations, String lookAndFeel) {
        boolean found = true;
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        try {
            if (lookAndFeel == null || lookAndFeel.equals(DEFAULT_LF)) {
                UIManager.setLookAndFeel(DEFAULT_LOOK_AND_FEEL);
                useDefaultLnFDecorations = DEFAULT_LOOK_AND_FEEL_DECORATIONS;
            } else if (lookAndFeel.equals(CROSS_PLATFORM_LF)) {
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
                UIManager.setLookAndFeel(lookAndFeel);
            } else if (lookAndFeel.equals(SYSTEM_LF)) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(lookAndFeel);
            } else if (lookAndFeel.equals(NIMBUS_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            } else if (lookAndFeel.equals(METAL_LF)) {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            } else if (lookAndFeel.equals(GTK_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else if (lookAndFeel.equals(MOTIF_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (lookAndFeel.equals(WINDOWS_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            JFrame.setDefaultLookAndFeelDecorated(useDefaultLnFDecorations);
            JDialog.setDefaultLookAndFeelDecorated(useDefaultLnFDecorations);
        }
        catch (Exception ex) {
            found = false;
        }
        if (!found) {
            try {
                UIManager.setLookAndFeel(currentLookAndFeel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return found;
    }

    public static boolean isDefaultLookAndFeelDecorated() {
        return JFrame.isDefaultLookAndFeelDecorated();
    }

    public static boolean isWindows() {
        try {
            return System.getProperty("os.name", "").toLowerCase().startsWith("windows");
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static boolean isMac() {
        try {
            return System.getProperty("os.name", "").toLowerCase().startsWith("mac");
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static boolean isLinux() {
        try {
            return System.getProperty("os.name", "").toLowerCase().startsWith("linux");
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static boolean isVista() {
        return System.getProperty("os.name", "").toLowerCase().indexOf("vista") > -1;
    }

    public static boolean hasJava3D() {
        try {
            if (OSPRuntime.isMac()) {
                boolean tryIt = true;
                String home = System.getProperty("java.home");
                String version = System.getProperty("java.version");
                tryIt = version.indexOf("1.7") < 0 && version.indexOf("1.8") < 0 ? true : new File(String.valueOf(home) + "/lib/ext/j3dcore.jar").exists();
                if (!tryIt) {
                    return false;
                }
            }
        }
        catch (Exception exc) {
            return false;
        }
        try {
            Class.forName("com.sun.j3d.utils.universe.SimpleUniverse");
            return true;
        }
        catch (Error e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasQTJava() {
        String separator;
        String extdir = System.getProperty("java.ext.dirs");
        if (extdir.indexOf(separator = System.getProperty("path.separator")) > -1) {
            extdir = extdir.substring(0, extdir.indexOf(separator));
        }
        String slash = System.getProperty("file.separator", "/");
        File extfile = new File(String.valueOf(extdir) + slash + "QTJava.zip");
        return extfile.exists();
    }

    public static boolean isPopupTrigger(InputEvent e) {
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            if (me.isShiftDown()) {
                return false;
            }
            return me.isPopupTrigger() || me.getButton() == 3 || me.isControlDown() && OSPRuntime.isMac();
        }
        return false;
    }

    public static boolean isWebStart() {
        if (!webStart) {
            try {
                webStart = System.getProperty("javawebstart.version") != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return webStart;
    }

    public static boolean isAppletMode() {
        return appletMode;
    }

    public static boolean isAuthorMode() {
        return authorMode;
    }

    public static void setAuthorMode(boolean b) {
        authorMode = b;
    }

    public static void setLauncherMode(boolean b) {
        launcherMode = b;
    }

    public static boolean isLauncherMode() {
        return launcherMode || "true".equals(System.getProperty("org.osp.launcher"));
    }

    public static void setLaunchJarPath(String path) {
        if (path == null || launchJarPath != null) {
            return;
        }
        if (!path.endsWith(".jar") && !path.endsWith(".exe")) {
            int n = path.indexOf(".jar!");
            if (n == -1) {
                n = path.indexOf(".exe!");
            }
            if (n > -1) {
                path = path.substring(0, n + 4);
            } else {
                return;
            }
        }
        launchJarPath = path;
        launchJarName = path.substring(path.lastIndexOf("/") + 1);
    }

    public static String getLaunchJarName() {
        return launchJarName;
    }

    public static String getLaunchJarPath() {
        return launchJarPath;
    }

    public static String getLaunchJarDirectory() {
        if (applet != null) {
            return null;
        }
        return launchJarPath == null ? null : XML.getDirectoryPath(launchJarPath);
    }

    public static JarFile getLaunchJar() {
        if (launchJar != null) {
            return launchJar;
        }
        if (launchJarPath == null) {
            return null;
        }
        boolean isWebFile = launchJarPath.startsWith("http:");
        if (!isWebFile) {
            launchJarPath = ResourceLoader.getNonURIPath(launchJarPath);
        }
        try {
            if (applet == null && !isWebFile) {
                launchJar = new JarFile(launchJarPath);
            } else {
                URL url = isWebFile ? new URL("jar:" + launchJarPath + "!/") : new URL("jar:file:/" + launchJarPath + "!/");
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                launchJar = conn.getJarFile();
            }
        }
        catch (Exception ex) {
            OSPLog.fine(ex.getMessage());
        }
        return launchJar;
    }

    public static String getLaunchJarBuildDate() {
        if (buildDate == null) {
            try {
                JarFile jarfile = OSPRuntime.getLaunchJar();
                Attributes att = jarfile.getManifest().getMainAttributes();
                buildDate = att.getValue("Build-Date");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buildDate;
    }

    public static File getJavaFile(String jrePath) {
        if (jrePath == null) {
            return null;
        }
        File file = new File(jrePath);
        if ((jrePath = XML.forwardSlash(jrePath)).endsWith("/lib/ext")) {
            jrePath = jrePath.substring(0, jrePath.length() - 8);
            file = new File(jrePath);
        }
        if (!jrePath.endsWith("/bin/java") && !jrePath.endsWith("/bin/java.exe")) {
            if (jrePath.endsWith("/bin")) {
                file = file.getParentFile();
            }
            if (OSPRuntime.isWindows()) {
                if (file.getParentFile() != null && file.getParentFile().getName().indexOf("jre") > -1) {
                    file = file.getParentFile();
                }
                if (file.getParentFile() != null && file.getParentFile().getName().indexOf("jdk") > -1) {
                    file = file.getParentFile();
                }
                file = file.getName().indexOf("jdk") > -1 ? new File(file, "jre/bin/java.exe") : (file.getName().indexOf("jre") > -1 ? new File(file, "bin/java.exe") : null);
            } else if (OSPRuntime.isMac()) {
                file = file.getName().endsWith("jdk") ? new File(file, "Contents/Home/bin/java") : (file.getName().equals("Home") && file.getPath().indexOf("/Java") > -1 ? new File(file, "bin/java") : null);
            } else if (OSPRuntime.isLinux()) {
                if (file.getParentFile() != null && file.getParentFile().getName().indexOf("jre") > -1) {
                    file = file.getParentFile();
                }
                if (file.getParentFile() != null && file.getParentFile().getName().indexOf("jdk") > -1) {
                    file = file.getParentFile();
                }
                if (file.getParentFile() != null && file.getParentFile().getName().indexOf("sun") > -1) {
                    file = file.getParentFile();
                }
                file = file.getName().indexOf("jdk") > -1 || file.getName().indexOf("sun") > -1 ? new File(file, "jre/bin/java") : null;
            }
        }
        if (file != null) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                file = null;
            }
        }
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static int getVMBitness() {
        String s = System.getProperty("java.vm.name");
        s = String.valueOf(s) + "-" + System.getProperty("os.arch");
        return (s = String.valueOf(s) + "-" + System.getProperty("sun.arch.data.model")).indexOf("64") > -1 ? 64 : 32;
    }

    public static String getJREPath(File javaFile) {
        if (javaFile == null) {
            return null;
        }
        String javaPath = XML.forwardSlash(javaFile.getAbsolutePath());
        if (XML.stripExtension(javaPath).endsWith("/bin/java")) {
            return javaFile.getParentFile().getParent();
        }
        return "";
    }

    public static Locale[] getDefaultLocales() {
        return defaultLocales;
    }

    public static Locale[] getInstalledLocales() {
        ArrayList<Locale> list = new ArrayList<Locale>();
        TreeMap<String, Locale> languages = new TreeMap<String, Locale>();
        list.add(Locale.ENGLISH);
        if (OSPRuntime.getLaunchJarPath() != null) {
            JarFile jar = OSPRuntime.getLaunchJar();
            if (jar != null) {
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    Locale next;
                    int m;
                    JarEntry entry = e.nextElement();
                    String path = entry.toString();
                    int n = path.indexOf(".properties");
                    if (path.indexOf(".properties") <= -1 || (m = path.indexOf("display_res_")) <= -1) continue;
                    String loc = path.substring(m + 12, n);
                    if (loc.equals("zh_TW")) {
                        next = Locale.TAIWAN;
                        languages.put(OSPRuntime.getDisplayLanguage(next).toLowerCase(), next);
                        continue;
                    }
                    if (loc.equals("zh_CN")) {
                        next = Locale.CHINA;
                        languages.put(OSPRuntime.getDisplayLanguage(next).toLowerCase(), next);
                        continue;
                    }
                    if (loc.equals("en_US")) continue;
                    if (!loc.contains("_")) {
                        next = new Locale(loc);
                    } else {
                        String lang = loc.substring(0, 2);
                        String country = loc.substring(3);
                        next = new Locale(lang, country, "");
                    }
                    if (next.equals(Locale.ENGLISH)) continue;
                    languages.put(OSPRuntime.getDisplayLanguage(next).toLowerCase(), next);
                }
                for (String s : languages.keySet()) {
                    list.add((Locale)languages.get(s));
                }
            } else {
                defaultLocales = new Locale[]{Locale.ENGLISH};
                return defaultLocales;
            }
        }
        return list.toArray(new Locale[0]);
    }

    public static String getDisplayLanguage(Locale locale) {
        if (locale.equals(Locale.CHINA)) {
            return "\u7b80\u4f53\u4e2d\u6587";
        }
        if (locale.equals(Locale.TAIWAN)) {
            return "\u7e41\u4f53\u4e2d\u6587";
        }
        return locale.getDisplayLanguage(locale);
    }

    public static ArrayList<String> getDefaultSearchPaths() {
        String codebase;
        File dir;
        ArrayList<String> paths = new ArrayList<String>();
        if (OSPRuntime.isWindows()) {
            String appdata = System.getenv("LOCALAPPDATA");
            if (appdata != null) {
                File dir2 = new File(appdata, "OSP");
                if (!dir2.exists()) {
                    dir2.mkdir();
                }
                if (dir2.exists()) {
                    paths.add(XML.forwardSlash(dir2.getAbsolutePath()));
                }
            }
        } else if (userhomeDir != null && OSPRuntime.isMac()) {
            dir = new File(userhomeDir, "Library/Application Support");
            if (dir.exists()) {
                if (!(dir = new File(dir, "OSP")).exists()) {
                    dir.mkdir();
                }
                if (dir.exists()) {
                    paths.add(XML.forwardSlash(dir.getAbsolutePath()));
                }
            }
        } else if (userhomeDir != null && OSPRuntime.isLinux() && (dir = new File(userhomeDir, ".config")).exists()) {
            if (!(dir = new File(dir, "OSP")).exists()) {
                dir.mkdir();
            }
            if (dir.exists()) {
                paths.add(XML.forwardSlash(dir.getAbsolutePath()));
            }
        }
        if (userhomeDir != null) {
            paths.add(userhomeDir);
        }
        if ((codebase = OSPRuntime.getLaunchJarDirectory()) != null) {
            paths.add(XML.forwardSlash(codebase));
        }
        return paths;
    }

    public static Object getPreference(String name) {
        XMLControl control = OSPRuntime.getPrefsControl();
        return control.getObject(name);
    }

    public static void setPreference(String name, Object pref) {
        XMLControl control = OSPRuntime.getPrefsControl();
        control.setValue(name, pref);
    }

    public static void savePreferences() {
        XMLControl control = OSPRuntime.getPrefsControl();
        File file = new File(prefsPath, prefsFileName);
        control.write(file.getAbsolutePath());
    }

    public static File getPreferencesFile() {
        OSPRuntime.getPrefsControl();
        File file = new File(prefsPath, prefsFileName);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static XMLControl getPrefsControl() {
        if (prefsControl == null) {
            ArrayList<String> dirs = OSPRuntime.getDefaultSearchPaths();
            for (String dir : dirs) {
                XMLControlElement test;
                File file = new File(dir, prefsFileName);
                if (!file.exists() && (file = new File(dir, "." + prefsFileName)).exists()) {
                    prefsFileName = "." + prefsFileName;
                }
                if (!file.exists() || (test = new XMLControlElement(file.getAbsolutePath())).failedToRead()) continue;
                prefsControl = test;
                prefsPath = XML.forwardSlash(dir);
                break;
            }
            if (prefsControl == null) {
                prefsControl = new XMLControlElement();
                prefsPath = XML.forwardSlash(dirs.get(0));
                if (prefsPath.equals(userhomeDir)) {
                    prefsFileName = "." + prefsFileName;
                }
                File file = new File(prefsPath, prefsFileName);
                prefsControl.write(file.getAbsolutePath());
            }
        }
        return prefsControl;
    }

    public static Translator getTranslator() {
        if (translator == null && loadTranslatorTool) {
            try {
                Class<?> translatorClass = Class.forName("org.opensourcephysics.tools.TranslatorTool");
                Method m = translatorClass.getMethod("getTool", null);
                translator = (Translator)m.invoke(null, null);
            }
            catch (Exception ex) {
                loadTranslatorTool = false;
                OSPLog.finest("Cannot instantiate translator tool class:\n" + ex.toString());
            }
        }
        return translator;
    }

    public static JFileChooser getChooser() {
        if (chooser != null) {
            FontSizer.setFonts(chooser, FontSizer.getLevel());
            return chooser;
        }
        try {
            chooser = chooserDir == null ? new JFileChooser() : new JFileChooser(new File(chooserDir));
        }
        catch (Exception e) {
            System.err.println("Exception in OSPFrame getChooser=" + e);
            return null;
        }
        FileFilter defaultFilter = chooser.getFileFilter();
        FileFilter xmlFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && extension.equals("xml");
            }

            @Override
            public String getDescription() {
                return DisplayRes.getString("OSPRuntime.FileFilter.Description.XML");
            }
        };
        FileFilter txtFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && extension.equals("txt");
            }

            @Override
            public String getDescription() {
                return DisplayRes.getString("OSPRuntime.FileFilter.Description.TXT");
            }
        };
        chooser.addChoosableFileFilter(xmlFilter);
        chooser.addChoosableFileFilter(txtFilter);
        chooser.setFileFilter(defaultFilter);
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    public static String chooseFilename(JFileChooser chooser) {
        return OSPRuntime.chooseFilename(chooser, null, true);
    }

    public static String chooseFilename(JFileChooser chooser, Component parent, boolean toSave) {
        String fileName = null;
        int result = toSave ? chooser.showSaveDialog(parent) : chooser.showOpenDialog(parent);
        if (result == 0) {
            chooserDir = chooser.getCurrentDirectory().toString();
            File file = chooser.getSelectedFile();
            if (toSave) {
                int selected;
                if (file.exists() && (selected = JOptionPane.showConfirmDialog(parent, String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + file.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
                    return null;
                }
            } else if (!file.exists()) {
                JOptionPane.showMessageDialog(parent, String.valueOf(DisplayRes.getString("GUIUtils.FileDoesntExist")) + " " + file.getName(), DisplayRes.getString("GUIUtils.FileChooserError"), 0);
                return null;
            }
            if ((fileName = file.getAbsolutePath()) == null || fileName.trim().equals("")) {
                return null;
            }
        }
        return fileName;
    }

    public static JFileChooser createChooser(String title, String description, String[] extensions) {
        JFileChooser chooser = OSPRuntime.createChooser(description, extensions, null);
        chooser.setDialogTitle(title);
        return chooser;
    }

    public static JFileChooser createChooser(String description, String[] extensions) {
        return OSPRuntime.createChooser(description, extensions, null);
    }

    public static JFileChooser createChooser(String description, String[] extensions, final File homeDir) {
        JFileChooser chooser = new JFileChooser(new File(chooserDir));
        ExtensionFileFilter filter = new ExtensionFileFilter();
        int i = 0;
        while (i < extensions.length) {
            filter.addExtension(extensions[i]);
            ++i;
        }
        filter.setDescription(description);
        if (homeDir != null) {
            chooser.setFileSystemView(new FileSystemView(){

                @Override
                public File createNewFolder(File arg0) throws IOException {
                    return FileSystemView.getFileSystemView().createNewFolder(arg0);
                }

                @Override
                public File getHomeDirectory() {
                    return homeDir;
                }
            });
        }
        chooser.setFileFilter(filter);
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private String description = "";
        private ArrayList<String> extensions = new ArrayList();

        private ExtensionFileFilter() {
        }

        public void addExtension(String extension) {
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            this.extensions.add(extension.toLowerCase());
        }

        public String toString() {
            return this.description;
        }

        public void setDescription(String aDescription) {
            this.description = aDescription;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName().toLowerCase();
            int i = 0;
            while (i < this.extensions.size()) {
                if (name.endsWith(this.extensions.get(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

