/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;

public class HighlightableDataset
extends Dataset
implements Interactive {
    boolean[] highlighted = new boolean[1];
    boolean[] previous;
    Color highlightColor = new Color(255, 255, 0, 128);
    Shape highlightShape;
    Shape[] hitShapes = new Shape[0];
    int hitIndex = -1;
    double[][] screenCoordinates = new double[2][];

    public HighlightableDataset() {
    }

    public HighlightableDataset(Color markerColor) {
        super(markerColor);
    }

    public HighlightableDataset(Color markerColor, Color lineColor, boolean connected) {
        super(markerColor, lineColor, connected);
    }

    @Override
    public void append(double x, double y) {
        super.append(x, y);
        this.adjustCapacity(this.xpoints.length);
    }

    @Override
    public void append(double[] xarray, double[] yarray) {
        super.append(xarray, yarray);
        this.adjustCapacity(this.xpoints.length);
    }

    @Override
    public void clear() {
        super.clear();
        this.previous = this.highlighted;
        this.highlighted = new boolean[this.xpoints.length];
    }

    public void restoreHighlights() {
        if (this.previous != null && this.previous.length == this.highlighted.length) {
            this.highlighted = this.previous;
        }
    }

    public void clearHighlights() {
        int i = 0;
        while (i < this.highlighted.length) {
            this.highlighted[i] = false;
            ++i;
        }
    }

    public void setHighlighted(int i, boolean highlight) {
        if (i >= this.highlighted.length) {
            this.adjustCapacity(i + 1);
        }
        this.highlighted[i] = highlight;
    }

    public boolean isHighlighted(int i) {
        if (i >= this.highlighted.length) {
            this.adjustCapacity(i + 1);
        }
        return this.highlighted[i];
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    @Override
    protected void moveDatum(int loc) {
        super.moveDatum(loc);
    }

    private synchronized void adjustCapacity(int minLength) {
        int len = Math.max(this.xpoints.length, minLength);
        if (this.highlighted.length == len) {
            return;
        }
        boolean[] temp = this.highlighted;
        this.highlighted = new boolean[len];
        int count = Math.min(temp.length, len);
        System.arraycopy(temp, 0, this.highlighted, 0, count);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics g) {
        super.draw(drawingPanel, g);
        Graphics2D g2 = (Graphics2D)g;
        int offset = this.getMarkerSize() + 4;
        int edge = 2 * offset;
        Shape clipShape = g2.getClip();
        g2.setClip(drawingPanel.leftGutter - offset - 1, drawingPanel.topGutter - offset - 1, drawingPanel.getWidth() - drawingPanel.leftGutter - drawingPanel.rightGutter + 2 + 2 * offset, drawingPanel.getHeight() - drawingPanel.bottomGutter - drawingPanel.topGutter + 2 + 2 * offset);
        Rectangle viewRect = drawingPanel.getViewRect();
        if (viewRect != null) {
            g2.clipRect(viewRect.x, viewRect.y, viewRect.x + viewRect.width, viewRect.y + viewRect.height);
        }
        this.hitShapes = new Shape[this.index];
        double[] xValues = this.getXPoints();
        double[] yValues = this.getYPoints();
        if (this.screenCoordinates[0] == null || this.screenCoordinates[0].length != this.index) {
            this.screenCoordinates[0] = new double[this.index];
            this.screenCoordinates[1] = new double[this.index];
        }
        int i = 0;
        while (i < this.index) {
            if (Double.isNaN(yValues[i])) {
                this.screenCoordinates[1][i] = Double.NaN;
            } else {
                double xp = drawingPanel.xToPix(xValues[i]);
                double yp = drawingPanel.yToPix(yValues[i]);
                this.screenCoordinates[0][i] = xp;
                this.screenCoordinates[1][i] = yp;
                this.hitShapes[i] = new Rectangle2D.Double(xp - (double)offset, yp - (double)offset, edge, edge);
                if (this.isHighlighted(i)) {
                    g2.setColor(this.highlightColor);
                    g2.fill(this.hitShapes[i]);
                }
            }
            ++i;
        }
        g2.setClip(clipShape);
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        int l = panel.getLeftGutter();
        int r = panel.getRightGutter();
        int t = panel.getTopGutter();
        int b = panel.getBottomGutter();
        Dimension dim = panel.getSize();
        if (xpix < l || xpix > dim.width - r) {
            return null;
        }
        if (ypix < t || ypix > dim.height - b) {
            return null;
        }
        this.hitIndex = -1;
        int i = 0;
        while (i < this.hitShapes.length) {
            if (this.hitShapes[i] != null && this.hitShapes[i].contains(xpix, ypix)) {
                this.hitIndex = i;
                return this;
            }
            ++i;
        }
        return null;
    }

    public int getHitIndex() {
        return this.hitIndex;
    }

    public double[][] getScreenCoordinates() {
        return this.screenCoordinates;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setXY(double x, double y) {
    }

    @Override
    public void setX(double x) {
    }

    @Override
    public void setY(double y) {
    }

    @Override
    public double getX() {
        if (this.hitIndex > -1) {
            return this.xpoints[this.hitIndex];
        }
        return Double.NaN;
    }

    @Override
    public double getY() {
        if (this.hitIndex > -1) {
            return this.ypoints[this.hitIndex];
        }
        return Double.NaN;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            XML.getLoader(Dataset.class).saveObject(control, obj);
            HighlightableDataset data = (HighlightableDataset)obj;
            control.setValue("highlighted", data.highlighted);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new HighlightableDataset();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            XML.getLoader(Dataset.class).loadObject(control, obj);
            HighlightableDataset data = (HighlightableDataset)obj;
            boolean[] highlighted = (boolean[])control.getObject("highlighted");
            if (highlighted != null) {
                data.highlighted = highlighted;
            }
            return data;
        }
    }
}

