/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensourcephysics.display.DataRowTable;

public class DataPanel
extends JPanel {
    DataRowTable table = new DataRowTable();
    JScrollPane scrollPane = new JScrollPane(this.table);

    public DataPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.table != null) {
            this.table.setFont(font);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.table != null) {
            this.table.setForeground(color);
        }
    }

    public void refreshTable() {
        this.table.refreshTable();
    }

    public Component getVisual() {
        return this.table;
    }

    public void setColumnNames(int column, String name) {
        if (this.table.rowModel.setColumnNames(column, name)) {
            this.refreshTable();
        }
    }

    public void setColumnNames(String[] names) {
        boolean changed = false;
        int i = 0;
        int n = names.length;
        while (i < n) {
            if (this.table.rowModel.setColumnNames(i, names[i])) {
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.refreshTable();
        }
    }

    public void setRowNumberVisible(boolean vis) {
        if (this.table.rowModel.setRowNumberVisible(vis)) {
            this.refreshTable();
        }
    }

    public void setFirstRowIndex(int index) {
        if (this.table.rowModel.firstRowIndex != index) {
            this.table.rowModel.firstRowIndex = index;
            this.refreshTable();
        }
    }

    public void setRefreshDelay(int delay) {
        this.table.setRefreshDelay(delay);
    }

    public synchronized void appendArray(Object obj) throws IllegalArgumentException {
        if (!obj.getClass().isArray()) {
            throw new IllegalArgumentException("");
        }
        Class<?> componentType = obj.getClass().getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        String type = componentType.getName();
        if (type.equals("double")) {
            double[][] array = (double[][])obj;
            double[] row = new double[array.length];
            int i = 0;
            int n = array[0].length;
            while (i < n) {
                int j = 0;
                int m = row.length;
                while (j < m) {
                    row[j] = array[j][i];
                    ++j;
                }
                this.appendRow(row);
                ++i;
            }
        } else if (type.equals("int")) {
            int[][] array = (int[][])obj;
            int[] row = new int[array.length];
            int i = 0;
            int n = array[0].length;
            while (i < n) {
                int j = 0;
                int m = row.length;
                while (j < m) {
                    row[j] = array[j][i];
                    ++j;
                }
                this.appendRow(row);
                ++i;
            }
        } else if (type.equals("byte")) {
            byte[][] array = (byte[][])obj;
            byte[] row = new byte[array.length];
            int i = 0;
            int n = array[0].length;
            while (i < n) {
                int j = 0;
                int m = row.length;
                while (j < m) {
                    row[j] = array[j][i];
                    ++j;
                }
                this.appendRow(row);
                ++i;
            }
        } else {
            Object[][] array = (Object[][])obj;
            Object[] row = new Object[array.length];
            int i = 0;
            int n = array[0].length;
            while (i < n) {
                int j = 0;
                int m = row.length;
                while (j < m) {
                    row[j] = array[j][i];
                    ++j;
                }
                this.appendRow(row);
                ++i;
            }
        }
    }

    public synchronized void appendRow(double[] x) {
        this.table.rowModel.appendDoubles(x);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(int[] x) {
        this.table.rowModel.appendInts(x);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(Object[] x) {
        this.table.rowModel.appendRow(x);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public synchronized void appendRow(byte[] x) {
        this.table.rowModel.appendBytes(x);
        if (this.isShowing()) {
            this.table.refreshTable();
        }
    }

    public boolean isRowNumberVisible() {
        return this.table.rowModel.rowNumberVisible;
    }

    public int getColumnCount() {
        return this.table.rowModel.getColumnCount();
    }

    public int getRowCount() {
        return this.table.rowModel.getRowCount();
    }

    public int getTotalRowCount() {
        return this.table.rowModel.rowList.size();
    }

    public int getStride() {
        return this.table.rowModel.stride;
    }

    public void setColumnFormat(int column, String format) {
        this.table.setColumnFormat(column, format);
    }

    public void clearFormats() {
        this.table.clearFormats();
    }

    public void setNumericFormat(String pattern) {
        this.table.setNumericFormat(pattern);
    }

    public void setMaxPoints(int max) {
        this.table.rowModel.setMaxPoints(max);
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            this.table.refreshTable();
        }
        super.setVisible(vis);
    }

    public void setStride(int stride) {
        this.table.setStride(stride);
    }

    public void clearData() {
        this.table.clearData();
    }

    public void clear() {
        this.table.clear();
    }

    public void setAutoResizeMode(int mode) {
        this.table.setAutoResizeMode(mode);
    }
}

