/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.util.ArrayList;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.tools.ToolsRes;

public class DataFunction
extends Dataset {
    DatasetManager inputData;
    ParsedMultiVarFunction function;
    String functionString;
    String inputString;
    int varCount;
    ArrayList<double[]> data = new ArrayList();

    public DataFunction(DatasetManager input) {
        this.inputData = input;
        String name = ToolsRes.getString("DataFunction.DefaultName");
        this.setXYColumnNames(input.getDataset(0).getXColumnName(), name);
        this.setXColumnVisible(false);
        this.setExpression("");
    }

    public DataFunction(DatasetManager input, String name, String expression) {
        this.inputData = input;
        this.setXYColumnNames(input.getDataset(0).getXColumnName(), name);
        this.setXColumnVisible(false);
        this.setExpression(expression);
    }

    public void setExpression(String e) {
        this.varCount = this.getVarCount();
        try {
            this.function = new ParsedMultiVarFunction(e, this.getVarNames());
            this.functionString = e;
            this.inputString = e;
            this.refreshFunctionData();
        }
        catch (ParserException ex) {
            this.setExpression("0");
            this.inputString = e;
            this.refreshFunctionData();
        }
    }

    public String getExpression() {
        return this.functionString;
    }

    public void setYColumnName(String name) {
        if (name == null || name.equals("")) {
            return;
        }
        this.setXYColumnNames(this.getXColumnName(), name);
    }

    public String getInputString() {
        return this.inputString;
    }

    public void refreshFunctionData() {
        super.clear();
        if (this.function == null) {
            return;
        }
        if (this.varCount != this.getVarCount()) {
            this.setExpression(this.inputString);
            return;
        }
        double[][] data = this.getFunctionData();
        if (data.length == 0) {
            return;
        }
        double[] fData = new double[data.length];
        int len = data[0].length;
        int n = 0;
        while (n < len) {
            int i = 0;
            while (i < data.length) {
                fData[i] = n < data[i].length ? data[i][n] : Double.NaN;
                ++i;
            }
            double val = Double.NaN;
            if (!"0".equals(this.functionString) || "0".equals(this.inputString)) {
                val = this.function.evaluate(fData);
                if (this.function.evaluatedToNaN()) {
                    val = Double.NaN;
                }
            }
            super.append(fData[0], val);
            ++n;
        }
    }

    @Override
    public String toString() {
        return this.getYColumnName();
    }

    @Override
    public void append(double x, double y) {
    }

    @Override
    public void append(double x, double y, double dx, double dy) {
    }

    @Override
    public void append(double[] x, double[] y) {
    }

    @Override
    public void append(double[] x, double[] y, double[] dx, double[] dy) {
    }

    @Override
    public void clear() {
    }

    private double[][] getFunctionData() {
        String[] names;
        int length = 0;
        this.data.clear();
        for (Dataset dataset : this.inputData.getDatasets()) {
            if (dataset == this) continue;
            if (this.data.isEmpty()) {
                double[] xPoints = dataset.getXPoints();
                length = xPoints.length;
                this.data.add(xPoints);
            }
            this.data.add(dataset.getYPoints());
        }
        String[] stringArray = names = this.inputData.getConstantNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            double[] points = new double[length];
            double val = this.inputData.getConstantValue(next);
            int i = 0;
            while (i < length) {
                points[i] = val;
                ++i;
            }
            this.data.add(points);
            ++n2;
        }
        return (double[][])this.data.toArray((T[])new double[0][0]);
    }

    private int getVarCount() {
        ArrayList<Dataset> list = this.inputData.getDatasets();
        int count = list.contains(this) ? list.size() : list.size() + 1;
        return count + this.inputData.getConstantNames().length;
    }

    private String[] getVarNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Dataset dataset : this.inputData.getDatasets()) {
            if (dataset == this) continue;
            String name = null;
            if (names.isEmpty()) {
                name = TeXParser.removeSubscripting(dataset.getXColumnName());
                names.add(name);
            }
            name = TeXParser.removeSubscripting(dataset.getYColumnName());
            names.add(name);
        }
        String[] stringArray = this.inputData.getConstantNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            names.add(name);
            ++n2;
        }
        return names.toArray(new String[0]);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DataFunction data = (DataFunction)obj;
            control.setValue("function_name", data.getYColumnName());
            control.setValue("function", data.getInputString());
            XML.getLoader(Dataset.class).saveObject(control, obj);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            DataFunction data = (DataFunction)obj;
            data.setYColumnName(control.getString("function_name"));
            data.setExpression(control.getString("function"));
            data.setYColumnDescription(control.getString("y_description"));
            data.setID(control.getInt("datasetID"));
            if (control.getPropertyNames().contains("marker_shape")) {
                data.setMarkerShape(control.getInt("marker_shape"));
            }
            if (control.getPropertyNames().contains("marker_size")) {
                data.setMarkerSize(control.getInt("marker_size"));
            }
            data.setSorted(control.getBoolean("sorted"));
            data.setConnected(control.getBoolean("connected"));
            Color color = (Color)control.getObject("line_color");
            if (color != null) {
                data.setLineColor(color);
            }
            Color fill = (Color)control.getObject("fill_color");
            color = (Color)control.getObject("edge_color");
            if (fill != null) {
                if (color != null) {
                    data.setMarkerColor(fill, color);
                } else {
                    data.setMarkerColor(fill);
                }
            }
            return obj;
        }
    }
}

