/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Rectangle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.OSPLog;

class OSPLogHandler
extends Handler {
    JTextPane logPane;
    OSPLog ospLog;

    public OSPLogHandler(JTextPane textPane, OSPLog log) {
        this.logPane = textPane;
        this.ospLog = log;
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        String msg = this.getFormatter().format(record);
        Style style = OSPLog.green;
        int val = record.getLevel().intValue();
        if (val == ConsoleLevel.ERR_CONSOLE.intValue()) {
            if (msg.indexOf("OutOfMemory") > -1) {
                this.ospLog.firePropertyChange("error", -1L, 1L);
            } else if (msg.indexOf("quicktime.QTSession") > -1) {
                this.ospLog.firePropertyChange("qt_error", null, msg);
            }
            if (!OSPLog.logConsole) {
                return;
            }
            style = OSPLog.magenta;
        } else if (val == ConsoleLevel.OUT_CONSOLE.intValue()) {
            if (msg.indexOf("ERROR org.ffmpeg") > -1) {
                this.ospLog.firePropertyChange("ffmpeg_error", null, msg);
            } else if (msg.indexOf("JNILibraryLoader") > -1) {
                this.ospLog.firePropertyChange("xuggle_error", null, msg);
            }
            if (!OSPLog.logConsole) {
                return;
            }
            style = OSPLog.gray;
        } else if (val >= Level.WARNING.intValue()) {
            style = OSPLog.red;
        } else if (val >= Level.INFO.intValue()) {
            style = OSPLog.black;
        } else if (val >= Level.CONFIG.intValue()) {
            style = OSPLog.green;
        } else if (val >= Level.FINEST.intValue()) {
            style = OSPLog.blue;
        }
        try {
            Document doc = this.logPane.getDocument();
            doc.insertString(doc.getLength(), String.valueOf(msg) + '\n', style);
            Rectangle rect = this.logPane.getBounds();
            rect.y = rect.height;
            this.logPane.scrollRectToVisible(rect);
        }
        catch (BadLocationException ex) {
            System.err.println(ex);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

