/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.tools.FontSizer;

public class ListChooser
extends JDialog {
    private JPanel checkPane = new JPanel();
    private Object[] objects;
    private boolean[] selections;
    private JCheckBox[] checkBoxes;
    private JLabel instructions;
    private boolean applyChanges = false;
    private String separator = ":  ";
    private Font lightFont;

    public ListChooser(String title, String text) {
        this(title, text, null);
    }

    public ListChooser(String title, String text, Component owner) {
        super(JOptionPane.getFrameForComponent(owner), true);
        this.setTitle(title);
        this.instructions = new JLabel(" " + text);
        this.instructions.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        this.createGUI();
    }

    public ListChooser(String title, String text, JDialog owner) {
        super((Dialog)owner, true);
        this.setTitle(title);
        this.instructions = new JLabel(" " + text);
        this.instructions.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        this.createGUI();
    }

    private void createGUI() {
        this.lightFont = new JLabel().getFont().deriveFont(0);
        JButton cancelButton = new JButton(ControlsRes.getString("Chooser.Button.Cancel"));
        JButton okButton = new JButton(ControlsRes.getString("Chooser.Button.OK"));
        JButton selectAllButton = new JButton(ControlsRes.getString("Chooser.Button.SelectAll"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListChooser.this.setVisible(false);
            }
        });
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < ListChooser.this.checkBoxes.length) {
                    ((ListChooser)ListChooser.this).selections[i] = ListChooser.this.checkBoxes[i].isSelected();
                    ++i;
                }
                ListChooser.this.applyChanges = true;
                ListChooser.this.setVisible(false);
            }
        });
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < ListChooser.this.checkBoxes.length) {
                    ListChooser.this.checkBoxes[i].setSelected(true);
                    ++i;
                }
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BoxLayout(headerPane, 0));
        headerPane.add(this.instructions);
        headerPane.add(Box.createHorizontalGlue());
        headerPane.add(selectAllButton);
        headerPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.checkPane.setLayout(new BoxLayout(this.checkPane, 1));
        this.checkPane.setBackground(Color.white);
        JScrollPane scroller = new JScrollPane(this.checkPane);
        scroller.setPreferredSize(new Dimension(250, 180));
        JPanel scrollPane = new JPanel(new BorderLayout());
        scrollPane.add((Component)scroller, "Center");
        scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(okButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)headerPane, "North");
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rect = new Rectangle(dim);
        if (this.getOwner() != null) {
            rect = this.getOwner().getBounds();
        }
        int x = rect.x + (rect.width - this.getBounds().width) / 2;
        int y = rect.y + (rect.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    public void setSeparator(String separator) {
        if (separator != null) {
            this.separator = separator;
        }
    }

    public boolean choose(Collection<?> choices, Collection<String> names) {
        return this.choose(choices, names, null);
    }

    public boolean choose(Collection<?> choices, Collection<String> names, Collection<?> values) {
        boolean[] selected = new boolean[choices.size()];
        return this.choose(choices, names, values, selected);
    }

    public boolean choose(Collection<?> choices, Collection<String> names, Collection<?> values, boolean[] selected) {
        boolean[] disabled = new boolean[choices.size()];
        return this.choose(choices, names, values, selected, disabled);
    }

    public boolean choose(Collection<?> choices, Collection<String> names, Collection<?> values, boolean[] selected, boolean[] disabled) {
        return this.choose(choices, names, values, null, selected, disabled);
    }

    public boolean choose(Collection<?> choices, Collection<String> names, Collection<?> values, Collection<String> descriptions, boolean[] selected) {
        boolean[] disabled = new boolean[choices.size()];
        return this.choose(choices, names, values, descriptions, selected, disabled);
    }

    public boolean choose(Collection<?> choices, Collection<String> names, Collection<?> values, Collection<String> descriptions, boolean[] selected, boolean[] disabled) {
        this.checkPane.removeAll();
        this.checkBoxes = new JCheckBox[choices.size()];
        this.selections = new boolean[choices.size()];
        this.objects = new Object[choices.size()];
        ArrayList<String> nameList = new ArrayList<String>();
        if (names != null) {
            nameList.addAll(names);
        }
        ArrayList valueList = new ArrayList();
        if (values != null) {
            valueList.addAll(values);
        }
        ArrayList<String> descriptionList = new ArrayList<String>();
        if (descriptions != null) {
            descriptionList.addAll(descriptions);
        }
        Iterator<?> it = choices.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.objects[i] = it.next();
            this.selections[i] = false;
            if (nameList.size() <= i || nameList.get(i) == null) {
                this.checkBoxes[i] = new JCheckBox(this.objects[i].toString());
            } else {
                String text = (String)nameList.get(i);
                if (valueList.size() > i && valueList.get(i) != null) {
                    text = String.valueOf(text) + this.separator + valueList.get(i);
                }
                this.checkBoxes[i] = new JCheckBox(text);
            }
            this.checkBoxes[i].setSelected(selected[i]);
            this.checkBoxes[i].setEnabled(!disabled[i]);
            this.checkBoxes[i].setBackground(Color.white);
            this.checkBoxes[i].setFont(this.lightFont);
            this.checkBoxes[i].setIconTextGap(10);
            Box box = Box.createHorizontalBox();
            box.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 8));
            box.add(this.checkBoxes[i]);
            box.add(Box.createHorizontalGlue());
            this.checkPane.add(box);
            if (descriptionList.size() > i && descriptionList.get(i) != null) {
                JLabel label = new JLabel((String)descriptionList.get(i));
                label.setFont(this.lightFont);
                box.add(label);
            }
            ++i;
        }
        FontSizer.setFonts(this, FontSizer.getLevel());
        this.pack();
        this.setVisible(true);
        if (!this.applyChanges) {
            return false;
        }
        i = 0;
        while (i < this.objects.length) {
            if (!this.selections[i]) {
                choices.remove(this.objects[i]);
            }
            ++i;
        }
        return true;
    }
}

