/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.SpecialRender;
import org.colos.ejs.library.utils.GIFEncoder;
import org.colos.ejs.library.utils.VideoUtil;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.media.xuggle.XuggleIO;
import org.opensourcephysics.tools.VideoCaptureTool;

public class VideoUtilClass
extends VideoUtil {
    private VideoCaptureTool videoTool = null;
    private Component videoComponent;
    private BufferedImage videoImage = null;
    private SpecialRender videoSpecialRender = null;

    @Override
    public boolean isFullClass() {
        return true;
    }

    @Override
    public void takeSnapshot(Component _component) {
        try {
            PrintUtils.saveComponentAsEPS(_component);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public boolean startVideoTool(View _view, String _element) {
        this.videoImage = null;
        this.videoComponent = null;
        this.videoSpecialRender = null;
        if (_view == null) {
            return false;
        }
        Component comp = _view.getComponent(_element);
        if (comp == null) {
            System.err.println("Component not found: " + _element);
            return false;
        }
        if (comp instanceof JFrame) {
            comp = ((JFrame)comp).getContentPane();
        } else if (comp instanceof JDialog) {
            comp = ((JDialog)comp).getContentPane();
        }
        this.videoImage = new BufferedImage(comp.getWidth(), comp.getHeight(), 1);
        this.videoComponent = comp;
        ControlElement ctrlEl = _view.getElement(_element);
        if (ctrlEl instanceof SpecialRender) {
            this.videoSpecialRender = (SpecialRender)((Object)ctrlEl);
        }
        if (this.videoTool == null) {
            this.videoTool = new VideoCaptureTool();
        }
        this.videoTool.setVisible(true);
        this.videoTool.clear();
        XuggleIO.registerWithVideoIO();
        try {
            String name = "org.opensourcephysics.media.xuggle.XuggleIO";
            Class<?> xuggleClass = Class.forName(name);
            Method method = xuggleClass.getMethod("registerWithVideoIO", new Class[0]);
            method.invoke(null, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error err) {
            err.printStackTrace();
        }
        return true;
    }

    @Override
    public void captureVideoImage() {
        if (this.videoImage == null) {
            return;
        }
        if (this.videoSpecialRender != null) {
            this.videoSpecialRender.render(this.videoImage);
        } else {
            Graphics g = this.videoImage.getGraphics();
            this.videoComponent.paint(g);
            g.dispose();
        }
        this.videoTool.addFrame(this.videoImage);
    }

    @Override
    public boolean writeGIF(OutputStream out, BufferedImage bi) {
        try {
            GIFEncoder encoder = new GIFEncoder(bi);
            encoder.Write(out);
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }
}

