/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.LocaleListener;

public class LocaleSelector {
    private LocaleListener listener;
    private JComboBox localeCB;
    private JComponent localePanel;
    private JLabel localeLabel;
    private Set<LocaleSelector> slaveSelectors = new HashSet<LocaleSelector>();
    private LocaleSelector masterSelector = null;
    private boolean isActive = true;

    public LocaleSelector(LocaleListener _listener) {
        this.listener = _listener;
        this.localeCB = new JComboBox();
        this.localeCB.addItem(LocaleItem.getDefaultItem());
        this.localeCB.setSelectedItem(LocaleItem.getDefaultItem());
        this.localeCB.setEditable(true);
        this.localeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LocaleSelector.this.isActive) {
                    LocaleSelector.this.isActive = true;
                    return;
                }
                Object selected = LocaleSelector.this.localeCB.getSelectedItem();
                if (selected == null) {
                    return;
                }
                if (selected instanceof LocaleItem) {
                    LocaleSelector.this.listener.setLocaleItem((LocaleItem)selected);
                    return;
                }
                if (LocaleSelector.this.masterSelector != null) {
                    return;
                }
                LocaleItem newItem = LocaleItem.getLocaleItem(selected.toString());
                if (newItem == null) {
                    JOptionPane.showMessageDialog(LocaleSelector.this.localeCB, String.valueOf(Simulation.getEjsString("LocaleSelector.InvalidLocale")) + " <" + selected.toString() + ">", Simulation.getEjsString("Error"), 0);
                    LocaleSelector.this.localeCB.setSelectedItem(LocaleItem.getDefaultItem());
                    return;
                }
                int i = 0;
                while (i < LocaleSelector.this.localeCB.getItemCount()) {
                    LocaleItem next = (LocaleItem)LocaleSelector.this.localeCB.getItemAt(i);
                    if (next.equals(newItem)) {
                        LocaleSelector.this.localeCB.setSelectedIndex(i);
                        return;
                    }
                    ++i;
                }
                LocaleSelector.this.addLocaleItem(newItem);
                LocaleSelector.this.localeCB.setSelectedItem(newItem);
            }
        });
        this.localeLabel = new JLabel(Simulation.getEjsString("LocaleSelector.Language"), 4);
        JPanel fieldPanel = new JPanel(new BorderLayout());
        fieldPanel.add((Component)this.localeLabel, "West");
        fieldPanel.add((Component)this.localeCB, "Center");
        fieldPanel.validate();
        this.localePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 10;
        this.localePanel.add((Component)fieldPanel, gbc);
    }

    public void refreshGUI(LocaleItem _item) {
        this.localeLabel.setText(Simulation.getEjsString("LocaleSelector.Language"));
        int n = this.localeCB.getItemCount();
        int i = 0;
        while (i < n) {
            LocaleItem next = (LocaleItem)this.localeCB.getItemAt(i);
            if (_item.equals(next)) {
                this.isActive = false;
                this.localeCB.setSelectedIndex(i);
                return;
            }
            ++i;
        }
    }

    public void setMasterSelector(LocaleSelector _selector) {
        if (this.masterSelector != null) {
            this.masterSelector.slaveSelectors.remove(this);
        }
        this.masterSelector = _selector;
        if (this.masterSelector != null) {
            this.masterSelector.slaveSelectors.add(this);
            this.localeCB.setEditable(false);
            for (LocaleItem item : this.masterSelector.getAvailableLocaleItems()) {
                this.addLocaleItem(item);
            }
        } else {
            this.localeCB.setEditable(true);
        }
    }

    public void setEditable(boolean editable) {
        this.localeCB.setEditable(editable);
    }

    public JComponent getComponent() {
        return this.localePanel;
    }

    public void setEnabled(boolean _enabled) {
        this.localeCB.setEnabled(_enabled);
    }

    public void setColor(Color _color) {
        this.localeLabel.setForeground(_color);
    }

    public void clear() {
        this.localeCB.removeAllItems();
        this.localeCB.addItem(LocaleItem.getDefaultItem());
        this.localeCB.setSelectedItem(LocaleItem.getDefaultItem());
        for (LocaleSelector slave : this.slaveSelectors) {
            slave.clear();
        }
    }

    public Set<LocaleItem> getAvailableLocaleItems() {
        HashSet<LocaleItem> set = new HashSet<LocaleItem>();
        int i = 0;
        int n = this.localeCB.getItemCount();
        while (i < n) {
            set.add((LocaleItem)this.localeCB.getItemAt(i));
            ++i;
        }
        return set;
    }

    public LocaleItem addLocaleItem(LocaleItem _item) {
        if (_item.isDefaultItem()) {
            return LocaleItem.getDefaultItem();
        }
        boolean done = false;
        int i = 1;
        int n = this.localeCB.getItemCount();
        while (i < n) {
            LocaleItem next = (LocaleItem)this.localeCB.getItemAt(i);
            if (_item.equals(next)) {
                done = true;
                break;
            }
            if (_item.compareTo(next) < 0) {
                this.localeCB.insertItemAt(_item, i);
                done = true;
                break;
            }
            ++i;
        }
        if (!done) {
            this.localeCB.addItem(_item);
        }
        for (LocaleSelector slave : this.slaveSelectors) {
            slave.addLocaleItem(_item);
        }
        return _item;
    }

    public void removeLocaleItem(LocaleItem _item) {
        if (_item.isDefaultItem()) {
            return;
        }
        boolean wasSelected = _item.equals(this.localeCB.getSelectedItem());
        int i = 1;
        int n = this.localeCB.getItemCount();
        while (i < n) {
            LocaleItem next = (LocaleItem)this.localeCB.getItemAt(i);
            if (_item.equals(next)) {
                this.localeCB.removeItemAt(i);
                for (LocaleSelector slave : this.slaveSelectors) {
                    slave.removeLocaleItem(_item);
                }
                if (wasSelected) {
                    this.setLocaleItem(LocaleItem.getDefaultItem());
                }
                return;
            }
            ++i;
        }
    }

    public void setLocaleItem(LocaleItem _item) {
        int n = this.localeCB.getItemCount();
        int i = 0;
        while (i < n) {
            LocaleItem next = (LocaleItem)this.localeCB.getItemAt(i);
            if (_item.equals(next)) {
                this.localeCB.setSelectedIndex(i);
                this.listener.setLocaleItem(_item);
                return;
            }
            ++i;
        }
        System.out.println("Warning! : Locale " + _item + " NOT found");
    }
}

