/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.displayejs.ControlInteractiveElement;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.GeneralParser;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ParserAndVariables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.displayejs.InteractivePoligon;

public class ControlAnalyticCurve
extends ControlInteractiveElement
implements NeedsPreUpdate {
    protected static final int CURVE_ADDED = 12;
    protected static final int MY_LINE_COLOR = 31;
    protected InteractivePoligon poligon;
    protected String variable;
    protected int numPoints;
    protected double min = Double.NaN;
    protected double max = Double.NaN;
    protected String functionX;
    protected String functionY;
    protected String functionZ;
    protected boolean useJavaSyntax = true;
    protected String parameterName = null;
    protected double[] parameterValues = null;
    protected boolean changedXfunction;
    protected boolean changedYfunction;
    protected boolean changedZfunction;
    protected boolean updateIndexes;
    protected GeneralParser parserX;
    protected GeneralParser parserY;
    protected GeneralParser parserZ;
    protected String[] varsX;
    protected String[] varsY;
    protected String[] varsZ;
    protected int indexX;
    protected int indexY;
    protected int indexZ;
    protected int indexParameterX;
    protected int indexParameterY;
    protected int indexParameterZ;
    private static List<String> infoList = null;

    public ControlAnalyticCurve() {
        this.enabledEjsEdit = true;
    }

    @Override
    protected void setName(String _name) {
        this.poligon.setName(_name);
    }

    @Override
    protected Drawable createDrawable() {
        this.poligon = new InteractivePoligon();
        this.numPoints = 0;
        this.poligon.setNumberOfPoints(0);
        this.poligon.setClosed(false);
        this.poligon.setAllowTable(true);
        this.variable = "t";
        this.functionX = null;
        this.varsX = new String[0];
        this.indexX = -1;
        this.functionY = null;
        this.varsY = new String[0];
        this.indexY = -1;
        this.functionZ = null;
        this.varsZ = new String[0];
        this.indexZ = -1;
        this.changedZfunction = true;
        this.changedYfunction = true;
        this.changedXfunction = true;
        this.poligon.canBeMeasured(false);
        return this.poligon;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 12;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("min");
            infoList.add("max");
            infoList.add("points");
            infoList.add("functionx");
            infoList.add("functiony");
            infoList.add("functionz");
            infoList.add("javaSyntax");
            infoList.add("parameterName");
            infoList.add("parameterValues");
            infoList.add("onErrorAction");
            infoList.add("onSuccessAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyCommonName(String _property) {
        if (_property.equals("color")) {
            return "lineColor";
        }
        if (_property.equals("secondaryColor")) {
            return "fillColor";
        }
        return super.getPropertyCommonName(_property);
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "String";
        }
        if (_property.equals("min")) {
            return "int|double";
        }
        if (_property.equals("max")) {
            return "int|double";
        }
        if (_property.equals("points")) {
            return "int";
        }
        if (_property.equals("functionx")) {
            return "String";
        }
        if (_property.equals("functiony")) {
            return "String";
        }
        if (_property.equals("functionz")) {
            return "String";
        }
        if (_property.equals("javaSyntax")) {
            return "boolean";
        }
        if (_property.equals("parameterName")) {
            return "String";
        }
        if (_property.equals("parameterValues")) {
            return "double[]";
        }
        if (_property.equals("onErrorAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("onSuccessAction")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getString().equals(this.variable)) break;
                this.variable = _value.getString();
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = _value.getDouble();
                this.poligon.canBeMeasured(!Double.isNaN(this.max));
                break;
            }
            case 2: {
                this.max = _value.getDouble();
                this.poligon.canBeMeasured(!Double.isNaN(this.min));
                break;
            }
            case 3: {
                this.numPoints = _value.getInteger();
                break;
            }
            case 4: {
                if (_value.getString().equals(this.functionX)) break;
                this.functionX = _value.getString();
                this.changedXfunction = true;
                break;
            }
            case 5: {
                if (_value.getString().equals(this.functionY)) break;
                this.functionY = _value.getString();
                this.changedYfunction = true;
                break;
            }
            case 6: {
                if (_value.getString().equals(this.functionZ)) break;
                this.functionZ = _value.getString();
                this.changedZfunction = true;
                break;
            }
            case 7: {
                if (_value.getBoolean() == this.useJavaSyntax) break;
                this.useJavaSyntax = _value.getBoolean();
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 8: {
                if (_value.getString().equals(this.parameterName)) break;
                this.parameterName = _value.getString();
                this.updateIndexes = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 9: {
                if (_value.getObject() instanceof double[]) {
                    this.parameterValues = (double[])_value.getObject();
                    break;
                }
                this.parameterValues = null;
                break;
            }
            case 10: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                this.addAction(1001, _value.getString());
                return;
            }
            case 11: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                this.addAction(1002, _value.getString());
                return;
            }
            default: {
                super.setValue(_index - 12, _value);
                break;
            }
            case 31: {
                super.setValue(18, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.variable = "t";
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = Double.NaN;
                this.poligon.canBeMeasured(false);
                break;
            }
            case 2: {
                this.max = Double.NaN;
                this.poligon.canBeMeasured(false);
                break;
            }
            case 3: {
                this.numPoints = 0;
                break;
            }
            case 4: {
                this.functionX = null;
                this.varsX = new String[0];
                this.changedXfunction = true;
                break;
            }
            case 5: {
                this.functionY = null;
                this.varsY = new String[0];
                this.changedYfunction = true;
                break;
            }
            case 6: {
                this.functionZ = null;
                this.varsZ = new String[0];
                this.changedZfunction = true;
                break;
            }
            case 7: {
                this.useJavaSyntax = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 8: {
                this.parameterName = null;
                this.updateIndexes = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 9: {
                this.parameterValues = null;
                break;
            }
            case 10: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                return;
            }
            case 11: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                return;
            }
            default: {
                super.setDefaultValue(_index - 12);
                break;
            }
            case 31: {
                super.setDefaultValue(18);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "t";
            }
            case 1: 
            case 2: {
                return "Double.NaN";
            }
            case 3: {
                return "0";
            }
            case 4: 
            case 5: 
            case 6: {
                return "<none>";
            }
            case 7: {
                return "true";
            }
            case 8: 
            case 9: {
                return "<none>";
            }
            case 10: 
            case 11: {
                return "<no_action>";
            }
            default: {
                return super.getDefaultValueString(_index - 12);
            }
            case 31: 
        }
        return super.getDefaultValueString(18);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        return super.getValue(_index - 12);
    }

    private boolean isVariableDefined(String varName) {
        if (this.variable.equals(varName)) {
            return true;
        }
        if (this.parameterName != null && varName.equals(this.parameterName)) {
            return true;
        }
        Value value = this.myGroup.getValue(varName);
        if (value instanceof IntegerValue) {
            return true;
        }
        return value instanceof DoubleValue;
    }

    @Override
    public void preupdate() {
        int n;
        int i;
        ParserAndVariables pav;
        boolean parsedOk = false;
        boolean errorX = false;
        boolean errorY = false;
        boolean errorZ = false;
        if (this.changedXfunction && this.functionX != null) {
            pav = new ParserAndVariables(this.useJavaSyntax, this.functionX);
            this.varsX = pav.getVariables();
            this.parserX = pav.getParser();
            i = 0;
            n = this.varsX.length;
            while (i < n) {
                if (!this.isVariableDefined(this.varsX[i])) {
                    errorX = true;
                    break;
                }
                this.parserX.defineVariable(i, this.varsX[i]);
                ++i;
            }
            if (!errorX) {
                this.parserX.define(this.functionX);
                this.parserX.parse();
                if (this.parserX.hasError()) {
                    errorX = true;
                } else {
                    parsedOk = true;
                }
            }
            this.changedXfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedYfunction && this.functionY != null) {
            pav = new ParserAndVariables(this.useJavaSyntax, this.functionY);
            this.varsY = pav.getVariables();
            this.parserY = pav.getParser();
            i = 0;
            n = this.varsY.length;
            while (i < n) {
                if (!this.isVariableDefined(this.varsY[i])) {
                    errorY = true;
                    break;
                }
                this.parserY.defineVariable(i, this.varsY[i]);
                ++i;
            }
            if (!errorY) {
                this.parserY.define(this.functionY);
                this.parserY.parse();
                if (this.parserY.hasError()) {
                    errorY = true;
                } else {
                    parsedOk = true;
                }
            }
            this.changedYfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedZfunction && this.functionZ != null) {
            pav = new ParserAndVariables(this.useJavaSyntax, this.functionZ);
            this.varsZ = pav.getVariables();
            this.parserZ = pav.getParser();
            i = 0;
            n = this.varsZ.length;
            while (i < n) {
                if (!this.isVariableDefined(this.varsZ[i])) {
                    errorZ = true;
                    break;
                }
                this.parserZ.defineVariable(i, this.varsZ[i]);
                ++i;
            }
            if (!errorZ) {
                this.parserZ.define(this.functionZ);
                this.parserZ.parse();
                if (this.parserZ.hasError()) {
                    errorZ = true;
                } else {
                    parsedOk = true;
                }
            }
            this.changedZfunction = false;
            this.updateIndexes = true;
        }
        if (errorX || errorY || errorZ) {
            this.invokeActions(1001);
        } else if (parsedOk) {
            this.invokeActions(1002);
        }
        if (this.isUnderEjs) {
            this.myEjsPropertyEditor.displayErrorOnProperty("functionx", errorX);
            this.myEjsPropertyEditor.displayErrorOnProperty("functiony", errorY);
            this.myEjsPropertyEditor.displayErrorOnProperty("functionz", errorZ);
        }
        if (this.updateIndexes) {
            this.indexX = ControlAnalyticCurve.indexOf(this.variable, this.varsX);
            this.indexY = ControlAnalyticCurve.indexOf(this.variable, this.varsY);
            this.indexZ = ControlAnalyticCurve.indexOf(this.variable, this.varsZ);
            if (this.parameterName != null) {
                this.indexParameterX = ControlAnalyticCurve.indexOf(this.parameterName, this.varsX);
                this.indexParameterY = ControlAnalyticCurve.indexOf(this.parameterName, this.varsY);
                this.indexParameterZ = ControlAnalyticCurve.indexOf(this.parameterName, this.varsZ);
            }
            this.updateIndexes = false;
        }
        DrawingPanel panel = this.myParent.getDrawingPanel();
        int nPoints = this.numPoints;
        if (nPoints <= 0) {
            nPoints = panel != null ? Math.max(100, panel.getWidth() / 2) : 100;
        }
        if (this.parameterName != null && this.parameterValues != null) {
            int nFinal = nPoints * this.parameterValues.length;
            if (this.poligon.getNumberOfPoints() != nFinal) {
                this.poligon.setNumberOfPoints(nFinal);
                int i2 = 1;
                int n2 = this.parameterValues.length;
                while (i2 < n2) {
                    this.poligon.setConnected(i2 * nPoints - 1, false);
                    ++i2;
                }
            }
        } else if (this.poligon.getNumberOfPoints() != nPoints) {
            this.poligon.setNumberOfPoints(nPoints);
        }
        double[][] data = this.poligon.getData();
        double minAbcise = this.min;
        double maxAbcise = this.max;
        if (panel != null) {
            if (Double.isNaN(minAbcise)) {
                minAbcise = panel.getXMin();
            }
            if (Double.isNaN(maxAbcise)) {
                maxAbcise = panel.getXMax();
            }
        }
        int i3 = 0;
        int n3 = this.varsX.length;
        while (i3 < n3) {
            if (i3 != this.indexX) {
                this.parserX.setVariable(i3, this.myGroup.getDouble(this.varsX[i3]));
            }
            ++i3;
        }
        i3 = 0;
        n3 = this.varsY.length;
        while (i3 < n3) {
            if (i3 != this.indexY) {
                this.parserY.setVariable(i3, this.myGroup.getDouble(this.varsY[i3]));
            }
            ++i3;
        }
        i3 = 0;
        n3 = this.varsZ.length;
        while (i3 < n3) {
            if (i3 != this.indexZ) {
                this.parserZ.setVariable(i3, this.myGroup.getDouble(this.varsZ[i3]));
            }
            ++i3;
        }
        if (this.parameterName != null && this.parameterValues != null) {
            int curve = 0;
            int nCurves = this.parameterValues.length;
            while (curve < nCurves) {
                if (this.functionX != null && this.indexParameterX >= 0) {
                    this.parserX.setVariable(this.indexParameterX, this.parameterValues[curve]);
                }
                if (this.functionY != null && this.indexParameterY >= 0) {
                    this.parserY.setVariable(this.indexParameterY, this.parameterValues[curve]);
                }
                if (this.functionZ != null && this.indexParameterZ >= 0) {
                    this.parserZ.setVariable(this.indexParameterZ, this.parameterValues[curve]);
                }
                int i4 = 0;
                int n4 = nPoints - 1;
                while (i4 <= n4) {
                    double t = ((double)(n4 - i4) * minAbcise + (double)i4 * maxAbcise) / (double)n4;
                    int index = i4 + curve * nPoints;
                    if (this.functionX == null || errorX) {
                        data[0][index] = 0.0;
                    } else {
                        if (this.indexX >= 0) {
                            this.parserX.setVariable(this.indexX, t);
                        }
                        data[0][index] = this.parserX.evaluate();
                    }
                    if (this.functionY == null || errorY) {
                        data[1][index] = 0.0;
                    } else {
                        if (this.indexY >= 0) {
                            this.parserY.setVariable(this.indexY, t);
                        }
                        data[1][index] = this.parserY.evaluate();
                    }
                    if (this.functionZ == null || errorZ) {
                        data[2][index] = 0.0;
                    } else {
                        if (this.indexZ >= 0) {
                            this.parserZ.setVariable(this.indexZ, t);
                        }
                        data[2][index] = this.parserZ.evaluate();
                    }
                    ++i4;
                }
                ++curve;
            }
        } else {
            i3 = 0;
            n3 = nPoints - 1;
            while (i3 <= n3) {
                double t = ((double)(n3 - i3) * minAbcise + (double)i3 * maxAbcise) / (double)n3;
                if (this.functionX == null || errorX) {
                    data[0][i3] = 0.0;
                } else {
                    if (this.indexX >= 0) {
                        this.parserX.setVariable(this.indexX, t);
                    }
                    data[0][i3] = this.parserX.evaluate();
                }
                if (this.functionY == null || errorY) {
                    data[1][i3] = 0.0;
                } else {
                    if (this.indexY >= 0) {
                        this.parserY.setVariable(this.indexY, t);
                    }
                    data[1][i3] = this.parserY.evaluate();
                }
                if (this.functionZ == null || errorZ) {
                    data[2][i3] = 0.0;
                } else {
                    if (this.indexZ >= 0) {
                        this.parserZ.setVariable(this.indexZ, t);
                    }
                    data[2][i3] = this.parserZ.evaluate();
                }
                ++i3;
            }
        }
        this.poligon.needsToProject(null);
    }
}

