/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class IntegerArray {
    public static int NumberFormatError = 1;
    public static int ArrayIndexOutOfBoundsError = 2;
    protected int[] array;
    protected String defaultString;
    protected int[] defaultArray;
    protected int errorcode = 0;

    public IntegerArray(int n) {
        this.array = new int[n];
        this.defaultArray = this.array;
    }

    public IntegerArray(int[] nArray) {
        this.defaultArray = (int[])nArray.clone();
        this.array = this.defaultArray;
    }

    public IntegerArray(String string) throws NumberFormatException {
        this.array = this.toInteger(string);
        this.defaultString = string;
        this.defaultArray = this.array;
    }

    public String getDefault() {
        return this.defaultString;
    }

    public String toString() {
        if (this.errorcode > 0) {
            return this.defaultString;
        }
        String string = "{";
        int n = 0;
        int n2 = this.array.length;
        while (n < n2) {
            string = String.valueOf(string) + Integer.toString(this.array[n]);
            if (n < n2 - 1) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
        }
        string = String.valueOf(string) + "}";
        return string;
    }

    public int getError() {
        return this.errorcode;
    }

    public int[] getArray(String string) {
        this.set(string);
        return this.array;
    }

    public int[] getArray() {
        return this.array;
    }

    public boolean set(String string) {
        this.errorcode = 0;
        try {
            this.array = this.toInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.errorcode = NumberFormatError;
            this.array = this.toInteger(this.defaultString);
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.errorcode = ArrayIndexOutOfBoundsError;
            this.array = this.toInteger(this.defaultString);
            return false;
        }
        return true;
    }

    public void setDefaultArray(int[] nArray) {
        this.defaultArray = (int[])nArray.clone();
        this.array = this.defaultArray;
    }

    protected int[] toInteger(String string) throws ArrayIndexOutOfBoundsException {
        int[] nArray = null;
        int n = string.indexOf("{") + 1;
        int n2 = string.indexOf("}");
        if (n2 - n <= 0) {
            this.errorcode = ArrayIndexOutOfBoundsError;
            return this.defaultArray;
        }
        String[] stringArray = string.substring(n, n2).split(",");
        if (this.array != null && this.array.length != stringArray.length) {
            throw new ArrayIndexOutOfBoundsException("Array length cannot be changed in DoubleArray. " + string);
        }
        nArray = new int[stringArray.length];
        int n3 = 0;
        int n4 = stringArray.length;
        while (n3 < n4) {
            try {
                nArray[n3] = Integer.parseInt(stringArray[n3].trim());
            }
            catch (NumberFormatException numberFormatException) {
                nArray[n3] = 0;
                this.errorcode = NumberFormatError;
            }
            ++n3;
        }
        return nArray;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            IntegerArray integerArray = (IntegerArray)object;
            xMLControl.setValue("data", integerArray.getArray());
        }

        public Object createObject(XMLControl xMLControl) {
            return new IntegerArray((int[])xMLControl.getObject("data"));
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            IntegerArray integerArray = (IntegerArray)object;
            int[] nArray = (int[])xMLControl.getObject("data");
            integerArray.array = nArray;
            integerArray.defaultArray = nArray;
            return object;
        }
    }
}

