/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.displayejs.ControlInteractiveElement;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.GeneralParser;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ParserAndVariables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.displayejs.InteractivePoligon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlAnalyticCurve
extends ControlInteractiveElement
implements NeedsPreUpdate {
    protected static final int CURVE_ADDED = 12;
    protected static final int MY_LINE_COLOR = 31;
    protected InteractivePoligon poligon;
    protected String variable;
    protected int numPoints;
    protected double min = Double.NaN;
    protected double max = Double.NaN;
    protected String functionX;
    protected String functionY;
    protected String functionZ;
    protected boolean useJavaSyntax = true;
    protected String parameterName = null;
    protected double[] parameterValues = null;
    protected boolean changedXfunction;
    protected boolean changedYfunction;
    protected boolean changedZfunction;
    protected boolean updateIndexes;
    protected GeneralParser parserX;
    protected GeneralParser parserY;
    protected GeneralParser parserZ;
    protected String[] varsX;
    protected String[] varsY;
    protected String[] varsZ;
    protected int indexX;
    protected int indexY;
    protected int indexZ;
    protected int indexParameterX;
    protected int indexParameterY;
    protected int indexParameterZ;
    private static List<String> infoList = null;

    public ControlAnalyticCurve() {
        this.enabledEjsEdit = true;
    }

    @Override
    protected void setName(String string) {
        this.poligon.setName(string);
    }

    @Override
    protected Drawable createDrawable() {
        this.poligon = new InteractivePoligon();
        this.numPoints = 0;
        this.poligon.setNumberOfPoints(0);
        this.poligon.setClosed(false);
        this.poligon.setAllowTable(true);
        this.variable = "t";
        this.functionX = null;
        this.varsX = new String[0];
        this.indexX = -1;
        this.functionY = null;
        this.varsY = new String[0];
        this.indexY = -1;
        this.functionZ = null;
        this.varsZ = new String[0];
        this.indexZ = -1;
        this.changedZfunction = true;
        this.changedYfunction = true;
        this.changedXfunction = true;
        this.poligon.canBeMeasured(false);
        return this.poligon;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 12;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("min");
            infoList.add("max");
            infoList.add("points");
            infoList.add("functionx");
            infoList.add("functiony");
            infoList.add("functionz");
            infoList.add("javaSyntax");
            infoList.add("parameterName");
            infoList.add("parameterValues");
            infoList.add("onErrorAction");
            infoList.add("onSuccessAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyCommonName(String string) {
        if (string.equals("color")) {
            return "lineColor";
        }
        if (string.equals("secondaryColor")) {
            return "fillColor";
        }
        return super.getPropertyCommonName(string);
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "String";
        }
        if (string.equals("min")) {
            return "int|double";
        }
        if (string.equals("max")) {
            return "int|double";
        }
        if (string.equals("points")) {
            return "int";
        }
        if (string.equals("functionx")) {
            return "String";
        }
        if (string.equals("functiony")) {
            return "String";
        }
        if (string.equals("functionz")) {
            return "String DEPRECATED";
        }
        if (string.equals("javaSyntax")) {
            return "boolean";
        }
        if (string.equals("parameterName")) {
            return "String";
        }
        if (string.equals("parameterValues")) {
            return "double[]";
        }
        if (string.equals("onErrorAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("onSuccessAction")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getString().equals(this.variable)) break;
                this.variable = value.getString();
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = value.getDouble();
                this.poligon.canBeMeasured(!Double.isNaN(this.max));
                break;
            }
            case 2: {
                this.max = value.getDouble();
                this.poligon.canBeMeasured(!Double.isNaN(this.min));
                break;
            }
            case 3: {
                this.numPoints = value.getInteger();
                break;
            }
            case 4: {
                if (value.getString().equals(this.functionX)) break;
                this.functionX = value.getString();
                this.changedXfunction = true;
                break;
            }
            case 5: {
                if (value.getString().equals(this.functionY)) break;
                this.functionY = value.getString();
                this.changedYfunction = true;
                break;
            }
            case 6: {
                if (value.getString().equals(this.functionZ)) break;
                this.functionZ = value.getString();
                this.changedZfunction = true;
                break;
            }
            case 7: {
                if (value.getBoolean() == this.useJavaSyntax) break;
                this.useJavaSyntax = value.getBoolean();
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 8: {
                if (value.getString().equals(this.parameterName)) break;
                this.parameterName = value.getString();
                this.updateIndexes = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 9: {
                if (value.getObject() instanceof double[]) {
                    this.parameterValues = (double[])value.getObject();
                    break;
                }
                this.parameterValues = null;
                break;
            }
            case 10: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                this.addAction(1001, value.getString());
                return;
            }
            case 11: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                this.addAction(1002, value.getString());
                return;
            }
            default: {
                super.setValue(n - 12, value);
                break;
            }
            case 31: {
                super.setValue(18, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.variable = "t";
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = Double.NaN;
                this.poligon.canBeMeasured(false);
                break;
            }
            case 2: {
                this.max = Double.NaN;
                this.poligon.canBeMeasured(false);
                break;
            }
            case 3: {
                this.numPoints = 0;
                break;
            }
            case 4: {
                this.functionX = null;
                this.varsX = new String[0];
                this.changedXfunction = true;
                break;
            }
            case 5: {
                this.functionY = null;
                this.varsY = new String[0];
                this.changedYfunction = true;
                break;
            }
            case 6: {
                this.functionZ = null;
                this.varsZ = new String[0];
                this.changedZfunction = true;
                break;
            }
            case 7: {
                this.useJavaSyntax = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 8: {
                this.parameterName = null;
                this.updateIndexes = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 9: {
                this.parameterValues = null;
                break;
            }
            case 10: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                return;
            }
            case 11: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                return;
            }
            default: {
                super.setDefaultValue(n - 12);
                break;
            }
            case 31: {
                super.setDefaultValue(18);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "t";
            }
            case 1: 
            case 2: {
                return "Double.NaN";
            }
            case 3: {
                return "0";
            }
            case 4: 
            case 5: 
            case 6: {
                return "<none>";
            }
            case 7: {
                return "true";
            }
            case 8: 
            case 9: {
                return "<none>";
            }
            case 10: 
            case 11: {
                return "<no_action>";
            }
            default: {
                return super.getDefaultValueString(n - 12);
            }
            case 31: 
        }
        return super.getDefaultValueString(18);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        return super.getValue(n - 12);
    }

    private boolean isVariableDefined(String string) {
        if (this.variable.equals(string)) {
            return true;
        }
        if (this.parameterName != null && string.equals(this.parameterName)) {
            return true;
        }
        Value value = this.myGroup.getValue(string);
        if (value instanceof IntegerValue) {
            return true;
        }
        return value instanceof DoubleValue;
    }

    @Override
    public void preupdate() {
        int n;
        int n2;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.changedXfunction && this.functionX != null) {
            object = new ParserAndVariables(this.useJavaSyntax, this.functionX);
            this.varsX = ((ParserAndVariables)object).getVariables();
            this.parserX = ((ParserAndVariables)object).getParser();
            n2 = 0;
            n = this.varsX.length;
            while (n2 < n) {
                if (!this.isVariableDefined(this.varsX[n2])) {
                    bl2 = true;
                    break;
                }
                this.parserX.defineVariable(n2, this.varsX[n2]);
                ++n2;
            }
            if (!bl2) {
                this.parserX.define(this.functionX);
                this.parserX.parse();
                if (this.parserX.hasError()) {
                    bl2 = true;
                } else {
                    bl = true;
                }
            }
            this.changedXfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedYfunction && this.functionY != null) {
            object = new ParserAndVariables(this.useJavaSyntax, this.functionY);
            this.varsY = ((ParserAndVariables)object).getVariables();
            this.parserY = ((ParserAndVariables)object).getParser();
            n2 = 0;
            n = this.varsY.length;
            while (n2 < n) {
                if (!this.isVariableDefined(this.varsY[n2])) {
                    bl3 = true;
                    break;
                }
                this.parserY.defineVariable(n2, this.varsY[n2]);
                ++n2;
            }
            if (!bl3) {
                this.parserY.define(this.functionY);
                this.parserY.parse();
                if (this.parserY.hasError()) {
                    bl3 = true;
                } else {
                    bl = true;
                }
            }
            this.changedYfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedZfunction && this.functionZ != null) {
            object = new ParserAndVariables(this.useJavaSyntax, this.functionZ);
            this.varsZ = ((ParserAndVariables)object).getVariables();
            this.parserZ = ((ParserAndVariables)object).getParser();
            n2 = 0;
            n = this.varsZ.length;
            while (n2 < n) {
                if (!this.isVariableDefined(this.varsZ[n2])) {
                    bl4 = true;
                    break;
                }
                this.parserZ.defineVariable(n2, this.varsZ[n2]);
                ++n2;
            }
            if (!bl4) {
                this.parserZ.define(this.functionZ);
                this.parserZ.parse();
                if (this.parserZ.hasError()) {
                    bl4 = true;
                } else {
                    bl = true;
                }
            }
            this.changedZfunction = false;
            this.updateIndexes = true;
        }
        if (bl2 || bl3 || bl4) {
            this.invokeActions(1001);
        } else if (bl) {
            this.invokeActions(1002);
        }
        if (this.isUnderEjs) {
            this.myEjsPropertyEditor.displayErrorOnProperty("functionx", bl2);
            this.myEjsPropertyEditor.displayErrorOnProperty("functiony", bl3);
            this.myEjsPropertyEditor.displayErrorOnProperty("functionz", bl4);
        }
        if (this.updateIndexes) {
            this.indexX = ControlAnalyticCurve.indexOf(this.variable, this.varsX);
            this.indexY = ControlAnalyticCurve.indexOf(this.variable, this.varsY);
            this.indexZ = ControlAnalyticCurve.indexOf(this.variable, this.varsZ);
            if (this.parameterName != null) {
                this.indexParameterX = ControlAnalyticCurve.indexOf(this.parameterName, this.varsX);
                this.indexParameterY = ControlAnalyticCurve.indexOf(this.parameterName, this.varsY);
                this.indexParameterZ = ControlAnalyticCurve.indexOf(this.parameterName, this.varsZ);
            }
            this.updateIndexes = false;
        }
        object = this.myParent.getDrawingPanel();
        n2 = this.numPoints;
        if (n2 <= 0) {
            n2 = object != null ? Math.max(100, ((DrawingPanel)object).getWidth() / 2) : 100;
        }
        if (this.parameterName != null && this.parameterValues != null) {
            n = n2 * this.parameterValues.length;
            if (this.poligon.getNumberOfPoints() != n) {
                this.poligon.setNumberOfPoints(n);
                int n3 = 1;
                int n4 = this.parameterValues.length;
                while (n3 < n4) {
                    this.poligon.setConnected(n3 * n2 - 1, false);
                    ++n3;
                }
            }
        } else if (this.poligon.getNumberOfPoints() != n2) {
            this.poligon.setNumberOfPoints(n2);
        }
        double[][] dArray = this.poligon.getData();
        double d = this.min;
        double d2 = this.max;
        if (Double.isNaN(d)) {
            d = ((DrawingPanel)object).getXMin();
        }
        if (Double.isNaN(d2)) {
            d2 = ((DrawingPanel)object).getXMax();
        }
        int n5 = 0;
        int n6 = this.varsX.length;
        while (n5 < n6) {
            if (n5 != this.indexX) {
                this.parserX.setVariable(n5, this.myGroup.getDouble(this.varsX[n5]));
            }
            ++n5;
        }
        n5 = 0;
        n6 = this.varsY.length;
        while (n5 < n6) {
            if (n5 != this.indexY) {
                this.parserY.setVariable(n5, this.myGroup.getDouble(this.varsY[n5]));
            }
            ++n5;
        }
        n5 = 0;
        n6 = this.varsZ.length;
        while (n5 < n6) {
            if (n5 != this.indexZ) {
                this.parserZ.setVariable(n5, this.myGroup.getDouble(this.varsZ[n5]));
            }
            ++n5;
        }
        if (this.parameterName != null && this.parameterValues != null) {
            n5 = 0;
            n6 = this.parameterValues.length;
            while (n5 < n6) {
                if (this.functionX != null && this.indexParameterX >= 0) {
                    this.parserX.setVariable(this.indexParameterX, this.parameterValues[n5]);
                }
                if (this.functionY != null && this.indexParameterY >= 0) {
                    this.parserY.setVariable(this.indexParameterY, this.parameterValues[n5]);
                }
                if (this.functionZ != null && this.indexParameterZ >= 0) {
                    this.parserZ.setVariable(this.indexParameterZ, this.parameterValues[n5]);
                }
                int n7 = 0;
                int n8 = n2 - 1;
                while (n7 <= n8) {
                    double d3 = ((double)(n8 - n7) * d + (double)n7 * d2) / (double)n8;
                    int n9 = n7 + n5 * n2;
                    if (this.functionX == null || bl2) {
                        dArray[0][n9] = 0.0;
                    } else {
                        if (this.indexX >= 0) {
                            this.parserX.setVariable(this.indexX, d3);
                        }
                        dArray[0][n9] = this.parserX.evaluate();
                    }
                    if (this.functionY == null || bl3) {
                        dArray[1][n9] = 0.0;
                    } else {
                        if (this.indexY >= 0) {
                            this.parserY.setVariable(this.indexY, d3);
                        }
                        dArray[1][n9] = this.parserY.evaluate();
                    }
                    if (this.functionZ == null || bl4) {
                        dArray[2][n9] = 0.0;
                    } else {
                        if (this.indexZ >= 0) {
                            this.parserZ.setVariable(this.indexZ, d3);
                        }
                        dArray[2][n9] = this.parserZ.evaluate();
                    }
                    ++n7;
                }
                ++n5;
            }
        } else {
            n5 = 0;
            n6 = n2 - 1;
            while (n5 <= n6) {
                double d4 = ((double)(n6 - n5) * d + (double)n5 * d2) / (double)n6;
                if (this.functionX == null || bl2) {
                    dArray[0][n5] = 0.0;
                } else {
                    if (this.indexX >= 0) {
                        this.parserX.setVariable(this.indexX, d4);
                    }
                    dArray[0][n5] = this.parserX.evaluate();
                }
                if (this.functionY == null || bl3) {
                    dArray[1][n5] = 0.0;
                } else {
                    if (this.indexY >= 0) {
                        this.parserY.setVariable(this.indexY, d4);
                    }
                    dArray[1][n5] = this.parserY.evaluate();
                }
                if (this.functionZ == null || bl4) {
                    dArray[2][n5] = 0.0;
                } else {
                    if (this.indexZ >= 0) {
                        this.parserZ.setVariable(this.indexZ, d4);
                    }
                    dArray[2][n5] = this.parserZ.evaluate();
                }
                ++n5;
            }
        }
        this.poligon.needsToProject(null);
    }
}

