/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.RemoteTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.ToolsRes;

public class Toolbox {
    private static final String HOST = "localhost";
    private static final int PORT = 1099;
    protected static Map<String, Tool> tools = new HashMap<String, Tool>();
    protected static Registry registry;
    protected static int allowRMI;

    static {
        allowRMI = -1;
    }

    protected Toolbox() {
    }

    public static void addTool(String string, Tool tool) {
        if (tools.get(string) == null) {
            tools.put(string, tool);
            OSPLog.fine("Added to toolbox: " + string);
        }
    }

    public static boolean addRMITool(String string, Tool tool) {
        Toolbox.initRMI();
        if (allowRMI == 0) {
            return false;
        }
        try {
            RemoteTool remoteTool = new RemoteTool(tool);
            registry.bind(string, remoteTool);
            OSPLog.fine("Added to RMI registry: " + string);
            return true;
        }
        catch (Exception exception) {
            OSPLog.warning("RMI registration failed: " + string + " [" + exception + "]");
            return false;
        }
    }

    public static Tool getTool(String string) {
        if (tools.containsKey(string)) {
            Tool tool = tools.get(string);
            OSPLog.fine("Found local tool: " + string);
            return tool;
        }
        Toolbox.initRMI();
        if (allowRMI == 0) {
            return null;
        }
        try {
            Tool tool = (Tool)registry.lookup(string);
            OSPLog.fine("Found RMI tool " + string);
            return new RemoteTool(tool);
        }
        catch (Exception exception) {
            OSPLog.info("RMI lookup failed: " + string + " [" + exception + "]");
            System.out.println("RMI lookup failed: " + string + " [" + exception + "]");
            return null;
        }
    }

    private static void initRMI() {
        if (allowRMI == 0) {
            return;
        }
        if (allowRMI < 0) {
            int n = JOptionPane.showConfirmDialog(null, ToolsRes.getString("Toolbox.Dialog.UseRemote.Query"), ToolsRes.getString("Toolbox.Dialog.UseRemote.Title"), 0, 3);
            if (n == 0) {
                allowRMI = 1;
            } else {
                allowRMI = 0;
                return;
            }
        }
        if (registry == null) {
            try {
                registry = LocateRegistry.getRegistry(HOST, 1099);
            }
            catch (RemoteException remoteException) {
                OSPLog.info(remoteException.getMessage());
                try {
                    registry = LocateRegistry.createRegistry(1099);
                }
                catch (RemoteException remoteException2) {
                    OSPLog.info(remoteException2.getMessage());
                }
            }
        }
    }
}

