/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_solvers;

import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolverException;
import org.opensourcephysics.numerics.ode_interpolation.EulerIntervalData;
import org.opensourcephysics.numerics.ode_interpolation.StateHistory;
import org.opensourcephysics.numerics.ode_solvers.DelayDifferentialEquation;
import org.opensourcephysics.numerics.ode_solvers.Discontinuity;
import org.opensourcephysics.numerics.ode_solvers.SolverEngine;
import org.opensourcephysics.numerics.ode_solvers.StateEvent;
import org.opensourcephysics.numerics.ode_solvers.ZenoEffectListener;

public class InterpolatorEventSolver {
    public static double EPSILON = 1.0;
    private boolean mEnableExceptions = true;
    protected boolean mUseBestInterpolation = false;
    private double mStepSize = 0.1;
    private double mAbsoluteTolerance = Double.NaN;
    private double mRelativeTolerance = Double.NaN;
    private double mMaxEventStep = Double.POSITIVE_INFINITY;
    private int mZenoMaximumAllowedTimes = 500;
    private double mProximityThreshold = 9.9E-324;
    private boolean mCoalesceCloseEvents = true;
    private int mMaxInternalSteps = 10000;
    protected SolverEngine mSolverEngine;
    protected ODE mODE;
    private boolean mRunsForwards = this.mStepSize > 0.0;
    private int mDimension;
    private int mTimeIndex;
    private ERROR mErrorCode = ERROR.NO_ERROR;
    private String mErrorMessage = "No error";
    private int mNumberOfAttempts = 0;
    private double[] mTest_ode_state;
    private double[] mIntermediate_ode_state;
    private List<EventData> mEventList = new ArrayList<EventData>();
    private List<EventData> mHappened = new ArrayList<EventData>();
    private List<EventData> mTemp_list = new ArrayList<EventData>();
    private double mLastEventDataTime = Double.NaN;
    private ProblemData mLastEventData = null;
    private int mZenoCounter = 0;
    private List<ZenoEffectListener> mZenoList = new ArrayList<ZenoEffectListener>();
    private ProblemData mCurrentEventData = null;
    private boolean mHasEventsOrDiscontinuities = false;
    private boolean mHasDiscontinuities = false;
    private DiscontinuityData mDiscontinuityAtEnd = null;
    private List<DiscontinuityData> mDiscontinuityList = new ArrayList<DiscontinuityData>();
    private DDEDiscontinuity mDDEdiscontinuity = null;
    private int mDDEdiscontinuityMaxIterations = 100;
    private double mDDEdiscontinuityTolerance = 1.0E-8;

    static {
        while (EPSILON + 1.0 != 1.0) {
            EPSILON /= 2.0;
        }
        EPSILON *= 2.0;
    }

    public InterpolatorEventSolver(SolverEngine engine, ODE ode) {
        this.mSolverEngine = engine;
        this.mODE = ode;
        if (this.mODE instanceof DelayDifferentialEquation) {
            this.mDDEdiscontinuity = new DDEDiscontinuity((DelayDifferentialEquation)this.mODE);
        }
        this.mSolverEngine.setODE(this, this.mODE);
    }

    public void setEnableExceptions(boolean enable) {
        this.mEnableExceptions = enable;
    }

    public void setBestInterpolation(boolean best) {
        this.mUseBestInterpolation = best;
    }

    public void setHistoryLength(double length) {
        this.mSolverEngine.getStateHistory().setLength(length);
    }

    public void setStepSize(double stepSize) {
        if (this.mStepSize == stepSize) {
            return;
        }
        this.mStepSize = stepSize;
        this.mRunsForwards = this.mStepSize > 0.0;
        this.setInternalStepSize(this.mSolverEngine.getStepSize());
    }

    public double getStepSize() {
        return this.mStepSize;
    }

    public void setEstimateFirstStep(boolean estimate) {
        this.mSolverEngine.setEstimateFirstStep(estimate);
    }

    public void setInternalStepSize(double stepSize) {
        this.mSolverEngine.setStepSize(this.mRunsForwards ? Math.abs(stepSize) : -Math.abs(stepSize));
    }

    public void setMaximumInternalStepSize(double stepSize) {
        this.mSolverEngine.setMaximumStepSize(stepSize);
    }

    public void setMaximumInternalSteps(int steps) {
        this.mMaxInternalSteps = steps;
    }

    public void setTolerances(double absTol, double relTol) {
        this.mAbsoluteTolerance = Math.abs(absTol);
        this.mRelativeTolerance = Math.abs(relTol);
        this.mSolverEngine.setTolerances(this.mAbsoluteTolerance, this.mRelativeTolerance);
    }

    public void setTolerance(double tol) {
        this.setTolerances(tol, 0.0);
    }

    public double getTolerance() {
        return Math.max(this.mAbsoluteTolerance, this.mRelativeTolerance);
    }

    public void setDDETolerance(double tol) {
        this.mDDEdiscontinuityTolerance = tol;
    }

    public double getDDETolerance() {
        return this.mDDEdiscontinuityTolerance;
    }

    public void setDDEIterations(int iterations) {
        this.mDDEdiscontinuityMaxIterations = iterations;
    }

    public int getDDEIterations() {
        return this.mDDEdiscontinuityMaxIterations;
    }

    public void addEvent(StateEvent event) {
        this.mEventList.add(new EventData(event, this.mODE.getState()));
        this.mHasEventsOrDiscontinuities = true;
    }

    public void removeEvent(StateEvent event) {
        EventData foundData = null;
        for (EventData data : this.mEventList) {
            if (data.event != event) continue;
            foundData = data;
            break;
        }
        if (foundData != null) {
            if (this.mLastEventData == foundData) {
                this.mLastEventData = null;
                this.mZenoCounter = 0;
            }
            if (this.mCurrentEventData == foundData) {
                this.mCurrentEventData = null;
            }
            this.mEventList.remove(foundData);
        }
        this.mHasEventsOrDiscontinuities = this.mHasDiscontinuities || !this.mEventList.isEmpty();
    }

    public void addDiscontinuity(Discontinuity discontinuity) {
        this.mDiscontinuityList.add(new DiscontinuityData(discontinuity, this.mODE.getState()));
        this.mHasDiscontinuities = true;
        this.mHasEventsOrDiscontinuities = true;
    }

    public void removeDiscontinuity(Discontinuity discontinuity) {
        DiscontinuityData foundData = null;
        for (DiscontinuityData data : this.mDiscontinuityList) {
            if (data.discontinuity != discontinuity) continue;
            foundData = data;
            break;
        }
        if (foundData != null) {
            this.mDiscontinuityList.remove(foundData);
        }
        this.mHasDiscontinuities = !this.mDiscontinuityList.isEmpty();
        this.mHasEventsOrDiscontinuities = this.mHasDiscontinuities || !this.mEventList.isEmpty();
    }

    public void removeAllEvents() {
        this.mEventList.clear();
        this.mDiscontinuityList.clear();
        this.mHasDiscontinuities = false;
        this.mHasEventsOrDiscontinuities = false;
        if (this.mDDEdiscontinuity != null) {
            this.addDiscontinuity(this.mDDEdiscontinuity);
        }
    }

    public void setMaximumEventStep(double step) {
        this.mMaxEventStep = Math.abs(step);
    }

    public double getMaximumEventStep() {
        return this.mMaxEventStep;
    }

    public void setCoalesceCloseEvents(boolean coalesce) {
        this.mCoalesceCloseEvents = coalesce;
    }

    public boolean isCoalesceCloseEvents() {
        return this.mCoalesceCloseEvents;
    }

    public void setEventProximityThreshold(double threshold) {
        this.mProximityThreshold = threshold;
    }

    public double getEventProximityThreshold() {
        return this.mProximityThreshold;
    }

    public void setZenoEffectDetection(int times) {
        this.mZenoMaximumAllowedTimes = times;
    }

    public int getZenoEffectDetection() {
        return this.mZenoMaximumAllowedTimes;
    }

    public void addZenoEffectListener(ZenoEffectListener listener) {
        this.mZenoList.add(listener);
    }

    public void removeZenoEffectListener(ZenoEffectListener _listener) {
        this.mZenoList.remove(_listener);
    }

    public void setZeroZenoCounter() {
        this.mZenoCounter = 0;
    }

    public SolverEngine getSolverEngine() {
        return this.mSolverEngine;
    }

    public ODE getODE() {
        return this.mODE;
    }

    public StateHistory getStateHistory() {
        return this.mSolverEngine.getStateHistory();
    }

    public ERROR getErrorCode() {
        return this.mErrorCode;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public long getCounter() {
        return this.mSolverEngine.getCounter();
    }

    public int getNumberOfAttempts() {
        return this.mNumberOfAttempts;
    }

    public double getInternalStepSize() {
        return this.mSolverEngine.getInternalStepSize();
    }

    public double getIndependentVariableValue() {
        return this.mODE.getState()[this.mTimeIndex];
    }

    public double getCurrentTime() {
        return this.mODE.getState()[this.mTimeIndex];
    }

    public void initialize(double stepSize) {
        this.mStepSize = stepSize;
        this.mRunsForwards = this.mStepSize > 0.0;
        this.mSolverEngine.initialize(this.mStepSize);
        double[] state = this.mODE.getState();
        this.mDimension = state.length;
        this.mTimeIndex = this.mDimension - 1;
        this.mTest_ode_state = new double[this.mDimension];
        this.mIntermediate_ode_state = new double[this.mDimension];
        this.mErrorCode = ERROR.NO_ERROR;
        this.mErrorMessage = "No error";
        this.mZenoCounter = 0;
        this.mLastEventData = null;
        this.mCurrentEventData = null;
        if (this.mDDEdiscontinuity != null) {
            this.mDDEdiscontinuity.initialize(state);
            this.removeDiscontinuity(this.mDDEdiscontinuity);
            this.addDiscontinuity(this.mDDEdiscontinuity);
        }
        for (EventData eventData : this.mEventList) {
            eventData.reset(state);
        }
        for (DiscontinuityData discontinuityData : this.mDiscontinuityList) {
            discontinuityData.reset(state);
        }
    }

    public double step() {
        if (this.mHasEventsOrDiscontinuities) {
            return this.stepWithEvents();
        }
        return this.stepWithoutEvents();
    }

    public double maxStep() {
        if (this.mHasEventsOrDiscontinuities) {
            return this.maxStepWithEvents();
        }
        return this.maxStepWithoutEvents();
    }

    public void userReinitialize() {
        this.mCurrentEventData = null;
        this.reinitialize();
    }

    public void reinitialize() {
        double[] state = this.mODE.getState();
        this.mSolverEngine.reinitialize(state);
        this.mErrorCode = ERROR.NO_ERROR;
        this.mErrorMessage = "No error";
        if (this.mDDEdiscontinuity != null) {
            this.mDDEdiscontinuity.reset(state);
        }
        for (EventData eventData : this.mEventList) {
            eventData.reset(state);
        }
        for (DiscontinuityData discData : this.mDiscontinuityList) {
            discData.reset(state);
        }
        this.mDiscontinuityAtEnd = null;
    }

    void resetDiscontinuities(double[] state) {
        if (this.mDDEdiscontinuity != null) {
            this.mDDEdiscontinuity.reset(state);
            for (DiscontinuityData discData : this.mDiscontinuityList) {
                discData.reset(state);
            }
        }
    }

    public DISCONTINUITY_CODE checkDiscontinuity(double[] state, boolean isEndOfInterval) {
        DiscontinuityData justHappened = null;
        block6: for (DiscontinuityData data : this.mDiscontinuityList) {
            data.h = data.discontinuity.evaluate(state);
            switch (data.currentPosition) {
                default: {
                    if (data.h <= 0.0) {
                        return DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
                    }
                    if (!(data.h < data.discontinuity.getTolerance())) continue block6;
                    justHappened = data;
                    break;
                }
                case 1: {
                    if (!(data.h <= 0.0) || !data.positiveFlag) continue block6;
                    this.error(ERROR.ILLEGAL_EVENT_STATE, "The system started from an illegal state at " + state[this.mTimeIndex] + " for the discontinuity " + data.discontinuity);
                    return DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
                }
                case 0: {
                    if (data.h < 0.0 && data.positiveFlag) {
                        this.error(ERROR.ILLEGAL_EVENT_STATE, "The system started from an illegal state at " + state[this.mTimeIndex] + " for the discontinuity " + data.discontinuity);
                        return DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
                    }
                    if (!(data.h > 0.0) || !data.negativeFlag) continue block6;
                    this.error(ERROR.ILLEGAL_EVENT_STATE, "The system started from an illegal state at " + state[this.mTimeIndex] + " for the discontinuity " + data.discontinuity);
                    return DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
                }
                case -1: {
                    if (!data.negativeFlag || !(data.h >= 0.0)) continue block6;
                    this.error(ERROR.ILLEGAL_EVENT_STATE, "The system started from an illegal state at " + state[this.mTimeIndex] + " for the discontinuity " + data.discontinuity);
                    return DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
                }
                case -2: {
                    if (data.h > 0.0) {
                        return DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
                    }
                    if (!(data.h > -data.discontinuity.getTolerance())) continue block6;
                    justHappened = data;
                }
            }
        }
        if (justHappened != null) {
            if (isEndOfInterval) {
                this.mDiscontinuityAtEnd = justHappened;
                this.mDiscontinuityAtEnd.time = state[this.mTimeIndex];
            }
            return DISCONTINUITY_CODE.DISCONTINUITY_EXACTLY_ON_STEP;
        }
        return DISCONTINUITY_CODE.NO_DISCONTINUITY_ALONG_STEP;
    }

    protected final void doTheInterpolation(double time, double[] state) {
        if (this.mUseBestInterpolation) {
            this.mSolverEngine.bestInterpolate(time, state);
        } else {
            this.mSolverEngine.interpolate(time, state);
        }
    }

    public double error(ERROR code, String msg) {
        this.mErrorCode = code;
        this.mErrorMessage = msg;
        if (this.mEnableExceptions) {
            throw new ODESolverException(this.mSolverEngine + ":\n" + msg);
        }
        OSPLog.warning(msg);
        return Double.NaN;
    }

    private final double maxStepWithoutEvents() {
        double[] rate;
        double[] state = this.mODE.getState();
        double tBegin = state[this.mTimeIndex];
        if (tBegin + (rate = this.mSolverEngine.getCurrentRate())[this.mTimeIndex] == tBegin) {
            return 0.0;
        }
        double max_t = this.mSolverEngine.getMaximumTime(false);
        if (Double.isNaN(max_t)) {
            return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver at " + state[this.mTimeIndex]);
        }
        if (tBegin == max_t && Double.isNaN(max_t = this.mSolverEngine.internalStep(false))) {
            return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver at max step at " + state[this.mTimeIndex]);
        }
        this.doTheInterpolation(max_t, state);
        return max_t - tBegin;
    }

    /*
     * Unable to fully structure code
     */
    private double stepWithoutEvents() {
        block6: {
            state = this.mODE.getState();
            tBegin = state[this.mTimeIndex];
            if (tBegin + (rate = this.mSolverEngine.getCurrentRate())[this.mTimeIndex] == tBegin) {
                return 0.0;
            }
            tEnd = state[this.mTimeIndex] + this.mStepSize;
            max_t = this.mSolverEngine.getMaximumTime(false);
            if (Double.isNaN(max_t)) {
                return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver at " + state[this.mTimeIndex]);
            }
            counter = 0;
            if (!this.mRunsForwards) ** GOTO lbl25
            while (max_t < tEnd) {
                max_t = this.mSolverEngine.internalStep(false);
                if (Double.isNaN(max_t)) {
                    return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver forwards at " + state[this.mTimeIndex]);
                }
                if (++counter <= this.mMaxInternalSteps) continue;
                initTime = state[this.mTimeIndex];
                currentTime = this.mSolverEngine.bestInterpolate(tEnd, new double[this.mDimension])[this.mTimeIndex];
                return this.error(ERROR.TOO_MANY_STEPS_ERROR, "The solver exceeded the maximum of " + this.mMaxInternalSteps + " internal steps\nat " + currentTime + ", starting from " + initTime + " for an step of " + this.mStepSize);
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                max_t = this.mSolverEngine.internalStep(false);
                if (Double.isNaN(max_t)) {
                    return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver backwards at " + state[this.mTimeIndex]);
                }
                if (++counter <= this.mMaxInternalSteps) continue;
                return this.error(ERROR.TOO_MANY_STEPS_ERROR, "The solver exceeded the number of internal steps at " + state[this.mTimeIndex]);
lbl25:
                // 2 sources

                ** while (max_t > tEnd)
            }
        }
        this.doTheInterpolation(tEnd, state);
        return this.mStepSize;
    }

    private final double maxStepWithEvents() {
        ProblemData problem;
        double[] state = this.mODE.getState();
        if (this.mZenoMaximumAllowedTimes > 0 && this.mZenoCounter > this.mZenoMaximumAllowedTimes && this.callZenoAction(state)) {
            return 0.0;
        }
        double tBegin = state[this.mTimeIndex];
        double[] rate = this.mSolverEngine.getCurrentRate();
        if (tBegin + rate[this.mTimeIndex] == tBegin) {
            return 0.0;
        }
        double max_t = this.mSolverEngine.getMaximumTime(this.mHasDiscontinuities);
        if (Double.isNaN(max_t)) {
            return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver at " + state[this.mTimeIndex]);
        }
        if (tBegin == max_t && Double.isNaN(max_t = this.mSolverEngine.internalStep(this.mHasDiscontinuities))) {
            return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver forwards at " + state[this.mTimeIndex]);
        }
        if (this.mLastEventData != null && !Double.isNaN(this.mLastEventData.getMaxAdvance())) {
            max_t = this.mRunsForwards ? Math.min(max_t, this.mLastEventData.getMaxAdvance()) : Math.max(max_t, this.mLastEventData.getMaxAdvance());
        }
        double tTest = this.mRunsForwards ? Math.min(tBegin + this.mMaxEventStep, max_t) : Math.max(tBegin - this.mMaxEventStep, max_t);
        while (true) {
            problem = null;
            this.mCurrentEventData = null;
            this.doTheInterpolation(tTest, this.mTest_ode_state);
            problem = this.findFirstEvent(state, tTest, this.mTest_ode_state);
            if (problem == null && this.mDiscontinuityAtEnd != null && this.mDiscontinuityAtEnd.time <= tTest) {
                problem = this.mDiscontinuityAtEnd;
            }
            if (problem != null) break;
            if (tTest == max_t) {
                System.arraycopy(this.mTest_ode_state, 0, state, 0, this.mDimension);
                this.updateEventsAndDiscontinuities(state[this.mTimeIndex]);
                return max_t - tBegin;
            }
            tTest = this.mRunsForwards ? Math.min(tTest + this.mMaxEventStep, max_t) : Math.max(tTest - this.mMaxEventStep, max_t);
        }
        this.mCurrentEventData = problem;
        if (this.mUseBestInterpolation) {
            this.mSolverEngine.bestInterpolate(problem.getTime(), state);
        } else {
            System.arraycopy(this.mTest_ode_state, 0, state, 0, this.mDimension);
        }
        double timeBefore = state[this.mTimeIndex];
        problem.action();
        this.reinitialize();
        state = this.mODE.getState();
        if (timeBefore != state[this.mTimeIndex]) {
            this.mZenoCounter = 0;
            this.mLastEventData = null;
            this.mCurrentEventData = null;
            problem.reset(state);
            return problem.getTime() - tBegin;
        }
        if (this.mLastEventData != null) {
            this.mZenoCounter = Math.abs(this.mLastEventDataTime - problem.getTime()) < this.mProximityThreshold ? ++this.mZenoCounter : 0;
        }
        this.mLastEventData = problem;
        this.mLastEventDataTime = problem.getTime();
        return problem.getTime() - tBegin;
    }

    private double stepWithEvents() {
        double[] state = this.mODE.getState();
        if (this.mZenoMaximumAllowedTimes > 0 && this.mZenoCounter > this.mZenoMaximumAllowedTimes && this.callZenoAction(state)) {
            return 0.0;
        }
        double tBegin = state[this.mTimeIndex];
        double[] rate = this.mSolverEngine.getCurrentRate();
        if (tBegin + rate[this.mTimeIndex] == tBegin) {
            return 0.0;
        }
        double tEnd = tBegin + this.mStepSize;
        double max_t = this.mSolverEngine.getMaximumTime(this.mHasDiscontinuities);
        if (Double.isNaN(max_t)) {
            return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver at " + state[this.mTimeIndex]);
        }
        double tTest = this.mRunsForwards ? Math.min(tBegin + this.mMaxEventStep, tEnd) : Math.max(tBegin - this.mMaxEventStep, tEnd);
        int counter = 0;
        while (true) {
            boolean notYetThere;
            ProblemData problem = null;
            this.mCurrentEventData = null;
            boolean bl = this.mRunsForwards ? max_t < tTest : (notYetThere = max_t > tTest);
            if (notYetThere) {
                this.mSolverEngine.bestInterpolate(max_t, this.mTest_ode_state);
                problem = this.findFirstEvent(state, max_t, this.mTest_ode_state);
                if (problem == null) {
                    problem = this.mDiscontinuityAtEnd;
                }
                if (problem == null) {
                    System.arraycopy(this.mTest_ode_state, 0, state, 0, this.mDimension);
                    this.updateEventsAndDiscontinuities(state[this.mTimeIndex]);
                    max_t = this.mSolverEngine.internalStep(this.mHasDiscontinuities);
                    if (Double.isNaN(max_t)) {
                        return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver looking for an event at " + state[this.mTimeIndex]);
                    }
                    if (++counter <= this.mMaxInternalSteps) continue;
                    return this.error(ERROR.TOO_MANY_STEPS_ERROR, "The solver exceeded the number of internal steps at " + state[this.mTimeIndex]);
                }
            } else {
                this.doTheInterpolation(tTest, this.mTest_ode_state);
                problem = this.findFirstEvent(state, tTest, this.mTest_ode_state);
                if (problem == null && this.mDiscontinuityAtEnd != null && this.mDiscontinuityAtEnd.time <= tTest) {
                    problem = this.mDiscontinuityAtEnd;
                }
                if (problem == null) {
                    if (tTest == tEnd) {
                        System.arraycopy(this.mTest_ode_state, 0, state, 0, this.mDimension);
                        this.updateEventsAndDiscontinuities(state[this.mTimeIndex]);
                        return tEnd - tBegin;
                    }
                    tTest = this.mRunsForwards ? Math.min(tTest + this.mMaxEventStep, tEnd) : Math.max(tTest - this.mMaxEventStep, tEnd);
                    continue;
                }
            }
            this.mCurrentEventData = problem;
            if (this.mUseBestInterpolation) {
                this.mSolverEngine.bestInterpolate(problem.getTime(), state);
            } else {
                System.arraycopy(this.mTest_ode_state, 0, state, 0, this.mDimension);
            }
            double timeBefore = state[this.mTimeIndex];
            boolean wantsToQuit = problem.action();
            this.reinitialize();
            counter = 0;
            state = this.mODE.getState();
            if (timeBefore != state[this.mTimeIndex]) {
                this.mZenoCounter = 0;
                this.mLastEventData = null;
                this.mCurrentEventData = null;
                problem.reset(state);
                return problem.getTime() - tBegin;
            }
            if (this.mLastEventData != null) {
                if (Math.abs(this.mLastEventDataTime - problem.getTime()) < this.mProximityThreshold) {
                    ++this.mZenoCounter;
                    if (this.mCoalesceCloseEvents) {
                        wantsToQuit = false;
                    }
                } else {
                    this.mZenoCounter = 0;
                }
            }
            this.mLastEventData = problem;
            this.mLastEventDataTime = problem.getTime();
            if (wantsToQuit) {
                return problem.getTime() - tBegin;
            }
            if (this.mZenoMaximumAllowedTimes > 0 && this.mZenoCounter > this.mZenoMaximumAllowedTimes && this.callZenoAction(state)) {
                return problem.getTime() - tBegin;
            }
            this.mDiscontinuityAtEnd = null;
            max_t = this.mSolverEngine.getMaximumTime(this.mHasDiscontinuities);
            if (!Double.isNaN(problem.getMaxAdvance())) {
                double d = max_t = this.mRunsForwards ? Math.min(max_t, problem.getMaxAdvance()) : Math.max(max_t, problem.getMaxAdvance());
            }
            if (Double.isNaN(max_t)) break;
        }
        return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver after an event at " + state[this.mTimeIndex]);
    }

    private void updateEventsAndDiscontinuities(double time) {
        for (EventData eventData : this.mEventList) {
            eventData.findPosition(time, eventData.h);
        }
        for (DiscontinuityData discontinuityData : this.mDiscontinuityList) {
            discontinuityData.findPosition(time, discontinuityData.h);
        }
    }

    private boolean callZenoAction(double[] state) {
        if (this.mZenoList.isEmpty()) {
            this.error(ERROR.ZENO_EFFECT, "A Zeno-like effect has been detected.\nLast event was " + this.mLastEventData.getProblem() + " which took place at " + this.mLastEventDataTime);
            return true;
        }
        boolean returnAtZeno = false;
        for (ZenoEffectListener listener : this.mZenoList) {
            if (!listener.zenoEffectAction(this.mLastEventData.getProblem(), state)) continue;
            returnAtZeno = true;
        }
        this.mZenoCounter = 0;
        return returnAtZeno;
    }

    private EventData findFirstEvent(double[] current_state, double tFinal, double[] final_state) {
        this.mNumberOfAttempts = 0;
        EventData happensAtT1 = this.happensRightNow(current_state[this.mTimeIndex], final_state, this.mHappened, "at t1");
        if (happensAtT1 != null) {
            happensAtT1.time = current_state[this.mTimeIndex];
            happensAtT1.maxAdvance = tFinal;
            System.arraycopy(current_state, 0, final_state, 0, this.mDimension);
            return happensAtT1;
        }
        if (this.mHappened.isEmpty()) {
            return null;
        }
        boolean doItAgain = true;
        for (EventData eventData : this.mEventList) {
            eventData.hAfter = eventData.h;
        }
        block1: while (doItAgain) {
            ++this.mNumberOfAttempts;
            double tTest = this.nextPointToCheck(this.mHappened, current_state[this.mTimeIndex], tFinal);
            this.doTheInterpolation(tTest, this.mIntermediate_ode_state);
            EventData shortDurationEvent = this.happensRightNow(current_state[this.mTimeIndex], this.mIntermediate_ode_state, this.mTemp_list, "short");
            if (shortDurationEvent != null) {
                shortDurationEvent.time = current_state[this.mTimeIndex];
                shortDurationEvent.maxAdvance = tTest;
                System.arraycopy(current_state, 0, final_state, 0, this.mDimension);
                return shortDurationEvent;
            }
            if (this.mTemp_list.isEmpty()) {
                EventData happensInTtest = null;
                for (EventData eventData : this.mHappened) {
                    if (eventData.currentPosition == 2) {
                        if (!(eventData.h < eventData.event.getTolerance())) continue;
                        happensInTtest = eventData;
                        break;
                    }
                    if (!(eventData.h > -eventData.event.getTolerance())) continue;
                    happensInTtest = eventData;
                    break;
                }
                if (happensInTtest != null) {
                    happensInTtest.time = tTest;
                    happensInTtest.maxAdvance = tFinal;
                    System.arraycopy(this.mIntermediate_ode_state, 0, final_state, 0, this.mDimension);
                    return happensInTtest;
                }
                System.arraycopy(this.mIntermediate_ode_state, 0, current_state, 0, this.mDimension);
                for (EventData eventData : this.mEventList) {
                    eventData.findPosition(current_state[this.mTimeIndex], eventData.h);
                }
                EventData happensNowInTtest = this.happensRightNow(current_state[this.mTimeIndex], final_state, this.mHappened, "at tTest");
                if (happensNowInTtest != null) {
                    happensNowInTtest.time = current_state[this.mTimeIndex];
                    happensNowInTtest.maxAdvance = tFinal;
                    System.arraycopy(current_state, 0, final_state, 0, this.mDimension);
                    return happensNowInTtest;
                }
            } else {
                boolean notPreviousFound = true;
                EventData happensInTtest = null;
                for (EventData data : this.mTemp_list) {
                    if (data.currentPosition == 2) {
                        if (data.h <= -data.event.getTolerance()) {
                            notPreviousFound = false;
                            break;
                        }
                        happensInTtest = data;
                        continue;
                    }
                    if (data.h >= data.event.getTolerance()) {
                        notPreviousFound = false;
                        break;
                    }
                    happensInTtest = data;
                }
                if (notPreviousFound && happensInTtest != null) {
                    happensInTtest.time = tTest;
                    happensInTtest.maxAdvance = tFinal;
                    System.arraycopy(this.mIntermediate_ode_state, 0, final_state, 0, this.mDimension);
                    return happensInTtest;
                }
                tFinal = tTest;
                System.arraycopy(this.mIntermediate_ode_state, 0, final_state, 0, this.mDimension);
                for (EventData eventData : this.mEventList) {
                    eventData.hAfter = eventData.h;
                }
                this.mHappened.clear();
                this.mHappened.addAll(this.mTemp_list);
            }
            for (EventData data : this.mHappened) {
                if (this.mNumberOfAttempts <= data.event.getMaxIterations()) continue;
                doItAgain = false;
                continue block1;
            }
        }
        EventData remaining = this.mHappened.get(0);
        this.error(ERROR.EVENT_NOT_FOUND, "Warning : Event not found after " + this.mNumberOfAttempts + " attempts at t=" + current_state[this.mTimeIndex] + " h = " + remaining.h + ".\nPlease check the code of your event, decrease the initial step size, the tolerance of the solver," + "\nor the event maximum step, or increase the maximum number of attempts." + "\nFirst event remaining in the queue: " + remaining.event);
        remaining.time = (current_state[this.mTimeIndex] + tFinal) / 2.0;
        remaining.maxAdvance = Double.NaN;
        this.mSolverEngine.bestInterpolate(remaining.time, final_state);
        return remaining;
    }

    private EventData happensRightNow(double currentTime, double[] final_state, List<EventData> list, String id) {
        list.clear();
        block6: for (EventData eventData : this.mEventList) {
            eventData.h = eventData.event.evaluate(final_state);
            switch (eventData.currentPosition) {
                default: {
                    if (!(eventData.h <= 0.0)) continue block6;
                    list.add(eventData);
                    break;
                }
                case 1: {
                    if (!(eventData.h <= 0.0) || !eventData.positiveFlag && eventData.eventType != 0) continue block6;
                    return eventData;
                }
                case 0: {
                    if (!(eventData.h < 0.0 ? eventData.positiveFlag || eventData.eventType == 0 : eventData.h > 0.0 && eventData.negativeFlag && eventData.eventType == 2)) continue block6;
                    return eventData;
                }
                case -1: {
                    if (!(eventData.eventType == 0 ? eventData.h <= -eventData.event.getTolerance() : eventData.eventType == 2 && eventData.negativeFlag && eventData.h >= 0.0)) continue block6;
                    return eventData;
                }
                case -2: {
                    if (eventData.eventType == 2) {
                        if (!(eventData.h >= 0.0)) continue block6;
                        list.add(eventData);
                        break;
                    }
                    if (eventData.eventType != 0) continue block6;
                    this.error(ERROR.ILLEGAL_EVENT_STATE, "The system started from an illegal state at " + currentTime + " for the state event " + eventData.event);
                    return eventData;
                }
            }
        }
        return null;
    }

    private double nextPointToCheck(List<EventData> list, double t1, double t2) {
        double tFirst = t2;
        double dt = t2 - t1;
        double tMiddle = (t1 + t2) / 2.0;
        if (this.mRunsForwards) {
            for (EventData eventData : list) {
                switch (eventData.event.getRootFindingMethod()) {
                    default: {
                        tFirst = Math.min(tFirst, tMiddle);
                        break;
                    }
                    case 1: {
                        tFirst = Math.min(tFirst, t1 - eventData.hBefore * dt / (eventData.hAfter - eventData.hBefore));
                    }
                }
            }
        } else {
            for (EventData eventData : list) {
                switch (eventData.event.getRootFindingMethod()) {
                    default: {
                        tFirst = Math.max(tFirst, tMiddle);
                        break;
                    }
                    case 1: {
                        tFirst = Math.max(tFirst, t1 - eventData.hBefore * dt / (eventData.hAfter - eventData.hBefore));
                    }
                }
            }
        }
        return tFirst;
    }

    static /* synthetic */ int access$7(InterpolatorEventSolver interpolatorEventSolver) {
        return interpolatorEventSolver.mDDEdiscontinuityMaxIterations;
    }

    private class DDEDiscontinuity
    implements Discontinuity {
        DelayDifferentialEquation mDDE;
        List<Double> mDiscontinuities = new ArrayList<Double>();
        int[] mDiIndex;
        double[] mRateForCorrections;

        private DDEDiscontinuity(DelayDifferentialEquation dde) {
            this.mDDE = dde;
        }

        private void initialize(double[] state) {
            if (InterpolatorEventSolver.this.mRunsForwards) {
                this.mDiscontinuities.add(Double.NEGATIVE_INFINITY);
            } else {
                this.mDiscontinuities.add(Double.POSITIVE_INFINITY);
            }
            double[] initDisc = this.mDDE.getInitialConditionDiscontinuities();
            if (initDisc != null) {
                double[] dArray = initDisc;
                int n = initDisc.length;
                int n2 = 0;
                while (n2 < n) {
                    double disc = dArray[n2];
                    this.mDiscontinuities.add(disc);
                    ++n2;
                }
            }
            this.mDiscontinuities.add(state[InterpolatorEventSolver.this.mTimeIndex]);
            double[] delays = this.mDDE.getDelays(state);
            this.mDiIndex = new int[delays.length];
            this.reset(state);
            this.mRateForCorrections = new double[InterpolatorEventSolver.this.mDimension];
        }

        void reset(double[] state) {
            int i = 0;
            while (i < this.mDiIndex.length) {
                this.mDiIndex[i] = 0;
                ++i;
            }
            this.update(state);
        }

        private void update(double[] state) {
            double[] delays = this.mDDE.getDelays(state);
            int n = delays.length;
            int discCount = this.mDiscontinuities.size();
            if (InterpolatorEventSolver.this.mRunsForwards) {
                int i = 0;
                while (i < n) {
                    double limit = state[InterpolatorEventSolver.this.mTimeIndex] - delays[i] + this.getTolerance();
                    int index = this.mDiIndex[i];
                    while (index < discCount) {
                        double disc = this.mDiscontinuities.get(index);
                        if (disc > limit) {
                            this.mDiIndex[i] = index;
                            break;
                        }
                        ++index;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < n) {
                    double limit = state[InterpolatorEventSolver.this.mTimeIndex] - delays[i] - this.getTolerance();
                    int index = this.mDiIndex[i];
                    while (index < discCount) {
                        double disc = this.mDiscontinuities.get(index);
                        if (disc < limit) {
                            this.mDiIndex[i] = index;
                            break;
                        }
                        ++index;
                    }
                    ++i;
                }
            }
        }

        @Override
        public double evaluate(double[] state) {
            double t = state[InterpolatorEventSolver.this.mTimeIndex];
            double[] delays = this.mDDE.getDelays(state);
            int n = delays.length;
            if (InterpolatorEventSolver.this.mRunsForwards) {
                double min = Double.POSITIVE_INFINITY;
                int i = 0;
                while (i < n) {
                    double di = this.mDiscontinuities.get(this.mDiIndex[i]);
                    min = Math.min(min, delays[i] + di - t);
                    ++i;
                }
                return min;
            }
            double max = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < n) {
                double di = this.mDiscontinuities.get(this.mDiIndex[i]);
                max = Math.max(max, delays[i] + di - t);
                ++i;
            }
            return max;
        }

        /*
         * Unable to fully structure code
         */
        private double correctTime(double[] state) {
            block4: {
                step = InterpolatorEventSolver.access$6(InterpolatorEventSolver.this) / 20.0;
                counter = 0;
                if (!InterpolatorEventSolver.access$4(InterpolatorEventSolver.this)) ** GOTO lbl28
                while (++counter < InterpolatorEventSolver.access$7(InterpolatorEventSolver.this)) {
                    this.mDDE.getRate(state, this.mRateForCorrections);
                    InterpolatorEventSolver.this.mSolverEngine.getStateHistory().addIntervalData(new EulerIntervalData(state, this.mRateForCorrections, state[InterpolatorEventSolver.access$0(InterpolatorEventSolver.this)] + step));
                    i = 0;
                    while (i < InterpolatorEventSolver.access$5(InterpolatorEventSolver.this)) {
                        v0 = i;
                        state[v0] = state[v0] + step * this.mRateForCorrections[i];
                        ++i;
                    }
                    h = this.evaluate(state);
                    if (!(h < 0.0)) continue;
                    return state[InterpolatorEventSolver.access$0(InterpolatorEventSolver.this)];
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    this.mDDE.getRate(state, this.mRateForCorrections);
                    InterpolatorEventSolver.this.mSolverEngine.getStateHistory().addIntervalData(new EulerIntervalData(state, this.mRateForCorrections, state[InterpolatorEventSolver.access$0(InterpolatorEventSolver.this)] - step));
                    i = 0;
                    while (i < InterpolatorEventSolver.access$5(InterpolatorEventSolver.this)) {
                        v1 = i;
                        state[v1] = state[v1] - step * this.mRateForCorrections[i];
                        ++i;
                    }
                    h = this.evaluate(state);
                    if (!(h > 0.0)) continue;
                    return state[InterpolatorEventSolver.access$0(InterpolatorEventSolver.this)];
lbl28:
                    // 2 sources

                    ** while (++counter < InterpolatorEventSolver.access$7((InterpolatorEventSolver)InterpolatorEventSolver.this))
                }
            }
            return NaN;
        }

        @Override
        public boolean action() {
            double[] state = this.mDDE.getState();
            double time = this.correctTime(state);
            this.mDiscontinuities.add(time);
            EventData eventData = InterpolatorEventSolver.this.findFirstEvent(state, time, state);
            if (eventData != null) {
                InterpolatorEventSolver.this.mCurrentEventData = eventData;
                eventData.action();
            }
            return true;
        }

        @Override
        public double getTolerance() {
            return InterpolatorEventSolver.this.mDDEdiscontinuityTolerance;
        }
    }

    public static enum DISCONTINUITY_CODE {
        DISCONTINUITY_PRODUCED_ERROR,
        NO_DISCONTINUITY_ALONG_STEP,
        DISCONTINUITY_ALONG_STEP,
        DISCONTINUITY_JUST_PASSED,
        DISCONTINUITY_EXACTLY_ON_STEP;

    }

    private class DiscontinuityData
    implements ProblemData {
        Discontinuity discontinuity;
        boolean positiveFlag;
        boolean negativeFlag;
        int currentPosition;
        double hBefore;
        double h;
        double time;

        DiscontinuityData(Discontinuity _disc, double[] state) {
            this.discontinuity = _disc;
            this.reset(state);
        }

        @Override
        public double getTime() {
            return this.time;
        }

        @Override
        public double getMaxAdvance() {
            return Double.NaN;
        }

        @Override
        public boolean action() {
            return this.discontinuity.action();
        }

        @Override
        public Object getProblem() {
            return this.discontinuity;
        }

        @Override
        public void reset(double[] state) {
            this.negativeFlag = false;
            this.positiveFlag = false;
            double h = this.discontinuity.evaluate(state);
            this.findPosition(state[InterpolatorEventSolver.this.mTimeIndex], h);
            if (InterpolatorEventSolver.this.mCurrentEventData != this) {
                if (h > 0.0) {
                    this.positiveFlag = true;
                } else if (h < 0.0) {
                    this.negativeFlag = true;
                }
            }
        }

        @Override
        public void findPosition(double _time, double hValue) {
            this.hBefore = hValue;
            if (this.hBefore >= this.discontinuity.getTolerance()) {
                this.currentPosition = 2;
                this.positiveFlag = true;
            } else if (this.hBefore > 0.0) {
                this.currentPosition = 1;
            } else if (this.hBefore == 0.0) {
                this.currentPosition = 0;
            } else if (this.hBefore > -this.discontinuity.getTolerance()) {
                this.currentPosition = -1;
            } else {
                this.currentPosition = -2;
                this.negativeFlag = true;
            }
        }
    }

    public static enum ERROR {
        NO_ERROR,
        INTERNAL_SOLVER_ERROR,
        EVENT_NOT_FOUND,
        ILLEGAL_EVENT_STATE,
        ZENO_EFFECT,
        TOO_MANY_STEPS_ERROR,
        DISCONTINUITY_PRODUCED_ERROR,
        DID_NOT_CONVERGE;

    }

    private class EventData
    implements ProblemData {
        StateEvent event;
        boolean positiveFlag;
        boolean negativeFlag;
        final int eventType;
        int currentPosition;
        double hBefore;
        double hAfter;
        double h;
        double time;
        double maxAdvance;

        EventData(StateEvent _event, double[] state) {
            this.event = _event;
            this.eventType = this.event.getTypeOfEvent();
            this.reset(state);
        }

        @Override
        public double getTime() {
            return this.time;
        }

        @Override
        public double getMaxAdvance() {
            return this.maxAdvance;
        }

        @Override
        public boolean action() {
            return this.event.action();
        }

        @Override
        public Object getProblem() {
            return this.event;
        }

        @Override
        public void reset(double[] state) {
            this.negativeFlag = false;
            this.positiveFlag = false;
            double h = this.event.evaluate(state);
            this.findPosition(state[InterpolatorEventSolver.this.mTimeIndex], h);
            if (InterpolatorEventSolver.this.mCurrentEventData != this) {
                if (this.eventType == 2) {
                    if (h > 0.0) {
                        this.positiveFlag = true;
                    } else if (h < 0.0) {
                        this.negativeFlag = true;
                    }
                } else if (this.eventType == 1 && h > 0.0) {
                    this.positiveFlag = true;
                }
            }
        }

        @Override
        public void findPosition(double _time, double hValue) {
            this.hBefore = hValue;
            if (this.hBefore >= this.event.getTolerance()) {
                this.currentPosition = 2;
                this.positiveFlag = true;
            } else if (this.hBefore > 0.0) {
                this.currentPosition = 1;
            } else if (this.hBefore == 0.0) {
                this.currentPosition = 0;
            } else if (this.hBefore > -this.event.getTolerance()) {
                this.currentPosition = -1;
            } else {
                this.currentPosition = -2;
                this.negativeFlag = true;
            }
            if (this.eventType == 0 && this.currentPosition == -2) {
                String msg = "The state event " + this.event + " is in an illegal state: " + this.hBefore + " at " + _time;
                msg = InterpolatorEventSolver.this.mLastEventData == null ? String.valueOf(msg) + "\nThere was no previous event" : String.valueOf(msg) + "\nLast previous event was " + InterpolatorEventSolver.this.mLastEventData.getProblem() + ", which took place at " + InterpolatorEventSolver.this.mLastEventDataTime;
                InterpolatorEventSolver.this.error(ERROR.ILLEGAL_EVENT_STATE, msg);
            }
        }
    }

    private static interface ProblemData {
        public static final int POSITIVE = 2;
        public static final int SMALL_POSITIVE = 1;
        public static final int ZERO = 0;
        public static final int SMALL_NEGATIVE = -1;
        public static final int NEGATIVE = -2;

        public void reset(double[] var1);

        public void findPosition(double var1, double var3);

        public double getTime();

        public double getMaxAdvance();

        public boolean action();

        public Object getProblem();
    }
}

