/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ode_interpolation.ConstantConditionData;
import org.opensourcephysics.numerics.ode_interpolation.InitialConditionData;
import org.opensourcephysics.numerics.ode_interpolation.IntervalData;
import org.opensourcephysics.numerics.ode_solvers.DelayDifferentialEquation;

public class StateHistory {
    private LinkedList<IntervalData> mIntervalList = new LinkedList();
    private boolean mForwards = true;
    private IntervalData mLastResourceInterval = null;
    private double mMinimumLength = 0.0;
    private double mUserLength = 0.0;
    private double mActualLength = 0.0;

    public StateHistory(ODE ode) {
        if (ode instanceof DelayDifferentialEquation) {
            DelayDifferentialEquation dde = (DelayDifferentialEquation)ode;
            this.mLastResourceInterval = new InitialConditionData(dde);
            dde.setStateHistory(this);
        } else {
            this.mLastResourceInterval = new ConstantConditionData(ode.getState());
        }
    }

    public void setLength(double length) {
        this.mUserLength = Math.abs(length);
        this.mActualLength = Math.max(this.mMinimumLength, this.mUserLength);
    }

    public void setMinimumLength(double length) {
        this.mMinimumLength = Math.abs(length);
        this.mActualLength = Math.max(this.mMinimumLength, this.mUserLength);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void addIntervalData(IntervalData data) {
        block6: {
            v0 = this.mForwards = data.getLeft() <= data.getRight();
            if (this.mIntervalList.isEmpty()) break block6;
            lastInterval /* !! */  = this.mIntervalList.getLast();
            if (!this.mForwards) ** GOTO lbl16
            while (lastInterval /* !! */  != null && lastInterval /* !! */ .getLeft() >= data.getLeft()) {
                this.mIntervalList.removeLast();
                lastInterval /* !! */  = this.mIntervalList.isEmpty() != false ? null : this.mIntervalList.getLast();
            }
            if (lastInterval /* !! */  == null || !(data.getLeft() < lastInterval /* !! */ .getRight())) break block6;
            lastInterval /* !! */ .setRight(data.getLeft());
            break block6;
lbl-1000:
            // 1 sources

            {
                this.mIntervalList.removeLast();
                lastInterval /* !! */  = this.mIntervalList.isEmpty() != false ? null : this.mIntervalList.getLast();
lbl16:
                // 2 sources

                ** while (lastInterval /* !! */  != null && lastInterval /* !! */ .getLeft() <= data.getLeft())
            }
lbl17:
            // 1 sources

            if (lastInterval /* !! */  != null && data.getLeft() > lastInterval /* !! */ .getRight()) {
                lastInterval /* !! */ .setRight(data.getLeft());
            }
        }
        this.mIntervalList.addLast(data);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("History has now " + this.mIntervalList.size() + " intervals");
        ListIterator iterator = this.mIntervalList.listIterator();
        while (iterator.hasNext()) {
            IntervalData interval = (IntervalData)iterator.next();
            buffer.append("Interval : [" + interval.getLeft() + " , " + interval.getRight() + ")");
        }
        return buffer.toString();
    }

    public void clearAll() {
        this.mIntervalList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(double currentTime) {
        if (Double.isInfinite(this.mActualLength)) {
            return;
        }
        if (this.mActualLength == 0.0) {
            this.clearAll();
            return;
        }
        currentTime = this.mForwards ? currentTime - this.mActualLength : currentTime + this.mActualLength;
        LinkedList<IntervalData> linkedList = this.mIntervalList;
        synchronized (linkedList) {
            ArrayList<IntervalData> toBeRemoved = new ArrayList<IntervalData>();
            if (this.mForwards) {
                currentTime -= this.mActualLength;
                ListIterator iterator = this.mIntervalList.listIterator();
                while (iterator.hasNext()) {
                    IntervalData interval = (IntervalData)iterator.next();
                    if (!(interval.getRight() > currentTime)) {
                        toBeRemoved.add(interval);
                        continue;
                    }
                    break;
                }
            } else {
                currentTime += this.mActualLength;
                ListIterator iterator = this.mIntervalList.listIterator();
                while (iterator.hasNext()) {
                    IntervalData interval = (IntervalData)iterator.next();
                    if (!(interval.getRight() < currentTime)) {
                        toBeRemoved.add(interval);
                        continue;
                    }
                    break;
                }
            }
            this.mIntervalList.removeAll(toBeRemoved);
        }
    }

    private IntervalData findInterval(double time) {
        if (this.mForwards) {
            Iterator<IntervalData> iterator = this.mIntervalList.descendingIterator();
            while (iterator.hasNext()) {
                IntervalData interval = iterator.next();
                if (!(interval.getLeft() <= time)) continue;
                return interval;
            }
        } else {
            Iterator<IntervalData> iterator = this.mIntervalList.descendingIterator();
            while (iterator.hasNext()) {
                IntervalData interval = iterator.next();
                if (!(interval.getLeft() >= time)) continue;
                return interval;
            }
        }
        return this.mLastResourceInterval;
    }

    public double[] interpolate(double time, double[] state) {
        IntervalData interval = this.findInterval(time);
        return interval.interpolate(time, state);
    }

    public double[] interpolate(double time, double[] state, int beginIndex, int length) {
        IntervalData interval = this.findInterval(time);
        return interval.interpolate(time, state, beginIndex, length);
    }

    public double interpolate(double time, int index) {
        IntervalData interval = this.findInterval(time);
        return interval.interpolate(time, index);
    }
}

