/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Frame;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.ResourceLoader;

public class VideoClip {
    public boolean changeEngine;
    private int startFrame = 0;
    private int stepSize = 1;
    private int stepCount;
    private int frameCount = this.stepCount = 10;
    private int maxFrameCount = 300000;
    private int frameShift = 0;
    private double startTime = 0.0;
    protected boolean isDefaultStartTime = true;
    protected Video video = null;
    private int[] stepFrames;
    ClipInspector inspector;
    private PropertyChangeSupport support = new SwingPropertyChangeSupport(this);
    private boolean playAllSteps = false;
    private boolean isDefaultState;
    private boolean isAdjusting = false;
    private int endFrame;
    protected String readoutType;
    protected String videoPath;
    protected double savedStartTime;
    protected boolean startTimeIsSaved = false;
    protected int extraFrames = 0;

    public VideoClip(Video video2) {
        this.video = video2;
        if (video2 != null) {
            video2.setProperty("videoclip", this);
            this.setStartFrameNumber(video2.getStartFrameNumber());
            if (video2.getFrameCount() > 1) {
                this.setStepCount(video2.getEndFrameNumber() - this.startFrame + 1);
            }
        }
        this.updateArray();
        this.isDefaultState = true;
    }

    public Video getVideo() {
        return this.video;
    }

    public String getVideoPath() {
        if (this.video != null) {
            return (String)this.video.getProperty("absolutePath");
        }
        return this.videoPath;
    }

    public boolean setStartFrameNumber(int n) {
        int n2 = this.getLastFrameNumber();
        return this.setStartFrameNumber(n, n2);
    }

    public boolean setStartFrameNumber(int n, int n2) {
        int n3 = this.getStartFrameNumber();
        int n4 = this.getEndFrameNumber();
        n = Math.max(n, this.getFirstFrameNumber());
        n = Math.min(n, n2);
        if (this.video != null && this.video.getFrameCount() > 1) {
            this.video.setEndFrameNumber(this.video.getFrameCount() - 1);
            int n5 = Math.max(0, n + this.frameShift);
            this.video.setStartFrameNumber(n5);
            this.startFrame = Math.max(0, this.video.getStartFrameNumber() - this.frameShift);
        } else {
            this.startFrame = n;
            this.updateArray();
        }
        n = this.getStartFrameNumber();
        this.setEndFrameNumber(n4);
        if (n3 != n) {
            this.isDefaultState = false;
            this.support.firePropertyChange("startframe", null, new Integer(n));
        }
        return n3 != n;
    }

    public int getStartFrameNumber() {
        return this.startFrame;
    }

    public boolean setStepSize(int n) {
        int n2;
        this.isDefaultState = false;
        if (n == 0) {
            return false;
        }
        n = Math.abs(n);
        if (this.video != null && this.video.getFrameCount() > 1) {
            n2 = Math.max(this.video.getFrameCount() - this.startFrame - 1 + this.extraFrames, 1);
            n = Math.min(n, n2);
        }
        if (this.stepSize == n) {
            return false;
        }
        n2 = this.getEndFrameNumber();
        this.stepSize = n;
        this.stepCount = 1 + (n2 - this.getStartFrameNumber()) / this.stepSize;
        this.updateArray();
        this.support.firePropertyChange("stepsize", null, new Integer(n));
        this.setEndFrameNumber(n2);
        this.trimFrameCount();
        return true;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepCount(int n) {
        if (n == 0) {
            return;
        }
        n = Math.abs(n);
        if (this.video != null) {
            int n2;
            if (this.video.getFrameCount() > 1) {
                n2 = this.video.getFrameCount() - 1 - this.frameShift + this.extraFrames;
                int n3 = 1 + (int)((double)(n2 - this.startFrame) / (1.0 * (double)this.stepSize));
                n = Math.min(n, n3);
            }
            if ((n2 = this.startFrame + (n - 1) * this.stepSize + this.frameShift) != this.video.getEndFrameNumber()) {
                this.video.setEndFrameNumber(n2);
            }
        } else {
            n = Math.min(n, this.frameToStep(this.maxFrameCount - 1) + 1);
        }
        if (this.stepCount == (n = Math.max(n, 1))) {
            this.updateArray();
            return;
        }
        Integer n4 = new Integer(this.stepCount);
        this.stepCount = n;
        this.updateArray();
        this.support.firePropertyChange("stepcount", n4, new Integer(this.stepCount));
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public int setFrameShift(int n) {
        int n2 = this.getStartFrameNumber();
        int n3 = this.getStepCount();
        return this.setFrameShift(n, n2, n3);
    }

    protected int setFrameShift(int n, int n2, int n3) {
        if (this.video != null) {
            n = Math.min(n, this.video.getFrameCount() - 1);
        }
        this.frameShift = n;
        this.support.firePropertyChange("frameshift", null, (Object)this.frameShift);
        this.setStartFrameNumber(n2);
        this.setStepCount(n3);
        return this.frameShift;
    }

    public int getFrameShift() {
        return this.frameShift;
    }

    public void setExtraFrames(int n) {
        int n2 = this.extraFrames;
        this.extraFrames = Math.max(n, 0);
        if (n2 != this.extraFrames) {
            OSPLog.finest("set extra frames to " + this.extraFrames);
        }
    }

    public int getFrameCount() {
        if (this.video != null && this.video.getFrameCount() > 1) {
            int n = this.video.getFrameCount() + this.extraFrames;
            n = Math.min(n, n - this.frameShift);
            n = Math.max(1, n);
            return n;
        }
        int n = this.getEndFrameNumber() + 1;
        this.frameCount = Math.max(this.frameCount, n);
        this.frameCount = Math.min(this.frameCount, this.maxFrameCount);
        return this.frameCount;
    }

    public void setStartTime(double d) {
        this.isDefaultState = false;
        if (this.startTime == d || this.isDefaultStartTime && Double.isNaN(d)) {
            return;
        }
        this.isDefaultStartTime = Double.isNaN(d);
        this.startTime = Double.isNaN(d) ? 0.0 : d;
        this.support.firePropertyChange("starttime", null, new Double(this.startTime));
    }

    public double getStartTime() {
        return this.startTime;
    }

    public int getEndFrameNumber() {
        this.endFrame = this.startFrame + this.stepSize * (this.stepCount - 1);
        return this.endFrame;
    }

    public boolean setEndFrameNumber(int n) {
        return this.setEndFrameNumber(n, this.maxFrameCount - 1 - this.frameShift, true);
    }

    public boolean extendEndFrameNumber(int n) {
        if (this.video != null && this.getFrameCount() <= n) {
            this.setExtraFrames(n - this.getFrameCount() + this.extraFrames);
        }
        return this.setEndFrameNumber(n);
    }

    private boolean setEndFrameNumber(int n, int n2, boolean bl) {
        int n3;
        int n4 = this.getEndFrameNumber();
        if (n4 == n && bl) {
            return false;
        }
        this.isDefaultState = false;
        n = Math.max(n, this.startFrame);
        int n5 = (n - this.startFrame) % this.stepSize;
        int n6 = (n - this.startFrame) / this.stepSize;
        if ((double)n5 * 1.0 / (double)this.stepSize > 0.5) {
            ++n6;
        }
        while (this.stepToFrame(n6) > n2) {
            --n6;
        }
        this.setStepCount(n6 + 1);
        n = this.getEndFrameNumber();
        if (n != this.startFrame && (n3 = Math.max(n - this.startFrame, 1)) < this.stepSize) {
            this.stepSize = n3;
        }
        return n4 != n;
    }

    public int stepToFrame(int n) {
        return this.startFrame + n * this.stepSize;
    }

    public int frameToStep(int n) {
        return (int)((double)(n - this.startFrame) / (1.0 * (double)this.stepSize));
    }

    public boolean includesFrame(int n) {
        int n2 = 0;
        while (n2 < this.stepCount) {
            if (this.stepFrames[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ClipInspector getClipInspector() {
        return this.inspector;
    }

    public ClipInspector getClipInspector(ClipControl clipControl, Frame frame) {
        if (this.inspector == null) {
            this.inspector = new ClipInspector(this, clipControl, frame);
        }
        return this.inspector;
    }

    public void hideClipInspector() {
        if (this.inspector != null) {
            this.inspector.setVisible(false);
        }
    }

    public boolean isDefaultState() {
        return this.isDefaultState && this.inspector == null;
    }

    public void setAdjusting(boolean bl) {
        if (this.isAdjusting == bl) {
            return;
        }
        this.isAdjusting = bl;
        this.support.firePropertyChange("adjusting", null, (Object)bl);
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public void setPlayAllSteps(boolean bl) {
        this.playAllSteps = bl;
    }

    public boolean isPlayAllSteps() {
        return this.playAllSteps;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void trimFrameCount() {
        if (this.video == null || this.video.getFrameCount() == 1) {
            this.frameCount = this.getEndFrameNumber() + 1;
            this.support.firePropertyChange("framecount", null, new Integer(this.frameCount));
        }
    }

    private void updateArray() {
        this.stepFrames = new int[this.stepCount];
        int n = 0;
        while (n < this.stepCount) {
            this.stepFrames[n] = this.stepToFrame(n);
            ++n;
        }
    }

    public int getFirstFrameNumber() {
        if (this.video == null) {
            return 0;
        }
        return Math.max(0, -this.frameShift);
    }

    public int getLastFrameNumber() {
        if (this.video == null) {
            return this.getEndFrameNumber();
        }
        int n = this.video.getFrameCount() - 1 + this.extraFrames;
        return Math.max(0, n - this.frameShift);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            VideoClip videoClip = (VideoClip)object;
            Video video2 = videoClip.getVideo();
            if (video2 != null) {
                if (video2 instanceof ImageVideo) {
                    ImageVideo imageVideo = (ImageVideo)video2;
                    if (imageVideo.isFileBased()) {
                        xMLControl.setValue("video", video2);
                    }
                } else {
                    xMLControl.setValue("video", video2);
                }
                xMLControl.setValue("video_framecount", video2.getFrameCount());
            }
            xMLControl.setValue("startframe", videoClip.getStartFrameNumber());
            xMLControl.setValue("stepsize", videoClip.getStepSize());
            xMLControl.setValue("stepcount", videoClip.getStepCount());
            xMLControl.setValue("starttime", videoClip.startTimeIsSaved ? videoClip.savedStartTime : videoClip.getStartTime());
            xMLControl.setValue("frameshift", videoClip.getFrameShift());
            xMLControl.setValue("readout", videoClip.readoutType);
            xMLControl.setValue("playallsteps", videoClip.playAllSteps);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            Collection<VideoType> collection;
            boolean bl = xMLControl.getPropertyNames().contains("video");
            if (!bl) {
                return new VideoClip(null);
            }
            ResourceLoader.addSearchPath(xMLControl.getString("basepath"));
            XMLControl xMLControl2 = xMLControl.getChildControl("video");
            String string = xMLControl2.getString("path");
            Video video2 = VideoIO.getVideo(string, null);
            boolean bl2 = false;
            if (video2 == null && string != null && !VideoIO.isCanceled()) {
                File[] fileArray;
                if (ResourceLoader.getResource(string) != null) {
                    Object object;
                    OSPLog.info("\"" + string + "\" could not be opened");
                    collection = new ArrayList<VideoType>();
                    fileArray = VideoIO.getEngine();
                    String object2 = XML.getExtension(string);
                    if (!fileArray.equals("Xuggle") && (object = VideoIO.getVideoType("Xuggle", object2)) != null) {
                        collection.add((VideoType)object);
                    }
                    if (!fileArray.equals("QT") && (object = VideoIO.getVideoType("QT", object2)) != null) {
                        collection.add((VideoType)object);
                    }
                    if (collection.isEmpty()) {
                        JOptionPane.showMessageDialog(null, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadVideo.Message")) + "\n\n" + string, MediaRes.getString("VideoClip.Dialog.BadVideo.Title"), 2);
                    } else {
                        object = new JCheckBox(MediaRes.getString("VideoIO.Dialog.TryDifferentEngine.Checkbox"));
                        video2 = VideoIO.getVideo(string, collection, (JComponent)object, null);
                        bl2 = ((AbstractButton)object).isSelected();
                        if (video2 != null && ((AbstractButton)object).isSelected()) {
                            String string2 = video2.getClass().getSimpleName();
                            String string3 = string2.indexOf("Xuggle") > -1 ? "Xuggle" : (string2.indexOf("QT") > -1 ? "QT" : "none");
                            VideoIO.setEngine(string3);
                        }
                    }
                } else {
                    int n = JOptionPane.showConfirmDialog(null, "\"" + string + "\" " + MediaRes.getString("VideoClip.Dialog.VideoNotFound.Message"), MediaRes.getString("VideoClip.Dialog.VideoNotFound.Title"), 0, 2);
                    if (n == 0) {
                        VideoIO.getChooser().setAccessory(VideoIO.videoEnginePanel);
                        VideoIO.videoEnginePanel.reset();
                        VideoIO.getChooser().setSelectedFile(new File(string));
                        fileArray = VideoIO.getChooserFiles("open video");
                        if (fileArray != null && fileArray.length > 0) {
                            VideoType videoType = VideoIO.videoEnginePanel.getSelectedVideoType();
                            string = XML.getAbsolutePath(fileArray[0]);
                            video2 = VideoIO.getVideo(string, videoType);
                        }
                    }
                }
            }
            if (video2 != null) {
                double d;
                collection = (Collection)xMLControl2.getObject("filters");
                if (collection != null) {
                    video2.getFilterStack().clear();
                    for (Filter filter : collection) {
                        video2.getFilterStack().addFilter(filter);
                    }
                }
                if (video2 instanceof ImageVideo && !Double.isNaN(d = xMLControl2.getDouble("delta_t"))) {
                    ((ImageVideo)video2).setFrameDuration(d);
                }
            }
            collection = new VideoClip(video2);
            ((VideoClip)((Object)collection)).changeEngine = bl2;
            if (string != null) {
                if (!string.startsWith("/") && string.indexOf(":") == -1) {
                    String string4 = xMLControl.getString("basepath");
                    string = XML.getResolvedPath(string, string4);
                }
                ((VideoClip)((Object)collection)).videoPath = string;
            }
            return collection;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            double d;
            VideoClip videoClip = (VideoClip)object;
            int n = xMLControl.getInt("startframe");
            int n2 = xMLControl.getInt("stepsize");
            int n3 = xMLControl.getInt("stepcount");
            int n4 = videoClip.getFrameCount();
            if (xMLControl.getPropertyNames().contains("video_framecount")) {
                n4 = xMLControl.getInt("video_framecount");
            } else if (n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE && n3 != Integer.MIN_VALUE) {
                n4 = n + n3 * n2;
            }
            videoClip.setStepCount(n4);
            int n5 = xMLControl.getInt("frameshift");
            if (n5 != Integer.MIN_VALUE) {
                videoClip.setFrameShift(n5);
            }
            if (n != Integer.MIN_VALUE) {
                videoClip.setStartFrameNumber(n);
            }
            if (n2 != Integer.MIN_VALUE) {
                videoClip.setStepSize(n2);
            }
            if (n3 != Integer.MIN_VALUE) {
                videoClip.setStepCount(n3);
            }
            if (!Double.isNaN(d = xMLControl.getDouble("starttime"))) {
                videoClip.startTime = d;
            }
            videoClip.readoutType = xMLControl.getString("readout");
            videoClip.playAllSteps = true;
            if (xMLControl.getPropertyNames().contains("playallsteps")) {
                videoClip.playAllSteps = xMLControl.getBoolean("playallsteps");
            }
            return object;
        }
    }
}

