/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.StepperClipControl;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoClipControl;

public abstract class ClipControl
implements PropertyChangeListener {
    protected int stepNumber = 0;
    protected int videoFrameNumber = 0;
    protected final VideoClip clip;
    protected Video video;
    protected double rate = 1.0;
    protected boolean looping = false;
    protected PropertyChangeSupport support;
    protected double timeStretch = 1.0;
    protected DataTrack timeSource;
    protected double savedFrameDuration;

    public static ClipControl getControl(VideoClip videoClip) {
        Video video2 = videoClip.getVideo();
        if (videoClip.isPlayAllSteps() || video2 == null || video2 instanceof ImageVideo) {
            return new StepperClipControl(videoClip);
        }
        return new VideoClipControl(videoClip);
    }

    protected ClipControl(VideoClip videoClip) {
        this.clip = videoClip;
        this.video = this.clip.getVideo();
        this.support = new SwingPropertyChangeSupport(this);
    }

    public VideoClip getVideoClip() {
        return this.clip;
    }

    public void play() {
    }

    public void stop() {
    }

    public void step() {
    }

    public void back() {
    }

    public void setFrameNumber(int n) {
        if (this.clip.includesFrame(n)) {
            this.stepNumber = this.clip.frameToStep(n);
            this.videoFrameNumber = n = Math.max(0, n + this.clip.getFrameShift());
        }
    }

    public void setStepNumber(int n) {
        this.stepNumber = n;
        this.videoFrameNumber = n = Math.max(0, this.clip.stepToFrame(n) + this.clip.getFrameShift());
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public void setRate(double d) {
        this.rate = d;
    }

    public double getRate() {
        return this.rate;
    }

    public void setLooping(boolean bl) {
        this.looping = bl;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public int getFrameNumber() {
        int n = this.videoFrameNumber - this.clip.getFrameShift();
        n = Math.max(0, n);
        return n;
    }

    public DataTrack getTimeSource() {
        return this.timeSource;
    }

    public void setTimeSource(DataTrack dataTrack) {
        DataTrack dataTrack2 = this.timeSource;
        this.timeSource = dataTrack;
        if (dataTrack2 == null && this.timeSource != null) {
            this.clip.savedStartTime = this.clip.isDefaultStartTime ? Double.NaN : this.clip.getStartTime();
            this.clip.startTimeIsSaved = true;
            this.savedFrameDuration = this.getMeanFrameDuration();
        } else if (dataTrack2 != null && this.timeSource == null) {
            this.clip.setStartTime(this.clip.savedStartTime);
            this.clip.startTimeIsSaved = false;
            this.setFrameDuration(this.savedFrameDuration);
        }
        if (this.timeSource != null && this.timeSource.isTimeDataAvailable()) {
            this.clip.setStartTime(this.timeSource.getVideoStartTime() * 1000.0);
            this.setFrameDuration(this.timeSource.getFrameDuration() * 1000.0);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("startframe")) {
            int n = this.getFrameNumber();
            this.stepNumber = this.clip.frameToStep(n);
        }
    }

    public abstract boolean isPlaying();

    public abstract double getTime();

    public abstract double getStepTime(int var1);

    public abstract void setFrameDuration(double var1);

    public abstract double getMeanFrameDuration();

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void dispose() {
    }

    public static boolean isTimeSource(DataTrack dataTrack) {
        if (dataTrack.getVideoPanel() == null) {
            return false;
        }
        return dataTrack == dataTrack.getVideoPanel().getPlayer().getClipControl().getTimeSource();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            ClipControl clipControl = (ClipControl)object;
            xMLControl.setValue("rate", clipControl.getRate());
            xMLControl.setValue("delta_t", clipControl.getTimeSource() != null ? clipControl.savedFrameDuration : clipControl.getMeanFrameDuration());
            if (clipControl.isLooping()) {
                xMLControl.setValue("looping", true);
            }
            xMLControl.setValue("frame", clipControl.getFrameNumber());
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            double d;
            ClipControl clipControl = (ClipControl)object;
            double d2 = xMLControl.getDouble("rate");
            if (d2 != Double.NaN) {
                clipControl.setRate(d2);
            }
            if ((d = xMLControl.getDouble("delta_t")) != Double.NaN) {
                clipControl.setFrameDuration(d);
            }
            clipControl.setLooping(xMLControl.getBoolean("looping"));
            if (xMLControl.getPropertyNames().contains("frame")) {
                int n = xMLControl.getInt("frame");
                n = clipControl.getVideoClip().frameToStep(n);
                clipControl.setStepNumber(n);
            }
            return object;
        }
    }
}

