/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.drawing2d.DrawingPanel;
import org.opensourcephysics.drawing2d.Group;
import org.opensourcephysics.drawing2d.Style;
import org.opensourcephysics.drawing2d.interaction.InteractionEvent;
import org.opensourcephysics.drawing2d.interaction.InteractionListener;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;
import org.opensourcephysics.numerics.Matrix2DTransformation;

public abstract class Element
implements Interactive,
LogMeasurable {
    public static final int TARGET_POSITION = 0;
    public static final int TARGET_SIZE = 1;
    protected static final double[] STD_ORIGIN = new double[]{0.0, 0.0};
    protected static final double[] STD_END = new double[]{1.0, 1.0};
    private boolean visible = true;
    private double x = 0.0;
    private double y = 0.0;
    private double sizeX = 1.0;
    private double sizeY = 1.0;
    private String name = "unnamed";
    private Style style = new Style(this);
    private Group group = null;
    private Object dataObject = null;
    private AffineTransform transformation = new AffineTransform();
    private boolean elementChanged = true;
    private boolean needsToProject = true;
    protected boolean canBeMeasured = true;
    private DrawingPanel panel;
    private double[] corners = new double[8];
    private AffineTransform totalTransformation = new AffineTransform();
    private double xmax;
    private double ymax;
    private double xmin;
    private double ymin;
    private double xmaxLogscale;
    private double ymaxLogscale;
    private double xminLogscale;
    private double yminLogscale;
    private List<InteractionListener> listeners = new ArrayList<InteractionListener>();
    protected final InteractionTarget targetPosition = new InteractionTarget(this, 0);
    protected final InteractionTarget targetSize = new InteractionTarget(this, 1);

    public final void setDataObject(Object _object) {
        this.dataObject = _object;
    }

    public final Object getDataObject() {
        return this.dataObject;
    }

    public final void setPanel(DrawingPanel _panel) {
        this.panel = _panel;
        this.needsToProject = true;
    }

    public final DrawingPanel getPanel() {
        Element el = this;
        while (el.group != null) {
            el = el.group;
        }
        return el.panel;
    }

    protected final void setGroup(Group _group) {
        this.group = _group;
        this.elementChanged = true;
    }

    protected final Group getGroup() {
        return this.group;
    }

    public final void setName(String _aName) {
        this.name = _aName;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final void setX(double _x) {
        this.x = _x;
        this.elementChanged = true;
    }

    @Override
    public final double getX() {
        return this.x;
    }

    @Override
    public final void setY(double _y) {
        this.y = _y;
        this.elementChanged = true;
    }

    @Override
    public final double getY() {
        return this.y;
    }

    @Override
    public final void setXY(double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.elementChanged = true;
    }

    public final void setPosition(double[] _pos) {
        this.x = _pos[0];
        this.y = _pos[1];
        this.elementChanged = true;
    }

    public final double[] getPosition() {
        return new double[]{this.x, this.y};
    }

    public void setSizeX(double _sizeX) {
        this.sizeX = _sizeX;
        this.elementChanged = true;
    }

    public final double getSizeX() {
        return this.sizeX;
    }

    public void setSizeY(double _sizeY) {
        this.sizeY = _sizeY;
        this.elementChanged = true;
    }

    public final double getSizeY() {
        return this.sizeY;
    }

    public void setSizeXY(double _sizeX, double _sizeY) {
        this.sizeX = _sizeX;
        this.sizeY = _sizeY;
        this.elementChanged = true;
    }

    public void setSize(double[] _size) {
        this.sizeX = _size[0];
        this.sizeY = _size[1];
        this.elementChanged = true;
    }

    public final double[] getSize() {
        return new double[]{this.sizeX, this.sizeY};
    }

    public void setCanBeMeasured(boolean measured) {
        this.canBeMeasured = measured;
    }

    public boolean getCanBeMeasured() {
        return this.canBeMeasured;
    }

    protected final double getDiagonalSize() {
        return Math.sqrt(this.sizeX * this.sizeX + this.sizeY * this.sizeY);
    }

    @Override
    public double getXMin() {
        this.updateExtrema();
        return this.xmin;
    }

    @Override
    public double getXMax() {
        this.updateExtrema();
        return this.xmax;
    }

    @Override
    public double getYMin() {
        this.updateExtrema();
        return this.ymin;
    }

    @Override
    public double getYMax() {
        this.updateExtrema();
        return this.ymax;
    }

    @Override
    public double getXMinLogscale() {
        this.updateExtrema();
        return this.xminLogscale;
    }

    @Override
    public double getXMaxLogscale() {
        this.updateExtrema();
        return this.xmaxLogscale;
    }

    @Override
    public double getYMinLogscale() {
        this.updateExtrema();
        return this.yminLogscale;
    }

    @Override
    public double getYMaxLogscale() {
        this.updateExtrema();
        return this.ymaxLogscale;
    }

    protected int getCorners(double[] _corners) {
        _corners[6] = 0.0;
        _corners[0] = 0.0;
        _corners[4] = 1.0;
        _corners[2] = 1.0;
        _corners[3] = 0.0;
        _corners[1] = 0.0;
        _corners[7] = 1.0;
        _corners[5] = 1.0;
        return 4;
    }

    protected final void initExtrema() {
        this.yminLogscale = Double.MAX_VALUE;
        this.xminLogscale = Double.MAX_VALUE;
        this.ymin = Double.MAX_VALUE;
        this.xmin = Double.MAX_VALUE;
        this.ymaxLogscale = -1.7976931348623157E308;
        this.xmaxLogscale = -1.7976931348623157E308;
        this.ymax = -1.7976931348623157E308;
        this.xmax = -1.7976931348623157E308;
    }

    protected final void compareToAllExtrema(double x1, double y1) {
        this.compareToExtrema(x1, y1);
        this.compareToLogExtrema(x1, y1);
    }

    protected final void compareToExtrema(double x1, double y1) {
        this.xmin = Math.min(this.xmin, x1);
        this.xmax = Math.max(this.xmax, x1);
        this.ymin = Math.min(this.ymin, y1);
        this.ymax = Math.max(this.ymax, y1);
    }

    protected final void compareToLogExtrema(double x1, double y1) {
        if (x1 > 0.0) {
            this.xminLogscale = Math.min(this.xminLogscale, x1);
            this.xmaxLogscale = Math.max(this.xmaxLogscale, x1);
        }
        if (y1 > 0.0) {
            this.yminLogscale = Math.min(this.yminLogscale, y1);
            this.ymaxLogscale = Math.max(this.ymaxLogscale, y1);
        }
    }

    protected void updateExtrema() {
        if (!this.hasChanged()) {
            return;
        }
        this.initExtrema();
        int points = this.getCorners(this.corners);
        this.getTotalTransform().transform(this.corners, 0, this.corners, 0, points);
        int i = 0;
        int n = 2 * points;
        while (i < n) {
            this.compareToAllExtrema(this.corners[i], this.corners[i + 1]);
            i += 2;
        }
    }

    @Override
    public boolean isMeasured() {
        return this.canBeMeasured;
    }

    public final void setVisible(boolean _visible) {
        this.visible = _visible;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    protected final boolean isReallyVisible() {
        Group el = this.group;
        while (el != null) {
            if (!el.visible) {
                return false;
            }
            el = el.group;
        }
        return this.visible;
    }

    public final Style getStyle() {
        return this.style;
    }

    protected void styleChanged(int styleThatChanged) {
    }

    public boolean hasChanged() {
        Element el = this;
        while (el != null) {
            if (el.elementChanged) {
                return true;
            }
            el = el.group;
        }
        return false;
    }

    public final void setElementChanged() {
        this.elementChanged = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setTransformation(Object _transform) throws ClassCastException {
        if (_transform == null) {
            this.transformation.setToIdentity();
        } else if (_transform instanceof Matrix2DTransformation) {
            this.transformation.setTransform(((Matrix2DTransformation)_transform).getTotalTransform());
        } else if (_transform instanceof double[]) {
            double[] array = (double[])_transform;
            if (array.length >= 6) {
                this.transformation.setTransform(new AffineTransform(array));
            }
        } else if (_transform instanceof double[][]) {
            double[][] array = (double[][])_transform;
            if (array.length < 2) throw new ClassCastException();
            if (array[0].length == 2) {
                this.transformation.setTransform(new AffineTransform(array[0][0], array[1][0], array[0][1], array[1][1], 0.0, 0.0));
            } else if (array[0].length >= 3) {
                this.transformation.setTransform(new AffineTransform(array[0][0], array[1][0], array[0][1], array[1][1], array[0][2], array[1][2]));
            }
        } else {
            this.transformation.setTransform((AffineTransform)_transform);
        }
        this.elementChanged = true;
    }

    public final Object getTransformation() {
        return new AffineTransform(this.transformation);
    }

    protected final AffineTransform getTheTransformation() {
        return this.transformation;
    }

    protected final AffineTransform getTotalTransform() {
        if (this.elementChanged) {
            this.totalTransformation = AffineTransform.getTranslateInstance(this.x, this.y);
            this.totalTransformation.concatenate(this.transformation);
            this.totalTransformation.scale(this.sizeX, this.sizeY);
            this.elementChanged = false;
            this.setNeedToProject(true);
        }
        if (this.group == null) {
            return this.totalTransformation;
        }
        AffineTransform tr = new AffineTransform(this.group.getTotalTransform());
        tr.concatenate(this.totalTransformation);
        return tr;
    }

    protected final AffineTransform getPixelTransform(org.opensourcephysics.display.DrawingPanel _panel) {
        AffineTransform transform = _panel.getPixelTransform();
        transform.concatenate(this.getTotalTransform());
        return transform;
    }

    public final double[] toSpaceFrame(double[] vector) {
        this.transformation.transform(vector, 0, vector, 0, 1);
        vector[0] = vector[0] + this.x;
        vector[1] = vector[1] + this.y;
        Group el = this.group;
        while (el != null) {
            vector[0] = vector[0] * el.sizeX;
            vector[1] = vector[1] * el.sizeY;
            el.transformation.transform(vector, 0, vector, 0, 1);
            vector[0] = vector[0] + el.x;
            vector[1] = vector[1] + el.y;
            el = el.group;
        }
        return vector;
    }

    public final double[] toBodyFrame(double[] vector) throws NoninvertibleTransformException {
        ArrayList<Element> elList = new ArrayList<Element>();
        Element el = this;
        do {
            elList.add(el);
        } while ((el = el.group) != null);
        int k = elList.size() - 1;
        while (k >= 0) {
            el = (Element)elList.get(k);
            vector[0] = vector[0] - el.x;
            vector[1] = vector[1] - el.y;
            el.transformation.inverseTransform(vector, 0, vector, 0, 1);
            if (el != this) {
                if (el.sizeX != 0.0) {
                    vector[0] = vector[0] / el.sizeX;
                }
                if (el.sizeY != 0.0) {
                    vector[1] = vector[1] / el.sizeY;
                }
            }
            --k;
        }
        return vector;
    }

    @Override
    public abstract void draw(org.opensourcephysics.display.DrawingPanel var1, Graphics var2);

    public void setNeedToProject(boolean _need) {
        this.needsToProject = _need;
    }

    protected final boolean needsToProject() {
        return this.needsToProject;
    }

    @Override
    public void setEnabled(boolean _enabled) {
        this.targetPosition.setEnabled(_enabled);
        this.targetSize.setEnabled(_enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.targetPosition.isEnabled() || this.targetSize.isEnabled();
    }

    public final InteractionTarget getInteractionTarget(int target) {
        switch (target) {
            case 0: {
                return this.targetPosition;
            }
            case 1: {
                return this.targetSize;
            }
        }
        return null;
    }

    public final void addInteractionListener(InteractionListener listener) {
        if (listener == null || this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public final void removeInteractionListener(InteractionListener listener) {
        this.listeners.remove(listener);
    }

    public final void invokeActions(InteractionEvent event) {
        Iterator<InteractionListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().interactionPerformed(event);
        }
    }

    @Override
    public abstract Interactive findInteractive(org.opensourcephysics.display.DrawingPanel var1, int var2, int var3);

    protected double[] getHotSpotBodyCoordinates(InteractionTarget target) {
        if (target == this.targetPosition) {
            return new double[]{0.0, 0.0};
        }
        if (target == this.targetSize) {
            return new double[]{this.sizeX != 0.0 ? 1 : 0, this.sizeY != 0.0 ? 1 : 0};
        }
        return null;
    }

    private final double[] getHotSpot(InteractionTarget target) {
        double[] coordinates = this.getHotSpotBodyCoordinates(target);
        if (coordinates != null) {
            this.getTotalTransform().transform(coordinates, 0, coordinates, 0, 1);
        }
        return coordinates;
    }

    public void updateHotSpot(InteractionTarget target, double[] point) {
        if (target.getEnabled() == 4) {
            return;
        }
        Group gr = this.group;
        block2 : switch (target.getType()) {
            case 0: {
                if (gr != null && target.getAffectsGroup()) {
                    double[] origin = this.getHotSpot(target);
                    switch (target.getEnabled()) {
                        case 2: {
                            gr.setX(gr.x + point[0] - origin[0]);
                            break block2;
                        }
                        case 3: {
                            gr.setY(gr.y + point[1] - origin[1]);
                            break block2;
                        }
                    }
                    gr.setXY(gr.x + point[0] - origin[0], gr.y + point[1] - origin[1]);
                    break;
                }
                double[] coordinates = (double[])point.clone();
                this.groupInverseTransformations(coordinates);
                double[] origin = this.getHotSpotBodyCoordinates(target);
                origin[0] = origin[0] * this.sizeX;
                origin[1] = origin[1] * this.sizeY;
                this.transformation.transform(origin, 0, origin, 0, 1);
                switch (target.getEnabled()) {
                    case 2: {
                        this.setX(coordinates[0] - origin[0]);
                        break block2;
                    }
                    case 3: {
                        this.setY(coordinates[1] - origin[1]);
                        break block2;
                    }
                }
                this.setXY(coordinates[0] - origin[0], coordinates[1] - origin[1]);
                break;
            }
            case 1: {
                if (gr != null && target.getAffectsGroup()) {
                    double[] coordinates = (double[])point.clone();
                    coordinates[0] = coordinates[0] - gr.x;
                    coordinates[1] = coordinates[1] - gr.y;
                    try {
                        gr.transformation.inverseTransform(coordinates, 0, coordinates, 0, 1);
                    }
                    catch (Exception exception) {}
                    double[] origin = this.getHotSpotBodyCoordinates(target);
                    this.elementDirectTransformations(origin);
                    coordinates[0] = origin[0] != 0.0 ? coordinates[0] / origin[0] : gr.x;
                    coordinates[1] = origin[1] != 0.0 ? coordinates[1] / origin[1] : gr.y;
                    switch (target.getEnabled()) {
                        case 2: {
                            gr.setSizeX(coordinates[0]);
                            break block2;
                        }
                        case 3: {
                            gr.setSizeY(coordinates[1]);
                            break block2;
                        }
                    }
                    gr.setSize(coordinates);
                    break;
                }
                double[] coordinates = (double[])point.clone();
                this.groupInverseTransformations(coordinates);
                coordinates[0] = coordinates[0] - this.x;
                coordinates[1] = coordinates[1] - this.y;
                try {
                    this.transformation.inverseTransform(coordinates, 0, coordinates, 0, 1);
                }
                catch (Exception exception) {}
                double[] origin = this.getHotSpotBodyCoordinates(target);
                if (origin[0] != 0.0) {
                    coordinates[0] = coordinates[0] / origin[0];
                }
                if (origin[1] != 0.0) {
                    coordinates[1] = coordinates[1] / origin[1];
                }
                switch (target.getEnabled()) {
                    case 2: {
                        this.setSizeX(coordinates[0]);
                        break block2;
                    }
                    case 3: {
                        this.setSizeY(coordinates[1]);
                        break block2;
                    }
                }
                this.setSize(coordinates);
            }
        }
    }

    protected final void groupInverseTransformations(double[] vector) throws UnsupportedOperationException {
        ArrayList<Group> elList = new ArrayList<Group>();
        Element el = this.group;
        while (el != null) {
            elList.add((Group)el);
            el = el.group;
        }
        int k = elList.size() - 1;
        while (k >= 0) {
            el = (Element)elList.get(k);
            vector[0] = vector[0] - el.x;
            vector[1] = vector[1] - el.y;
            try {
                el.transformation.inverseTransform(vector, 0, vector, 0, 1);
            }
            catch (Exception exception) {}
            if (el.sizeX != 0.0) {
                vector[0] = vector[0] / el.sizeX;
            }
            if (el.sizeY != 0.0) {
                vector[1] = vector[1] / el.sizeY;
            }
            --k;
        }
    }

    protected final void elementDirectTransformations(double[] vector) {
        Element el = this;
        do {
            if (el.sizeX != 0.0) {
                vector[0] = vector[0] * el.sizeX;
            }
            if (el.sizeY != 0.0) {
                vector[1] = vector[1] * el.sizeY;
            }
            if (el.transformation != null) {
                el.transformation.transform(vector, 0, vector, 0, 1);
            }
            vector[0] = vector[0] + this.x;
            vector[1] = vector[1] + this.y;
        } while ((el = el.group) != null && el.group != null);
    }
}

