/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveTrace;

public class TraceSet
extends ElementSet
implements Data {
    protected int datasetID = this.hashCode();

    public TraceSet(int _n) {
        super(_n, InteractiveTrace.class);
    }

    public InteractiveTrace traceAt(int i) {
        return (InteractiveTrace)this.elements[i];
    }

    public void clear() {
        int i = 0;
        while (i < this.numElements) {
            ((InteractiveTrace)this.elements[i]).clear();
            ++i;
        }
    }

    @Override
    public void setName(String _name) {
        super.setName(_name);
        int i = 0;
        while (i < this.numElements) {
            ((InteractiveTrace)this.elements[i]).setName(String.valueOf(_name) + "_" + i);
            ++i;
        }
    }

    public void addPoints(double[] _x, double[] _y, double[] _z) {
        int n = this.numElements;
        if (n > _x.length) {
            n = _x.length;
        }
        if (n > _y.length) {
            n = _y.length;
        }
        if (_z == null) {
            int i = 0;
            while (i < n) {
                ((InteractiveTrace)this.elements[i]).addPoint(_x[i], _y[i], 0.0);
                ++i;
            }
        } else {
            if (n > _z.length) {
                n = _z.length;
            }
            int i = 0;
            while (i < n) {
                ((InteractiveTrace)this.elements[i]).addPoint(_x[i], _y[i], _z[i]);
                ++i;
            }
        }
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return null;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, Color.BLUE};
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{Color.BLACK, Color.RED};
    }

    @Override
    public List<Data> getDataList() {
        ArrayList<Data> list = new ArrayList<Data>();
        int i = 0;
        while (i < this.numElements) {
            list.add((InteractiveTrace)this.elements[i]);
            ++i;
        }
        return list;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }
}

