/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.displayejs.Comparator3D;
import org.opensourcephysics.displayejs.Drawable3D;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveText;
import org.opensourcephysics.displayejs.Measurable3D;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.displayejs.Resolution;

public class DrawingPanel3D
extends InteractivePanel
implements InteractionSource {
    private static final long serialVersionUID = 1L;
    public static final int TRANSPARENCY_LEVEL = 100;
    private static final int AXIS_DIVISIONS = 10;
    public static final int DISPLAY_PLANAR = 0;
    public static final int DISPLAY_PLANAR_XY = 0;
    public static final int DISPLAY_PLANAR_XZ = 1;
    public static final int DISPLAY_PLANAR_YZ = 2;
    public static final int DISPLAY_3D = 10;
    public static final int DISPLAY_PERSPECTIVE = 10;
    public static final int DISPLAY_NO_PERSPECTIVE = 12;
    public static final int CURSOR_NONE = 0;
    public static final int CURSOR_XYZ = 1;
    public static final int CURSOR_CUBE = 2;
    public static final int CURSOR_CROSSHAIR = 3;
    public static final int DECORATION_NONE = 0;
    public static final int DECORATION_AXES = 1;
    public static final int DECORATION_CUBE = 2;
    protected boolean autoscaleZ = false;
    protected boolean removeHiddenLines = true;
    protected boolean respondToMouse = true;
    protected boolean showPosition = true;
    protected boolean useColorDepth = true;
    protected boolean allowQuickRedraw = true;
    protected int displayMode = 10;
    protected int cursorMode = 1;
    protected int decorationType = 2;
    protected int deltaa = 0;
    protected int deltab = 0;
    protected double alpha = 0.0;
    protected double beta = 0.0;
    protected double zoom = 1.0;
    protected double zmin = -1.0;
    protected double zmax = 1.0;
    protected double zminPreferred = -10.0;
    protected double zmaxPreferred = 10.0;
    protected double zfloor = Double.NaN;
    protected double zceil = Double.NaN;
    protected List<InteractionListener> listeners = new ArrayList<InteractionListener>();
    protected NumberFormat xFormat = new DecimalFormat("x=0.000;x=-0.000");
    protected NumberFormat yFormat = new DecimalFormat("y=0.000;y=-0.000");
    protected NumberFormat zFormat = new DecimalFormat("z=0.000;z=-0.000");
    private boolean quickRedrawOn = false;
    private double cosAlpha = Math.cos(this.alpha);
    private double sinAlpha = Math.sin(this.alpha);
    private double cosBeta = Math.cos(this.beta);
    private double sinBeta = Math.sin(this.beta);
    private double ratioToPlane = 2.5;
    private double ratioToCenter = 2.0;
    private double centerX;
    private double centerY;
    private double centerZ;
    private double aconstant;
    private double bconstant;
    private double viewToPlane;
    private double viewToCenter;
    private int acenter;
    private int bcenter;
    private int trackersVisible;
    private int keyPressed = -1;
    private Point3D trackerPoint = new Point3D(0.0, 0.0, 0.0);
    private ArrayList<Object3D> list3D = new ArrayList();
    private Comparator3D comparator = new Comparator3D();
    private InteractiveArrow xAxis;
    private InteractiveArrow yAxis;
    private InteractiveArrow zAxis;
    private InteractiveText xText;
    private InteractiveText yText;
    private InteractiveText zText;
    private InteractiveArrow[] boxSides = new InteractiveArrow[12];
    private InteractiveArrow[] trackerLines = null;
    private float[] crc = new float[4];
    private int lastX = 0;
    private int lastY = 0;
    private InteractionTarget targetHit = null;
    private Interactive iad = null;

    public DrawingPanel3D() {
        this(10);
    }

    public DrawingPanel3D(int _displayMode) {
        super.setSquareAspect(true);
        super.setShowCoordinates(false);
        super.enableInspector(false);
        super.removeOptionController();
        this.autoscaleZ = false;
        this.autoscaleY = false;
        this.autoscaleX = false;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DrawingPanel3D.this.computeConstants(1);
                if (!DrawingPanel3D.this.getIgnoreRepaint()) {
                    DrawingPanel3D.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent _e) {
                DrawingPanel3D.this.keyPressed = _e.getKeyCode();
            }

            @Override
            public void keyReleased(KeyEvent _e) {
                DrawingPanel3D.this.keyPressed = -1;
            }
        });
        Resolution axesRes = new Resolution(10);
        int i = 0;
        int n = this.boxSides.length;
        while (i < n) {
            this.boxSides[i] = new InteractiveArrow(1);
            this.boxSides[i].setResolution(axesRes);
            this.boxSides[i].setEnabled(false);
            this.boxSides[i].canBeMeasured(false);
            ++i;
        }
        this.xAxis = new InteractiveArrow(0);
        this.xAxis.setResolution(axesRes);
        this.xAxis.setEnabled(false);
        this.xAxis.canBeMeasured(false);
        this.xText = new InteractiveText("X");
        this.xText.getStyle().setFont(new Font("Dialog", 0, 12));
        this.xText.setEnabled(false);
        this.xText.canBeMeasured(false);
        this.yAxis = new InteractiveArrow(0);
        this.yAxis.setResolution(axesRes);
        this.yAxis.setEnabled(false);
        this.yAxis.canBeMeasured(false);
        this.yText = new InteractiveText("Y");
        this.yText.getStyle().setFont(new Font("Dialog", 0, 12));
        this.yText.setEnabled(false);
        this.yText.canBeMeasured(false);
        this.zAxis = new InteractiveArrow(0);
        this.zAxis.setResolution(axesRes);
        this.zAxis.setEnabled(false);
        this.zAxis.canBeMeasured(false);
        this.zText = new InteractiveText("Z");
        this.zText.getStyle().setFont(new Font("Dialog", 0, 12));
        this.zText.setEnabled(false);
        this.zText.canBeMeasured(false);
        this.trackerLines = new InteractiveArrow[9];
        i = 0;
        n = this.trackerLines.length;
        while (i < n) {
            this.trackerLines[i] = new InteractiveArrow(1);
            this.trackerLines[i].setResolution(axesRes);
            this.trackerLines[i].setEnabled(false);
            this.trackerLines[i].setVisible(false);
            this.trackerLines[i].canBeMeasured(false);
            ++i;
        }
        this.setForeground(this.getForeground());
        this.clear();
        this.displayMode = _displayMode;
        if (this.displayMode < 10) {
            this.setDecorationType(0);
            this.setCursorMode(0);
            this.setUseColorDepth(false);
        } else {
            this.setDecorationType(2);
            this.setCursorMode(1);
            this.setUseColorDepth(true);
        }
        this.setPixelScale();
        this.computeConstants(2);
        this.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
    }

    @Override
    public void setSquareAspect(boolean _val) {
        if (this.squareAspect == _val) {
            return;
        }
        this.squareAspect = _val;
        this.computeConstants(3);
        this.invalidateImage();
        this.repaint();
    }

    public void setAutoscaleZ(boolean _autoscale) {
        this.autoscaleZ = _autoscale;
        this.invalidateImage();
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public void setRemoveHiddenLines(boolean _value) {
        this.removeHiddenLines = _value;
        this.invalidateImage();
    }

    public boolean isRemoveHiddenLines() {
        return this.removeHiddenLines;
    }

    public void setAllowQuickRedraw(boolean _allow) {
        this.allowQuickRedraw = _allow;
        this.invalidateImage();
    }

    public boolean isAllowQuickRedraw() {
        return this.allowQuickRedraw;
    }

    @Override
    public void setShowCoordinates(boolean _val) {
        this.showPosition = _val;
    }

    public boolean isShowCoordinates() {
        return this.showPosition;
    }

    public void setXFormat(NumberFormat _format) {
        this.xFormat = _format;
    }

    public void setYFormat(NumberFormat _format) {
        this.yFormat = _format;
    }

    public void setZFormat(NumberFormat _format) {
        this.zFormat = _format;
    }

    public void setUseColorDepth(boolean _mode) {
        this.useColorDepth = _mode;
        this.invalidateImage();
    }

    public boolean isUseColorDepth() {
        return this.useColorDepth;
    }

    public void setDisplayMode(int _mode) {
        if (this.displayMode == _mode) {
            return;
        }
        this.displayMode = _mode;
        this.setDecorationType(this.decorationType);
        this.computeConstants(4);
        this.invalidateImage();
        if (!this.getIgnoreRepaint()) {
            this.repaint();
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setCursorMode(int _mode) {
        this.cursorMode = _mode;
        switch (_mode) {
            case 0: {
                this.trackersVisible = 0;
                break;
            }
            case 1: {
                this.trackersVisible = 3;
                break;
            }
            case 2: {
                this.trackersVisible = 9;
                break;
            }
            default: {
                this.trackersVisible = 3;
            }
        }
    }

    public int getCursorMode() {
        return this.cursorMode;
    }

    public void setDecorationType(int _value) {
        this.decorationType = _value;
        switch (_value) {
            case 0: {
                this.xAxis.setVisible(false);
                this.xText.setVisible(false);
                this.yAxis.setVisible(false);
                this.yText.setVisible(false);
                this.zAxis.setVisible(false);
                this.zText.setVisible(false);
                int i = 0;
                int n = this.boxSides.length;
                while (i < n) {
                    this.boxSides[i].setVisible(false);
                    ++i;
                }
                break;
            }
            case 1: {
                boolean showX = this.displayMode == 0 || this.displayMode == 1 || this.displayMode >= 10;
                boolean showY = this.displayMode == 0 || this.displayMode == 2 || this.displayMode >= 10;
                boolean showZ = this.displayMode == 2 || this.displayMode == 1 || this.displayMode >= 10;
                this.xAxis.setVisible(showX);
                this.xText.setVisible(showX);
                this.yAxis.setVisible(showY);
                this.yText.setVisible(showY);
                this.zAxis.setVisible(showZ);
                this.zText.setVisible(showZ);
                int i = 0;
                int n = this.boxSides.length;
                while (i < n) {
                    this.boxSides[i].setVisible(false);
                    ++i;
                }
                break;
            }
            case 2: {
                this.xAxis.setVisible(false);
                this.xText.setVisible(false);
                this.yAxis.setVisible(false);
                this.yText.setVisible(false);
                this.zAxis.setVisible(false);
                this.zText.setVisible(false);
                int i = 0;
                int n = this.boxSides.length;
                while (i < n) {
                    this.boxSides[i].setVisible(true);
                    ++i;
                }
                break;
            }
        }
        this.invalidateImage();
        if (!this.getIgnoreRepaint()) {
            this.repaint();
        }
    }

    public int getDecorationType() {
        return this.decorationType;
    }

    public void setDecorationResolution(Resolution _res) {
        int i = 0;
        int n = this.boxSides.length;
        while (i < n) {
            this.boxSides[i].setResolution(_res);
            ++i;
        }
        this.xAxis.setResolution(_res);
        this.yAxis.setResolution(_res);
        this.zAxis.setResolution(_res);
        i = 0;
        n = this.trackerLines.length;
        while (i < n) {
            this.trackerLines[i].setResolution(_res);
            ++i;
        }
    }

    public void setAxesLabels(String[] _labels) {
        this.xText.getStyle().setDisplayObject(_labels[0]);
        this.yText.getStyle().setDisplayObject(_labels[1]);
        this.zText.getStyle().setDisplayObject(_labels[2]);
    }

    public void setPan(int _deltaa, int _deltab) {
        this.deltaa = _deltaa;
        this.deltab = _deltab;
        this.computeConstants(5);
    }

    public Point getPan() {
        return new Point(this.deltaa, this.deltab);
    }

    public void setAlpha(double _alpha) {
        this.alpha = _alpha;
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.reportTheNeedToProject(1);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setBeta(double _beta) {
        this.beta = _beta;
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.reportTheNeedToProject(2);
    }

    public double getBeta() {
        return this.beta;
    }

    public void setAlphaAndBeta(double _alpha, double _beta) {
        this.alpha = _alpha;
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.beta = _beta;
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.reportTheNeedToProject(3);
    }

    public void setZoom(double _zoom) {
        this.zoom = _zoom;
        this.computeConstants(6);
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setRatioToCenter(double _value) {
        this.ratioToCenter = _value;
        this.computeConstants(7);
    }

    public double getRatioToCenter() {
        return this.ratioToCenter;
    }

    public void setRatioToPlane(double _value) {
        this.ratioToPlane = _value;
        this.computeConstants(8);
    }

    public double getRatioToPlane() {
        return this.ratioToPlane;
    }

    public void setPreferredMinMax(double _xmin, double _xmax, double _ymin, double _ymax, double _zmin, double _zmax) {
        super.setPreferredMinMax(_xmin, _xmax, _ymin, _ymax);
        this.setPreferredMinMaxZ(_zmin, _zmax);
    }

    public void setPreferredMinMaxZ(double _min, double _max) {
        if (this.zminPreferred == _min && this.zmaxPreferred == _max) {
            return;
        }
        if (Double.isNaN(_min)) {
            _min = this.yminPreferred;
        }
        if (Double.isNaN(_max)) {
            _max = this.ymaxPreferred;
        }
        this.autoscaleZ = false;
        if (_min == _max) {
            _min = 0.9 * _min - 0.5;
            _max = 1.1 * _max + 0.5;
        }
        this.zminPreferred = _min;
        this.zmaxPreferred = _max;
        this.invalidateImage();
    }

    public double getPreferredZMax() {
        return this.zmaxPreferred;
    }

    public double getPreferredZMin() {
        return this.zminPreferred;
    }

    public double getZMin() {
        return this.zmin;
    }

    public double getZMax() {
        return this.zmax;
    }

    public void limitAutoscaleZ(double _floor, double _ceil) {
        if (_ceil - _floor < (double)1.4E-45f) {
            _floor = 0.9 * _floor - (double)1.4E-45f;
            _ceil = 1.1 * _ceil + (double)1.4E-45f;
        }
        this.zfloor = _floor;
        this.zceil = _ceil;
        this.invalidateImage();
    }

    @Override
    protected void scale(ArrayList<Drawable> tempList) {
        super.scale(tempList);
        if (this.autoscaleZ) {
            this.scaleZ(tempList);
        }
    }

    @Override
    public void setEnabled(boolean _value) {
        this.respondToMouse = _value;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(int _target, boolean _value) {
        this.respondToMouse = _value;
    }

    @Override
    public boolean isEnabled(int _target) {
        return true;
    }

    @Override
    public void addListener(InteractionListener _listener) {
        if (_listener == null || this.listeners.contains(_listener)) {
            return;
        }
        this.listeners.add(_listener);
    }

    @Override
    public void removeListener(InteractionListener _listener) {
        this.listeners.remove(_listener);
    }

    @Override
    public void removeAllListeners() {
        this.listeners = new ArrayList<InteractionListener>();
    }

    @Override
    public void invokeActions(InteractionEvent _event) {
        Iterator<InteractionListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().interactionPerformed(_event);
        }
    }

    @Override
    public void setForeground(Color _color) {
        super.setForeground(_color);
        if (this.xAxis != null) {
            int i = 0;
            int n = this.boxSides.length;
            while (i < n) {
                this.boxSides[i].getStyle().setEdgeColor(_color);
                ++i;
            }
            this.xAxis.getStyle().setEdgeColor(_color);
            this.xText.getStyle().setEdgeColor(_color);
            this.yAxis.getStyle().setEdgeColor(_color);
            this.yText.getStyle().setEdgeColor(_color);
            this.zAxis.getStyle().setEdgeColor(_color);
            this.zText.getStyle().setEdgeColor(_color);
            i = 0;
            n = this.trackerLines.length;
            while (i < n) {
                this.trackerLines[i].getStyle().setEdgeColor(_color.brighter().brighter());
                ++i;
            }
        }
    }

    @Override
    public void setPixelScale() {
        double xm = this.xmin;
        double xM = this.xmax;
        double ym = this.ymin;
        double yM = this.ymax;
        double zm = this.zmin;
        double zM = this.zmax;
        this.xmin = this.xminPreferred;
        this.xmax = this.xmaxPreferred;
        this.ymin = this.yminPreferred;
        this.ymax = this.ymaxPreferred;
        this.zmin = this.zminPreferred;
        this.zmax = this.zmaxPreferred;
        if (xm != this.xmin || xM != this.xmax || ym != this.ymin || yM != this.ymax || zm != this.zmin || zM != this.zmax) {
            this.computeConstants(9);
        }
    }

    @Override
    public void clear() {
        super.clear();
        int i = 0;
        int n = this.boxSides.length;
        while (i < n) {
            this.addDrawable(this.boxSides[i]);
            ++i;
        }
        this.addDrawable(this.xAxis);
        this.addDrawable(this.xText);
        this.addDrawable(this.yAxis);
        this.addDrawable(this.yText);
        this.addDrawable(this.zAxis);
        this.addDrawable(this.zText);
        i = 0;
        n = this.trackerLines.length;
        while (i < n) {
            this.addDrawable(this.trackerLines[i]);
            ++i;
        }
    }

    @Override
    public void paintDrawableList(Graphics g, ArrayList<Drawable> tempList) {
        Graphics2D g2 = (Graphics2D)g;
        Iterator<Drawable> it = tempList.iterator();
        Shape clipShape = g2.getClip();
        int w = this.getWidth() - this.leftGutter - this.rightGutter;
        int h = this.getHeight() - this.bottomGutter - this.topGutter;
        if (w < 0 || h < 0) {
            return;
        }
        if (this.clipAtGutter) {
            g2.clipRect(this.leftGutter, this.topGutter, w, h);
        }
        if (this.quickRedrawOn || !this.removeHiddenLines) {
            while (it.hasNext()) {
                if (this.isValidImage()) {
                    Drawable drawable = it.next();
                    if (drawable instanceof Drawable3D) {
                        ((Drawable3D)drawable).drawQuickly(this, g2);
                        continue;
                    }
                    drawable.draw(this, g2);
                    continue;
                }
                break;
            }
        } else {
            this.list3D.clear();
            while (it.hasNext()) {
                if (!this.isValidImage()) break;
                Drawable drawable = it.next();
                if (drawable instanceof Drawable3D) {
                    Object3D[] objects = ((Drawable3D)drawable).getObjects3D(this);
                    if (objects == null) continue;
                    int i = 0;
                    int n = objects.length;
                    while (i < n) {
                        if (objects[i] != null && !Double.isNaN(objects[i].distance)) {
                            this.list3D.add(objects[i]);
                        }
                        ++i;
                    }
                    continue;
                }
                drawable.draw(this, g2);
            }
            if (this.list3D.size() > 0) {
                Object[] objects = this.list3D.toArray();
                Arrays.sort(objects, this.comparator);
                int i = 0;
                int n = objects.length;
                while (i < n) {
                    Object3D obj = (Object3D)objects[i];
                    obj.drawable3D.draw(this, g2, obj.index);
                    ++i;
                }
            }
        }
        g2.setClip(clipShape);
    }

    @Override
    public double[] project(double[] coordinate, double[] pixel) {
        double factor;
        double zprime;
        double yprime;
        double xprime;
        double x = coordinate[0] - this.centerX;
        double y = coordinate[1] - this.centerY;
        double z = 0.0;
        switch (coordinate.length) {
            case 2: 
            case 4: {
                z = 0.0;
                break;
            }
            case 3: 
            case 6: {
                z = coordinate[2] - this.centerZ;
                break;
            }
            default: {
                throw new IllegalArgumentException("Method project not supported for this length.");
            }
        }
        switch (this.displayMode) {
            case 0: {
                xprime = z;
                yprime = x;
                zprime = y;
                factor = 1.8;
                break;
            }
            case 1: {
                xprime = y;
                yprime = x;
                zprime = z;
                factor = 1.8;
                break;
            }
            case 2: {
                xprime = x;
                yprime = y;
                zprime = z;
                factor = 1.8;
                break;
            }
            case 12: {
                xprime = x * this.cosAlpha + y * this.sinAlpha;
                yprime = -x * this.sinAlpha + y * this.cosAlpha;
                zprime = -xprime * this.sinBeta + z * this.cosBeta;
                xprime = xprime * this.cosBeta + z * this.sinBeta;
                factor = 1.3;
                break;
            }
            default: {
                xprime = x * this.cosAlpha + y * this.sinAlpha;
                yprime = -x * this.sinAlpha + y * this.cosAlpha;
                zprime = -xprime * this.sinBeta + z * this.cosBeta;
                xprime = xprime * this.cosBeta + z * this.sinBeta;
                double aux = this.viewToCenter - xprime;
                if (Math.abs(aux) < 0.01) {
                    aux = 0.01;
                }
                factor = this.viewToPlane / aux;
            }
        }
        pixel[0] = (double)this.acenter + yprime * factor * this.aconstant;
        pixel[1] = (double)this.bcenter - zprime * factor * this.bconstant;
        switch (coordinate.length) {
            case 2: 
            case 3: {
                pixel[2] = (this.viewToCenter - xprime) / this.viewToCenter;
                break;
            }
            case 4: {
                pixel[2] = coordinate[2] * factor * this.aconstant;
                pixel[3] = coordinate[3] * factor * this.bconstant;
                pixel[4] = (this.viewToCenter - xprime) / this.viewToCenter;
                break;
            }
            case 6: {
                switch (this.displayMode) {
                    case 0: {
                        pixel[2] = coordinate[3] * factor * this.aconstant;
                        pixel[3] = coordinate[4] * factor * this.bconstant;
                        break;
                    }
                    case 1: {
                        pixel[2] = coordinate[3] * factor * this.aconstant;
                        pixel[3] = coordinate[5] * factor * this.bconstant;
                        break;
                    }
                    case 2: {
                        pixel[2] = coordinate[4] * factor * this.aconstant;
                        pixel[3] = coordinate[5] * factor * this.bconstant;
                        break;
                    }
                    default: {
                        pixel[2] = Math.max(coordinate[3], coordinate[4]) * factor * this.aconstant;
                        pixel[3] = coordinate[5] * factor * this.bconstant;
                    }
                }
                pixel[4] = (this.viewToCenter - xprime) / this.viewToCenter;
            }
        }
        return pixel;
    }

    public Color projectColor(Color _aColor, double _depth) {
        if (!this.useColorDepth) {
            return _aColor;
        }
        try {
            _aColor.getRGBComponents(this.crc);
            int i = 0;
            while (i < 3) {
                int n = i;
                this.crc[n] = (float)((double)this.crc[n] / _depth);
                this.crc[i] = (float)Math.max(Math.min((double)this.crc[i], 1.0), 0.0);
                ++i;
            }
            return new Color(this.crc[0], this.crc[1], this.crc[2], this.crc[3]);
        }
        catch (Exception exception) {
            return _aColor;
        }
    }

    private Point3D worldPoint(int a, int b) {
        double factor = 1.8;
        switch (this.displayMode) {
            case 0: {
                return new Point3D(this.centerX + (double)(a - this.acenter) / (factor * this.aconstant), this.centerY + (double)(this.bcenter - b) / (factor * this.bconstant), this.zmax);
            }
            case 1: {
                return new Point3D(this.centerX + (double)(a - this.acenter) / (factor * this.aconstant), this.ymax, this.centerZ + (double)(this.bcenter - b) / (factor * this.bconstant));
            }
            case 2: {
                return new Point3D(this.xmax, this.centerY + (double)(a - this.acenter) / (factor * this.aconstant), this.centerZ + (double)(this.bcenter - b) / (factor * this.bconstant));
            }
        }
        return new Point3D((this.xmin + this.xmax) / 2.0, (this.ymin + this.ymax) / 2.0, (this.zmin + this.zmax) / 2.0);
    }

    private Point3D worldDistance(int dx, int dy) {
        double factor = 1.8;
        switch (this.displayMode) {
            case 0: {
                return new Point3D((double)dx / (factor * this.aconstant), (double)(-dy) / (factor * this.bconstant), 0.0);
            }
            case 1: {
                return new Point3D((double)dx / (factor * this.aconstant), 0.0, (double)(-dy) / (factor * this.bconstant));
            }
            case 2: {
                return new Point3D(0.0, (double)dx / (factor * this.aconstant), (double)(-dy) / (factor * this.bconstant));
            }
        }
        return new Point3D((double)dx / (1.3 * this.aconstant), (double)dy / (1.3 * this.bconstant), 0.0);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    private boolean mouseDraggedComputations(MouseEvent e) {
        if (e.isControlDown()) {
            this.setPan(this.deltaa + (e.getX() - this.lastX), this.deltab + (e.getY() - this.lastY));
            return false;
        }
        if (e.isShiftDown()) {
            this.setZoom(this.zoom - (double)(e.getY() - this.lastY) * 0.01);
            return false;
        }
        if (this.displayMode >= 10 && this.iad == null && !e.isAltDown()) {
            this.setAlphaAndBeta(this.alpha - (double)(e.getX() - this.lastX) * 0.01, this.beta + (double)(e.getY() - this.lastY) * 0.01);
            return false;
        }
        Point3D point = this.worldDistance(e.getX() - this.lastX, e.getY() - this.lastY);
        if (this.displayMode < 10) {
            switch (this.keyPressed) {
                case 88: {
                    this.trackerPoint.x += point.x;
                    break;
                }
                case 89: {
                    this.trackerPoint.y += point.y;
                    break;
                }
                case 90: {
                    this.trackerPoint.z += point.z;
                    break;
                }
                default: {
                    this.trackerPoint.x += point.x;
                    this.trackerPoint.y += point.y;
                    this.trackerPoint.z += point.z;
                    break;
                }
            }
        } else {
            int factor = 1;
            if (this.cosBeta < 0.0) {
                factor = -1;
            }
            switch (this.keyPressed) {
                case 88: {
                    if (this.cosAlpha >= 0.0 && Math.abs(this.sinAlpha) < this.cosAlpha) {
                        this.trackerPoint.x += point.y;
                        break;
                    }
                    if (this.sinAlpha >= 0.0 && Math.abs(this.cosAlpha) < this.sinAlpha) {
                        this.trackerPoint.x -= point.x;
                        break;
                    }
                    if (this.cosAlpha < 0.0 && Math.abs(this.sinAlpha) < -this.cosAlpha) {
                        this.trackerPoint.x -= point.y;
                        break;
                    }
                    this.trackerPoint.x += point.x;
                    break;
                }
                case 89: {
                    if (this.cosAlpha >= 0.0 && Math.abs(this.sinAlpha) < this.cosAlpha) {
                        this.trackerPoint.y += point.x;
                        break;
                    }
                    if (this.sinAlpha >= 0.0 && Math.abs(this.cosAlpha) < this.sinAlpha) {
                        this.trackerPoint.y += point.y;
                        break;
                    }
                    if (this.cosAlpha < 0.0 && Math.abs(this.sinAlpha) < -this.cosAlpha) {
                        this.trackerPoint.y -= point.x;
                        break;
                    }
                    this.trackerPoint.y -= point.y;
                    break;
                }
                case 90: {
                    if (this.cosBeta >= 0.0) {
                        this.trackerPoint.z -= point.y;
                        break;
                    }
                    this.trackerPoint.z += point.y;
                    break;
                }
                default: {
                    this.trackerPoint.z -= (double)factor * point.y;
                    if (this.cosAlpha >= 0.0 && Math.abs(this.sinAlpha) < this.cosAlpha) {
                        this.trackerPoint.y += point.x;
                        break;
                    }
                    if (this.sinAlpha >= 0.0 && Math.abs(this.cosAlpha) < this.sinAlpha) {
                        this.trackerPoint.x -= point.x;
                        break;
                    }
                    if (this.cosAlpha < 0.0 && Math.abs(this.sinAlpha) < -this.cosAlpha) {
                        this.trackerPoint.y -= point.x;
                        break;
                    }
                    this.trackerPoint.x += point.x;
                }
            }
        }
        return true;
    }

    private void resetInteraction(InteractivePanel _panel) {
        this.iad = null;
        this.targetHit = null;
        this.showTrackers(false);
        this.blMessageBox.setText(null);
        this.repaint();
    }

    @Override
    public void handleMouseAction(InteractivePanel _panel, MouseEvent _evt) {
        switch (_panel.getMouseAction()) {
            case 1: {
                this.requestFocus();
                if (_evt.isPopupTrigger() || _evt.getModifiers() == 4) {
                    return;
                }
                this.lastX = _evt.getX();
                this.lastY = _evt.getY();
                this.targetHit = null;
                this.iad = _panel.getInteractive();
                if (this.iad instanceof InteractionTarget) {
                    this.targetHit = (InteractionTarget)this.iad;
                    this.trackerPoint = this.targetHit.getHotspot(_panel);
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2000, null, this.targetHit));
                    this.trackerPoint = this.targetHit.getHotspot(_panel);
                } else if (this.iad != null) {
                    if (!this.iad.isEnabled()) {
                        return;
                    }
                    switch (this.displayMode) {
                        default: {
                            this.trackerPoint.x = this.iad.getX();
                            this.trackerPoint.y = this.iad.getY();
                            this.trackerPoint.z = this.zmax;
                            break;
                        }
                        case 1: {
                            this.trackerPoint.x = this.iad.getX();
                            this.trackerPoint.z = this.iad.getY();
                            this.trackerPoint.y = this.ymax;
                            break;
                        }
                        case 2: {
                            this.trackerPoint.y = this.iad.getX();
                            this.trackerPoint.z = this.iad.getY();
                            this.trackerPoint.x = this.xmax;
                        }
                    }
                    this.invokeActions(new InteractionEvent((Object)this, 2000, null, this.iad));
                    switch (this.displayMode) {
                        default: {
                            this.trackerPoint.x = this.iad.getX();
                            this.trackerPoint.y = this.iad.getY();
                            this.trackerPoint.z = this.zmax;
                            break;
                        }
                        case 1: {
                            this.trackerPoint.x = this.iad.getX();
                            this.trackerPoint.z = this.iad.getY();
                            this.trackerPoint.y = this.ymax;
                            break;
                        }
                        case 2: {
                            this.trackerPoint.y = this.iad.getX();
                            this.trackerPoint.z = this.iad.getY();
                            this.trackerPoint.x = this.xmax;
                            break;
                        }
                    }
                } else if (this.displayMode < 10 || _evt.isAltDown()) {
                    this.trackerPoint = this.worldPoint(_evt.getX(), _evt.getY());
                    this.invokeActions(new InteractionEvent((Object)this, 2000, null, this.trackerPoint));
                } else {
                    this.invokeActions(new InteractionEvent((Object)this, 2000, null, null));
                    this.resetInteraction(_panel);
                    return;
                }
                if (this.showPosition) {
                    this.displayPosition(this.trackerPoint.x, this.trackerPoint.y, this.trackerPoint.z);
                }
                this.positionTrackers();
                this.showTrackers(true);
                _panel.repaint();
                break;
            }
            case 3: {
                if (_evt.isPopupTrigger() || _evt.getModifiers() == 4) {
                    return;
                }
                if (this.iad != null && !this.iad.isEnabled()) {
                    return;
                }
                this.quickRedrawOn = this.allowQuickRedraw && this.keyPressed != 83;
                boolean trackerMoved = this.mouseDraggedComputations(_evt);
                this.lastX = _evt.getX();
                this.lastY = _evt.getY();
                if (!trackerMoved) {
                    this.invokeActions(new InteractionEvent((Object)this, 2001, null, null));
                    this.resetInteraction(_panel);
                    return;
                }
                if (this.targetHit != null) {
                    this.targetHit.updateHotspot(_panel, this.trackerPoint);
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2001, null, this.targetHit));
                    this.trackerPoint = this.targetHit.getHotspot(_panel);
                } else if (this.iad != null) {
                    this.invokeActions(new InteractionEvent((Object)this, 2001, null, this.iad));
                } else {
                    this.invokeActions(new InteractionEvent((Object)this, 2001, null, this.trackerPoint));
                }
                if (this.showPosition) {
                    this.displayPosition(this.trackerPoint.x, this.trackerPoint.y, this.trackerPoint.z);
                }
                this.positionTrackers();
                this.showTrackers(true);
                _panel.repaint();
                break;
            }
            case 2: {
                if (_evt.isPopupTrigger() || _evt.getModifiers() == 4) {
                    return;
                }
                if (this.iad != null && !this.iad.isEnabled()) {
                    return;
                }
                if (this.targetHit != null) {
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2002, null, this.targetHit));
                } else if (this.iad != null) {
                    this.invokeActions(new InteractionEvent((Object)this, 2002, null, this.iad));
                } else if (this.displayMode < 10 || _evt.isAltDown()) {
                    this.invokeActions(new InteractionEvent((Object)this, 2002, null, this.trackerPoint));
                } else {
                    this.invokeActions(new InteractionEvent((Object)this, 2002, null, null));
                }
                this.quickRedrawOn = false;
                this.resetInteraction(_panel);
                break;
            }
            case 6: {
                this.invokeActions(new InteractionEvent((Object)this, 2004, null, null));
                break;
            }
            case 5: {
                this.invokeActions(new InteractionEvent((Object)this, 2003, null, null));
                break;
            }
            case 7: {
                if (_panel.getInteractive() != null) {
                    _panel.setMouseCursor(Cursor.getPredefinedCursor(12));
                } else {
                    _panel.setMouseCursor(Cursor.getPredefinedCursor(1));
                }
                this.invokeActions(new InteractionEvent((Object)this, 2005, null, null));
            }
        }
    }

    private void reportTheNeedToProject(int _count) {
        ArrayList tempList = (ArrayList)this.drawableList.clone();
        for (Object drawable : tempList) {
            if (!(drawable instanceof Drawable3D)) continue;
            ((Drawable3D)drawable).needsToProject(this);
        }
    }

    private void computeConstants(int _caller) {
        double maxSpace;
        int thisWidth = this.getWidth();
        int thisHeight = this.getHeight();
        this.acenter = this.deltaa + thisWidth / 2;
        this.bcenter = this.deltab + thisHeight / 2;
        if (this.squareAspect) {
            thisWidth = thisHeight = Math.min(thisWidth, thisHeight);
        }
        double dx = this.xmax - this.xmin;
        double dy = this.ymax - this.ymin;
        double dz = this.zmax - this.zmin;
        switch (this.displayMode) {
            case 0: {
                maxSpace = Math.max(dx, dy);
                break;
            }
            case 1: {
                maxSpace = Math.max(dx, dz);
                break;
            }
            case 2: {
                maxSpace = Math.max(dy, dz);
                break;
            }
            default: {
                maxSpace = Math.max(Math.max(dx, dy), dz);
            }
        }
        this.centerX = (this.xmax + this.xmin) / 2.0;
        this.centerY = (this.ymax + this.ymin) / 2.0;
        this.centerZ = (this.zmax + this.zmin) / 2.0;
        this.aconstant = 0.5 * this.zoom * (double)thisWidth / maxSpace;
        this.bconstant = 0.5 * this.zoom * (double)thisHeight / maxSpace;
        this.viewToPlane = this.ratioToPlane * maxSpace;
        this.viewToCenter = this.ratioToCenter * maxSpace;
        this.resetDecoration(dx, dy, dz);
        this.reportTheNeedToProject(3);
    }

    private void scaleZ(ArrayList<Drawable> tempList) {
        double newZMin = Double.MAX_VALUE;
        double newZMax = -1.7976931348623157E308;
        boolean measurableFound = false;
        for (Drawable obj : tempList) {
            Measurable3D measurable;
            if (!(obj instanceof Measurable3D) || !(measurable = (Measurable3D)obj).isMeasured() || Double.isNaN(measurable.getZMax()) || Double.isNaN(measurable.getZMin())) continue;
            newZMin = Math.min(newZMin, measurable.getZMin());
            newZMin = Math.min(newZMin, measurable.getZMax());
            newZMax = Math.max(newZMax, measurable.getZMax());
            newZMax = Math.max(newZMax, measurable.getZMin());
            measurableFound = true;
        }
        if (measurableFound) {
            if (newZMin == newZMax) {
                newZMin = 0.9 * newZMin - 0.5;
                newZMax = 1.1 * newZMax + 0.5;
            }
            double range = newZMax - newZMin;
            this.zminPreferred = newZMin - this.autoscaleMargin * range;
            this.zmaxPreferred = newZMax + this.autoscaleMargin * range;
        }
        if (!Double.isNaN(this.zfloor)) {
            this.zminPreferred = Math.min(this.zfloor, this.zminPreferred);
        }
        if (!Double.isNaN(this.zceil)) {
            this.zmaxPreferred = Math.max(this.zceil, this.zmaxPreferred);
        }
    }

    private void displayPosition(double x, double y, double z) {
        switch (this.displayMode) {
            case 0: {
                this.blMessageBox.setText(String.valueOf(this.xFormat.format(x)) + " " + this.yFormat.format(y));
                break;
            }
            case 1: {
                this.blMessageBox.setText(String.valueOf(this.xFormat.format(x)) + " " + this.zFormat.format(z));
                break;
            }
            case 2: {
                this.blMessageBox.setText(String.valueOf(this.yFormat.format(y)) + " " + this.zFormat.format(z));
                break;
            }
            default: {
                this.blMessageBox.setText(String.valueOf(this.xFormat.format(x)) + " " + this.yFormat.format(y) + " " + this.zFormat.format(z));
            }
        }
    }

    private void showTrackers(boolean value) {
        int i = 0;
        int n = this.trackerLines.length;
        while (i < n) {
            if (i < this.trackersVisible) {
                this.trackerLines[i].setVisible(value);
            } else {
                this.trackerLines[i].setVisible(false);
            }
            ++i;
        }
    }

    private void positionTrackers() {
        switch (this.cursorMode) {
            case 0: {
                return;
            }
            default: {
                this.trackerLines[0].setXYZ(this.trackerPoint.x, this.ymin, this.zmin);
                this.trackerLines[0].setSizeXYZ(0.0, this.trackerPoint.y - this.ymin, 0.0);
                this.trackerLines[1].setXYZ(this.xmin, this.trackerPoint.y, this.zmin);
                this.trackerLines[1].setSizeXYZ(this.trackerPoint.x - this.xmin, 0.0, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint.x, this.trackerPoint.y, this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint.z - this.zmin);
                break;
            }
            case 2: {
                this.trackerLines[0].setXYZ(this.xmin, this.trackerPoint.y, this.trackerPoint.z);
                this.trackerLines[0].setSizeXYZ(this.trackerPoint.x - this.xmin, 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint.x, this.ymin, this.trackerPoint.z);
                this.trackerLines[1].setSizeXYZ(0.0, this.trackerPoint.y - this.ymin, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint.x, this.trackerPoint.y, this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint.z - this.zmin);
                this.trackerLines[3].setXYZ(this.trackerPoint.x, this.ymin, this.zmin);
                this.trackerLines[3].setSizeXYZ(0.0, this.trackerPoint.y - this.ymin, 0.0);
                this.trackerLines[4].setXYZ(this.xmin, this.trackerPoint.y, this.zmin);
                this.trackerLines[4].setSizeXYZ(this.trackerPoint.x - this.xmin, 0.0, 0.0);
                this.trackerLines[5].setXYZ(this.trackerPoint.x, this.ymin, this.zmin);
                this.trackerLines[5].setSizeXYZ(0.0, 0.0, this.trackerPoint.z - this.zmin);
                this.trackerLines[6].setXYZ(this.xmin, this.ymin, this.trackerPoint.z);
                this.trackerLines[6].setSizeXYZ(this.trackerPoint.x - this.xmin, 0.0, 0.0);
                this.trackerLines[7].setXYZ(this.xmin, this.trackerPoint.y, this.zmin);
                this.trackerLines[7].setSizeXYZ(0.0, 0.0, this.trackerPoint.z - this.zmin);
                this.trackerLines[8].setXYZ(this.xmin, this.ymin, this.trackerPoint.z);
                this.trackerLines[8].setSizeXYZ(0.0, this.trackerPoint.y - this.ymin, 0.0);
                break;
            }
            case 3: {
                this.trackerLines[0].setXYZ(this.xmin, this.trackerPoint.y, this.trackerPoint.z);
                this.trackerLines[0].setSizeXYZ(this.xmax - this.xmin, 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint.x, this.ymin, this.trackerPoint.z);
                this.trackerLines[1].setSizeXYZ(0.0, this.ymax - this.ymin, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint.x, this.trackerPoint.y, this.zmin);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.zmax - this.zmin);
            }
        }
    }

    private void resetDecoration(double _dx, double _dy, double _dz) {
        if (this.boxSides == null || this.boxSides[0] == null) {
            return;
        }
        this.boxSides[0].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[0].setSizeXYZ(_dx, 0.0, 0.0);
        this.boxSides[1].setXYZ(this.xmax, this.ymin, this.zmin);
        this.boxSides[1].setSizeXYZ(0.0, _dy, 0.0);
        this.boxSides[2].setXYZ(this.xmin, this.ymax, this.zmin);
        this.boxSides[2].setSizeXYZ(_dx, 0.0, 0.0);
        this.boxSides[3].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[3].setSizeXYZ(0.0, _dy, 0.0);
        this.boxSides[4].setXYZ(this.xmin, this.ymin, this.zmax);
        this.boxSides[4].setSizeXYZ(_dx, 0.0, 0.0);
        this.boxSides[5].setXYZ(this.xmax, this.ymin, this.zmax);
        this.boxSides[5].setSizeXYZ(0.0, _dy, 0.0);
        this.boxSides[6].setXYZ(this.xmin, this.ymax, this.zmax);
        this.boxSides[6].setSizeXYZ(_dx, 0.0, 0.0);
        this.boxSides[7].setXYZ(this.xmin, this.ymin, this.zmax);
        this.boxSides[7].setSizeXYZ(0.0, _dy, 0.0);
        this.boxSides[8].setXYZ(this.xmin, this.ymin, this.zmin);
        this.boxSides[8].setSizeXYZ(0.0, 0.0, _dz);
        this.boxSides[9].setXYZ(this.xmax, this.ymin, this.zmin);
        this.boxSides[9].setSizeXYZ(0.0, 0.0, _dz);
        this.boxSides[10].setXYZ(this.xmax, this.ymax, this.zmin);
        this.boxSides[10].setSizeXYZ(0.0, 0.0, _dz);
        this.boxSides[11].setXYZ(this.xmin, this.ymax, this.zmin);
        this.boxSides[11].setSizeXYZ(0.0, 0.0, _dz);
        this.xAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.xAxis.setSizeXYZ(_dx, 0.0, 0.0);
        this.xText.setXYZ(this.xmax + _dx * 0.02, this.ymin, this.zmin);
        this.yAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.yAxis.setSizeXYZ(0.0, _dy, 0.0);
        this.yText.setXYZ(this.xmin, this.ymax + _dx * 0.02, this.zmin);
        this.zAxis.setXYZ(this.xmin, this.ymin, this.zmin);
        this.zAxis.setSizeXYZ(0.0, 0.0, _dz);
        this.zText.setXYZ(this.xmin, this.ymin, this.zmax + _dx * 0.02);
    }
}

