/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.NeedsFinalUpdate;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.dialogs.AutoScaleInspector;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.tools.ToolForData;

public abstract class ControlDrawablesParent
extends ControlSwingElement
implements NeedsUpdate,
NeedsFinalUpdate,
ControlParentOfDrawables {
    protected Vector<NeedsPreUpdate> preupdateList = new Vector();
    protected boolean isZoomed = false;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected boolean autoX;
    protected boolean autoY;
    protected boolean xminSet = false;
    protected boolean xmaxSet = false;
    protected boolean yminSet = false;
    protected boolean ymaxSet = false;

    public ControlDrawablesParent() {
        this.getVisual().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent _e) {
                if (_e.isControlDown() && ControlDrawablesParent.this.getSimulation() != null) {
                    if (_e.getKeyCode() == 77) {
                        ControlDrawablesParent.this.getPopupMenu(0, 0);
                    } else if (_e.getKeyCode() == 80) {
                        ControlDrawablesParent.this.printScreen();
                    }
                }
            }
        });
        this.getVisual().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent _evt) {
                if (ControlDrawablesParent.this.getSimulation() == null || !OSPRuntime.isPopupTrigger(_evt)) {
                    return;
                }
                if (!ToolForData.getTool().isFullTool()) {
                    ControlDrawablesParent.this.getPopupMenu(_evt.getX(), _evt.getY());
                    return;
                }
                Interactive interactive = ((InteractivePanel)ControlDrawablesParent.this.getVisual()).getInteractive();
                if (interactive instanceof Data) {
                    JPopupMenu popupMenu = new JPopupMenu();
                    for (Object entry : ControlDrawablesParent.getDataInformationMenuEntries(ControlDrawablesParent.this.getVisual(), (Data)((Object)interactive))) {
                        if (entry instanceof Action) {
                            popupMenu.add((Action)entry);
                            continue;
                        }
                        if (entry instanceof JMenuItem) {
                            popupMenu.add((JMenuItem)entry);
                            continue;
                        }
                        popupMenu.add(entry.toString());
                    }
                    popupMenu.show(ControlDrawablesParent.this.getVisual(), _evt.getX(), _evt.getY());
                } else {
                    ControlDrawablesParent.this.getPopupMenu(_evt.getX(), _evt.getY());
                }
            }
        });
    }

    @Override
    public String getPropertyCommonName(String _property) {
        if (_property.equals("pressaction")) {
            return "pressAction";
        }
        if (_property.equals("dragaction")) {
            return "dragAction";
        }
        if (_property.equals("action")) {
            return "releaseAction";
        }
        return super.getPropertyCommonName(_property);
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), this.getExtraMenuOptions());
    }

    protected List<Object> getExtraMenuOptions() {
        JMenuItem scales = new JMenuItem("tools_res:MenuItem.Scale");
        scales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _evt) {
                ControlDrawablesParent.this.isZoomed = true;
                ScaleInspector plotInspector = new ScaleInspector((DrawingPanel)ControlDrawablesParent.this.getVisual());
                plotInspector.setLocationRelativeTo(ControlDrawablesParent.this.getVisual());
                plotInspector.updateDisplay();
                plotInspector.setVisible(true);
            }
        });
        scales.setActionCommand("tools_res:MenuItem.Scale");
        JMenuItem zoomIn = new JMenuItem("tools_res:MenuItem.ZoomIn");
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _evt) {
                ControlDrawablesParent.this.checkAutoscaling();
                new ZoomController();
            }
        });
        zoomIn.setActionCommand("tools_res:MenuItem.ZoomIn");
        JMenuItem zoomOut = new JMenuItem("tools_res:MenuItem.ZoomOut");
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _evt) {
                ControlDrawablesParent.this.checkAutoscaling();
                double xmin = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getXMin();
                double xmax = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getXMax();
                double ymin = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getYMin();
                double ymax = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getYMax();
                double dx = xmax - xmin;
                double dy = ymax - ymin;
                ControlDrawablesParent.this.isZoomed = true;
                if (!((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAutoscaleX()) {
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setPreferredMinMaxX(xmin - dx / 2.0, xmax + dx / 2.0);
                }
                if (!((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAutoscaleY()) {
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setPreferredMinMaxY(ymin - dy / 2.0, ymax + dy / 2.0);
                }
                ControlDrawablesParent.this.update();
            }
        });
        zoomOut.setActionCommand("tools_res:MenuItem.ZoomOut");
        JMenuItem zoomCancel = new JMenuItem("tools_res:MenuItem.ZoomCancel");
        zoomCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _evt) {
                ControlDrawablesParent.this.isZoomed = false;
                ControlDrawablesParent.this.updateAutoscale();
                ControlDrawablesParent.this.update();
                if (ControlDrawablesParent.this.getSimulation() == null || ControlDrawablesParent.this.getSimulation().isPaused()) {
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).render();
                }
            }
        });
        zoomCancel.setActionCommand("tools_res:MenuItem.ZoomCancel");
        JMenu zoomMenu = new JMenu("tools_res:MenuItem.Zoom");
        zoomMenu.setActionCommand("tools_res:MenuItem.Zoom");
        zoomMenu.add(scales);
        zoomMenu.add(zoomIn);
        zoomMenu.add(zoomOut);
        zoomMenu.add(zoomCancel);
        final JCheckBoxMenuItem textAliasItem = new JCheckBoxMenuItem("display_res:DrawingFrame.Text_checkbox_label", false);
        textAliasItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setAntialiasTextOn(textAliasItem.isSelected());
                Simulation sim = ControlDrawablesParent.this.getSimulation();
                if (sim == null || sim.isPaused()) {
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).invalidateImage();
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).repaint();
                }
            }
        });
        textAliasItem.setActionCommand("display_res:DrawingFrame.Text_checkbox_label");
        final JCheckBoxMenuItem shapeAliasItem = new JCheckBoxMenuItem("display_res:DrawingFrame.Drawing_textbox_label", false);
        shapeAliasItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setAntialiasShapeOn(shapeAliasItem.isSelected());
                Simulation sim = ControlDrawablesParent.this.getSimulation();
                if (sim == null || sim.isPaused()) {
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).invalidateImage();
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).repaint();
                }
            }
        });
        shapeAliasItem.setActionCommand("display_res:DrawingFrame.Drawing_textbox_label");
        JMenu aliasMenu = new JMenu("display_res:DrawingFrame.AntiAlias_menu_title");
        aliasMenu.add(textAliasItem);
        aliasMenu.add(shapeAliasItem);
        aliasMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                textAliasItem.setSelected(((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAntialiasTextOn());
                shapeAliasItem.setSelected(((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAntialiasShapeOn());
            }
        });
        aliasMenu.setActionCommand("display_res:DrawingFrame.AntiAlias_menu_title");
        JMenuItem snapshotMenuItem = new JMenuItem("tools_res:MenuItem.Snapshot");
        snapshotMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent _evt) {
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).snapshot();
            }
        });
        snapshotMenuItem.setActionCommand("tools_res:MenuItem.Snapshot");
        ArrayList<Object> menuEntries = new ArrayList<Object>();
        menuEntries.add(snapshotMenuItem);
        menuEntries.add(zoomMenu);
        menuEntries.add(aliasMenu);
        if (ToolForData.getTool().isFullTool()) {
            JMenuItem dataToolItem = new JMenuItem("tools_res:DataTool.Frame.Title");
            dataToolItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolForData.getTool().showDataTool(ControlDrawablesParent.this.getVisual(), ControlDrawablesParent.this.getAllData(ControlDrawablesParent.this.getDrawingPanel()));
                }
            });
            dataToolItem.setActionCommand("tools_res:DataTool.Frame.Title");
            menuEntries.add(dataToolItem);
        }
        return menuEntries;
    }

    @Override
    public DrawingPanel getDrawingPanel() {
        return (DrawingPanel)this.getVisual();
    }

    private List<Data> getAllData(DrawingPanel _panel) {
        ArrayList<Data> dataList = new ArrayList<Data>();
        for (Drawable drawable : _panel.getDrawables()) {
            if (!(drawable instanceof Data)) continue;
            dataList.add((Data)((Object)drawable));
        }
        return dataList;
    }

    @Override
    public void reset() {
        this.isZoomed = false;
        this.updateAutoscale();
        if (this.isUnderEjs) {
            ((DrawingPanel)this.getVisual()).setBuffered(false);
        }
    }

    protected void updateAutoscale() {
        if (!this.isZoomed) {
            DrawingPanel dPanel = (DrawingPanel)this.getVisual();
            dPanel.setAutoscaleX(this.autoX);
            dPanel.setAutoscaleY(this.autoY);
            this.updateExtrema();
        }
    }

    protected void updateExtrema() {
        if (!this.isZoomed) {
            DrawingPanel dPanel = (DrawingPanel)this.getVisual();
            if (dPanel.isAutoscaleX()) {
                if (this.xminSet || this.xmaxSet) {
                    dPanel.limitAutoscaleX(this.minX, this.maxX);
                }
            } else {
                dPanel.setPreferredMinMaxX(this.minX, this.maxX);
            }
            if (dPanel.isAutoscaleY()) {
                if (this.yminSet || this.ymaxSet) {
                    dPanel.limitAutoscaleY(this.minY, this.maxY);
                }
            } else {
                dPanel.setPreferredMinMaxY(this.minY, this.maxY);
            }
            if (this.isUnderEjs) {
                dPanel.render();
            }
        }
    }

    protected void checkAutoscaling() {
        DrawingPanel dPanel = (DrawingPanel)this.getVisual();
        if (dPanel.isAutoscaleX() || dPanel.isAutoscaleY()) {
            this.isZoomed = true;
            AutoScaleInspector plotInspector = new AutoScaleInspector(dPanel);
            plotInspector.setLocationRelativeTo(dPanel);
            plotInspector.updateDisplay();
            plotInspector.setVisible(true);
        }
    }

    @Override
    public boolean acceptsChild(ControlElement _child) {
        return _child instanceof ControlDrawable;
    }

    @Override
    public void update() {
        for (NeedsPreUpdate npu : this.preupdateList) {
            npu.preupdate();
        }
    }

    @Override
    public void finalUpdate() {
        if (SwingUtilities.isEventDispatchThread() || Thread.currentThread().getName().equals("main")) {
            Simulation sim = this.getSimulation();
            if (sim == null || sim.isPaused()) {
                ((DrawingPanel)this.getVisual()).invalidateImage();
                ((DrawingPanel)this.getVisual()).repaint();
            }
        } else {
            ((DrawingPanel)this.getVisual()).render();
        }
    }

    @Override
    public Component getComponent() {
        return this.getVisual();
    }

    @Override
    public void addToPreupdateList(NeedsPreUpdate _child) {
        this.preupdateList.add(_child);
    }

    @Override
    public void removeFromPreupdateList(NeedsPreUpdate _child) {
        this.preupdateList.remove(_child);
    }

    @Override
    public void addDrawable(Drawable _drawable) {
        ((DrawingPanel)this.getVisual()).addDrawable(_drawable);
    }

    @Override
    public void addDrawableAtIndex(int _index, Drawable _drawable) {
        ((DrawingPanel)this.getVisual()).addDrawableAtIndex(_index, _drawable);
    }

    @Override
    public void removeDrawable(Drawable _drawable) {
        ((DrawingPanel)this.getVisual()).removeDrawable(_drawable);
    }

    public ControlDrawable getSelectedDrawable() {
        return null;
    }

    class ZoomController
    extends MouseInputAdapter {
        ZoomController() {
            DrawingPanel dPanel = (DrawingPanel)ControlDrawablesParent.this.getVisual();
            dPanel.addMouseListener(this);
            dPanel.addMouseMotionListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().startZoom(e.getX(), e.getY());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().drag(e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DrawingPanel dPanel = (DrawingPanel)ControlDrawablesParent.this.getVisual();
            Rectangle rect = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().reportZoom();
            dPanel.removeMouseListener(this);
            dPanel.removeMouseMotionListener(this);
            if (rect != null) {
                ControlDrawablesParent.this.isZoomed = true;
                if (!dPanel.isAutoscaleX()) {
                    dPanel.setPreferredMinMaxX(rect.x, rect.x + rect.width);
                }
                if (!dPanel.isAutoscaleY()) {
                    dPanel.setPreferredMinMaxY(rect.y, rect.y + rect.height);
                }
                ControlDrawablesParent.this.update();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

