/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;

public abstract class LauncherApplet
extends JApplet {
    private static final long serialVersionUID = 1L;
    private JFrame _parentFrame = null;
    private Component mainComponent = null;
    public Model _model = null;
    public Simulation _simulation = null;
    public View _view = null;
    private byte[] imageByteArray = null;
    private byte[] stateByteArray = null;

    static {
        OSPRuntime.appletMode = true;
    }

    public LauncherApplet() {
        OSPRuntime.applet = this;
    }

    @Override
    public void init() {
        String osName;
        String lookAndFeel;
        super.init();
        String bqParameter = this.getParameter("bqServer");
        if (bqParameter != null) {
            ResourceLoader.addSearchPath(bqParameter);
        }
        if ((lookAndFeel = this.getParameter("lookandfeel")) != null && ((osName = System.getProperty("os.name").toLowerCase()).contains("win") || osName.contains("nix") || osName.contains("nux") || osName.indexOf("aix") > 0)) {
            boolean decorated = true;
            if (this.getParameter("not_decorated") != null) {
                decorated = false;
            }
            OSPRuntime.setLookAndFeel(decorated, lookAndFeel);
        }
    }

    public void _play() {
        this._simulation.play();
    }

    public void _pause() {
        this._simulation.pause();
    }

    public void _step() {
        this._simulation.step();
    }

    public void _setFPS(int _fps) {
        this._simulation.setFPS(_fps);
    }

    public void _setDelay(int _delay) {
        this._simulation.setDelay(_delay);
    }

    public void _reset() {
        this._model._reset();
    }

    public void _initialize() {
        this._model._initialize();
    }

    public boolean _isPlaying() {
        return this._simulation.isPlaying();
    }

    public boolean _isPaused() {
        return this._simulation.isPaused();
    }

    public void _setParentComponent(String _parent) {
        this._simulation.setParentComponent(_parent);
    }

    public boolean _saveImage(String _filename, String _element) {
        return this._simulation.saveImage(_filename, _element);
    }

    public boolean _saveState(String _filename) {
        return this._simulation.saveState(_filename);
    }

    public boolean _saveVariables(String _filename, String _varList) {
        return this._simulation.saveVariables(_filename, _varList);
    }

    public boolean _saveVariables(String _filename, List<String> _varList) {
        return this._simulation.saveVariables(_filename, _varList);
    }

    public boolean _saveText(String _filename, String _text) {
        return this._simulation.saveText(_filename, _text);
    }

    public boolean _saveText(String _filename, String _annotation, String _text) {
        return this._simulation.saveText(_filename, _annotation, _text);
    }

    public boolean _saveText(String _filename, StringBuffer _text) {
        return this._simulation.saveText(_filename, _text);
    }

    public boolean _readState(String _filename) {
        return this._simulation.readState(_filename);
    }

    public boolean _readVariables(String _filename, String _varList) {
        return this._simulation.readVariables(_filename, null, _varList);
    }

    public boolean _readVariables(String _filename, List<String> _varList) {
        return this._simulation.readVariables(_filename, this.getCodeBase(), _varList);
    }

    public String _readText(String _filename) {
        return this._simulation.readText(_filename);
    }

    public String _readText(String _filename, String _type) {
        return this._simulation.readText(_filename, _type);
    }

    public boolean _setVariables(String _command, String _delim, String _arrayDelim) {
        return this._simulation.setVariables(_command, _delim, _arrayDelim);
    }

    public boolean _setVariables(String _command) {
        return this._simulation.setVariables(_command);
    }

    public String _getVariables(String _varName) {
        return this._simulation.getVariable(_varName);
    }

    public Object _getUserData(String _name) {
        return this._model.getUserData(_name);
    }

    public void _clearView() {
        if (this._view != null) {
            this._view.initialize();
        }
    }

    public void _resetView() {
        if (this._view != null) {
            this._view.reset();
            this._view.initialize();
        }
    }

    public void _alert(String _panel, String _title, String _message) {
        this._model._alert(_panel, _title, _message);
    }

    public void _print(String _txt) {
        if (this._view != null) {
            this._view.print(_txt);
        } else {
            System.out.print(_txt);
        }
    }

    public void _println(String _txt) {
        if (this._view != null) {
            this._view.println(_txt);
        } else {
            System.out.print(_txt);
        }
    }

    public void _println() {
        if (this._view != null) {
            this._view.println();
        } else {
            System.out.println();
        }
    }

    public void _clearMessages() {
        if (this._view != null) {
            this._view.clearMessages();
        }
    }

    public String _format(double _value, String _pattern) {
        DecimalFormat _tmp_format = new DecimalFormat(_pattern);
        return _tmp_format.format(_value);
    }

    protected Frame getParentFrame() {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof Frame) {
                return (Frame)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public Component captureWindow(Model _aModel, String _aWindow) {
        if (_aWindow == null) {
            return null;
        }
        Container root = this._parentFrame != null ? this._parentFrame : this;
        Component comp = _aModel._getView().getComponent(_aWindow);
        if (comp == null) {
            return null;
        }
        if (comp instanceof DrawingFrame) {
            comp.setVisible(true);
            Container contentPane = ((RootPaneContainer)((Object)comp)).getContentPane();
            contentPane.setVisible(true);
            root.setContentPane(contentPane);
            Component glassPane = ((RootPaneContainer)((Object)comp)).getGlassPane();
            root.setGlassPane(glassPane);
            glassPane.setVisible(true);
            ((DrawingFrame)comp).setKeepHidden(true);
            ((DrawingFrame)comp).setDefaultCloseOperation(2);
        } else if (comp instanceof JDialog) {
            comp.setVisible(true);
            Container contentPane = ((RootPaneContainer)((Object)comp)).getContentPane();
            contentPane.setVisible(true);
            root.setContentPane(contentPane);
            Component glassPane = ((RootPaneContainer)((Object)comp)).getGlassPane();
            root.setGlassPane(glassPane);
            glassPane.setVisible(true);
            ((JDialog)comp).dispose();
        } else {
            root.getContentPane().setLayout(new BorderLayout());
            root.getContentPane().add(comp, "Center");
            root.getContentPane().validate();
            Container oldParent = comp.getParent();
            if (oldParent != null) {
                oldParent.validate();
            }
        }
        if (this._parentFrame != null) {
            this._parentFrame.pack();
        }
        this.mainComponent = root.getContentPane();
        _aModel._getSimulation().setParentComponent(this.mainComponent);
        return this.mainComponent;
    }

    public Component _getMainComponent() {
        return this.mainComponent;
    }

    public void setImageByteArray(byte[] b) {
        this.imageByteArray = b;
    }

    private String byteArray2String(byte[] b) {
        if (b.length < 1) {
            return "";
        }
        String s = "" + b[0];
        int i = 1;
        while (i < b.length) {
            s = String.valueOf(s) + "_" + b[i];
            ++i;
        }
        return s;
    }

    public String imageByteData() {
        return this.byteArray2String(this.imageByteArray);
    }

    public void setStateByteArray(byte[] b) {
        this.stateByteArray = b;
    }

    public String stateByteData() {
        return this.byteArray2String(this.stateByteArray);
    }

    public String frameName() {
        return this._getMainComponent().getName();
    }
}

