/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.rocket_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.ntnu.fkh.rocket_pkg.rocketSimulation;
import users.ntnu.fkh.rocket_pkg.rocketView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class rocket
extends AbstractModel {
    public rocketSimulation _simulation = null;
    public rocketView _view = null;
    public rocket _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double range = 20.0;
    public double xmin = -this.range / 2.0;
    public double xmax = this.range / 2.0;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 25.0;
    public double size2 = this.size / 2.0;
    public double stroke = 2.0;
    public double pi = Math.PI;
    public int psize = 5;
    public int ntrace = 3;
    public double M;
    public double m = this.M = 1.0;
    public double mratio = 2.0;
    public double mpratio = 1.0 - 1.0 / this.mratio;
    public double prate = 0.01;
    public double mrate = this.prate * this.M;
    public double mT = 46.8577;
    public double x = this.xmin + this.size;
    public double y = 0.0;
    public double vx = 0.0;
    public boolean init = true;
    public double u = 1.0;
    private _ODE_evolution1 _ODEi_evolution1;
    double dv;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/rocket.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ntnu/fkh/rocket_pkg/rocket_zh.properties");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        rocket rocket2 = new rocket(stringArray);
    }

    public rocket() {
        this(null, null, null, null, null, false);
    }

    public rocket(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public rocket(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new rocketSimulation(this, string, frame, uRL, bl);
        this._view = (rocketView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.init = true;
        this.t = 0.0;
        this.m = this.M;
        this.vx = 0.0;
        this.x = 0.0;
        this.mT = this.mpratio * this.M / this.prate;
    }

    public void _constraints1() {
        if (this.init && this.t > 0.0) {
            this.init = false;
        }
        if (this.m < this.M / this.mratio) {
            this._pause();
        }
    }

    public double dvalue(double d) {
        this.dv = d > 0.0 ? 0.5 : (d < 0.0 ? -0.5 : 0.0);
        return (double)((int)(d * 100.0 + this.dv)) / 100.0;
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public boolean _method_for_buttoninit_enabled() {
        return this._isPaused();
    }

    public void _method_for_buttoninit_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_sliderMratio_dragaction() {
        this._simulation.disableLoop();
        this.mpratio = 1.0 - 1.0 / this.mratio;
        this.mT = this.mpratio * this.M / this.prate;
        this._simulation.enableLoop();
    }

    public void _method_for_slidermpratio_dragaction() {
        this._simulation.disableLoop();
        this.mratio = 1.0 / (1.0 - this.mpratio);
        this.mT = this.mpratio * this.M / this.prate;
        this._simulation.enableLoop();
    }

    public void _method_for_slidermT_dragaction() {
        this._simulation.disableLoop();
        this.mT = this.mpratio * this.M / this.prate;
        this._simulation.enableLoop();
    }

    public void _method_for_slidermT2_dragaction() {
        this._simulation.disableLoop();
        this.prate = this.mpratio * this.M / this.mT;
        this._simulation.enableLoop();
    }

    public void _method_for_sliderm_dragaction() {
        this._simulation.disableLoop();
        this.m = this.M;
        this.mT = this.mpratio * this.M / this.prate;
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.range = 20.0;
        this.xmin = -this.range / 2.0;
        this.xmax = this.range / 2.0;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 25.0;
        this.size2 = this.size / 2.0;
        this.stroke = 2.0;
        this.pi = Math.PI;
        this.psize = 5;
        this.ntrace = 3;
        this.m = this.M = 1.0;
        this.mratio = 2.0;
        this.mpratio = 1.0 - 1.0 / this.mratio;
        this.prate = 0.01;
        this.mrate = this.prate * this.M;
        this.mT = 46.8577;
        this.x = this.xmin + this.size;
        this.y = 0.0;
        this.vx = 0.0;
        this.init = true;
        this.u = 1.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }

    private class _ODE_evolution1
    implements ODE {
        private RK4 __solver = null;
        private double[] __state = null;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[3];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = rocket.this.m;
            this.__state[n++] = rocket.this.x;
            this.__state[n++] = rocket.this.t;
            this.__solver = new RK4(this);
            this.__solver.initialize(rocket.this.dt);
        }

        void step() {
            if (rocket.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(rocket.this.dt);
            }
            int n = 0;
            this.__state[n++] = rocket.this.m;
            this.__state[n++] = rocket.this.x;
            this.__state[n++] = rocket.this.t;
            this.__solver.step();
            n = 0;
            rocket.this.m = this.__state[n++];
            rocket.this.x = this.__state[n++];
            rocket.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            n = 0;
            dArray2[n++] = -rocket.this.prate;
            dArray2[n++] = rocket.this.vx = rocket.this.u * Math.log(rocket.this.M / d);
            dArray2[n++] = 1.0;
        }
    }
}

