/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class EulerRichardson
extends AbstractODESolver {
    private double[] rate;
    private double[] midstate;

    public EulerRichardson(ODE oDE) {
        super(oDE);
    }

    public void initialize(double d) {
        super.initialize(d);
        this.rate = new double[this.numEqn];
        this.midstate = new double[this.numEqn];
    }

    public double step() {
        double[] dArray = this.ode.getState();
        this.ode.getRate(dArray, this.rate);
        double d = this.stepSize / 2.0;
        int n = 0;
        while (n < this.numEqn) {
            this.midstate[n] = dArray[n] + this.rate[n] * d;
            ++n;
        }
        this.ode.getRate(this.midstate, this.rate);
        n = 0;
        while (n < this.numEqn) {
            dArray[n] = dArray[n] + this.stepSize * this.rate[n];
            ++n;
        }
        return this.stepSize;
    }
}

