/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.opensourcephysics.drawing2d.Element;

public class Style {
    public static final int DEFAULT_SENSITIVITY = 5;
    public static final int CHANGED_LINE_COLOR = 0;
    public static final int CHANGED_LINE_WIDTH = 1;
    public static final int CHANGED_FILL_COLOR = 2;
    public static final int CHANGED_DRAWING_FILL = 3;
    public static final int CHANGED_DRAWING_LINES = 4;
    public static final int CHANGED_RELATIVE_POSITION = 5;
    public static final int CHANGED_SENSITIVITY = 6;
    public static final int CENTERED = 0;
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 3;
    public static final int WEST = 4;
    public static final int NORTH_EAST = 5;
    public static final int NORTH_WEST = 6;
    public static final int SOUTH_EAST = 7;
    public static final int SOUTH_WEST = 8;
    private boolean drawsFill = true;
    private boolean drawsLines = true;
    private Color lineColor = Color.black;
    private float lineWidth = 1.0f;
    private Color fillColor = Color.blue;
    private int sensitivity = 5;
    int position = 0;
    private Element element = null;
    private Stroke lineStroke = new BasicStroke(this.lineWidth);

    Style(Element element) {
        this.element = element;
    }

    public Style clone() {
        Style style = new Style(this.element);
        style.drawsFill = this.drawsFill;
        style.drawsLines = this.drawsLines;
        style.fillColor = this.fillColor;
        style.lineColor = this.lineColor;
        style.lineStroke = this.lineStroke;
        style.lineWidth = this.lineWidth;
        style.position = this.position;
        style.sensitivity = this.sensitivity;
        return style;
    }

    public void copyTo(Style style) {
        style.drawsFill = this.drawsFill;
        style.drawsLines = this.drawsLines;
        style.fillColor = this.fillColor;
        style.lineColor = this.lineColor;
        style.lineStroke = this.lineStroke;
        style.lineWidth = this.lineWidth;
        style.position = this.position;
        style.sensitivity = this.sensitivity;
    }

    public final void setLineColor(Color color) {
        if (color == null) {
            return;
        }
        this.lineColor = color;
        if (this.element != null) {
            this.element.styleChanged(0);
        }
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public final void setLineWidth(float f) {
        if (this.lineWidth == f) {
            return;
        }
        this.lineWidth = f;
        this.lineStroke = new BasicStroke(this.lineWidth);
        if (this.element != null) {
            this.element.styleChanged(1);
        }
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public final void setFillColor(Color color) {
        if (color == null) {
            return;
        }
        this.fillColor = color;
        if (this.element != null) {
            this.element.styleChanged(2);
        }
    }

    public final Color getFillColor() {
        return this.fillColor;
    }

    public final boolean isDrawingFill() {
        return this.drawsFill;
    }

    public final void setDrawingFill(boolean bl) {
        this.drawsFill = bl;
        if (this.element != null) {
            this.element.styleChanged(3);
        }
    }

    public final boolean isDrawingLines() {
        return this.drawsLines;
    }

    public final void setDrawingLines(boolean bl) {
        this.drawsLines = bl;
        if (this.element != null) {
            this.element.styleChanged(4);
        }
    }

    public final void setRelativePosition(int n) {
        this.position = n;
        this.element.styleChanged(5);
    }

    public final int getRelativePosition() {
        return this.position;
    }

    public final void setSensitivity(int n) {
        this.sensitivity = n;
    }

    public final int getSensitivity() {
        return this.sensitivity;
    }
}

